/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.sdk.remote.internal.packages;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkManager;
import com.android.sdklib.SystemImage;
import com.android.sdklib.repository.FullRevision;
import com.android.sdklib.repository.MajorRevision;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalSysImgPkgInfo;
import com.android.tools.idea.sdk.remote.RemotePkgInfo;
import com.android.tools.idea.sdk.remote.internal.packages.IAndroidVersionProvider;
import com.android.tools.idea.sdk.remote.internal.packages.RemotePackageParserUtils;
import com.android.tools.idea.sdk.remote.internal.sources.SdkSource;
import java.io.File;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.w3c.dom.Node;

public class RemoteSystemImagePkgInfo
extends RemotePkgInfo
implements IAndroidVersionProvider {
    public RemoteSystemImagePkgInfo(SdkSource source, Node packageNode, String nsUri, Map<String, String> licenses) {
        super(source, packageNode, nsUri, licenses);
        PkgDesc.Builder descBuilder;
        int apiLevel = RemotePackageParserUtils.getXmlInt(packageNode, "api-level", 0);
        String codeName = RemotePackageParserUtils.getXmlString(packageNode, "codename");
        if (codeName.length() == 0) {
            codeName = null;
        }
        AndroidVersion version = new AndroidVersion(apiLevel, codeName);
        String abi = RemotePackageParserUtils.getXmlString(packageNode, "abi");
        String tagId = RemotePackageParserUtils.getXmlString(packageNode, "tag-id", SystemImage.DEFAULT_TAG.getId());
        String tagDisp = RemotePackageParserUtils.getOptionalXmlString(packageNode, "tag-display");
        if (tagDisp == null || tagDisp.isEmpty()) {
            tagDisp = LocalSysImgPkgInfo.tagIdToDisplay((String)tagId);
        }
        assert (tagId != null);
        IdDisplay tag = new IdDisplay(tagId, tagDisp);
        Node addonNode = RemotePackageParserUtils.findChildElement(packageNode, "add-on");
        IdDisplay vendor = null;
        if (addonNode == null) {
            descBuilder = PkgDesc.Builder.newSysImg((AndroidVersion)version, (IdDisplay)tag, (String)abi, (MajorRevision)new MajorRevision(this.getRevision()));
        } else {
            String vendorId = RemotePackageParserUtils.getXmlString(addonNode, "vendor-id");
            String vendorDisp = RemotePackageParserUtils.getXmlString(addonNode, "vendor-display", vendorId);
            assert (vendorId.length() > 0);
            assert (vendorDisp.length() > 0);
            vendor = new IdDisplay(vendorId, vendorDisp);
            descBuilder = PkgDesc.Builder.newAddonSysImg((AndroidVersion)version, (IdDisplay)vendor, (IdDisplay)tag, (String)abi, (MajorRevision)new MajorRevision(this.getRevision()));
        }
        descBuilder.setDescriptionShort(RemoteSystemImagePkgInfo.createShortDescription(this.getListDisplay(), abi, vendor, tag, version, this.getRevision(), this.isObsolete()));
        descBuilder.setDescriptionUrl(this.getDescUrl());
        descBuilder.setListDisplay(RemoteSystemImagePkgInfo.createListDescription(this.mListDisplay, tag, RemoteSystemImagePkgInfo.getAbiDisplayNameInternal(abi), this.isObsolete()));
        descBuilder.setIsObsolete(this.isObsolete());
        descBuilder.setLicense(this.getLicense());
        this.mPkgDesc = descBuilder.create();
    }

    @Override
    public void saveProperties(Properties props) {
        super.saveProperties(props);
        this.getAndroidVersion().saveProperties(props);
        props.setProperty("SystemImage.Abi", this.getAbi());
        props.setProperty("SystemImage.TagId", this.getTag().getId());
        props.setProperty("SystemImage.TagDisplay", this.getTag().getDisplay());
        IdDisplay addonVendor = this.getAddonVendor();
        if (addonVendor != null) {
            props.setProperty("Addon.VendorId", addonVendor.getId());
            props.setProperty("Addon.VendorDisplay", addonVendor.getDisplay());
        }
    }

    public IdDisplay getTag() {
        return this.getPkgDesc().getTag();
    }

    public String getAbi() {
        return this.getPkgDesc().getPath();
    }

    private static String getAbiDisplayNameInternal(String abi) {
        return abi.replace("armeabi", "ARM EABI").replace("arm64", "ARM 64").replace("x86", "Intel x86 Atom").replace("x86_64", "Intel x86_64 Atom").replace("mips", "MIPS").replace("-", " ");
    }

    @Override
    @NonNull
    public AndroidVersion getAndroidVersion() {
        return this.getPkgDesc().getAndroidVersion();
    }

    public boolean isPlatform() {
        return this.getAddonVendor() == null;
    }

    @Nullable
    public IdDisplay getAddonVendor() {
        return this.getPkgDesc().getVendor();
    }

    @Override
    public String installId() {
        StringBuilder sb = new StringBuilder("sys-img-");
        sb.append(this.getAbi()).append('-');
        if (!this.isPlatform()) {
            sb.append("addon-");
        }
        sb.append(SystemImage.DEFAULT_TAG.equals((Object)this.getTag()) ? "android" : this.getTag().getId());
        sb.append('-');
        if (!this.isPlatform()) {
            sb.append(this.getAddonVendor().getId()).append('-');
        }
        sb.append(this.getAndroidVersion().getApiString());
        String s = sb.toString();
        s = s.toLowerCase(Locale.US).replaceAll("[^a-z0-9_.-]+", "_").replaceAll("_+", "_");
        return s;
    }

    private static String createListDescription(String listDisplay, IdDisplay tag, String abiDisplayName, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s%2$s", listDisplay, obsolete ? " (Obsolete)" : "");
        }
        boolean isDefaultTag = SystemImage.DEFAULT_TAG.equals((Object)tag);
        return String.format("%1$s%2$s System Image%3$s", isDefaultTag ? "" : tag.getDisplay() + " ", abiDisplayName, obsolete ? " (Obsolete)" : "");
    }

    private static String createShortDescription(String listDisplay, String abi, IdDisplay vendor, IdDisplay tag, AndroidVersion version, FullRevision revision, boolean obsolete) {
        if (!listDisplay.isEmpty()) {
            return String.format("%1$s, %2$s API %3$s, revision %4$s%5$s", listDisplay, vendor == null ? "Android" : vendor.getDisplay(), version.getApiString(), revision.toShortString(), obsolete ? " (Obsolete)" : "");
        }
        boolean isDefaultTag = SystemImage.DEFAULT_TAG.equals((Object)tag);
        return String.format("%1$s%2$s System Image, %3$s API %4$s, revision %5$s%6$s", isDefaultTag ? "" : tag.getDisplay() + " ", RemoteSystemImagePkgInfo.getAbiDisplayNameInternal(abi), vendor == null ? "Android" : vendor.getDisplay(), version.getApiString(), revision.toShortString(), obsolete ? " (Obsolete)" : "");
    }

    @Override
    public File getInstallFolder(String osSdkRoot, SdkManager sdkManager) {
        File folder = new File(osSdkRoot, "system-images");
        folder = new File(folder, AndroidTargetHash.getPlatformHashString((AndroidVersion)this.getAndroidVersion()));
        String tag = this.getTag().getId();
        tag = tag.toLowerCase(Locale.US);
        tag = tag.replaceAll("[^a-z0-9_-]+", "_");
        tag = tag.replaceAll("_+", "_");
        tag = tag.replaceAll("-+", "-");
        folder = new File(folder, tag);
        String abi = this.getAbi();
        abi = abi.toLowerCase(Locale.US);
        abi = abi.replaceAll("[^a-z0-9_-]+", "_");
        abi = abi.replaceAll("_+", "_");
        abi = abi.replaceAll("-+", "-");
        folder = new File(folder, abi);
        return folder;
    }
}

