/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.ArrayList;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0007\u0004)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\t\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u0001\u0012E\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0004\u000b\u0005AA!B\u0001\u0005\u0006\u0015\t\u0001RC\u0003\u0001\u000b\u0005AA\"B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0003\u00111Q!\u0001E\u0006\u000b\u0005!)!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tAa\u0003\u0007\u0001+\u0011!\u0001\u0001#\u0001\u0016\u0003a\t\u0011$\u0001M\u0002CGI1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011b\u0001\u0005\u0004\u001b\u0005A:!\u0003\u0004\t\t5!\u0011BA\u0005\u00029\u0001AJ!U\u0002\u0002\u0011\u0015)K\u0002\u0003\u000b\u000e\u0011%1\u0011\"B\u0005\u0003\u0013\u0005a\u0002\u0001$\u0001\u0019\u000ea1\u0011kA\u0001\t\u0010\u0015\"A!\u0001E\u0015\u001b\u0005AR#\n\u0005\u0005\u0003!-R\"\u0001\r\u00163\rAa#D\u0001\u0019\b\u0015Z\u0001RF\u0007\u0006\u0013\tI\u0011\u0001\b\u0001\r\u0002a5\u0011d\u0001\u0005\u0018\u001b\u0005Az#\n\u0007\u0005\u0015!AR\"\u0001\r\u00163\rA!!D\u0001\u0019\u0006e\u0019\u0001BF\u0007\u00021\u000f)3\u0003B\u0001\t25\t\u0001$F\r\u0007\u0011eiA!\u0003\u0002\n\u0003q\u0001\u0001TB\r\u0004\u0011Yi\u0011\u0001g\u0002\u001a\u0007!\u0011Q\"\u0001M\u0003K=!\u0011\u0001c\r\u000e\u0003a)\u0012d\u0001\u0005\u0018\u001b\u0005Ar\"\u0007\u0004\t55!\u0011BA\u0005\u00029\u0001Aj!J\b\u0005\u0015!UR\u0002B\u0005\u0003\u0013\u0005a\u0002\u0001'\u0004\u001a\u0007!YR\"\u0001\r\u00103\rA9$D\u0001\u0019\u001f\u0015zAA\u0003E\u001b\u001b\u0011I!!C\u0001\u001d\u0001a5\u0011d\u0002\u0005\u001d\u001b\u0015I1\u0001\"\u0001\n\u0003q\u0001\u0001TB\u0013\u0014\t\u0005AI$D\u0001\u0019+e1\u0001\"G\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u0019\u000ee\u0019\u0001bF\u0007\u00021=I2\u0001C\u000f\u000e\u0003ayQ\u0005\u0004\u0003\u000b\u0011wi\u0011\u0001\u0007\u0010\u001a\u0007!9R\"\u0001\r\u00103\rAi$D\u0001\u0019\u001f\u0015bAA\u0003\u0005 \u001b\u0005Ab$G\u0002\t/5\t\u0001dD\r\u0004\u0011{i\u0011\u0001G\b&\u0019\u0011Q\u0001bH\u0007\u00021yI2\u0001C\f\u000e\u0003ay\u0011d\u0001E \u001b\u0005A\u001a\"J\f\u0005\u0003!\u0001S\"\u0001\r\u00163\rA\t%D\u0001\u0019Ce1\u0001\"G\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u0019\u000ee\u0019\u0001bF\u0007\u00021=I2\u0001c\u0011\u000e\u0003ayQe\u0005\u0003\u0002\u0011\tj\u0011\u0001G\u000b\u001a\u0007!\u0005S\"\u0001M#3\u0019A\u0011$\u0004\u0003\n\u0005%\tA\u0004\u0001M\u00073\rAq#D\u0001\u0019\u001f\u0015zA!\u0001\u0005$\u001b\u0005AR#\u0007\u0004\tH5!\u0011BA\u0005\u00029\u0001Aj!G\u0002\t/5\t\u0001dD\u0013\u0010\t\u0005AA%D\u0001\u0019+e1\u0001\"G\u0007\u0005\u0013\tI\u0011\u0001\b\u0001\u0019\u000ee\u0019\u0001bF\u0007\u00021=)3\u0003B\u0001\tJ5\t\u0001$F\r\u0004\u0011\u0003j\u0011\u0001G\u0013\u001a\r!IR\u0002B\u0005\u0003\u0013\u0005a\u0002\u0001'\u0004\u001a\u0007!9R\"\u0001\r\u0010SI!1\t\u0003E\u0006\u001b!Ia!C\u0003\n\u0005%\tA\u0004\u0001G\u00011\u001bAb!U\u0002\u0006\u000b\u0005A\u0001\"\u0004\u0002\u0005\u000f!=\u0011f\u0004\u0003B\u0011!EQ\u0002C\u0005\u0007\u0013\u0015I!!C\u0001\u0019\u00141\u0005\u0001$\u0003\r\u0007#\u000e\u0011Q!\u0001\u0005\u000bS)!1\t\u0003E\u000b\u001b\u0005A2\"U\u0002\u0005\u000b\u0001i!\u0001b\u0006\t\u0019%jAA\u0011\u0005\t\t5!\u0011BA\u0005\u00029\u0001AJ!U\u0002\u0005\u000b\u0001i!\u0001\"\u0007\t\u001b%RAa\u0011\u0005\t\u00075\t\u0001tA)\u0004\t\u0015\u0001QB\u0001C\u000e\u00119I#\u0002B\"\t\u0011;i\u0011\u0001G\bR\u0007\u0011)\u0001!\u0004\u0002\u0005 !\u0001\u0012F\u0003\u0003D\u0011!\u0011Q\"\u0001M\u0003#\u000e!Q\u0001A\u0007\u0003\tCA\u0011#K\u0004\u0005\u0003\"A\u0019#D\u0001\u0019%E\u001b\u0011!\u0002\u0001*\u000f\u0011\t\u0005\u0002#\n\u000e\u0003a\u0019\u0012kA\u0001\u0006\u0001%:A!\u0011\u000f\t(5\t\u0001dD)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/codegen/optimization/common/MethodAnalyzer;", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;)V", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "getFrames", "()[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "handlers", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "instructions", "Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "getInstructions", "()Lorg/jetbrains/org/objectweb/asm/tree/InsnList;", "getInterpreter", "()Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "nInsns", "", "getNInsns", "()I", "getOwner", "()Ljava/lang/String;", "queue", "", "queued", "", "top", "analyze", "checkAssertions", "", "computeExceptionHandlersForEachInsn", "m", "getFrame", "insn", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "init", "initControlFlowAnalysis", "current", "mergeControlFlowEdge", "frame", "newFrame", "nLocals", "nStack", "src", "processControlFlowEdge", "jump", "visitControlFlowEdge", "", "successor", "visitControlFlowExceptionEdge", "tcb", "visitJumpInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insnOpcode", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitNopInsn", "f", "visitOpInsn", "visitTableSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;"}, moduleName="kotlin-compiler")
public class MethodAnalyzer<V extends Value> {
    @NotNull
    private final InsnList instructions;
    private final int nInsns;
    @NotNull
    private final Frame<V>[] frames;
    private final List<TryCatchBlockNode>[] handlers;
    private final boolean[] queued;
    private final int[] queue;
    private int top;
    @NotNull
    private final String owner;
    @NotNull
    private final MethodNode method;
    @NotNull
    private final Interpreter<V> interpreter;

    @NotNull
    public final InsnList getInstructions() {
        return this.instructions;
    }

    public final int getNInsns() {
        return this.nInsns;
    }

    @NotNull
    public final Frame<V>[] getFrames() {
        return this.frames;
    }

    protected void init(@NotNull String owner, @NotNull MethodNode m) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(m, "m");
    }

    @NotNull
    protected Frame<V> newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    @NotNull
    protected Frame<V> newFrame(@NotNull Frame<? extends V> src) {
        Intrinsics.checkParameterIsNotNull(src, "src");
        Frame<V> frame = this.newFrame(src.getLocals(), src.getMaxStackSize());
        frame.init(src);
        return frame;
    }

    protected boolean visitControlFlowEdge(int insn, int successor) {
        return true;
    }

    protected boolean visitControlFlowExceptionEdge(int insn, int successor) {
        return true;
    }

    protected boolean visitControlFlowExceptionEdge(int insn, @NotNull TryCatchBlockNode tcb) {
        Intrinsics.checkParameterIsNotNull(tcb, "tcb");
        return this.visitControlFlowExceptionEdge(insn, this.instructions.indexOf(tcb.handler));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Frame<V>[] analyze() {
        if (this.nInsns == 0) {
            return this.frames;
        }
        this.checkAssertions();
        this.computeExceptionHandlersForEachInsn(this.method);
        Frame<V> current = this.newFrame(this.method.maxLocals, this.method.maxStack);
        Frame<V> handler2 = this.newFrame(this.method.maxLocals, this.method.maxStack);
        this.initControlFlowAnalysis(current, this.method, this.owner);
        while (this.top > 0) {
            MethodAnalyzer methodAnalyzer = this;
            methodAnalyzer.top += -1;
            int insn = this.queue[methodAnalyzer.top];
            if (this.frames[insn] == null) {
                Intrinsics.throwNpe();
            }
            this.queued[insn] = false;
            AbstractInsnNode insnNode = this.method.instructions.get(insn);
            try {
                Unit unit;
                Frame<V> f;
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                if (insnType == 8 || insnType == 15 || insnType == 14) {
                    this.visitNopInsn(f, insn);
                } else {
                    current.init(f).execute(insnNode, this.interpreter);
                    if (insnNode instanceof JumpInsnNode) {
                        this.visitJumpInsnNode((JumpInsnNode)insnNode, current, insn, insnOpcode);
                    } else if (insnNode instanceof LookupSwitchInsnNode) {
                        this.visitLookupSwitchInsnNode((LookupSwitchInsnNode)insnNode, current, insn);
                    } else if (insnNode instanceof TableSwitchInsnNode) {
                        this.visitTableSwitchInsnNode((TableSwitchInsnNode)insnNode, current, insn);
                    } else if (insnOpcode != 191 && (insnOpcode < 172 || insnOpcode > 177)) {
                        this.visitOpInsn(current, insn);
                    }
                }
                List<TryCatchBlockNode> list = this.handlers[insn];
                if (list != null) {
                    void $receiver;
                    Iterable iterable = list;
                    for (Object element : $receiver) {
                        TryCatchBlockNode tcb = (TryCatchBlockNode)element;
                        String string = tcb.type;
                        if (string == null) {
                            string = "java/lang/Throwable";
                        }
                        Type exnType = Type.getObjectType(string);
                        int jump = this.getInstructions().indexOf(tcb.handler);
                        if (!this.visitControlFlowExceptionEdge(insn, tcb)) continue;
                        handler2.init(f);
                        handler2.clearStack();
                        handler2.push(this.getInterpreter().newValue(exnType));
                        this.mergeControlFlowEdge(jump, handler2);
                    }
                    unit = Unit.INSTANCE;
                    continue;
                }
                unit = null;
            }
            catch (AnalyzerException e) {
                void $receiver;
                AnalyzerException analyzerException;
                Throwable insnType = e;
                StringBuilder stringBuilder = new StringBuilder().append("Error at instruction ").append(insn).append(": ");
                AbstractInsnNode abstractInsnNode = e.node;
                AnalyzerException analyzerException2 = analyzerException;
                AnalyzerException analyzerException3 = analyzerException;
                String string = $receiver.getMessage();
                analyzerException2(abstractInsnNode, stringBuilder.append(string).toString(), e);
                throw (Throwable)analyzerException3;
            }
            catch (Exception e) {
                AnalyzerException analyzerException;
                Throwable $receiver = e;
                StringBuilder stringBuilder = new StringBuilder().append("Error at instruction ").append(insn).append(": ");
                AbstractInsnNode abstractInsnNode = insnNode;
                AnalyzerException analyzerException4 = analyzerException;
                AnalyzerException analyzerException5 = analyzerException;
                String string = $receiver.getMessage();
                analyzerException4(abstractInsnNode, stringBuilder.append(string).toString(), e);
                throw (Throwable)analyzerException5;
            }
        }
        return this.frames;
    }

    @Nullable
    public final Frame<V> getFrame(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkParameterIsNotNull(insn, "insn");
        return this.frames[this.instructions.indexOf(insn)];
    }

    private final void checkAssertions() {
        boolean bl;
        block2: {
            Object[] $receiver = this.instructions.toArray();
            for (int i = 0; i < $receiver.length; ++i) {
                Object element = $receiver[i];
                AbstractInsnNode it = (AbstractInsnNode)element;
                if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            throw (Throwable)((Object)new AssertionError((Object)"Subroutines are deprecated since Java 6"));
        }
    }

    private final void visitOpInsn(Frame<V> current, int insn) {
        this.processControlFlowEdge(current, insn, insn + 1);
    }

    private final void visitTableSwitchInsnNode(TableSwitchInsnNode insnNode, Frame<V> current, int insn) {
        int jump = this.instructions.indexOf(insnNode.dflt);
        this.processControlFlowEdge(current, insn, jump);
        for (LabelNode label : insnNode.labels) {
            jump = this.instructions.indexOf(label);
            this.processControlFlowEdge(current, insn, jump);
        }
    }

    private final void visitLookupSwitchInsnNode(LookupSwitchInsnNode insnNode, Frame<V> current, int insn) {
        int jump = this.instructions.indexOf(insnNode.dflt);
        this.processControlFlowEdge(current, insn, jump);
        for (LabelNode label : insnNode.labels) {
            jump = this.instructions.indexOf(label);
            this.processControlFlowEdge(current, insn, jump);
        }
    }

    private final void visitJumpInsnNode(JumpInsnNode insnNode, Frame<V> current, int insn, int insnOpcode) {
        if (insnOpcode != 167 && insnOpcode != 168) {
            this.processControlFlowEdge(current, insn, insn + 1);
        }
        int jump = this.instructions.indexOf(insnNode.label);
        this.processControlFlowEdge(current, insn, jump);
    }

    private final void visitNopInsn(Frame<V> f, int insn) {
        this.processControlFlowEdge(f, insn, insn + 1);
    }

    private final void processControlFlowEdge(Frame<V> current, int insn, int jump) {
        if (this.visitControlFlowEdge(insn, jump)) {
            this.mergeControlFlowEdge(jump, current);
        }
    }

    private final void initControlFlowAnalysis(Frame<V> current, MethodNode m, String owner) {
        current.setReturn(this.interpreter.newValue(Type.getReturnType(m.desc)));
        Type[] args = Type.getArgumentTypes(m.desc);
        int local = 0;
        if ((m.access & 8) == 0) {
            Type ctype = Type.getObjectType(owner);
            current.setLocal(local++, this.interpreter.newValue(ctype));
        }
        for (int i = 0; i < args.length; ++i) {
            Type arg = args[i];
            current.setLocal(local++, this.interpreter.newValue(arg));
            if (arg.getSize() != 2) continue;
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        while (local < m.maxLocals) {
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        this.mergeControlFlowEdge(0, current);
        this.init(owner, m);
    }

    /*
     * WARNING - void declaration
     */
    private final void computeExceptionHandlersForEachInsn(MethodNode m) {
        block0: for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            int end;
            int n;
            int begin = this.instructions.indexOf(tcb.start);
            int n2 = begin;
            if (n2 > (n = (end = this.instructions.indexOf(tcb.end)) - 1)) continue;
            while (true) {
                void j;
                List insnHandlers;
                if ((insnHandlers = this.handlers[j]) == null) {
                    this.handlers[j] = insnHandlers = (List)new ArrayList();
                }
                TryCatchBlockNode tryCatchBlockNode = tcb;
                Intrinsics.checkExpressionValueIsNotNull(tryCatchBlockNode, "tcb");
                insnHandlers.add(tryCatchBlockNode);
                if (j == n) continue block0;
                ++j;
            }
        }
    }

    private final void mergeControlFlowEdge(int insn, Frame<V> frame) {
        boolean changes;
        Frame<V> oldFrame = this.frames[insn];
        if (oldFrame == null) {
            this.frames[insn] = this.newFrame(frame);
            changes = true;
        } else {
            changes = oldFrame.merge(frame, this.interpreter);
        }
        if (changes && !this.queued[insn]) {
            this.queued[insn] = true;
            this.queue[this.top++] = insn;
        }
    }

    @NotNull
    public final String getOwner() {
        return this.owner;
    }

    @NotNull
    public final MethodNode getMethod() {
        return this.method;
    }

    @NotNull
    protected final Interpreter<V> getInterpreter() {
        return this.interpreter;
    }

    public MethodAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull Interpreter<V> interpreter) {
        Intrinsics.checkParameterIsNotNull(owner, "owner");
        Intrinsics.checkParameterIsNotNull(method, "method");
        Intrinsics.checkParameterIsNotNull(interpreter, "interpreter");
        this.owner = owner;
        this.method = method;
        this.interpreter = interpreter;
        InsnList insnList = this.method.instructions;
        Intrinsics.checkExpressionValueIsNotNull(insnList, "method.instructions");
        this.instructions = insnList;
        this.nInsns = this.instructions.size();
        this.frames = new Frame[this.nInsns];
        this.handlers = new List[this.nInsns];
        this.queued = new boolean[this.nInsns];
        this.queue = new int[this.nInsns];
    }
}

