/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fileClasses;

import com.google.protobuf.MessageLite;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.fileClasses.JvmFileClassInfo;
import org.jetbrains.kotlin.fileClasses.JvmMultifileClassPartInfo;
import org.jetbrains.kotlin.fileClasses.JvmSimpleFileClassInfo;
import org.jetbrains.kotlin.fileClasses.ParsedJmvFileClassAnnotations;
import org.jetbrains.kotlin.load.java.descriptors.UtilKt;
import org.jetbrains.kotlin.load.kotlin.PackagePartClassUtils;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFileAnnotationList;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedCallableMemberDescriptor;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"a\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Aq!B\u0001\r\u0003\u0015\tAqA\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u0005G\u0006a\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ%\u0004C\u0004\u0011!i!\u0001$\u0001\u0019\u0012e\u0019\u0001\"C\u0007\u00021'I2\u0001\u0003\u0006\u000e\u0003a!Q\u0005\u0003C\u0004\u0011+i\u0011\u0001G\u0006\u001a\u0007!IQ\"\u0001M\nK1!9\u0001c\u0006\u000e\u0003a\u0011\u0011d\u0001\u0005\n\u001b\u0005A\u001a\"G\u0002\t\u00195\t\u0001\u0014D\u0013\u000e\t\u000fAQ\"D\u0001\u0019\u0017e\u0019\u0001\"C\u0007\u00021'IB\u0001\u0003\u0007\u000e\u00051\u0005\u0001\u0014D\u0013\r\t\u000fAY\"D\u0001\u0019\u0017e\u0019\u0001\"C\u0007\u00021'I2\u0001\u0003\u0007\u000e\u0003aeQ\u0005\u0003C\u0004\u00119i\u0011\u0001G\u0006\u001a\u0007!IQ\"\u0001M\nK1!9\u0001#\b\u000e\u0003a\u0011\u0011d\u0001\u0005\n\u001b\u0005A\u001a\"G\u0002\t\u00195\t\u0001\u0014D\u0013\u000e\t\u000fAq\"\u0004\u0002\r\u0002a}\u0011d\u0001\u0005\u0011\u001b\u0005A\n#G\u0002\t#5\t\u00014E\u0013\n\t\u000fAq\"\u0004\u0002\r\u0002a}\u0011d\u0001\u0005\u0013\u001b\u0005A*#\n\u0006\u0005\u0004!\u0019RB\u0001G\u00011\u0011IB\u0001c\n\u000e\u00051\u0005\u0001\u0004F\u0013\t\t\u000fAI#D\u0001\u0019\u0005e\u0019\u0001BE\u0007\u00021K)C\u0002b\u0002\t+5\t\u0001\u0004B\r\u0004\u0011Wi\u0011\u0001\u0007\u0003\u001a\u0007!1R\"\u0001\r\u0005K%!9\u0001#\f\u000e\u00051\u0005\u0001\u0014D\r\u0004\u0011%i\u0011\u0001g\u0005*\u0015\u0011\u0019\u0005\u0002c\u0001\u000e\u0003a\u0011\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0001\u0005\u0004S3!1\t\u0003E\u0004\u001b\u000fAB!U\u0002\u0002\t\u0013\t6\u0001B\u0003\u0001\u001b\t!Q\u0001c\u0003*\u0015\u0011\u0019\u0005\u0002\u0003\u0004\u000e\u0003a\u0011\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0002\u0005\u0004S)!1\t\u0003\u0005\b\u001b\u0005AB!U\u0002\u0005\u000b\u0001i!\u0001b\u0004\t\f\u0001"}, strings={"Lorg/jetbrains/kotlin/fileClasses/JvmFileClassUtil;", "", "()V", "JVM_MULTIFILE_CLASS", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_MULTIFILE_CLASS", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_MULTIFILE_CLASS_SHORT", "", "Lorg/jetbrains/annotations/NotNull;", "getJVM_MULTIFILE_CLASS_SHORT", "()Ljava/lang/String;", "JVM_NAME", "getJVM_NAME", "JVM_NAME_SHORT", "getJVM_NAME_SHORT", "findAnnotationEntryOnFileNoResolve", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "shortName", "getDefaultFileClassInfo", "Lorg/jetbrains/kotlin/fileClasses/JvmFileClassInfo;", "getFacadeFqName", "jvmFileClassAnnotations", "Lorg/jetbrains/kotlin/fileClasses/ParsedJmvFileClassAnnotations;", "getFileClassInfo", "getFileClassInfoForAnnotation", "getFileClassInfoNoResolve", "getHiddenPartFqName", "getImplClassName", "Lorg/jetbrains/kotlin/name/Name;", "proto", "Lcom/google/protobuf/MessageLite;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "callable", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedCallableMemberDescriptor;", "getLiteralStringFromRestrictedConstExpression", "argumentExpression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "getPartFqNameForDeserializedCallable", "manglePartName", "facadeName", "fileName", "parseJvmNameOnFileNoResolve"}, moduleName="kotlin-compiler")
public final class JvmFileClassUtil {
    @NotNull
    public static final FqName JVM_NAME;
    @NotNull
    public static final String JVM_NAME_SHORT;
    @NotNull
    public static final FqName JVM_MULTIFILE_CLASS;
    @NotNull
    public static final String JVM_MULTIFILE_CLASS_SHORT;
    public static final JvmFileClassUtil INSTANCE;
    public static final JvmFileClassUtil INSTANCE$;

    @NotNull
    public final FqName getJVM_NAME() {
        return JVM_NAME;
    }

    @NotNull
    public final String getJVM_NAME_SHORT() {
        return JVM_NAME_SHORT;
    }

    @NotNull
    public final FqName getJVM_MULTIFILE_CLASS() {
        return JVM_MULTIFILE_CLASS;
    }

    @NotNull
    public final String getJVM_MULTIFILE_CLASS_SHORT() {
        return JVM_MULTIFILE_CLASS_SHORT;
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfo(@NotNull KtFile file, @Nullable ParsedJmvFileClassAnnotations jvmFileClassAnnotations) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return jvmFileClassAnnotations != null ? JvmFileClassUtil.getFileClassInfoForAnnotation(file, jvmFileClassAnnotations) : JvmFileClassUtil.getDefaultFileClassInfo(file);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoForAnnotation(@NotNull KtFile file, @NotNull ParsedJmvFileClassAnnotations jvmFileClassAnnotations) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(jvmFileClassAnnotations, "jvmFileClassAnnotations");
        return jvmFileClassAnnotations.getMultipleFiles() ? (JvmFileClassInfo)new JvmMultifileClassPartInfo(JvmFileClassUtil.getHiddenPartFqName(file, jvmFileClassAnnotations), JvmFileClassUtil.getFacadeFqName(file, jvmFileClassAnnotations)) : (JvmFileClassInfo)new JvmSimpleFileClassInfo(JvmFileClassUtil.getFacadeFqName(file, jvmFileClassAnnotations), true);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getDefaultFileClassInfo(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        FqName fqName2 = file.getPackageFqName();
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "file.packageFqName");
        String string = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string, "file.name");
        return new JvmSimpleFileClassInfo(PackagePartClassUtils.getPackagePartFqName(fqName2, string), false);
    }

    @JvmStatic
    @NotNull
    public static final FqName getFacadeFqName(@NotNull KtFile file, @NotNull ParsedJmvFileClassAnnotations jvmFileClassAnnotations) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(jvmFileClassAnnotations, "jvmFileClassAnnotations");
        FqName fqName2 = file.getPackageFqName().child(Name.identifier(jvmFileClassAnnotations.getName()));
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "file.packageFqName.child\u2026leClassAnnotations.name))");
        return fqName2;
    }

    @JvmStatic
    @NotNull
    public static final FqName getPartFqNameForDeserializedCallable(@NotNull DeserializedCallableMemberDescriptor callable) {
        Intrinsics.checkParameterIsNotNull(callable, "callable");
        Name name = JvmFileClassUtil.getImplClassName(callable);
        if (name == null) {
            name = (Name)((Object)PreconditionsKt.error("No implClassName for " + callable));
        }
        Name implClassName = name;
        DeclarationDescriptor declarationDescriptor = callable.getContainingDeclaration();
        if (declarationDescriptor == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor");
        }
        FqName packageFqName = ((PackageFragmentDescriptor)declarationDescriptor).getFqName();
        FqName fqName2 = packageFqName.child(implClassName);
        Intrinsics.checkExpressionValueIsNotNull(fqName2, "packageFqName.child(implClassName)");
        return fqName2;
    }

    @JvmStatic
    @Nullable
    public static final Name getImplClassName(@NotNull DeserializedCallableMemberDescriptor callable) {
        Intrinsics.checkParameterIsNotNull(callable, "callable");
        return UtilKt.getImplClassNameForDeserialized(callable);
    }

    @JvmStatic
    @Nullable
    public static final Name getImplClassName(@NotNull MessageLite proto, @NotNull NameResolver nameResolver) {
        Intrinsics.checkParameterIsNotNull(proto, "proto");
        Intrinsics.checkParameterIsNotNull(nameResolver, "nameResolver");
        return UtilKt.getImplClassNameForProto(proto, nameResolver);
    }

    @JvmStatic
    @NotNull
    public static final FqName getHiddenPartFqName(@NotNull KtFile file, @NotNull ParsedJmvFileClassAnnotations jvmFileClassAnnotations) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(jvmFileClassAnnotations, "jvmFileClassAnnotations");
        FqName fqName2 = file.getPackageFqName();
        String string = jvmFileClassAnnotations.getName();
        String string2 = file.getName();
        Intrinsics.checkExpressionValueIsNotNull(string2, "file.name");
        FqName fqName3 = fqName2.child(Name.identifier(JvmFileClassUtil.manglePartName(string, string2)));
        Intrinsics.checkExpressionValueIsNotNull(fqName3, "file.packageFqName.child\u2026ations.name, file.name)))");
        return fqName3;
    }

    @JvmStatic
    @NotNull
    public static final String manglePartName(@NotNull String facadeName, @NotNull String fileName) {
        Intrinsics.checkParameterIsNotNull(facadeName, "facadeName");
        Intrinsics.checkParameterIsNotNull(fileName, "fileName");
        return facadeName + "__" + PackagePartClassUtils.getFilePartShortName(fileName);
    }

    @JvmStatic
    @NotNull
    public static final JvmFileClassInfo getFileClassInfoNoResolve(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        return JvmFileClassUtil.getFileClassInfo(file, JvmFileClassUtil.parseJvmNameOnFileNoResolve(file));
    }

    @JvmStatic
    @Nullable
    public static final ParsedJmvFileClassAnnotations parseJvmNameOnFileNoResolve(@NotNull KtFile file) {
        Intrinsics.checkParameterIsNotNull(file, "file");
        KtAnnotationEntry ktAnnotationEntry = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, JVM_NAME_SHORT);
        if (ktAnnotationEntry == null) {
            return null;
        }
        KtAnnotationEntry jvmName = ktAnnotationEntry;
        Object object = CollectionsKt.firstOrNull(jvmName.getValueArguments());
        if (object == null || (object = object.getArgumentExpression()) == null) {
            return null;
        }
        Object nameExpr = object;
        String string = JvmFileClassUtil.getLiteralStringFromRestrictedConstExpression((KtExpression)nameExpr);
        if (string == null) {
            return null;
        }
        String name = string;
        if (!Name.isValidIdentifier(name)) {
            return null;
        }
        String string2 = JVM_MULTIFILE_CLASS_SHORT;
        Intrinsics.checkExpressionValueIsNotNull(string2, "JVM_MULTIFILE_CLASS_SHORT");
        boolean isMultifileClassPart = JvmFileClassUtil.findAnnotationEntryOnFileNoResolve(file, string2) != null;
        return new ParsedJmvFileClassAnnotations(name, isMultifileClassPart);
    }

    @JvmStatic
    @Nullable
    public static final KtAnnotationEntry findAnnotationEntryOnFileNoResolve(@NotNull KtFile file, @NotNull String shortName) {
        KtAnnotationEntry ktAnnotationEntry;
        Intrinsics.checkParameterIsNotNull(file, "file");
        Intrinsics.checkParameterIsNotNull(shortName, "shortName");
        Object object = file.getFileAnnotationList();
        if (object != null && (object = ((KtFileAnnotationList)object).getAnnotationEntries()) != null) {
            Object v2;
            block3: {
                Iterable $receiver = (Iterable)object;
                for (Object element : $receiver) {
                    KtAnnotationEntry it2 = (KtAnnotationEntry)element;
                    KtExpression ktExpression = it2.getCalleeExpression();
                    if (!Intrinsics.areEqual(ktExpression != null && (ktExpression = ((KtConstructorCalleeExpression)ktExpression).getConstructorReferenceExpression()) != null ? ktExpression.getReferencedName() : null, shortName)) continue;
                    v2 = element;
                    break block3;
                }
                v2 = null;
            }
            ktAnnotationEntry = v2;
        } else {
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }

    @JvmStatic
    private static final String getLiteralStringFromRestrictedConstExpression(KtExpression argumentExpression) {
        KtExpression ktExpression = argumentExpression;
        if (!(ktExpression instanceof KtStringTemplateExpression)) {
            ktExpression = null;
        }
        KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
        if (ktStringTemplateExpression == null) {
            return null;
        }
        KtStringTemplateExpression stringTemplate = ktStringTemplateExpression;
        KtStringTemplateEntry[] stringTemplateEntries = stringTemplate.getEntries();
        Object[] $receiver = stringTemplateEntries;
        if ($receiver.length != 1) {
            return null;
        }
        KtStringTemplateEntry ktStringTemplateEntry = stringTemplateEntries[0];
        if (!(ktStringTemplateEntry instanceof KtLiteralStringTemplateEntry)) {
            ktStringTemplateEntry = null;
        }
        KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)ktStringTemplateEntry;
        if (ktLiteralStringTemplateEntry == null) {
            return null;
        }
        KtLiteralStringTemplateEntry singleEntry = ktLiteralStringTemplateEntry;
        return singleEntry.getText();
    }

    static {
        new JvmFileClassUtil();
    }

    private JvmFileClassUtil() {
        INSTANCE = this;
        INSTANCE$ = this;
        JVM_NAME = new FqName("kotlin.jvm.JvmName");
        String string = JVM_NAME.shortName().asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "JVM_NAME.shortName().asString()");
        JVM_NAME_SHORT = string;
        JVM_MULTIFILE_CLASS = new FqName("kotlin.jvm.JvmMultifileClass");
        JVM_MULTIFILE_CLASS_SHORT = JVM_MULTIFILE_CLASS.shortName().asString();
    }
}

