/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.intellij.psi.PsiElement;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorResolver;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"Q\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0005)\u0011\u0001\u0003\t\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011\u0001\u0004\u0001\u001a\u0003a\u0005\u0011UC\u0005\u0004\u0011\u0005i\u0011\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0003#\u000e\t\u0001bA\u0013\u0011\t\u0005A9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0003\u000e\u0003a1\u0011d\u0001E\u0007\u001b\u0005Ar!J\u0012\u0005\b!=Q\"\u0001\r\u00053\u0019A\u0001\"\u0004\u0003\n\u0005%\t\u0001D\u0002M\t3\u0019A\u0011\"\u0004\u0003\n\u0005%\t\u0001$\u0002M\t3\rA\u0019\"D\u0001\u0019\u0015e\u0019\u0001RC\u0007\u00021-I2\u0001c\u0006\u000e\u0003aa\u0011\u0004\u0002\u0003\u0002\u00113i\u0011\u0001G\u0007*\u000f\u0011\t\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00035\t\u00014A)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/types/expressions/ValueParameterResolver;", "", "expressionTypingServices", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;", "constantExpressionEvaluator", "Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingServices;Lorg/jetbrains/kotlin/resolve/constants/evaluate/ConstantExpressionEvaluator;)V", "resolveDefaultValue", "", "valueParameterDescriptor", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "jetParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "resolveValueParameters", "valueParameters", "", "valueParameterDescriptors", "declaringScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "callChecker", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;"}, moduleName="kotlin-compiler")
public final class ValueParameterResolver {
    private final ExpressionTypingServices expressionTypingServices;
    private final ConstantExpressionEvaluator constantExpressionEvaluator;

    @JvmOverloads
    public final void resolveValueParameters(@NotNull List<? extends KtParameter> valueParameters, @NotNull List<? extends ValueParameterDescriptor> valueParameterDescriptors, @NotNull LexicalScope declaringScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace trace, @NotNull CallChecker callChecker) {
        Intrinsics.checkParameterIsNotNull(valueParameters, "valueParameters");
        Intrinsics.checkParameterIsNotNull(valueParameterDescriptors, "valueParameterDescriptors");
        Intrinsics.checkParameterIsNotNull(declaringScope, "declaringScope");
        Intrinsics.checkParameterIsNotNull(dataFlowInfo, "dataFlowInfo");
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(callChecker, "callChecker");
        LexicalScopeImpl scopeForDefaultValue = new LexicalScopeImpl(declaringScope, declaringScope.getOwnerDescriptor(), false, null, LexicalScopeKind.DEFAULT_VALUE, null, null, 96, null);
        ExpressionTypingContext contextForDefaultValue = ExpressionTypingContext.newContext(trace, scopeForDefaultValue, dataFlowInfo, TypeUtils.NO_EXPECTED_TYPE, callChecker);
        for (Pair pair : CollectionsKt.zip((Iterable)valueParameterDescriptors, (Iterable)valueParameters)) {
            ValueParameterDescriptor descriptor2 = (ValueParameterDescriptor)pair.component1();
            KtParameter parameter = (KtParameter)pair.component2();
            ForceResolveUtil.forceResolveAllContents(descriptor2.getAnnotations());
            ExpressionTypingContext expressionTypingContext = contextForDefaultValue;
            Intrinsics.checkExpressionValueIsNotNull(expressionTypingContext, "contextForDefaultValue");
            this.resolveDefaultValue(descriptor2, parameter, expressionTypingContext);
        }
    }

    @JvmOverloads
    public static /* bridge */ /* synthetic */ void resolveValueParameters$default(ValueParameterResolver valueParameterResolver, List list, List list2, LexicalScope lexicalScope, DataFlowInfo dataFlowInfo, BindingTrace bindingTrace, CallChecker callChecker, int n) {
        if ((n & 0x20) != 0) {
            callChecker = CallChecker.DoNothing.INSTANCE;
        }
        valueParameterResolver.resolveValueParameters(list, list2, lexicalScope, dataFlowInfo, bindingTrace, callChecker);
    }

    @JvmOverloads
    public void resolveValueParameters(@NotNull List<? extends KtParameter> list, @NotNull List<? extends ValueParameterDescriptor> list2, @NotNull LexicalScope lexicalScope, @NotNull DataFlowInfo dataFlowInfo, @NotNull BindingTrace bindingTrace) {
        ValueParameterResolver.resolveValueParameters$default(this, list, list2, lexicalScope, dataFlowInfo, bindingTrace, null, 32);
    }

    private final void resolveDefaultValue(ValueParameterDescriptor valueParameterDescriptor, KtParameter jetParameter, ExpressionTypingContext context) {
        if (!valueParameterDescriptor.declaresDefaultValue()) {
            return;
        }
        KtExpression ktExpression = jetParameter.getDefaultValue();
        if (ktExpression == null) {
            return;
        }
        KtExpression defaultValue = ktExpression;
        this.expressionTypingServices.getTypeInfo(defaultValue, (ResolutionContext)context.replaceExpectedType(valueParameterDescriptor.getType()));
        if (DescriptorUtils.isAnnotationClass(DescriptorResolver.getContainingClass(context.scope))) {
            KtExpression ktExpression2 = defaultValue;
            Intrinsics.checkExpressionValueIsNotNull(ktExpression2, "defaultValue");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            CompileTimeConstant<?> compileTimeConstant = this.constantExpressionEvaluator.evaluateExpression(ktExpression2, bindingTrace, valueParameterDescriptor.getType());
            if (compileTimeConstant == null) {
                context.trace.report(Errors.ANNOTATION_PARAMETER_DEFAULT_VALUE_MUST_BE_CONSTANT.on((KtExpression)((PsiElement)defaultValue)));
                compileTimeConstant = Unit.INSTANCE;
            }
        }
    }

    public ValueParameterResolver(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull ConstantExpressionEvaluator constantExpressionEvaluator) {
        Intrinsics.checkParameterIsNotNull(expressionTypingServices, "expressionTypingServices");
        Intrinsics.checkParameterIsNotNull(constantExpressionEvaluator, "constantExpressionEvaluator");
        this.expressionTypingServices = expressionTypingServices;
        this.constantExpressionEvaluator = constantExpressionEvaluator;
    }
}

