/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm;

import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.LeafASTNode;
import org.intellij.markdown.ast.impl.ListCompositeNode;
import org.intellij.markdown.ast.impl.ListItemCompositeNode;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineHolderGeneratingProvider;
import org.intellij.markdown.html.SimpleTagProvider;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tA\u0001\u0001\u0007\u00013\u0005A\n!(\u0001\bC\u000b\t6!\u0001\u0005\u0002K5!\u0011\u0001c\u0001\u000e\u0003a\u0011\u0011\u0004\u0002E\u0003\u001b\ta\t\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u0003KI!1\u0002\u0003\u0003\u000e\u0003a%\u0011$\u0002\u0005\u0006\u001b\rAZ!K\u0001\u0019\re\u0019\u0001rA\u0007\u00021\tI2\u0001#\u0002\u000e\u0003a\u0019QE\u0005\u0003\f\u0011\u001bi\u0011\u0001'\u0003\u001a\u000b!)Qb\u0001M\u0006S\u0005Ab!G\u0002\t\b5\t\u0001DA\r\u0004\u0011\u000bi\u0011\u0001G\u0002"}, strings={"Lorg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider;", "Lorg/intellij/markdown/html/SimpleTagProvider;", "()V", "getIsCheckedString", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "text", "openTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "processNode", "SubParagraphGeneratingProvider"}, moduleName="intellij-markdown")
public final class CheckedListItemGeneratingProvider
extends SimpleTagProvider {
    @Override
    public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
    }

    @Override
    public void processNode(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
        CharSequence inputHtml;
        CharSequence listItemClass;
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        PreconditionsKt.assert((boolean)(node instanceof ListItemCompositeNode));
        ASTNode checkBoxElement = ASTUtilKt.findChildOfType(node, GFMTokenTypes.INSTANCE.getCHECK_BOX());
        if (checkBoxElement != null) {
            listItemClass = "class=\"task-list-item\"";
            String checkedString = this.getIsCheckedString(checkBoxElement, text);
            inputHtml = "<input type=" + "\"" + "checkbox" + "\"" + " class=" + "\"" + "task-list-item-checkbox" + "\"" + checkedString + " disabled />";
        } else {
            listItemClass = null;
            inputHtml = "";
        }
        HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "li", new CharSequence[]{listItemClass}, false, 8);
        ASTNode aSTNode = node;
        if (aSTNode == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.intellij.markdown.ast.impl.ListItemCompositeNode");
        }
        ListCompositeNode listCompositeNode = ((ListItemCompositeNode)aSTNode).getParent();
        if (listCompositeNode == null) {
            Intrinsics.throwNpe();
        }
        boolean isLoose = listCompositeNode.getLoose();
        boolean flushedInput = false;
        for (ASTNode child : ((ListItemCompositeNode)node).getChildren()) {
            if (child instanceof LeafASTNode) continue;
            if (!flushedInput) {
                if (Intrinsics.areEqual((Object)child.getType(), (Object)MarkdownElementTypes.Companion.getPARAGRAPH())) {
                    new SubParagraphGeneratingProvider(isLoose, (String)inputHtml).processNode(visitor, text, child);
                } else {
                    visitor.consumeHtml(inputHtml);
                    ASTNodeKt.accept(child, visitor);
                }
                flushedInput = true;
                continue;
            }
            ASTNodeKt.accept(child, visitor);
        }
        this.closeTag(visitor, text, node);
    }

    /*
     * WARNING - void declaration
     */
    private final String getIsCheckedString(ASTNode node, String text) {
        Boolean bl;
        Object object = node;
        if (object != null && (object = ASTUtilKt.getTextInNode((ASTNode)object, text)) != null) {
            void $receiver$iv;
            Object object2 = object;
            CharSequence it = (CharSequence)$receiver$iv;
            bl = it.length() > 1 && it.charAt(1) != ' ';
        } else {
            bl = null;
        }
        boolean isChecked = Intrinsics.areEqual(bl, (Object)true);
        String checkedString = isChecked ? " checked" : "";
        return checkedString;
    }

    public CheckedListItemGeneratingProvider() {
        super("li");
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!1!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\t\u0005a\u0001!G\u0001\u0019\u0002\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA)\u0004\u0003!\u0019QE\u0005\u0003\f\u0011\u0017i\u0011\u0001\u0007\u0004\u001a\u000b!5Qb\u0001\r\bS\u0005Az!G\u0002\t\u00115\t\u0001TA\r\u0004\u0011#i\u0011\u0001G\u0005&%\u0011Y\u00012C\u0007\u00021\u0019IR\u0001#\u0004\u000e\u0007a9\u0011&\u0001M\b3\rA\u0001\"D\u0001\u0019\u0006e\u0019\u0001\u0012C\u0007\u00021%I#\u0002B\"\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\b!!\u0011F\u0003\u0003D\u0011!\tQ\"\u0001M\u0002#\u000e!Q\u0001A\u0007\u0003\t\u0013AQ\u0001"}, strings={"Lorg/intellij/markdown/flavours/gfm/CheckedListItemGeneratingProvider$SubParagraphGeneratingProvider;", "Lorg/intellij/markdown/html/InlineHolderGeneratingProvider;", "wrapInParagraph", "", "inputHtml", "", "(ZLjava/lang/String;)V", "getInputHtml", "()Ljava/lang/String;", "getWrapInParagraph", "()Z", "closeTag", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "text", "node", "Lorg/intellij/markdown/ast/ASTNode;", "openTag"}, moduleName="intellij-markdown")
    private static final class SubParagraphGeneratingProvider
    extends InlineHolderGeneratingProvider {
        private final boolean wrapInParagraph;
        @NotNull
        private final String inputHtml;

        @Override
        public void openTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (this.wrapInParagraph) {
                HtmlGenerator.HtmlGeneratingVisitor.consumeTagOpen$default(visitor, node, "p", new CharSequence[0], false, 8);
            }
            visitor.consumeHtml(this.inputHtml);
        }

        @Override
        public void closeTag(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (this.wrapInParagraph) {
                visitor.consumeTagClose("p");
            }
        }

        public final boolean getWrapInParagraph() {
            return this.wrapInParagraph;
        }

        @NotNull
        public final String getInputHtml() {
            return this.inputHtml;
        }

        public SubParagraphGeneratingProvider(boolean wrapInParagraph, @NotNull String inputHtml) {
            Intrinsics.checkParameterIsNotNull((Object)inputHtml, (String)"inputHtml");
            this.wrapInParagraph = wrapInParagraph;
            this.inputHtml = inputHtml;
        }
    }
}

