/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import java.util.Map;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.MarkdownTokenTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTNodeKt;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.ast.visitors.RecursiveVisitor;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.GeneratingProvider;
import org.intellij.markdown.html.entities.EntityConverter;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005AY!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005A!#B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007a\u0001\u0001\u0005\u0006\u001a\u0003a\u0005Q$\u0001F\u000bCcI1\u0001C\u0001\u000e\u0003a\r\u0011b\u0001\u0005\u0003\u001b\u0005A*!C\u0002\t\u00075\t\u0001tA\u0005\u0005\t\u0005AA!D\u0001\u0019\n%!A!\u0001\u0005\u0006\u001b\u0005AZ!U\u0002\u0002\u0011\u0019)3\u0001c\u0005\u000e\u0003a\r\u0011f\u0002\u0003B\u0011!5Q\"\u0001\r\b#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001\"B\u0007\u00021\u0017\t6!A\u0003\u0001S\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001IS\u0002B!\t\u0011\u001fiq!\u0003\u0002\n\u0003aE\u0011BA\u0005\u00021%A\u0002\"U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\ti\u0011\u0001'\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/intellij/markdown/html/HtmlGenerator;", "", "markdownText", "", "root", "Lorg/intellij/markdown/ast/ASTNode;", "flavour", "Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "includeSrcPositions", "", "(Ljava/lang/String;Lorg/intellij/markdown/ast/ASTNode;Lorg/intellij/markdown/flavours/MarkdownFlavourDescriptor;Lorg/intellij/markdown/parser/LinkMap;Z)V", "htmlString", "Ljava/lang/StringBuilder;", "providers", "", "Lorg/intellij/markdown/IElementType;", "Lorg/intellij/markdown/html/GeneratingProvider;", "generateHtml", "Companion", "HtmlGeneratingVisitor"}, moduleName="intellij-markdown")
public final class HtmlGenerator {
    @NotNull
    public static final String SRC_ATTRIBUTE_NAME = "md-src-pos";
    private final Map<IElementType, GeneratingProvider> providers;
    private final StringBuilder htmlString;
    private final String markdownText;
    private final ASTNode root;
    private final boolean includeSrcPositions;
    public static final Companion Companion = org.intellij.markdown.html.HtmlGenerator$Companion.INSTANCE;

    static {
        SRC_ATTRIBUTE_NAME = SRC_ATTRIBUTE_NAME;
    }

    @NotNull
    public final String generateHtml() {
        new HtmlGeneratingVisitor().visitNode(this.root);
        String string = this.htmlString.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"htmlString.toString()");
        return string;
    }

    public HtmlGenerator(@NotNull String markdownText, @NotNull ASTNode root, @NotNull MarkdownFlavourDescriptor flavour, @NotNull LinkMap linkMap, boolean includeSrcPositions) {
        Intrinsics.checkParameterIsNotNull((Object)markdownText, (String)"markdownText");
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Intrinsics.checkParameterIsNotNull((Object)flavour, (String)"flavour");
        Intrinsics.checkParameterIsNotNull((Object)linkMap, (String)"linkMap");
        this.markdownText = markdownText;
        this.root = root;
        this.includeSrcPositions = includeSrcPositions;
        this.providers = flavour.createHtmlGeneratingProviders(linkMap);
        this.htmlString = new StringBuilder();
    }

    public /* synthetic */ HtmlGenerator(String string, ASTNode aSTNode, MarkdownFlavourDescriptor markdownFlavourDescriptor, LinkMap linkMap, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            linkMap = LinkMap.Builder.buildLinkMap(aSTNode, string);
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        this(string, aSTNode, markdownFlavourDescriptor, linkMap, bl);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011\u001b)\u0011\u0001\u0002\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0011#)\u0001!B\u0001\t\f\u0015\tA1\u0001\u0003D\u00051\u0001\u0011$\u0001M\u0001C\u000b\t6!\u0001\u0005\u0002K\u001dA\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\r)s\u0001c\u0002\u000e\u0003a\u0011\u0011d\u0001\u0005\u0005\u001b\u0005A2!*\u0010\t\n5\t\u0001DA\r\u0004\u0011\u0015i\u0011\u0001g\u0003\u001a\u0007!!Q\"\u0001\r\u00043-Aa!\u0004\u0004\n\t\u0011\u0005\u0011B\u0001G\u00011\rAj!\u0005\u0002\r\u0002a\u0019\u0011\u0004\u0002\u0003\u0002\u0011\u001di\u0011\u0001g\u0004R\u0007\u0005A\u0001\"J\u0004\t\u00125\t\u0001DA\r\u0004\u0011\u0015i\u0011\u0001g\u0003&\u0011\u0011Y\u0001\"C\u0007\u00021\tI2\u0001C\u0003\u000e\u0003a-\u0001"}, strings={"Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/ast/visitors/RecursiveVisitor;", "(Lorg/intellij/markdown/html/HtmlGenerator;)V", "consumeHtml", "", "html", "", "consumeTagClose", "tagName", "consumeTagOpen", "node", "Lorg/intellij/markdown/ast/ASTNode;", "attributes", "", "autoClose", "", "(Lorg/intellij/markdown/ast/ASTNode;Ljava/lang/CharSequence;[Ljava/lang/CharSequence;Z)V", "visitLeaf", "visitNode"}, moduleName="intellij-markdown")
    public final class HtmlGeneratingVisitor
    extends RecursiveVisitor {
        @Override
        public void visitNode(@NotNull ASTNode node) {
            block3: {
                GeneratingProvider generatingProvider;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    generatingProvider = (GeneratingProvider)HtmlGenerator.this.providers.get(node.getType());
                    if (generatingProvider == null) break block2;
                    generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
                    generatingProvider = Unit.INSTANCE;
                    if (generatingProvider != null) break block3;
                }
                ASTNodeKt.acceptChildren(node, this);
                generatingProvider = Unit.INSTANCE;
            }
        }

        public final void visitLeaf(@NotNull ASTNode node) {
            block3: {
                GeneratingProvider generatingProvider;
                block2: {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    generatingProvider = (GeneratingProvider)HtmlGenerator.this.providers.get(node.getType());
                    if (generatingProvider == null) break block2;
                    generatingProvider.processNode(this, HtmlGenerator.this.markdownText, node);
                    generatingProvider = Unit.INSTANCE;
                    if (generatingProvider != null) break block3;
                }
                this.consumeHtml(org.intellij.markdown.html.HtmlGenerator$Companion.leafText$default(Companion, HtmlGenerator.this.markdownText, node, false, 4));
                generatingProvider = Unit.INSTANCE;
            }
        }

        public final void consumeTagOpen(@NotNull ASTNode node, @NotNull CharSequence tagName, @NotNull CharSequence[] attributes, boolean autoClose) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            Intrinsics.checkParameterIsNotNull((Object)attributes, (String)"attributes");
            HtmlGenerator.this.htmlString.append("<" + tagName);
            for (int i = 0; i < attributes.length; ++i) {
                CharSequence attribute = attributes[i];
                if (attribute == null) continue;
                HtmlGenerator.this.htmlString.append(" " + attribute);
            }
            if (HtmlGenerator.this.includeSrcPositions) {
                HtmlGenerator.this.htmlString.append(" " + Companion.getSrcPosAttribute(node));
            }
            if (autoClose) {
                HtmlGenerator.this.htmlString.append(" />");
            } else {
                HtmlGenerator.this.htmlString.append(">");
            }
        }

        public static /* bridge */ /* synthetic */ void consumeTagOpen$default(HtmlGeneratingVisitor htmlGeneratingVisitor, ASTNode aSTNode, CharSequence charSequence, CharSequence[] charSequenceArray, boolean bl, int n) {
            if ((n & 8) != 0) {
                bl = false;
            }
            htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, bl);
        }

        public final void consumeTagClose(@NotNull CharSequence tagName) {
            Intrinsics.checkParameterIsNotNull((Object)tagName, (String)"tagName");
            HtmlGenerator.this.htmlString.append("</" + tagName + ">");
        }

        public final void consumeHtml(@NotNull CharSequence html) {
            Intrinsics.checkParameterIsNotNull((Object)html, (String)"html");
            HtmlGenerator.this.htmlString.append(html);
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"/\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005Ai!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005AY!B\u0001\u0005\u0003\u0015\t\u0001\u0002\u0002\u0003D\u00041\u0001\u0011$\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005)s\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!\n\t\t\f5\t\u0001\u0004B\r\u0004\u0011\u0019i\u0011\u0001\u0007\u0002\u001a\u0007!%Q\"\u0001\r\u00063\u0011!\u0011\u0001#\u0004\u000e\u0003a9Qe\u0003E\b\u001b\u0005AB!G\u0002\t\r5\t\u0001\u0004B\r\u0004\u0011!i\u0011\u0001'\u0005*\u0018\u0011\u0019\u0005*\u0001E\u0002\u001b\u0005A\"!U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0006!\u0019\u0001"}, strings={"Lorg/intellij/markdown/html/HtmlGenerator$Companion;", "", "()V", "SRC_ATTRIBUTE_NAME", "", "getSRC_ATTRIBUTE_NAME", "()Ljava/lang/String;", "getSrcPosAttribute", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "leafText", "text", "replaceEscapesAndEntities", "", "trimIndents", "indent", ""}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getSRC_ATTRIBUTE_NAME() {
            return SRC_ATTRIBUTE_NAME;
        }

        @NotNull
        public final CharSequence leafText(@NotNull String text, @NotNull ASTNode node, boolean replaceEscapesAndEntities) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownTokenTypes.Companion.getBLOCK_QUOTE())) {
                return "";
            }
            return EntityConverter.INSTANCE.replaceEntities(ASTUtilKt.getTextInNode(node, text), replaceEscapesAndEntities, replaceEscapesAndEntities);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ CharSequence leafText$default(Companion companion, String string, ASTNode aSTNode, boolean bl, int n) {
            if ((n & 4) != 0) {
                bl = true;
            }
            return companion.leafText(string, aSTNode, bl);
        }

        @NotNull
        public final CharSequence getSrcPosAttribute(@NotNull ASTNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.getSRC_ATTRIBUTE_NAME() + "=" + "\"" + node.getStartOffset() + ".." + node.getEndOffset() + "\"";
        }

        @NotNull
        public final CharSequence trimIndents(@NotNull CharSequence text, int indent) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            if (indent == 0) {
                return text;
            }
            StringBuilder buffer = new StringBuilder();
            int lastFlushed = 0;
            for (int offset = 0; offset < text.length(); ++offset) {
                if (offset != 0 && text.charAt(offset - 1) != '\n') continue;
                buffer.append(text.subSequence(lastFlushed, offset));
                int indentEaten = 0;
                block5: while (indentEaten < indent && offset < text.length()) {
                    switch (text.charAt(offset)) {
                        case ' ': {
                            ++indentEaten;
                            break;
                        }
                        case '\t': {
                            indentEaten += 4 - indentEaten % 4;
                            break;
                        }
                        default: {
                            break block5;
                        }
                    }
                    ++offset;
                }
                if (indentEaten > indent) {
                    buffer.append(StringsKt.repeat((CharSequence)" ", (int)(indentEaten - indent)));
                }
                lastFlushed = offset;
            }
            buffer.append(text.subSequence(lastFlushed, text.length()));
            return buffer;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

