/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.html;

import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.Regex;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.ast.ASTUtilKt;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.InlineLinkGeneratingProvider;
import org.intellij.markdown.html.LinkGeneratingProvider;
import org.intellij.markdown.html.ReferenceLinksGeneratingProvider;
import org.intellij.markdown.parser.LinkMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"M\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005Ai!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\t\u0001a\u0001\u0001e\u0007\u001a\u0003a\u0005Q\u0014a\u0007\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003K1!\u0011\u0001#\u0004\u000e\u0003a9\u0011d\u0001E\b\u001b\u0005A\u0002\"G\u0002\t\u00125\t\u0001$C\u0013\u000e\t-A\u0019\"\u0004\u0002\r\u0002aQ\u0011d\u0001E\t\u001b\u0005A\u0012\"G\u0002\t\u00105\t\u0001\u0004C\u0013\u0017\t-A)\"D\u0001\u0019\u0017e)\u0001rC\u0007\u000411I\u0013\u0001'\u0007\u001a\u0007!EQ\"\u0001\r\n3\rAy!D\u0001\u0019\u0011e\u0019\u0001\"D\u0007\u00021)I#\u0002B\"\t\u0011\u000bi\u0011\u0001G\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\b!!\u0011F\u0003\u0003D\u0011!%Q\"\u0001\r\u0006#\u000e!Q\u0001A\u0007\u0003\t\u0017Aa\u0001"}, strings={"Lorg/intellij/markdown/html/ImageGeneratingProvider;", "Lorg/intellij/markdown/html/LinkGeneratingProvider;", "linkMap", "Lorg/intellij/markdown/parser/LinkMap;", "(Lorg/intellij/markdown/parser/LinkMap;)V", "inlineLinkProvider", "Lorg/intellij/markdown/html/InlineLinkGeneratingProvider;", "getInlineLinkProvider", "()Lorg/intellij/markdown/html/InlineLinkGeneratingProvider;", "referenceLinkProvider", "Lorg/intellij/markdown/html/ReferenceLinksGeneratingProvider;", "getReferenceLinkProvider", "()Lorg/intellij/markdown/html/ReferenceLinksGeneratingProvider;", "getPlainTextFrom", "", "node", "Lorg/intellij/markdown/ast/ASTNode;", "text", "", "getRenderInfo", "Lorg/intellij/markdown/html/LinkGeneratingProvider$RenderInfo;", "renderLink", "", "visitor", "Lorg/intellij/markdown/html/HtmlGenerator$HtmlGeneratingVisitor;", "Lorg/intellij/markdown/html/HtmlGenerator;", "info", "Companion"}, moduleName="intellij-markdown")
public final class ImageGeneratingProvider
extends LinkGeneratingProvider {
    @NotNull
    public static final Regex REGEX;
    @NotNull
    private final ReferenceLinksGeneratingProvider referenceLinkProvider;
    @NotNull
    private final InlineLinkGeneratingProvider inlineLinkProvider;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.html.ImageGeneratingProvider$Companion.INSTANCE;
        REGEX = new Regex("[^a-zA-Z0-9 ]");
    }

    @NotNull
    public final ReferenceLinksGeneratingProvider getReferenceLinkProvider() {
        return this.referenceLinkProvider;
    }

    @NotNull
    public final InlineLinkGeneratingProvider getInlineLinkProvider() {
        return this.inlineLinkProvider;
    }

    @Override
    @Nullable
    public LinkGeneratingProvider.RenderInfo getRenderInfo(@NotNull String text, @NotNull ASTNode node) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        ASTNode aSTNode = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.Companion.getINLINE_LINK());
        if (aSTNode != null) {
            ASTNode $receiver$iv = aSTNode;
            ASTNode linkNode = $receiver$iv;
            return this.getInlineLinkProvider().getRenderInfo(text, linkNode);
        }
        ASTNode aSTNode2 = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.Companion.getFULL_REFERENCE_LINK());
        if (aSTNode2 == null) {
            aSTNode2 = ASTUtilKt.findChildOfType(node, MarkdownElementTypes.Companion.getSHORT_REFERENCE_LINK());
        }
        if (aSTNode2 != null) {
            ASTNode $receiver$iv = aSTNode2;
            ASTNode linkNode = $receiver$iv;
            return this.getReferenceLinkProvider().getRenderInfo(text, linkNode);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void renderLink(@NotNull HtmlGenerator.HtmlGeneratingVisitor visitor, @NotNull String text, @NotNull ASTNode node, @NotNull LinkGeneratingProvider.RenderInfo info) {
        String string;
        CharSequence[] charSequenceArray;
        Intrinsics.checkParameterIsNotNull((Object)visitor, (String)"visitor");
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor = visitor;
        ASTNode aSTNode = node;
        CharSequence charSequence = "img";
        boolean bl = true;
        CharSequence[] charSequenceArray2 = new CharSequence[3];
        charSequenceArray2[0] = "src=" + "\"" + info.getDestination() + "\"";
        charSequenceArray2[1] = "alt=" + "\"" + this.getPlainTextFrom(info.getLabel(), text) + "\"";
        CharSequence[] charSequenceArray3 = charSequenceArray2;
        CharSequence[] charSequenceArray4 = charSequenceArray2;
        int n = 2;
        CharSequence[] charSequenceArray5 = info.getTitle();
        if (charSequenceArray5 != null) {
            void $receiver$iv;
            charSequenceArray = charSequenceArray5;
            int n2 = n;
            CharSequence[] charSequenceArray6 = charSequenceArray3;
            CharSequence[] charSequenceArray7 = charSequenceArray4;
            boolean bl2 = bl;
            CharSequence charSequence2 = charSequence;
            ASTNode aSTNode2 = aSTNode;
            HtmlGenerator.HtmlGeneratingVisitor htmlGeneratingVisitor2 = htmlGeneratingVisitor;
            CharSequence it = (CharSequence)$receiver$iv;
            String string2 = "title=" + "\"" + it + "\"";
            htmlGeneratingVisitor = htmlGeneratingVisitor2;
            aSTNode = aSTNode2;
            charSequence = charSequence2;
            bl = bl2;
            charSequenceArray4 = charSequenceArray7;
            charSequenceArray3 = charSequenceArray6;
            n = n2;
            string = string2;
        } else {
            string = null;
        }
        charSequenceArray3[n] = string;
        charSequenceArray = charSequenceArray4;
        boolean bl3 = bl;
        htmlGeneratingVisitor.consumeTagOpen(aSTNode, charSequence, charSequenceArray, bl3);
    }

    private final CharSequence getPlainTextFrom(ASTNode node, String text) {
        return Companion.getREGEX().replace(ASTUtilKt.getTextInNode(node, text), "");
    }

    public ImageGeneratingProvider(@NotNull LinkMap linkMap) {
        Intrinsics.checkParameterIsNotNull((Object)linkMap, (String)"linkMap");
        this.referenceLinkProvider = new ReferenceLinksGeneratingProvider(linkMap);
        this.inlineLinkProvider = new InlineLinkGeneratingProvider();
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\t\r\u000fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!K\u0006\u0005\u0007\"A\u0019!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011AQ\u0001\u0005\u0004"}, strings={"Lorg/intellij/markdown/html/ImageGeneratingProvider$Companion;", "", "()V", "REGEX", "Lkotlin/text/Regex;", "getREGEX", "()Lkotlin/text/Regex;"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final Regex getREGEX() {
            return REGEX;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

