/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.parser.markerblocks.providers;

import java.util.List;
import kotlin.CollectionsKt;
import kotlin.Pair;
import kotlin.PreconditionsKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.MarkerProcessor;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockProvider;
import org.intellij.markdown.parser.markerblocks.impl.HtmlBlockMarkerBlock;
import org.intellij.markdown.parser.markerblocks.providers.HtmlBlockProvider;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0011\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0001\u0019\u0001\u0001\u001a\"\u0007\u0003\n\u0005%\t\u0001$\u0001M\u0001;\u0003M\u0011UA)\u0004\u0003!\rQ%\u0006\u0003\f\u0011\tiA!\u0003\u0002\n\u0003a\u0019\u0001TA\r\u0006\u0011\u000fi1\u0001\u0007\u0003*\u0003a%\u0011d\u0001\u0005\u0006\u001b\u0005AZ!G\u0002\t\r5\t\u0001$A\u0013\u000f\t-Ai!D\u0001\u0019\u000fe)\u0001rA\u0007\u00041\u0011I\u0013\u0001'\u0003\u001a\u0007!=Q\"\u0001\r\tK9!\u0011\u0001#\u0005\u000e\u0003aI\u0011$\u0002E\u0004\u001b\rAB!K\u0001\u0019\ne\u0019\u0001rB\u0007\u00021!\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockProvider;", "Lorg/intellij/markdown/parser/MarkerProcessor$StateInfo;", "()V", "createMarkerBlocks", "", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "stateInfo", "interruptsParagraph", "", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "matches", "", "Companion"}, moduleName="intellij-markdown")
public final class HtmlBlockProvider
implements MarkerBlockProvider<MarkerProcessor.StateInfo> {
    @NotNull
    public static final String TAG_NAMES = "address, article, aside, base, basefont, blockquote, body, caption, center, col, colgroup, dd, details, dialog, dir, div, dl, dt, fieldset, figcaption, figure, footer, form, frame, frameset, h1, head, header, hr, html, legend, li, link, main, menu, menuitem, meta, nav, noframes, ol, optgroup, option, p, param, pre, section, source, title, summary, table, tbody, td, tfoot, th, thead, title, tr, track, ul";
    @NotNull
    public static final String TAG_NAME = "[a-zA-Z][a-zA-Z0-9-]*";
    @NotNull
    public static final String ATTR_NAME = "[A-Za-z:_][A-Za-z0-9_.:-]*";
    @NotNull
    public static final String ATTR_VALUE = "\\s*=\\s*(?:[^ \"'=<>`]+|'[^']*'|\"[^\"]*\")";
    @NotNull
    public static final String ATTRIBUTE = "\\s+[A-Za-z:_][A-Za-z0-9_.:-]*(?:\\s*=\\s*(?:[^ \"'=<>`]+|'[^']*'|\"[^\"]*\"))?";
    @NotNull
    public static final String OPEN_TAG = "<[a-zA-Z][a-zA-Z0-9-]*(?:\\s+[A-Za-z:_][A-Za-z0-9_.:-]*(?:\\s*=\\s*(?:[^ \"'=<>`]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>";
    @NotNull
    public static final String CLOSE_TAG = "</[a-zA-Z][a-zA-Z0-9-]*\\s*>";
    @NotNull
    public static final List<Pair<Regex, Regex>> OPEN_CLOSE_REGEXES;
    @NotNull
    public static final Regex FIND_START_REGEX;
    public static final Companion Companion;

    static {
        Companion = org.intellij.markdown.parser.markerblocks.providers.HtmlBlockProvider$Companion.INSTANCE;
        TAG_NAMES = "address, article, aside, base, basefont, blockquote, body, caption, center, col, colgroup, dd, details, " + "dialog, dir, div, dl, dt, fieldset, figcaption, figure, footer, form, frame, frameset, h1, " + "head, header, hr, html, legend, li, link, main, menu, menuitem, meta, nav, noframes, ol, " + "optgroup, option, p, param, pre, section, source, title, summary, table, tbody, td, tfoot, " + "th, thead, title, tr, track, ul";
        TAG_NAME = TAG_NAME;
        ATTR_NAME = ATTR_NAME;
        ATTR_VALUE = ATTR_VALUE;
        ATTRIBUTE = "\\" + "s+" + Companion.getATTR_NAME() + "(?:" + Companion.getATTR_VALUE() + ")?";
        OPEN_TAG = "<" + Companion.getTAG_NAME() + "(?:" + Companion.getATTRIBUTE() + ")*" + "\\" + "s*/?>";
        CLOSE_TAG = "</" + Companion.getTAG_NAME() + "\\" + "s*>";
        OPEN_CLOSE_REGEXES = CollectionsKt.listOf((Object[])new Pair[]{new Pair((Object)new Regex("<(?i:script|pre|style)(?: |>|$)"), (Object)new Regex("</(?i:script|style|pre)>")), new Pair((Object)new Regex("<!--"), (Object)new Regex("-->")), new Pair((Object)new Regex("<\\?"), (Object)new Regex("\\?>")), new Pair((Object)new Regex("<![A-Z]"), (Object)new Regex(">")), new Pair((Object)new Regex("<!\\[CDATA\\["), (Object)new Regex("\\]\\]>")), new Pair((Object)new Regex("</?(?i:" + StringsKt.replace$default((String)Companion.getTAG_NAMES(), (String)", ", (String)"|", (boolean)false, (int)4) + ")(?: |/?>|" + "$" + ")"), null), new Pair((Object)new Regex("(?:" + Companion.getOPEN_TAG() + "|" + Companion.getCLOSE_TAG() + ")(?: |" + "$" + ")"), null)});
        FIND_START_REGEX = new Regex(CollectionsKt.joinToString$default((Iterable)Companion.getOPEN_CLOSE_REGEXES(), (CharSequence)"|", null, null, (int)0, null, (Function1)Companion.FIND_START_REGEX.1.INSTANCE, (int)30));
    }

    @Override
    @NotNull
    public List<MarkerBlock> createMarkerBlocks(@NotNull LookaheadText.Position pos, @NotNull ProductionHolder productionHolder, @NotNull MarkerProcessor.StateInfo stateInfo) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)productionHolder, (String)"productionHolder");
        Intrinsics.checkParameterIsNotNull((Object)stateInfo, (String)"stateInfo");
        int matchingGroup = this.matches(pos, stateInfo.getCurrentConstraints());
        if (matchingGroup != -1) {
            return CollectionsKt.listOf((Object)new HtmlBlockMarkerBlock(stateInfo.getCurrentConstraints(), productionHolder, (Regex)Companion.getOPEN_CLOSE_REGEXES().get(matchingGroup).getSecond(), pos));
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean interruptsParagraph(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)pos, (String)"pos");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        int n = this.matches(pos, constraints);
        boolean bl = true;
        if (n < 0) {
            bl = false;
        }
        boolean bl2 = true;
        if (n > 5) {
            bl2 = false;
        }
        return bl & bl2;
    }

    private final int matches(LookaheadText.Position pos, MarkdownConstraints constraints) {
        Unit unit;
        int i;
        Unit unit2;
        int value$iv;
        if (!MarkerBlockProvider.Companion.isStartOfLineWithConstraints(pos, constraints)) {
            return -1;
        }
        MatchResult matchResult = Regex.find$default((Regex)Companion.getFIND_START_REGEX(), (CharSequence)pos.getCurrentLineFromPosition(), (int)0, (int)2);
        if (matchResult == null) {
            return -1;
        }
        MatchResult matchResult2 = matchResult;
        boolean bl = matchResult2.getGroups().size() == Companion.getOPEN_CLOSE_REGEXES().size() + 1;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (value$iv == 0) {
                String message$iv = "There are some excess capturing groups probably!";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit2 = Unit.INSTANCE;
        } else {
            unit2 = Unit.INSTANCE;
        }
        value$iv = 1;
        int message$iv = Companion.getOPEN_CLOSE_REGEXES().size();
        if (value$iv <= message$iv) {
            while (true) {
                if (matchResult2.getGroups().get(i) != null) {
                    return i - 1;
                }
                if (i == message$iv) break;
                ++i;
            }
        }
        i = 0;
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (value$iv == 0) {
                String message$iv2 = "Match found but all groups are empty!";
                throw (Throwable)((Object)new AssertionError((Object)message$iv2));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        return -1;
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={")\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0005\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0003\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\t\u0011v\u0003\u0003D\u0011\u0006A\u0019!D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011AQ\u0001\u0005\u0004S/!1\tS\u0001\t\b5\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u0011A1!k\u0006\u0005\u0007\"\u000b\u0001\u0012B\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001B\u0003\t\u0007%^Aa\u0011%\u0002\u0011\u0017i\u0011\u0001\u0007\u0002R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u00111\u0001bA\u0015\f\t\rC\u0001RB\u0007\u00021\u001d\t6!B\u0003\u0002\u0019\u0003i!\u0001b\u0004\t\u0011%*Ba\u0011\u0005\t\u00125Y\u0011\"C\u0005\t\u0013\tI\u0011\u0001G\u0004\n\u0007%\u0011A\u0012\u0001\r\b1'A\u0012\"U\u0002\u0006\u000b\u0005a\t!\u0004\u0002\u0005\u0015!U\u0011v\u0003\u0003D\u0011\u0006A1\"D\u0001\u0019\u0005E\u001bQ!B\u0001\r\u00025\u0011Aq\u0003\u0005\u0004S/!1\tS\u0001\t\u00195\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t3A1!k\u0006\u0005\u0007\"\u000b\u0001\"D\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001b\u0007\t\u0007\u0001"}, strings={"Lorg/intellij/markdown/parser/markerblocks/providers/HtmlBlockProvider$Companion;", "", "()V", "ATTRIBUTE", "", "getATTRIBUTE", "()Ljava/lang/String;", "ATTR_NAME", "getATTR_NAME", "ATTR_VALUE", "getATTR_VALUE", "CLOSE_TAG", "getCLOSE_TAG", "FIND_START_REGEX", "Lkotlin/text/Regex;", "getFIND_START_REGEX", "()Lkotlin/text/Regex;", "OPEN_CLOSE_REGEXES", "", "Lkotlin/Pair;", "getOPEN_CLOSE_REGEXES", "()Ljava/util/List;", "OPEN_TAG", "getOPEN_TAG", "TAG_NAME", "getTAG_NAME", "TAG_NAMES", "getTAG_NAMES"}, moduleName="intellij-markdown")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getTAG_NAMES() {
            return TAG_NAMES;
        }

        @NotNull
        public final String getTAG_NAME() {
            return TAG_NAME;
        }

        @NotNull
        public final String getATTR_NAME() {
            return ATTR_NAME;
        }

        @NotNull
        public final String getATTR_VALUE() {
            return ATTR_VALUE;
        }

        @NotNull
        public final String getATTRIBUTE() {
            return ATTRIBUTE;
        }

        @NotNull
        public final String getOPEN_TAG() {
            return OPEN_TAG;
        }

        @NotNull
        public final String getCLOSE_TAG() {
            return CLOSE_TAG;
        }

        @NotNull
        public final List<Pair<Regex, Regex>> getOPEN_CLOSE_REGEXES() {
            return OPEN_CLOSE_REGEXES;
        }

        @NotNull
        public final Regex getFIND_START_REGEX() {
            return FIND_START_REGEX;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }
}

