/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.JavaPsiFacadeEx;
import com.intellij.psi.impl.PsiModificationTrackerImpl;
import com.intellij.psi.search.ProjectScope;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.JavaCodeInsightTestFixture;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.CodeInsightTestFixtureImpl;
import com.intellij.util.ui.UIUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class JavaCodeInsightTestFixtureImpl
extends CodeInsightTestFixtureImpl
implements JavaCodeInsightTestFixture {
    public JavaCodeInsightTestFixtureImpl(IdeaProjectTestFixture projectFixture, TempDirTestFixture tempDirFixture) {
        super(projectFixture, tempDirFixture);
    }

    @Override
    public JavaPsiFacadeEx getJavaFacade() {
        this.assertInitialized();
        return JavaPsiFacadeEx.getInstanceEx((Project)this.getProject());
    }

    @Override
    public PsiClass addClass(@NotNull @NonNls String classText) {
        if (classText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classText", "com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl", "addClass"));
        }
        this.assertInitialized();
        PsiClass psiClass = this.addClass(this.getTempDirPath(), classText);
        VirtualFile file = psiClass.getContainingFile().getVirtualFile();
        this.allowTreeAccessForFile(file);
        return psiClass;
    }

    private PsiClass addClass(@NonNls String rootPath, final @NotNull @NonNls String classText) {
        if (classText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classText", "com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl", "addClass"));
        }
        String qName = ApplicationManager.getApplication().runReadAction(new Computable<String>(){

            public String compute() {
                PsiFileFactory factory = PsiFileFactory.getInstance(JavaCodeInsightTestFixtureImpl.this.getProject());
                PsiJavaFile javaFile = (PsiJavaFile)factory.createFileFromText("a.java", (FileType)JavaFileType.INSTANCE, (CharSequence)classText);
                return javaFile.getClasses()[0].getQualifiedName();
            }
        });
        assert (qName != null);
        final PsiFile psiFile = this.addFileToProject(rootPath, qName.replace('.', '/') + ".java", classText);
        return ApplicationManager.getApplication().runReadAction(new Computable<PsiClass>(){

            public PsiClass compute() {
                return ((PsiJavaFile)psiFile).getClasses()[0];
            }
        });
    }

    @Override
    @NotNull
    public PsiClass findClass(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl", "findClass"));
        }
        PsiClass aClass = this.getJavaFacade().findClass(name, ProjectScope.getProjectScope(this.getProject()));
        Assert.assertNotNull((String)("Class " + name + " not found"), (Object)aClass);
        PsiClass psiClass = aClass;
        if (psiClass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl", "findClass"));
        }
        return psiClass;
    }

    @Override
    @NotNull
    public PsiPackage findPackage(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl", "findPackage"));
        }
        PsiPackage aPackage = this.getJavaFacade().findPackage(name);
        Assert.assertNotNull((String)("Package " + name + " not found"), (Object)aPackage);
        PsiPackage psiPackage = aPackage;
        if (psiPackage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/JavaCodeInsightTestFixtureImpl", "findPackage"));
        }
        return psiPackage;
    }

    public void tearDown() throws Exception {
        try {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((PsiModificationTrackerImpl)JavaCodeInsightTestFixtureImpl.this.getPsiManager().getModificationTracker()).incCounter();
                }
            });
        }
        finally {
            super.tearDown();
        }
    }
}

