/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.actions;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.StorageScheme;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.actions.CommonCheckinFilesAction;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.BeforeCheckinDialogHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.List;
import kotlin.ArraysKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.settingsRepository.IcsBundleKt;
import org.jetbrains.settingsRepository.actions.CommitToIcsAction;
import org.jetbrains.settingsRepository.actions.CommitToIcsActionKt;
import org.jetbrains.settingsRepository.actions.ProjectChangeCollectConsumer;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"E\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0012C\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\r\u0001e\t\u0001\u0014AO\u0001\u0019\u0005\u0016\u0011kA\u0001\t\u0003\u0015BAA\u0003E\u0002\u001b\u0005A\"!G\u0002\t\u00065\t\u0001dA\u0013\u0011\t)A9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0003\u000e\u0003a1\u0011d\u0001E\u0003\u001b\u0005A2!*\f\u0005\u0015!5Q\"\u0001\r\b3\rAy!D\u0001\u0019\u0007e\u0019\u0001\u0002C\u0007\u00021#Ir\u0001C\u0005\u000e\u000b%\u0019A\u0011A\u0005\u00021)A\u001a\"U\u0002\u0002\u0011+)[\u0003\u0002\u0006\t\u00175!\u0011BA\u0005\u00021)A\u001a\"G\u0004\t\u00135)\u0011b\u0001C\u0001\u0013\u0005A\"\u0002g\u0005\u001a\u0007!AQ\"\u0001M\t#\u000e\t\u0001r\u0003"}, strings={"Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction;", "Lcom/intellij/openapi/vcs/actions/CommonCheckinFilesAction;", "()V", "getActionName", "", "dataContext", "Lcom/intellij/openapi/vcs/actions/VcsContext;", "isApplicableRoot", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "status", "Lcom/intellij/openapi/vcs/FileStatus;", "performCheckIn", "", "context", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vcs/FilePath;", "(Lcom/intellij/openapi/vcs/actions/VcsContext;Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vcs/FilePath;)V", "prepareRootsForCommit", "([Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/project/Project;)[Lcom/intellij/openapi/vcs/FilePath;", "IcsBeforeCommitDialogHandler"}, moduleName="settings-repository")
public final class CommitToIcsAction
extends CommonCheckinFilesAction {
    @NotNull
    protected String getActionName(@NotNull VcsContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        return IcsBundleKt.icsMessage("action.CommitToIcs.text", new Object[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean isApplicableRoot(@NotNull VirtualFile file, @NotNull FileStatus status, @NotNull VcsContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)status, (String)"status");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        Project project = dataContext.getProject();
        if (!(project instanceof ProjectEx)) return false;
        IComponentStore iComponentStore = ServiceKt.getStateStore((ComponentManager)((ComponentManager)project));
        if (iComponentStore == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.components.impl.stores.IProjectStore");
        }
        if (!Intrinsics.areEqual((Object)((IProjectStore)iComponentStore).getStorageScheme(), (Object)StorageScheme.DIRECTORY_BASED)) return false;
        if (!super.isApplicableRoot(file, status, dataContext)) return false;
        if (file.isDirectory()) return false;
        Project project2 = dataContext.getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"dataContext.project!!");
        if (!CommitToIcsActionKt.access$isProjectConfigFile(file, project2)) return false;
        return true;
    }

    @NotNull
    protected FilePath[] prepareRootsForCommit(@NotNull FilePath[] roots, @NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (roots == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<com.intellij.openapi.vcs.FilePath>");
        }
        return roots;
    }

    protected void performCheckIn(@NotNull VcsContext context, @NotNull Project project, @NotNull FilePath[] roots) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        String projectId = CommitToIcsActionKt.access$getProjectId(project);
        if (projectId == null) {
            return;
        }
        Change[] changes = context.getSelectedChanges();
        ProjectChangeCollectConsumer collectConsumer = new ProjectChangeCollectConsumer(project);
        if (changes != null && ArraysKt.isNotEmpty((Object[])changes)) {
            for (int i = 0; i < changes.length; ++i) {
                Change change;
                Change change2 = change = changes[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)change2, (String)"change");
                collectConsumer.consume(change2);
            }
        } else {
            ChangeListManager manager = ChangeListManager.getInstance((Project)project);
            FilePath[] filePathArray = this.getRoots(context);
            for (int i = 0; i < filePathArray.length; ++i) {
                FilePath path = filePathArray[i];
                Collection collection = manager.getChangesIn(path);
                Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"manager.getChangesIn(path)");
                CommitToIcsActionKt.access$collectProjectChanges(collection, collectConsumer);
            }
        }
        CommitToIcsActionKt.access$showDialog(project, collectConsumer, projectId);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"+\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00011\u0001\u0001SB\r\u00021\u0003i\nQBQ\u0003#\u000e\t\u0001\"A\u0013\r\t-A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!Q%\u0003\u0003\f\u0011\u0013i!\u0001$\u0001\u0019\u000be\u0019\u00012B\u0007\u00021\u0019\u0001"}, strings={"Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandlerFactory;", "()V", "createHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "createSystemReadyHandler", "Lcom/intellij/openapi/vcs/checkin/BeforeCheckinDialogHandler;", "project", "Lcom/intellij/openapi/project/Project;", "Companion"}, moduleName="settings-repository")
    public static final class IcsBeforeCommitDialogHandler
    extends CheckinHandlerFactory {
        private static final Companion.BEFORE_CHECKIN_DIALOG_HANDLER.1 BEFORE_CHECKIN_DIALOG_HANDLER;
        public static final Companion Companion;

        static {
            Companion = Companion.INSTANCE;
            BEFORE_CHECKIN_DIALOG_HANDLER = new BeforeCheckinDialogHandler(){

                public boolean beforeCommitDialogShown(@NotNull Project project, @NotNull List<? extends Change> changes, @NotNull Iterable<? extends CommitExecutor> executors, boolean showVcsCommit) {
                    Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
                    Intrinsics.checkParameterIsNotNull(changes, (String)"changes");
                    Intrinsics.checkParameterIsNotNull(executors, (String)"executors");
                    ProjectChangeCollectConsumer collectConsumer = new ProjectChangeCollectConsumer(project);
                    CommitToIcsActionKt.access$collectProjectChanges(changes, collectConsumer);
                    CommitToIcsActionKt.access$showDialog(project, collectConsumer, null);
                    return true;
                }
            };
        }

        @NotNull
        public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
            Intrinsics.checkParameterIsNotNull((Object)panel, (String)"panel");
            Intrinsics.checkParameterIsNotNull((Object)commitContext, (String)"commitContext");
            CheckinHandler checkinHandler = CheckinHandler.DUMMY;
            Intrinsics.checkExpressionValueIsNotNull((Object)checkinHandler, (String)"CheckinHandler.DUMMY");
            return checkinHandler;
        }

        @Nullable
        public BeforeCheckinDialogHandler createSystemReadyHandler(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return IcsBeforeCommitDialogHandler.Companion.getBEFORE_CHECKIN_DIALOG_HANDLER();
        }

        @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u0014\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003\u0011\u0011Q\u0013\u0001\u0002\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\t\u0011\u0006\u0004\u0003B\u0011!\rQ\"\u0001\r\u0003#\u000e1QA\u0001E\u0004\u0019\u0003i!\u0001\"\u0002\t\u0007\u0001"}, strings={"Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler$Companion;", "", "()V", "BEFORE_CHECKIN_DIALOG_HANDLER", "org/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler$Companion$BEFORE_CHECKIN_DIALOG_HANDLER$1", "getBEFORE_CHECKIN_DIALOG_HANDLER", "()Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler$Companion$BEFORE_CHECKIN_DIALOG_HANDLER$1;", "Lorg/jetbrains/settingsRepository/actions/CommitToIcsAction$IcsBeforeCommitDialogHandler$Companion$BEFORE_CHECKIN_DIALOG_HANDLER$1;"}, moduleName="settings-repository")
        public static final class Companion {
            public static final Companion INSTANCE;

            private final BEFORE_CHECKIN_DIALOG_HANDLER.1 getBEFORE_CHECKIN_DIALOG_HANDLER() {
                return BEFORE_CHECKIN_DIALOG_HANDLER;
            }

            static {
                new Companion();
            }

            private Companion() {
                INSTANCE = this;
            }
        }
    }
}

