/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import java.util.LinkedHashSet;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class RunInspectionIntention
implements IntentionAction,
HighPriorityAction {
    private final String myShortName;

    public RunInspectionIntention(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/actions/RunInspectionIntention", "<init>"));
        }
        this.myShortName = toolWrapper.getShortName();
    }

    public RunInspectionIntention(HighlightDisplayKey key) {
        this.myShortName = key.toString();
    }

    @NotNull
    public String getText() {
        String string = InspectionsBundle.message((String)"run.inspection.on.file.intention.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/RunInspectionIntention", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionIntention", "isAvailable"));
        }
        return LocalInspectionToolWrapper.findTool2RunInBatch(project, (PsiElement)file2, this.myShortName) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        BaseAnalysisActionDialog dlg;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/actions/RunInspectionIntention", "invoke"));
        }
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        Module module = file2 != null ? ModuleUtilCore.findModuleForPsiElement((PsiElement)file2) : null;
        AnalysisScope analysisScope = new AnalysisScope(project);
        if (file2 != null) {
            VirtualFile virtualFile = file2.getVirtualFile();
            if (file2.isPhysical() && virtualFile != null && virtualFile.isInLocalFileSystem()) {
                analysisScope = new AnalysisScope(file2);
            }
        }
        if (!(dlg = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.title", (Object[])new Object[0])}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{InspectionsBundle.message((String)"inspection.action.noun", (Object[])new Object[0])}), project, analysisScope, module != null ? module.getName() : null, true, AnalysisUIOptions.getInstance(project), (PsiElement)file2)).showAndGet()) {
            return;
        }
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project);
        analysisScope = dlg.getScope(uiOptions, analysisScope, project, module);
        RunInspectionIntention.rerunInspection(LocalInspectionToolWrapper.findTool2RunInBatch(project, (PsiElement)file2, this.myShortName), managerEx, analysisScope, (PsiElement)file2);
    }

    public static void rerunInspection(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, @NotNull AnalysisScope scope, PsiElement psiElement) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/actions/RunInspectionIntention", "rerunInspection"));
        }
        if (managerEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managerEx", "com/intellij/codeInspection/actions/RunInspectionIntention", "rerunInspection"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/codeInspection/actions/RunInspectionIntention", "rerunInspection"));
        }
        GlobalInspectionContextImpl inspectionContext = RunInspectionIntention.createContext(toolWrapper, managerEx, psiElement);
        inspectionContext.doInspections(scope);
    }

    public static GlobalInspectionContextImpl createContext(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionManagerEx managerEx, PsiElement psiElement) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toolWrapper", "com/intellij/codeInspection/actions/RunInspectionIntention", "createContext"));
        }
        if (managerEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managerEx", "com/intellij/codeInspection/actions/RunInspectionIntention", "createContext"));
        }
        InspectionProfileImpl rootProfile = (InspectionProfileImpl)InspectionProfileManager.getInstance().getRootProfile();
        LinkedHashSet<InspectionToolWrapper> allWrappers = new LinkedHashSet<InspectionToolWrapper>();
        allWrappers.add(toolWrapper);
        rootProfile.collectDependentInspections(toolWrapper, allWrappers, managerEx.getProject());
        InspectionToolWrapper[] toolWrappers = allWrappers.toArray(new InspectionToolWrapper[allWrappers.size()]);
        InspectionProfileImpl model = InspectionProfileImpl.createSimple(toolWrapper.getDisplayName(), managerEx.getProject(), toolWrappers);
        try {
            Element element = new Element("toCopy");
            for (InspectionToolWrapper wrapper : toolWrappers) {
                wrapper.getTool().writeSettings(element);
                InspectionToolWrapper tw = psiElement == null ? model.getInspectionTool(wrapper.getShortName(), managerEx.getProject()) : model.getInspectionTool(wrapper.getShortName(), psiElement);
                tw.getTool().readSettings(element);
            }
        }
        catch (WriteExternalException element) {
        }
        catch (InvalidDataException element) {
            // empty catch block
        }
        model.setEditable(toolWrapper.getDisplayName());
        GlobalInspectionContextImpl inspectionContext = managerEx.createNewGlobalContext(false);
        inspectionContext.setExternalProfile(model);
        return inspectionContext;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

