/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SystemProperties;
import gnu.trove.THashMap;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import kotlin.ArraysKt;
import kotlin.IntRange;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.iq80.snappy.SnappyInputStream;
import org.iq80.snappy.SnappyOutputStream;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\u0012\u0015\t\u0001bB\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0004\u0015\t\u0001\"A\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001E\u0012\u000b\u0005!\u0019!B\u0001\t%\u0015\u0001Q!\u0001E\u0006\u000b\u0005!1!B\u0001\t&\u0015\u0001A\u0002\u0001I\u00103\u0005A\n!(A\u0010CK!\u0011!\u0003\u0004\t\u00035!\u0011BA\u0005\u00021\tA\u001a!C\u0004\t\u00065)\u0011bA\u0005\u0003\u0019\u0003A\n\u0001G\u0002R\u0007\u0005A9!\n\u0007\t\n5\t\u0001$B\r\u0004\u0011\u0017i\u0011\u0001\u0007\u0002\u001a\t!1QB\u0001G\u00011\u001b)#\u0003C\u0004\u000e\u0003a)\u0011d\u0001E\u0006\u001b\u0005A\"!G\u0002\t\u00105\t\u0001\u0004A\r\u0007\u0011!iA!\u0003\u0002\n\u0003a\u0011\u0001\u0014C\u0013\t\u0011%i!\u0001$\u0001\u0019\u0002e\u0019\u00012B\u0007\u00021\t)3\u0003c\u0005\u000e\u0003a5\u0011d\u0001E\u0006\u001b\u0005A\"!G\u0006\u0005\u0003!QQ\u0002C\u0005\u0003\u0013\u0005A\"!\u0003\u0002\n\u0003a5A\u0012\u0001M\u000bK5A1\"\u0004\u0002\r\u0002a5\u0011d\u0001E\u0006\u001b\u0005A\"!\u0007\u0003\u0005\u0003!%Q\"\u0001M\fK\u001dAA\"D\u0001\u0019\u0018e\u0019\u00012B\u0007\u00021\t)3\u0001#\u0007\u000e\u0003a]Qe\u0001\u0005\u000e\u001b\u0005A:\"*\u0005\t\u001c5!\u0011BA\u0005\u00021\tA\u001a!U\u0002\u0002\u00119)\u0013\u0002#\b\u000e\u000f%\u0011\u0011\"\u0001\r\u0003\u0013\tI\u0011\u0001'\u0001\u0019\u001f%ZA!\u0011\u0005\t\u00035!\u0011BA\u0005\u00021\tA\u001a!U\u0002\u0003\u000b\u0005AA!K\u0006\u0005\u0003\"A)!D\u0003\n\u0007%\u0011A\u0012\u0001M\u00011\r\t6!A\u0003\u0001"}, strings={"Lcom/intellij/configurationStore/StateMap;", "", "names", "", "", "states", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "([Ljava/lang/String;Ljava/util/concurrent/atomic/AtomicReferenceArray;)V", "[Ljava/lang/String;", "archive", "", "key", "state", "Lorg/jdom/Element;", "compare", "newStates", "diffs", "", "get", "getElement", "newLiveStates", "", "getState", "", "hasState", "hasStates", "isEmpty", "keys", "()[Ljava/lang/String;", "toMutableMap", "", "Companion"}, moduleName="configuration-store-impl")
public final class StateMap {
    private static final Format XML_FORMAT;
    @NotNull
    public static final StateMap EMPTY;
    private final String[] names;
    private final AtomicReferenceArray<Object> states;
    public static final Companion Companion;

    static {
        StateMap stateMap;
        Companion = com.intellij.configurationStore.StateMap$Companion.INSTANCE;
        XML_FORMAT = Format.getRawFormat().setTextMode(Format.TextMode.TRIM).setOmitEncoding(true).setOmitDeclaration(true);
        StateMap stateMap2 = stateMap;
        StateMap stateMap3 = stateMap;
        Object[] objectArray = new String[0];
        stateMap2((String[])objectArray, new AtomicReferenceArray<Object>(0));
        EMPTY = stateMap3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Object> toMutableMap() {
        int n;
        THashMap map = new THashMap(((Object[])this.names).length);
        IntRange intRange = ArraysKt.getIndices((Object[])this.names);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                map.put((Object)this.names[i], this.states.get((int)i));
                if (i == n) break;
                ++i;
            }
        }
        return (Map)map;
    }

    @NotNull
    public final String[] keys() {
        return this.names;
    }

    @Nullable
    public final Object get(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        return index < 0 ? null : this.states.get(index);
    }

    @NotNull
    public final Element getElement(@NotNull String key, @Nullable Map<String, ? extends Element> newLiveStates) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return Companion.stateToElement(key, this.get(key), newLiveStates);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Element getElement$default(StateMap stateMap, String string, Map map, int n) {
        if ((n & 2) != 0) {
            map = null;
        }
        return stateMap.getElement(string, map);
    }

    public final boolean isEmpty() {
        return ArraysKt.isEmpty((Object[])this.names);
    }

    public final boolean hasState(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return this.get(key) instanceof Element;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasStates() {
        int n;
        if (this.isEmpty()) {
            return false;
        }
        IntRange intRange = ArraysKt.getIndices((Object[])this.names);
        int n2 = intRange.getFirst();
        if (n2 <= (n = intRange.getLast())) {
            while (true) {
                void i;
                if (this.states.get((int)i) instanceof Element) {
                    return true;
                }
                if (i == n) break;
                ++i;
            }
        }
        return false;
    }

    public final void compare(@NotNull String key, @NotNull StateMap newStates, @NotNull Set<String> diffs) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)newStates, (String)"newStates");
        Intrinsics.checkParameterIsNotNull(diffs, (String)"diffs");
        Object oldState = this.get(key);
        Object newState = newStates.get(key);
        if (oldState instanceof Element) {
            if (!JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)((Element)newState))) {
                diffs.add(key);
            }
        } else {
            Object object = newState;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            Object object2 = oldState;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
            }
            if (Companion.getNewByteIfDiffers(key, object, (byte[])object2) != null) {
                diffs.add(key);
            }
        }
    }

    @Nullable
    public final Element getState(@NotNull String key, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        if (index < 0) {
            return null;
        }
        Object object = this.states.get(index);
        if (!(object instanceof Element)) {
            object = null;
        }
        Element element = (Element)object;
        if (element == null) {
            return null;
        }
        Element state = element;
        if (!archive) {
            return state;
        }
        return this.states.compareAndSet(index, state, StateMap.Companion.archiveState(state)) ? state : this.getState(key, true);
    }

    @Nullable
    public static /* bridge */ /* synthetic */ Element getState$default(StateMap stateMap, String string, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return stateMap.getState(string, bl);
    }

    public final void archive(@NotNull String key, @Nullable Element state) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        int index = Arrays.binarySearch(this.names, key);
        if (index < 0) {
            return;
        }
        Object currentState = this.states.get(index);
        ComponentStoreImplKt.getLOG().assertTrue(currentState instanceof Element);
        this.states.set(index, state == null ? (byte[])null : StateMap.Companion.archiveState(state));
    }

    private StateMap(String[] names, AtomicReferenceArray<Object> states) {
        this.names = names;
        this.states = states;
    }

    public /* synthetic */ StateMap(@NotNull String[] names, @NotNull AtomicReferenceArray states, DefaultConstructorMarker $constructor_marker) {
        this(names, states);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"7\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u0001\"C\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001BE\u0003\u0002\u0011\u001d)\u0011\u0001b\u0002\u0005\u0007\ba\u0001!G\u0001\u0019\u0002\u0005\u001eA!A)\u0004\u0003!\tQ\u0005\u0003\u0003\u0002\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001M\bK5A\u0001\"D\u0001\u0019\u0005eI\u0001\u0012C\u0007\b\u0013\tI\u0011\u0001g\u0005\n\u0005%\t\u0001\u0014\u0001\r\nKAA!\"\u0004\u0002\r\u0002a5\u0011d\u0001E\u000b\u001b\u0005A\u001a\"G\u0002\t\u00175\t\u0001\u0014A\r\u0004\u0011/i\u0011\u0001'\u0004&1!aQ\"\u0001M\b3\rA)\"D\u0001\u0019\u0014e!\u0001bB\u0007\u0003\u0019\u0003A\n!G\u0006\u0005\u0003!eQ\u0002C\u0005\u0003\u0013\u0005A\u001a\"\u0003\u0002\n\u0003a=A\u0012\u0001\r\nK1!\u0011\u0001C\u0007\u000e\u000bA%QC\u0001G\u00011\u001fAz!G\u0002\t\u000f5\t\u0001TB\u0015\f\t\rC\u00012A\u0007\u00021\t\t6!B\u0003\u0002\u0019\u0003i!\u0001\"\u0002\t\u0007%zA!\u0011\u0005\t\b5)\u0001\u0013B\u000b\u0003\u0019\u0003AB\u0001\u0007\u0003R\u0007\u0015)\u0011\u0001$\u0001\u000e\u0005\u0011)\u00012\u0002"}, strings={"Lcom/intellij/configurationStore/StateMap$Companion;", "", "()V", "EMPTY", "Lcom/intellij/configurationStore/StateMap;", "getEMPTY", "()Lcom/intellij/configurationStore/StateMap;", "XML_FORMAT", "Lorg/jdom/output/Format;", "kotlin.jvm.PlatformType", "getXML_FORMAT", "()Lorg/jdom/output/Format;", "archiveState", "", "state", "Lorg/jdom/Element;", "fromMap", "map", "", "", "getNewByteIfDiffers", "key", "newState", "oldState", "stateToElement", "newLiveStates", "unarchiveState"}, moduleName="configuration-store-impl")
    public static final class Companion {
        public static final Companion INSTANCE;

        private final Format getXML_FORMAT() {
            return XML_FORMAT;
        }

        @NotNull
        public final StateMap getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final StateMap fromMap(@NotNull Map<String, ? extends Object> map) {
            int n;
            Intrinsics.checkParameterIsNotNull(map, (String)"map");
            if (map.isEmpty()) {
                return this.getEMPTY();
            }
            Collection $receiver = map.keySet();
            Collection collection = $receiver;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection22 = collection;
            String[] stringArray = thisCollection22.toArray(new String[thisCollection22.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] names = (String[])((Object[])stringArray);
            if (!(map instanceof TreeMap)) {
                Arrays.sort(names);
            }
            AtomicReferenceArray<Object> states = new AtomicReferenceArray<Object>(((Object[])names).length);
            IntRange intRange = ArraysKt.getIndices((Object[])names);
            int thisCollection22 = intRange.getFirst();
            if (thisCollection22 <= (n = intRange.getLast())) {
                while (true) {
                    void i;
                    states.set((int)i, map.get(names[i]));
                    if (i == n) break;
                    ++i;
                }
            }
            return new StateMap(names, states, null);
        }

        @NotNull
        public final Element stateToElement(@NotNull String key, @Nullable Object state, @Nullable Map<String, ? extends Element> newLiveStates) {
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            if (state instanceof Element) {
                Element element = ((Element)state).clone();
                Intrinsics.checkExpressionValueIsNotNull((Object)element, (String)"state.clone()");
                return element;
            }
            Element element = newLiveStates;
            if (element == null || (element = element.get(key)) == null) {
                Object object = state;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                Element element2 = this.unarchiveState((byte[])object);
                element = element2;
                Intrinsics.checkExpressionValueIsNotNull((Object)element2, (String)"unarchiveState(state as ByteArray)");
            }
            return element;
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Element stateToElement$default(Companion companion, String string, Object object, Map map, int n) {
            if ((n & 4) != 0) {
                map = null;
            }
            return companion.stateToElement(string, object, map);
        }

        @Nullable
        public final byte[] getNewByteIfDiffers(@NotNull String key, @NotNull Object newState, @NotNull byte[] oldState) {
            byte[] newBytes;
            byte[] byArray;
            Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
            Intrinsics.checkParameterIsNotNull((Object)newState, (String)"newState");
            Intrinsics.checkParameterIsNotNull((Object)oldState, (String)"oldState");
            if (newState instanceof Element) {
                byArray = this.archiveState((Element)newState);
            } else {
                Object object = newState;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.ByteArray");
                }
                byArray = newBytes = (byte[])object;
            }
            if (Arrays.equals(newBytes, oldState)) {
                return null;
            }
            if (SystemProperties.getBooleanProperty((String)"idea.log.changed.components", (boolean)false)) {
                Object after;
                getNewByteIfDiffers.1 stateToString$ = getNewByteIfDiffers.1.INSTANCE;
                Object before = stateToString$.invoke(oldState);
                if (Intrinsics.areEqual((Object)before, (Object)(after = stateToString$.invoke(newState)))) {
                    ComponentStoreImplKt.getLOG().info("Serialization error: serialized are different, but unserialized are equal");
                } else {
                    ComponentStoreImplKt.getLOG().info(key + " " + StringUtil.repeat((String)"=", (int)(80 - key.length())) + "\n" + "Before:" + "\n" + (String)before + "\n" + "After:" + "\n" + (String)after);
                }
            }
            return newBytes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final byte[] archiveState(Element state) {
            BufferExposingByteArrayOutputStream byteOut = new BufferExposingByteArrayOutputStream();
            Closeable $receiver = new OutputStreamWriter((OutputStream)new SnappyOutputStream((OutputStream)byteOut), CharsetToolkit.UTF8_CHARSET);
            boolean closed = false;
            try {
                OutputStreamWriter it = (OutputStreamWriter)$receiver;
                JDOMUtil.MyXMLOutputter xmlOutputter = new JDOMUtil.MyXMLOutputter();
                xmlOutputter.setFormat(Companion.getXML_FORMAT());
                xmlOutputter.output(state, (Writer)it);
                it = Unit.INSTANCE;
            }
            catch (Exception e) {
                closed = true;
                try {
                    $receiver.close();
                }
                catch (Exception closeException) {
                    // empty catch block
                }
                throw (Throwable)e;
            }
            finally {
                if (!closed) {
                    $receiver.close();
                }
            }
            byte[] byArray = ArrayUtil.realloc((byte[])byteOut.getInternalBuffer(), (int)byteOut.size());
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ArrayUtil.realloc(byteOu\u2026alBuffer, byteOut.size())");
            return byArray;
        }

        private final Element unarchiveState(byte[] state) {
            return JDOMUtil.load((InputStream)((InputStream)new SnappyInputStream((InputStream)new ByteArrayInputStream(state))));
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }

        public static final /* synthetic */ Element access$unarchiveState(Companion $this, @NotNull byte[] state) {
            return $this.unarchiveState(state);
        }
    }
}

