/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.structureView.StructureView;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.util.FileStructurePopup;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.PlaceHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewStructureAction
extends DumbAwareAction {
    public ViewStructureAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        VirtualFile virtualFile;
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (fileEditor == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        } else {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
            if (psiFile == null) {
                return;
            }
            virtualFile = psiFile.getVirtualFile();
        }
        String title = virtualFile == null ? fileEditor.getName() : virtualFile.getName();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.popup.file.structure");
        FileStructurePopup popup = ViewStructureAction.createPopup(project, fileEditor);
        if (popup == null) {
            return;
        }
        popup.setTitle(title);
        popup.show();
    }

    @Nullable
    public static FileStructurePopup createPopup(@NotNull Project project, @NotNull FileEditor fileEditor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/actions/ViewStructureAction", "createPopup"));
        }
        if (fileEditor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditor", "com/intellij/ide/actions/ViewStructureAction", "createPopup"));
        }
        StructureViewBuilder structureViewBuilder = fileEditor.getStructureViewBuilder();
        if (structureViewBuilder == null) {
            return null;
        }
        StructureView structureView = structureViewBuilder.createStructureView(fileEditor, project);
        StructureViewModel model = structureView.getTreeModel();
        if (model instanceof PlaceHolder) {
            ((PlaceHolder)model).setPlace((Object)"StructureViewPopup");
        }
        return ViewStructureAction.createStructureViewPopup(project, fileEditor, structureView);
    }

    private static FileStructurePopup createStructureViewPopup(Project project, FileEditor fileEditor, StructureView structureView) {
        return new FileStructurePopup(project, fileEditor, structureView, true);
    }

    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        FileEditor fileEditor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        e.getPresentation().setEnabled(fileEditor != null && fileEditor.getStructureViewBuilder() != null);
    }
}

