/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.favoritesTreeView;

import com.intellij.ide.SelectInContext;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.ide.favoritesTreeView.FavoritesManager;
import com.intellij.ide.favoritesTreeView.FavoritesViewSelectInTarget;
import com.intellij.ide.favoritesTreeView.FavoritesViewTreeBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AutoScrollFromSourceHandler;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class FavoritesAutoscrollFromSourceHandler
extends AutoScrollFromSourceHandler {
    private final FavoritesViewSelectInTarget mySelectInTarget;

    public FavoritesAutoscrollFromSourceHandler(@NotNull Project project, @NotNull FavoritesViewTreeBuilder builder) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/favoritesTreeView/FavoritesAutoscrollFromSourceHandler", "<init>"));
        }
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/ide/favoritesTreeView/FavoritesAutoscrollFromSourceHandler", "<init>"));
        }
        super(project, (JComponent)builder.getTree(), (Disposable)builder);
        this.mySelectInTarget = new FavoritesViewSelectInTarget(this.myProject);
    }

    protected boolean isAutoScrollEnabled() {
        return FavoritesManager.getInstance(this.myProject).getViewSettings().isAutoScrollFromSource();
    }

    protected void setAutoScrollEnabled(boolean enabled) {
        FavoritesManager.getInstance(this.myProject).getViewSettings().setAutoScrollFromSource(enabled);
    }

    protected void selectElementFromEditor(@NotNull FileEditor editor) {
        SelectInContext selectInContext;
        PsiFile psiFile;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/ide/favoritesTreeView/FavoritesAutoscrollFromSourceHandler", "selectElementFromEditor"));
        }
        VirtualFile file2 = FileEditorManagerEx.getInstanceEx(this.myProject).getFile(editor);
        if (file2 != null && (psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2)) != null && this.mySelectInTarget.canSelect(selectInContext = SelectInContextImpl.createEditorContext(this.myProject, editor))) {
            this.mySelectInTarget.selectIn(selectInContext, false);
        }
    }
}

