/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.encoding;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.nio.charset.Charset;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PlatformFileEncodingConfigurable
implements SearchableConfigurable {
    private static final String SYSTEM_DEFAULT = IdeBundle.message((String)"encoding.name.system.default", (Object[])new Object[]{CharsetToolkit.getDefaultSystemCharset().displayName()});
    private PlatformEncodingOptionsPanel myPanel;

    @NotNull
    public String getId() {
        if ("GeneralEncodingOptions" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/encoding/PlatformFileEncodingConfigurable", "getId"));
        }
        return "GeneralEncodingOptions";
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "";
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = new PlatformEncodingOptionsPanel();
        }
        return this.myPanel.getMainPanel();
    }

    public boolean isModified() {
        Object item = this.myPanel.myIDEEncodingComboBox.getSelectedItem();
        if (SYSTEM_DEFAULT.equals(item)) {
            return !StringUtil.isEmpty((String)EncodingManager.getInstance().getDefaultCharsetName());
        }
        return !Comparing.equal((Object)item, (Object)EncodingManager.getInstance().getDefaultCharset());
    }

    public void apply() throws ConfigurationException {
        Object item = this.myPanel.myIDEEncodingComboBox.getSelectedItem();
        if (SYSTEM_DEFAULT.equals(item)) {
            EncodingManager.getInstance().setDefaultCharsetName("");
        } else if (item != null) {
            EncodingManager.getInstance().setDefaultCharsetName(((Charset)item).name());
        }
    }

    public void reset() {
        DefaultComboBoxModel<Charset> encodingsModel = new DefaultComboBoxModel<Charset>(CharsetToolkit.getAvailableCharsets());
        encodingsModel.insertElementAt((Charset)((Object)SYSTEM_DEFAULT), 0);
        this.myPanel.myIDEEncodingComboBox.setModel(encodingsModel);
        String name = EncodingManager.getInstance().getDefaultCharsetName();
        if (StringUtil.isEmpty((String)name)) {
            this.myPanel.myIDEEncodingComboBox.setSelectedItem(SYSTEM_DEFAULT);
        } else {
            this.myPanel.myIDEEncodingComboBox.setSelectedItem(EncodingManager.getInstance().getDefaultCharset());
        }
    }

    public void disposeUIResources() {
        this.myPanel = null;
    }

    public static class PlatformEncodingOptionsPanel {
        JComboBox myIDEEncodingComboBox;
        private JPanel myMainPanel;

        public PlatformEncodingOptionsPanel() {
            this.$$$setupUI$$$();
        }

        public JPanel getMainPanel() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JComboBox jComboBox;
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JLabel jLabel = new JLabel();
            jLabel.setText("IDE Encoding:");
            jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myIDEEncodingComboBox = jComboBox = new JComboBox();
            jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 3, 8, 1, 2, 0, null, null, null));
            jLabel.setLabelFor(jComboBox);
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }
    }
}

