/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.caches.FileContent;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.CacheUpdateRunner;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.ProjectRootManagerComponent;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Consumer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileBasedIndexProjectHandler
extends AbstractProjectComponent
implements IndexableFileSet {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.util.indexing.FileBasedIndexProjectHandler");
    private final FileBasedIndex myIndex;
    private final ProjectRootManagerEx myRootManager;
    private final FileTypeManager myFileTypeManager;

    public FileBasedIndexProjectHandler(FileBasedIndex index, final Project project, ProjectRootManagerComponent rootManager, FileTypeManager ftManager, final ProjectManager projectManager) {
        super(project);
        StartupManagerEx startupManager;
        this.myIndex = index;
        this.myRootManager = rootManager;
        this.myFileTypeManager = ftManager;
        if (ApplicationManager.getApplication().isInternal()) {
            project.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                }

                public void exitDumbMode() {
                    LOG.info("Has changed files: " + (FileBasedIndexProjectHandler.createChangedFilesIndexingTask(project) != null) + "; project=" + project);
                }
            });
        }
        if ((startupManager = (StartupManagerEx)StartupManager.getInstance((Project)project)) != null) {
            startupManager.registerPreStartupActivity(new Runnable(){

                @Override
                public void run() {
                    PushedFilePropertiesUpdater.getInstance((Project)project).initializeProperties();
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!project.isDisposed() && FileBasedIndex.getInstance() instanceof FileBasedIndexImpl) {
                                DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project, true));
                            }
                        }
                    });
                    FileBasedIndexProjectHandler.this.myIndex.registerIndexableSet((IndexableFileSet)FileBasedIndexProjectHandler.this, project);
                    projectManager.addProjectManagerListener(project, (ProjectManagerListener)new ProjectManagerAdapter(){
                        private boolean removed;

                        public void projectClosing(Project project) {
                            if (!this.removed) {
                                this.removed = true;
                                FileBasedIndexProjectHandler.this.myIndex.removeIndexableSet((IndexableFileSet)FileBasedIndexProjectHandler.this);
                            }
                        }
                    });
                }
            });
        }
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexProjectHandler", "isInSet"));
        }
        ProjectFileIndex index = this.myRootManager.getFileIndex();
        if (index.isInContent(file2) || index.isInLibraryClasses(file2) || index.isInLibrarySource(file2)) {
            return !this.myFileTypeManager.isFileIgnored(file2);
        }
        return false;
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexProjectHandler", "iterateIndexableFilesIn"));
        }
        if (iterator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterator", "com/intellij/util/indexing/FileBasedIndexProjectHandler", "iterateIndexableFilesIn"));
        }
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/util/indexing/FileBasedIndexProjectHandler$3", "visitFile"));
                }
                if (!FileBasedIndexProjectHandler.this.isInSet(file2)) {
                    return false;
                }
                iterator.processFile(file2);
                return true;
            }
        });
    }

    public void disposeComponent() {
        this.myIndex.removeIndexableSet((IndexableFileSet)this);
    }

    @Nullable
    public static DumbModeTask createChangedFilesIndexingTask(final Project project) {
        FileBasedIndex i = FileBasedIndex.getInstance();
        if (!(i instanceof FileBasedIndexImpl)) {
            return null;
        }
        final FileBasedIndexImpl index = (FileBasedIndexImpl)i;
        if (index.getChangedFileCount() + index.getNumberOfPendingInvalidations() < 20) {
            return null;
        }
        return new DumbModeTask(){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/util/indexing/FileBasedIndexProjectHandler$4", "performInDumbMode"));
                }
                Collection<VirtualFile> files = index.getFilesToUpdate(project);
                indicator.setIndeterminate(false);
                indicator.setText(IdeBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
                FileBasedIndexProjectHandler.reindexRefreshedFiles(indicator, files, project, index);
            }
        };
    }

    private static void reindexRefreshedFiles(ProgressIndicator indicator, Collection<VirtualFile> files, final Project project, final FileBasedIndexImpl index) {
        CacheUpdateRunner.processFiles(indicator, true, files, project, new Consumer<FileContent>(){

            public void consume(FileContent content) {
                index.processRefreshedFile(project, content);
            }
        });
    }
}

