/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.filter;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.data.VcsLogDataHolder;
import com.intellij.vcs.log.data.VcsLogUiProperties;
import com.intellij.vcs.log.ui.filter.FilterModel;
import com.intellij.vcs.log.ui.filter.MultipleValueFilterPopupComponent;
import com.intellij.vcs.log.ui.filter.VcsLogUserFilterImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UserFilterPopupComponent
extends MultipleValueFilterPopupComponent<VcsLogUserFilter> {
    private static final String ME = "me";
    @NotNull
    private final VcsLogDataHolder myDataHolder;
    @NotNull
    private final VcsLogUiProperties myUiProperties;

    UserFilterPopupComponent(@NotNull VcsLogUiProperties uiProperties, @NotNull VcsLogDataHolder dataHolder, @NotNull FilterModel<VcsLogUserFilter> filterModel) {
        if (uiProperties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "uiProperties", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        if (dataHolder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataHolder", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        if (filterModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filterModel", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "<init>"));
        }
        super("User", uiProperties, filterModel);
        this.myDataHolder = dataHolder;
        this.myUiProperties = uiProperties;
    }

    @Override
    @NotNull
    protected String getText(@NotNull VcsLogUserFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getText"));
        }
        String string = UserFilterPopupComponent.displayableText(this.getTextValues(filter));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getText"));
        }
        return string;
    }

    @Override
    @Nullable
    protected String getToolTip(@NotNull VcsLogUserFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getToolTip"));
        }
        return UserFilterPopupComponent.tooltip(this.getTextValues(filter));
    }

    @Override
    protected ActionGroup createActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(this.createAllAction());
        group.add(this.createSelectMultipleValuesAction());
        if (!this.myDataHolder.getCurrentUser().isEmpty()) {
            group.add(this.createPredefinedValueAction(Collections.singleton(ME)));
        }
        group.addAll(this.createRecentItemsActionGroup());
        return group;
    }

    @Override
    @NotNull
    protected Collection<String> getTextValues(@Nullable VcsLogUserFilter filter) {
        if (filter == null) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getTextValues"));
            }
            return set;
        }
        HashSet hashSet = ContainerUtil.newHashSet(((VcsLogUserFilterImpl)filter).getUserNamesForPresentation());
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getTextValues"));
        }
        return hashSet;
    }

    @Override
    @NotNull
    protected List<List<String>> getRecentValuesFromSettings() {
        List<List<String>> list = this.myUiProperties.getRecentlyFilteredUserGroups();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getRecentValuesFromSettings"));
        }
        return list;
    }

    @Override
    protected void rememberValuesInSettings(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "rememberValuesInSettings"));
        }
        this.myUiProperties.addRecentlyFilteredUserGroup(new ArrayList<String>(values));
    }

    @Override
    @NotNull
    protected List<String> getAllValues() {
        List list = ContainerUtil.map(this.myDataHolder.getAllUsers(), (Function)new Function<VcsUser, String>(){

            public String fun(VcsUser user) {
                return user.getName();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "getAllValues"));
        }
        return list;
    }

    @Override
    @NotNull
    protected VcsLogUserFilter createFilter(@NotNull Collection<String> values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "values", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "createFilter"));
        }
        VcsLogUserFilterImpl vcsLogUserFilterImpl = new VcsLogUserFilterImpl(values, this.myDataHolder.getCurrentUser(), this.myDataHolder.getAllUsers());
        if (vcsLogUserFilterImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/filter/UserFilterPopupComponent", "createFilter"));
        }
        return vcsLogUserFilterImpl;
    }
}

