/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XJumpToSourceActionBase
extends XDebuggerTreeActionBase {
    @Override
    protected void perform(final XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        if (nodeName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodeName", "com/intellij/xdebugger/impl/ui/tree/actions/XJumpToSourceActionBase", "perform"));
        }
        XValue value = (XValue)node.getValueContainer();
        final XDebuggerEvaluationDialog dialog = (XDebuggerEvaluationDialog)((Object)e.getData(XDebuggerEvaluationDialog.KEY));
        XNavigatable navigatable = new XNavigatable(){

            public void setSourcePosition(final @Nullable XSourcePosition sourcePosition) {
                if (sourcePosition != null) {
                    final Project project = node.getTree().getProject();
                    AppUIUtil.invokeOnEdt(new Runnable(){

                        @Override
                        public void run() {
                            sourcePosition.createNavigatable(project).navigate(true);
                            if (dialog != null && Registry.is((String)"debugger.close.dialog.on.navigate")) {
                                dialog.close(1);
                            }
                        }
                    }, project.getDisposed());
                }
            }
        };
        this.startComputingSourcePosition(value, navigatable);
    }

    protected abstract void startComputingSourcePosition(XValue var1, XNavigatable var2);
}

