/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions.xmlbeans;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.actions.xmlbeans.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;

public class GenerateSchemaFromInstanceDocumentDialog
extends DialogWrapper {
    private JPanel panel;
    private TextFieldWithBrowseButton generateFromUrl;
    private JLabel status;
    private JLabel statusText;
    private JLabel generateFromUrlText;
    private JLabel designTypeText;
    private JTextField detectEnumerationsLimit;
    private ComboBox detectSimpleContentTypes;
    private ComboBox designType;
    private JLabel detectEnumerationsLimitText;
    private JLabel detectSimpleContentTypesText;
    private JLabel resultSchemaFileNameText;
    private JTextField resultSchemaFileName;
    static final String LOCAL_ELEMENTS_GLOBAL_COMPLEX_TYPES = XmlBundle.message((String)"local.elements.global.complex.types.option.name", (Object[])new Object[0]);
    static final String LOCAL_ELEMENTS_TYPES = XmlBundle.message((String)"local.elements.types.option.name", (Object[])new Object[0]);
    static final String GLOBAL_ELEMENTS_LOCAL_TYPES = XmlBundle.message((String)"global.elements.local.types.option.name", (Object[])new Object[0]);
    private static final List<String> designTypes = Arrays.asList(LOCAL_ELEMENTS_GLOBAL_COMPLEX_TYPES, LOCAL_ELEMENTS_TYPES, GLOBAL_ELEMENTS_LOCAL_TYPES);
    static final String STRING_TYPE = "string";
    static final String SMART_TYPE = "smart";
    private static final List<String> simpleContentTypes = Arrays.asList("string", "smart");
    private Runnable myOkAction;

    public GenerateSchemaFromInstanceDocumentDialog(Project project, VirtualFile file2) {
        super(project, true);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(XmlBundle.message((String)"generate.schema.from.instance.document.dialog.title", (Object[])objectArray));
        this.doInitFor(this.designTypeText, (JComponent)this.designType);
        GenerateSchemaFromInstanceDocumentDialog.configureComboBox((JComboBox)this.designType, designTypes);
        this.doInitFor(this.detectSimpleContentTypesText, (JComponent)this.detectSimpleContentTypes);
        GenerateSchemaFromInstanceDocumentDialog.configureComboBox((JComboBox)this.detectSimpleContentTypes, simpleContentTypes);
        this.doInitFor(this.detectEnumerationsLimitText, this.detectEnumerationsLimit);
        this.detectEnumerationsLimit.setText("10");
        UIUtils.configureBrowseButton(project, this.generateFromUrl, new String[]{"xml"}, XmlBundle.message((String)"select.xml.document.dialog.title", (Object[])new Object[0]), false);
        this.doInitFor(this.generateFromUrlText, this.generateFromUrl.getTextField());
        this.doInitFor(this.resultSchemaFileNameText, this.resultSchemaFileName);
        this.init();
        this.generateFromUrl.setText(file2.getPresentableUrl());
        this.resultSchemaFileName.setText(file2.getNameWithoutExtension() + ".xsd");
    }

    private void validateData() {
        String msg = this.doValidateWithData();
        this.setOKActionEnabled(msg == null);
        this.status.setText(msg == null ? "" : msg);
        this.status.setForeground((Color)JBColor.RED);
    }

    public static void configureComboBox(JComboBox combo, List<String> lastValues) {
        combo.setModel(new DefaultComboBoxModel<String>(ArrayUtil.toStringArray(lastValues)));
        if (combo.getItemCount() != 0) {
            combo.setSelectedIndex(0);
            combo.getEditor().selectAll();
        }
    }

    public void setFileUrl(String url) {
        this.generateFromUrl.setText(url);
    }

    protected void doOKAction() {
        super.doOKAction();
        if (this.myOkAction != null) {
            this.myOkAction.run();
        }
    }

    public void setOkAction(Runnable okAction) {
        this.myOkAction = okAction;
    }

    public void doInitFor(JLabel textComponent, JComponent component) {
        textComponent.setLabelFor(component);
        if (component instanceof JTextField) {
            ((JTextField)component).getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                }
            });
        } else if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            jComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                }
            });
            if (jComboBox.isEditable()) {
                jComboBox.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyTyped(KeyEvent e) {
                        GenerateSchemaFromInstanceDocumentDialog.this.validateData();
                    }
                });
            }
        }
    }

    protected TextFieldWithBrowseButton getUrl() {
        return this.generateFromUrl;
    }

    protected JLabel getUrlText() {
        return this.generateFromUrlText;
    }

    protected JLabel getStatusTextField() {
        return this.statusText;
    }

    protected JLabel getStatusField() {
        return this.status;
    }

    protected JComponent createCenterPanel() {
        return this.panel;
    }

    String getDesignType() {
        return (String)this.designType.getSelectedItem();
    }

    String getSimpleContentType() {
        return (String)this.detectSimpleContentTypes.getSelectedItem();
    }

    String getEnumerationsLimit() {
        return this.detectEnumerationsLimit.getText();
    }

    public String getTargetSchemaName() {
        return this.resultSchemaFileName.getText();
    }

    protected String doValidateWithData() {
        if (!new File(this.generateFromUrl.getText()).exists()) {
            return XmlBundle.message((String)"instance.document.file.is.not.exist", (Object[])new Object[0]);
        }
        try {
            int i = Integer.parseInt(this.getEnumerationsLimit());
            if (i < 0) {
                return XmlBundle.message((String)"negative.number.validation.problem", (Object[])new Object[0]);
            }
        }
        catch (NumberFormatException ex) {
            return XmlBundle.message((String)"invalid.number.validation.problem", (Object[])new Object[0]);
        }
        if (this.getTargetSchemaName() == null || this.getTargetSchemaName().length() == 0) {
            return XmlBundle.message((String)"result.schema.file.name.is.empty.validation.problem", (Object[])new Object[0]);
        }
        return null;
    }

    @NotNull
    protected String getHelpId() {
        if ("webservices.GenerateSchemaFromInstanceDocument" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/actions/xmlbeans/GenerateSchemaFromInstanceDocumentDialog", "getHelpId"));
        }
        return "webservices.GenerateSchemaFromInstanceDocument";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JLabel jLabel;
        ComboBox comboBox;
        ComboBox comboBox2;
        JTextField jTextField2;
        JLabel jLabel2;
        JLabel jLabel3;
        JLabel jLabel4;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel5;
        JLabel jLabel6;
        JLabel jLabel7;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(1, 1, 1, 1), -1, -1, false, false));
        this.generateFromUrlText = jLabel7 = new JLabel();
        jLabel7.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.instance2schema.url.tooltip"));
        this.$$$loadLabelText$$$(jLabel7, ResourceBundle.getBundle("messages/XmlBundle").getString("instance2schema.dialog.instance.document.path"));
        jPanel.add((Component)jLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.statusText = jLabel6 = new JLabel();
        jLabel6.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("webservice.status.tooltip"));
        this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/XmlBundle").getString("any.dialog.status"));
        jPanel.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.status = jLabel5 = new JLabel();
        ((Component)jLabel5).setForeground(new Color(-65536));
        jLabel5.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("webservice.status.tooltip"));
        jLabel5.setText("");
        jPanel.add((Component)jLabel5, new GridConstraints(5, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.generateFromUrl = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.instance2schema.url.tooltip"));
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.designTypeText = jLabel4 = new JLabel();
        jLabel4.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.designtype.tooltip"));
        this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/XmlBundle").getString("instance2schema.dialog.design.type"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.detectSimpleContentTypesText = jLabel3 = new JLabel();
        jLabel3.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.simplecontenttype.tooltip"));
        this.$$$loadLabelText$$$(jLabel3, ResourceBundle.getBundle("messages/XmlBundle").getString("instance2schema.dialog.detect.simple.content.type"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.detectEnumerationsLimitText = jLabel2 = new JLabel();
        jLabel2.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.enumerations.tooltip"));
        this.$$$loadLabelText$$$(jLabel2, ResourceBundle.getBundle("messages/XmlBundle").getString("instance2schema.dialog.detect.enumerations.limit"));
        jPanel.add((Component)jLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.detectEnumerationsLimit = jTextField2 = new JTextField();
        jTextField2.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.enumerations.tooltip"));
        jPanel.add((Component)jTextField2, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.detectSimpleContentTypes = comboBox2 = new ComboBox();
        comboBox2.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.simplecontenttype.tooltip"));
        jPanel.add((Component)comboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.designType = comboBox = new ComboBox();
        comboBox.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.designtype.tooltip"));
        jPanel.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.resultSchemaFileNameText = jLabel = new JLabel();
        jLabel.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.instance2schema.result.schema.name"));
        jLabel.setText("Result schema file name:");
        jPanel.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.resultSchemaFileName = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("messages/XmlBundle").getString("xmlbeans.enumerations.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        jLabel2.setLabelFor(jTextField2);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

