/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JavadocOrderRootType;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.util.Iterator;
import kotlin.CollectionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.StringsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt;
import org.jetbrains.builtInWebServer.DefaultWebServerRootsProviderKt$ORDER_ROOT_TYPES$1;
import org.jetbrains.builtInWebServer.FileResolver;
import org.jetbrains.builtInWebServer.PathInfo;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"=\u0015\u0001Q!\u0001E\t\u000b\u0005a\u0011!B\u0001\u0005\b\u0015\tA\"A\u0003\u0001\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA\u0011B\u0007\u001e\t\u0005AI!\u0004\u0002\r\u0002a)\u0011d\u0001E\u0006\u001b\u0005Ab!\u0007\u0004\t\u000e5!\u0011BA\u0005\u00021\u001dA\n!G\u0002\t\u00105\t\u0001\u0004C\r\u0005\u0011#i!\u0001$\u0001\u0019\rE\u001b\u0011\u0001C\u0005U\u0007\u0011i)\u0003B\u0001\t\u00145\u0011A\u0012\u0001\r\u00063\rA!\"D\u0001\u0019\u0016e\u0019\u00012B\u0007\u00021\u0019I2\u0001c\u0004\u000e\u0003aAAk\u0001\u0003\u000eG\u0011\t\u0001bC\u0007\u0003\u0019\u0003AR!G\u0002\t\u00155\t\u0001TC\r\u0007\u0011/iA!\u0003\u0002\n\u0003a\t\u0001\u0014A\r\u000f\u00111iA\"\u0003\u0002\n\u0003a9\u0011bA\u0005\u0003\u0019\u0003AR\"C\u0002\n\u00051\u0005\u0001$\u0002M\r#\u000e\t\u00012\u0004+\u0004\t5mB!\u0001\u0005\u000f\u001b\ta\t\u0001G\u0003\u001a\u0007!uQ\"\u0001\r\u000e3\rAq\"D\u0001\u0019\u0003eq\u0001\u0002D\u0007\r\u0013\tI\u0011\u0001G\u0004\n\u0007%\u0011A\u0012\u0001\r\u000e\u0013\rI!\u0001$\u0001\u0019\u000baeAk\u0001\u0003\u000e&\u0011\t\u0001rD\u0007\u0003\u0019\u0003AR!G\u0002\t\f5\t\u0001DB\r\u0004\u0011;i\u0011\u0001G\u0007\u001a\u0007!=Q\"\u0001\r\t)\u000e!QR\u0004\u0003\u0002\u0011Ai!\u0001$\u0001\u0019\u000be\u0019\u0001\u0012E\u0007\u00021\u001dI2\u0001\u0003\u0006\u000e\u0003aUAk\u0001\u0003\u000e\u000e\u0011\t\u0001\"E\u0007\u0003\u0019\u0003A\u0012\u0001V\u0002\u0005\u001b?!\u0011\u0001c\t\u000e\u00051\u0005\u0001DB\r\u0004\u0011)i\u0011\u0001'\u0006\u001a\t!uQB\u0001G\u000115!6\u0001BI\u0016\t\u0005C\u0001\u0002A\u0007\t\u0013\u0019IQ\u0001e\u0001\u0016\u00051\u0005\u0001$\u0001\r\u00021\u0003a\u0012%U\u0002\u0007\u000b\t!1\u0001c\u0002\u000e\u0005\u0011\u0011\u0001R\u0001+\u0004\t\u0001"}, strings={"ORDER_ROOT_TYPES", "", "Lcom/intellij/openapi/roots/OrderRootType;", "kotlin.jvm.PlatformType", "getORDER_ROOT_TYPES", "()[Lcom/intellij/openapi/roots/OrderRootType;", "ORDER_ROOT_TYPES$delegate", "Lkotlin/Lazy;", "DefaultWebServerRootsProviderKt", "findByRelativePath", "Lorg/jetbrains/builtInWebServer/PathInfo;", "path", "", "roots", "Lcom/intellij/openapi/vfs/VirtualFile;", "resolver", "Lorg/jetbrains/builtInWebServer/FileResolver;", "moduleName", "(Ljava/lang/String;[Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/builtInWebServer/FileResolver;Ljava/lang/String;)Lorg/jetbrains/builtInWebServer/PathInfo;", "findInLibraries", "project", "Lcom/intellij/openapi/project/Project;", "findInLibrariesAndSdk", "rootTypes", "fileProcessor", "Lkotlin/Function2;", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/roots/OrderRootType;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/builtInWebServer/PathInfo;", "findInModuleLevelLibraries", "module", "rootType", "findInModuleLibraries", "getInfoForDocJar", "file", "getJavadocOrderRootType", "getModuleNameQualifier"}, moduleName="built-in-server")
public final class DefaultWebServerRootsProviderKt {
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    private static final Lazy<? extends OrderRootType[]> ORDER_ROOT_TYPES$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)DefaultWebServerRootsProviderKt$ORDER_ROOT_TYPES$1.INSTANCE};
        ORDER_ROOT_TYPES$delegate = LazyKt.lazy((Function0)ORDER_ROOT_TYPES.2.INSTANCE);
    }

    private static final OrderRootType[] getORDER_ROOT_TYPES() {
        return (OrderRootType[])LazyKt.getValue(ORDER_ROOT_TYPES$delegate, null, (KProperty)$$delegatedProperties[0]);
    }

    private static final OrderRootType getJavadocOrderRootType() {
        try {
            return JavadocOrderRootType.getInstance();
        }
        catch (Throwable e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final PathInfo findInModuleLibraries(String path, Module module, FileResolver resolver) {
        PathInfo pathInfo;
        block2: {
            void $receiver;
            int index = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6);
            if (index <= 0) {
                return null;
            }
            String libraryFileName = StringsKt.substring((String)path, (int)0, (int)index);
            String relativePath = StringsKt.substring((String)path, (int)(index + 1));
            Object[] objectArray = DefaultWebServerRootsProviderKt.getORDER_ROOT_TYPES();
            for (int i = 0; i < ((void)$receiver).length; ++i) {
                OrderRootType it;
                void file2 = $receiver[i];
                OrderRootType orderRootType = it = (OrderRootType)file2;
                Intrinsics.checkExpressionValueIsNotNull((Object)orderRootType, (String)"it");
                PathInfo result2 = DefaultWebServerRootsProviderKt.findInModuleLevelLibraries(module, orderRootType, (Function2<? super VirtualFile, ? super Module, ? extends PathInfo>)((Function2)new Function2<VirtualFile, Module, PathInfo>(module, libraryFileName, resolver, relativePath){
                    final /* synthetic */ Module $module$inlined;
                    final /* synthetic */ String $libraryFileName$inlined;
                    final /* synthetic */ FileResolver $resolver$inlined;
                    final /* synthetic */ String $relativePath$inlined;

                    public final PathInfo invoke(VirtualFile root, Module module) {
                        return StringUtil.equalsIgnoreCase((CharSequence)root.getNameSequence(), (CharSequence)this.$libraryFileName$inlined) ? FileResolver.DefaultImpls.resolve$default(this.$resolver$inlined, this.$relativePath$inlined, root, null, true, 4) : (PathInfo)null;
                    }
                    {
                        this.$module$inlined = module;
                        this.$libraryFileName$inlined = string;
                        this.$resolver$inlined = fileResolver;
                        this.$relativePath$inlined = string2;
                        super(2);
                    }
                }));
                if (result2 == null) continue;
                pathInfo = result2;
                break block2;
            }
            pathInfo = null;
        }
        return pathInfo;
    }

    private static final PathInfo findInLibraries(Project project, String path, FileResolver resolver) {
        int index = StringsKt.indexOf$default((CharSequence)path, (char)'/', (int)0, (boolean)false, (int)6);
        if (index < 0) {
            return null;
        }
        String libraryFileName = StringsKt.substring((String)path, (int)0, (int)index);
        String relativePath = StringsKt.substring((String)path, (int)(index + 1));
        return DefaultWebServerRootsProviderKt.findInLibrariesAndSdk(project, DefaultWebServerRootsProviderKt.getORDER_ROOT_TYPES(), (Function2<? super VirtualFile, ? super Module, ? extends PathInfo>)((Function2)new Function2<VirtualFile, Module, PathInfo>(libraryFileName, resolver, relativePath){
            final /* synthetic */ String $libraryFileName;
            final /* synthetic */ FileResolver $resolver;
            final /* synthetic */ String $relativePath;

            @Nullable
            public final PathInfo invoke(@NotNull VirtualFile root, @Nullable Module module) {
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                return StringUtil.equalsIgnoreCase((CharSequence)root.getNameSequence(), (CharSequence)this.$libraryFileName) ? FileResolver.DefaultImpls.resolve$default(this.$resolver, this.$relativePath, root, null, true, 4) : (PathInfo)null;
            }
            {
                this.$libraryFileName = string;
                this.$resolver = fileResolver;
                this.$relativePath = string2;
                super(2);
            }
        }));
    }

    private static final PathInfo getInfoForDocJar(VirtualFile file2, Project project) {
        OrderRootType orderRootType = DefaultWebServerRootsProviderKt.getJavadocOrderRootType();
        if (orderRootType == null) {
            return null;
        }
        OrderRootType javaDocRootType = orderRootType;
        return DefaultWebServerRootsProviderKt.findInLibrariesAndSdk(project, new OrderRootType[]{javaDocRootType}, (Function2<? super VirtualFile, ? super Module, ? extends PathInfo>)((Function2)new Function2<VirtualFile, Module, PathInfo>(file2, project){
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Project $project;

            @Nullable
            public final PathInfo invoke(@NotNull VirtualFile root, @Nullable Module module) {
                Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
                return VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)this.$file, (boolean)false) ? new PathInfo((File)null, this.$file, root, DefaultWebServerRootsProviderKt.access$getModuleNameQualifier(this.$project, module), true) : (PathInfo)null;
            }
            {
                this.$file = virtualFile;
                this.$project = project;
                super(2);
            }
        }));
    }

    private static final String getModuleNameQualifier(Project project, Module module) {
        if (module != null && PlatformUtils.isIntelliJ() && !StringsKt.equals((String)module.getName(), (String)project.getName(), (boolean)true)) {
            String string = module.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"module.name");
            if (!BuiltInWebServerKt.compareNameAndProjectBasePath(string, project)) {
                return module.getName();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final PathInfo findByRelativePath(String path, VirtualFile[] roots, FileResolver resolver, String moduleName) {
        PathInfo pathInfo;
        block1: {
            void $receiver;
            Object[] objectArray = roots;
            for (int i = 0; i < ((void)$receiver).length; ++i) {
                void file2 = $receiver[i];
                VirtualFile it = (VirtualFile)file2;
                PathInfo result2 = FileResolver.DefaultImpls.resolve$default(resolver, path, it, moduleName, false, 8);
                if (result2 == null) continue;
                pathInfo = result2;
                break block1;
            }
            pathInfo = null;
        }
        return pathInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final PathInfo findInLibrariesAndSdk(Project project, OrderRootType[] rootTypes, Function2<? super VirtualFile, ? super Module, ? extends PathInfo> fileProcessor) {
        PathInfo pathInfo;
        block12: {
            void $receiver;
            Function2<LibraryTable, OrderRootType, PathInfo> findInLibraryTable$ = new Function2<LibraryTable, OrderRootType, PathInfo>(fileProcessor){
                final /* synthetic */ Function2 $fileProcessor;

                /*
                 * WARNING - void declaration
                 */
                @Nullable
                public final PathInfo invoke(@NotNull LibraryTable table, @NotNull OrderRootType rootType) {
                    PathInfo pathInfo;
                    block3: {
                        Intrinsics.checkParameterIsNotNull((Object)table, (String)"table");
                        Intrinsics.checkParameterIsNotNull((Object)rootType, (String)"rootType");
                        Iterator $receiver = table.getLibraryIterator();
                        Iterator iterator = CollectionsKt.iterator((Iterator)$receiver);
                        while (iterator.hasNext()) {
                            PathInfo result2;
                            PathInfo pathInfo2;
                            block2: {
                                void $receiver2;
                                E file2 = iterator.next();
                                Library it = (Library)file2;
                                Object[] objectArray = it.getFiles(rootType);
                                for (int i = 0; i < ((void)$receiver2).length; ++i) {
                                    VirtualFile it2;
                                    void file3 = $receiver2[i];
                                    VirtualFile virtualFile = it2 = (VirtualFile)file3;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                                    PathInfo result3 = (PathInfo)this.$fileProcessor.invoke((Object)virtualFile, null);
                                    if (result3 == null) continue;
                                    pathInfo2 = result3;
                                    break block2;
                                }
                                pathInfo2 = null;
                            }
                            if ((result2 = (PathInfo)pathInfo2) == null) continue;
                            pathInfo = result2;
                            break block3;
                        }
                        pathInfo = null;
                    }
                    return pathInfo;
                }
                {
                    this.$fileProcessor = function2;
                    super(2);
                }
            };
            Function1<OrderRootType, PathInfo> findInProjectSdkOrInAll$ = new Function1<OrderRootType, PathInfo>(fileProcessor, project){
                final /* synthetic */ Function2 $fileProcessor;
                final /* synthetic */ Project $project;

                @Nullable
                public final PathInfo invoke(@NotNull OrderRootType rootType) {
                    Sdk sdk;
                    block6: {
                        PathInfo pathInfo;
                        block4: {
                            Object[] $receiver;
                            Sdk projectSdk;
                            Function1 inSdkFinder2;
                            block5: {
                                Intrinsics.checkParameterIsNotNull((Object)rootType, (String)"rootType");
                                inSdkFinder2 = (Function1)new Function1<Sdk, PathInfo>(this, rootType){
                                    final /* synthetic */ findInLibrariesAndSdk.2 this$0;
                                    final /* synthetic */ OrderRootType $rootType;

                                    @Nullable
                                    public final PathInfo invoke(@NotNull Sdk sdk) {
                                        PathInfo pathInfo;
                                        block1: {
                                            Intrinsics.checkParameterIsNotNull((Object)sdk, (String)"sdk");
                                            Object[] $receiver = sdk.getRootProvider().getFiles(this.$rootType);
                                            for (int i = 0; i < $receiver.length; ++i) {
                                                Object file2 = $receiver[i];
                                                VirtualFile it = (VirtualFile)file2;
                                                Function2 function2 = this.this$0.$fileProcessor;
                                                VirtualFile virtualFile = it;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                                                PathInfo result2 = (PathInfo)function2.invoke((Object)virtualFile, null);
                                                if (result2 == null) continue;
                                                pathInfo = result2;
                                                break block1;
                                            }
                                            pathInfo = null;
                                        }
                                        return pathInfo;
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$rootType = orderRootType;
                                        super(1);
                                    }
                                };
                                projectSdk = ProjectRootManager.getInstance((Project)this.$project).getProjectSdk();
                                sdk = projectSdk;
                                if (sdk == null) break block5;
                                Sdk sdk2 = sdk;
                                sdk = (PathInfo)inSdkFinder2.invoke((Object)$receiver);
                                if (sdk != null) break block6;
                            }
                            $receiver = ProjectJdkTable.getInstance().getAllJdks();
                            for (int i = 0; i < $receiver.length; ++i) {
                                PathInfo result2;
                                PathInfo pathInfo2;
                                Object file2 = $receiver[i];
                                Sdk it = (Sdk)file2;
                                if (it == projectSdk) {
                                    pathInfo2 = null;
                                } else {
                                    Sdk sdk3 = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)sdk3, (String)"it");
                                    pathInfo2 = result2 = (PathInfo)inSdkFinder2.invoke((Object)sdk3);
                                }
                                if (result2 == null) continue;
                                pathInfo = result2;
                                break block4;
                            }
                            pathInfo = null;
                        }
                        sdk = pathInfo;
                    }
                    return sdk;
                }
                {
                    this.$fileProcessor = function2;
                    this.$project = project;
                    super(1);
                }
            };
            Object[] objectArray = rootTypes;
            for (int i = 0; i < ((void)$receiver).length; ++i) {
                PathInfo pathInfo2;
                void file2 = $receiver[i];
                OrderRootType rootType = (OrderRootType)file2;
                AccessToken token = ReadAction.start();
                try {
                    PathInfo pathInfo3;
                    PathInfo pathInfo4;
                    LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTable(project);
                    Intrinsics.checkExpressionValueIsNotNull((Object)libraryTable, (String)"LibraryTablesRegistrar.g\u2026.getLibraryTable(project)");
                    PathInfo pathInfo5 = findInLibraryTable$.invoke(libraryTable, rootType);
                    if (pathInfo5 == null) {
                        pathInfo5 = pathInfo4 = findInProjectSdkOrInAll$.invoke(rootType);
                    }
                    if (pathInfo5 == null) {
                        PathInfo pathInfo6;
                        block10: {
                            void $receiver2;
                            Object[] objectArray2 = ModuleManager.getInstance((Project)project).getModules();
                            for (int j = 0; j < ((void)$receiver2).length; ++j) {
                                PathInfo result2;
                                PathInfo pathInfo7;
                                void file3 = $receiver2[j];
                                Module it = (Module)file3;
                                if (it.isDisposed()) {
                                    pathInfo7 = null;
                                } else {
                                    Module module = it;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)module, (String)"it");
                                    pathInfo7 = result2 = DefaultWebServerRootsProviderKt.findInModuleLevelLibraries(module, rootType, (Function2<? super VirtualFile, ? super Module, ? extends PathInfo>)fileProcessor);
                                }
                                if (result2 == null) continue;
                                pathInfo6 = result2;
                                break block10;
                            }
                            pathInfo6 = null;
                        }
                        pathInfo4 = pathInfo3 = (PathInfo)pathInfo6;
                    }
                    if (pathInfo4 == null) {
                        LibraryTable libraryTable2 = LibraryTablesRegistrar.getInstance().getLibraryTable();
                        Intrinsics.checkExpressionValueIsNotNull((Object)libraryTable2, (String)"LibraryTablesRegistrar.getInstance().libraryTable");
                        pathInfo3 = findInLibraryTable$.invoke(libraryTable2, rootType);
                    }
                    pathInfo2 = pathInfo3;
                }
                finally {
                    token.finish();
                }
                PathInfo result3 = pathInfo2;
                if (result3 == null) continue;
                pathInfo = result3;
                break block12;
            }
            pathInfo = null;
        }
        return pathInfo;
    }

    /*
     * WARNING - void declaration
     */
    private static final PathInfo findInModuleLevelLibraries(Module module, OrderRootType rootType, Function2<? super VirtualFile, ? super Module, ? extends PathInfo> fileProcessor) {
        PathInfo pathInfo;
        block5: {
            Object[] $receiver = ModuleRootManager.getInstance((Module)module).getOrderEntries();
            for (int i = 0; i < $receiver.length; ++i) {
                PathInfo result2;
                PathInfo pathInfo2;
                Object file2 = $receiver[i];
                OrderEntry it = (OrderEntry)file2;
                if (it instanceof LibraryOrderEntry && ((LibraryOrderEntry)it).isModuleLevel()) {
                    PathInfo pathInfo3;
                    block4: {
                        void $receiver2;
                        Object[] objectArray = ((LibraryOrderEntry)it).getFiles(rootType);
                        for (int j = 0; j < ((void)$receiver2).length; ++j) {
                            VirtualFile it2;
                            void file3 = $receiver2[j];
                            VirtualFile virtualFile = it2 = (VirtualFile)file3;
                            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"it");
                            PathInfo result3 = (PathInfo)fileProcessor.invoke((Object)virtualFile, (Object)module);
                            if (result3 == null) continue;
                            pathInfo3 = result3;
                            break block4;
                        }
                        pathInfo3 = null;
                    }
                    pathInfo2 = pathInfo3;
                } else {
                    pathInfo2 = result2 = (PathInfo)null;
                }
                if (result2 == null) continue;
                pathInfo = result2;
                break block5;
            }
            pathInfo = null;
        }
        return pathInfo;
    }

    @Nullable
    public static final /* synthetic */ PathInfo access$findByRelativePath(@NotNull String path, @NotNull VirtualFile[] roots, @NotNull FileResolver resolver, @Nullable String moduleName) {
        return DefaultWebServerRootsProviderKt.findByRelativePath(path, roots, resolver, moduleName);
    }

    @Nullable
    public static final /* synthetic */ PathInfo access$findInModuleLibraries(@NotNull String path, @NotNull Module module, @NotNull FileResolver resolver) {
        return DefaultWebServerRootsProviderKt.findInModuleLibraries(path, module, resolver);
    }

    @Nullable
    public static final /* synthetic */ String access$getModuleNameQualifier(@NotNull Project project, @Nullable Module module) {
        return DefaultWebServerRootsProviderKt.getModuleNameQualifier(project, module);
    }

    @Nullable
    public static final /* synthetic */ PathInfo access$findInLibraries(@NotNull Project project, @NotNull String path, @NotNull FileResolver resolver) {
        return DefaultWebServerRootsProviderKt.findInLibraries(project, path, resolver);
    }

    @Nullable
    public static final /* synthetic */ PathInfo access$getInfoForDocJar(@NotNull VirtualFile file2, @NotNull Project project) {
        return DefaultWebServerRootsProviderKt.getInfoForDocJar(file2, project);
    }

    @NotNull
    public static final /* synthetic */ OrderRootType[] access$getORDER_ROOT_TYPES$p() {
        return DefaultWebServerRootsProviderKt.getORDER_ROOT_TYPES();
    }

    @Nullable
    public static final /* synthetic */ OrderRootType access$getJavadocOrderRootType() {
        return DefaultWebServerRootsProviderKt.getJavadocOrderRootType();
    }
}

