/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"O\u0015\tA\"A\u0003\u0001\u000b\u0005A\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\u0003\u0006\u0003\u0011\tQ!\u0001\u0005\b\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011\tQ!\u0001E\u0011\u000b\u0005!9\"B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t\u0003\u0015\tA!A\u0003\u0002\u0011A!1\u0003\u0004\u0001\u0016\t\u0011\u0001\u0001\u0012A\u000b\u00021\u0005I\u0012\u0001g\u0001\"0%\u0019\u0001BA\u0007\u00021\u000bI1\u0001C\u0002\u000e\u0003a\u001d\u0011b\u0001\u0005\u0005\u001b\u0005A:!\u0003\u0003\t\n5\u0011A\u0012\u0001\r\u0006\u0013\rAY!D\u0001\u0019\rE\u001b\u0011\u0001#\u0004&\u0015\u0011\u0019\u0002bE\u0007\u0004\u0013\u0005!\u0019\u0001g\n\u001a\u0007!!R\"\u0001M\u0015K\u0011!1\u0002C\u000b\u000e\u0003a\u001dQ\u0005\u0002\u0003\u0014\u0011Wi\u0011\u0001\u0007\u0004&\u0016!1R\"\u0001M\u00173\u0011A!\"\u0004\u0002\r\u0002q\u0001\u0011kA\u0001\t/\u0015Z\u0001rF\u0007\u00021[Ir\u0001\u0003\u0006\u000e\u000b%\u0011\u0011\"\u0001\u000f\u0001\u0019\u0003A\u0002$K\u0007\u0005\u0007\"Aq!\u0004\u0003\n\u0005%\tA\u0004\u0001M\b#\u000e!Q\u0001A\u0007\u0003\t!A\t\"\u000b\u0006\u0005\u0017\"AA!D\u0001\u0019\bE\u001bA!\u0002\u0001\u000e\u0005\u0011I\u00012C\u0015\u0015\t-c\u0002\u0012B\u0007\u0003\u0019\u0003AR!\u0007\u0003\t\u00155\u0011A\u0012\u0001\r\u0006A-\n6aB\u0003\u0001\u001b\t!)\u0002C\u0006\u0012\u0005\u0011]\u0001\u0002D\u0015\u0010\t\u000bc\u0002\u0012D\u0007\u00021\u0019a\"\u0001\t\u0002R\u0007\u001d)\u0001!\u0004\u0002\u0005\u001b!m\u0011C\u0001\u0003\u000f\u0011;I#\u0003B&\u001d\u0011\u0017i\u0011\u0001\u0007\u0004\u001a\u0007!QQ\"\u0001\r\u0007A-\n6aB\u0003\u0001\u001b\t!q\u0002c\u0007\u0012\u0005\u0011}\u0001RD\u0015\u000b\t-C\u0001\u0002E\u0007\u00021\u0019a2&U\u0002\u0004\u001b\t!\u0001\u0003c\u0007*\u001b\u0011YE\u0004C\u0002\u000e\u0003a\u001d\u0011kA\u0004\u0006\u00015\u0011A\u0011\u0005E\n#\t!\u0011\u0003c\t*\u0015\u0011Y\u0005\u0002\u0003\u0002\u000e\u0003a\u0015\u0011k\u0001\u0003\u0006\u00015\u0011AA\u0005E\u0013"}, strings={"Lorg/jetbrains/debugger/BreakpointBase;", "L", "", "Lorg/jetbrains/debugger/Breakpoint;", "target", "Lorg/jetbrains/debugger/BreakpointTarget;", "line", "", "column", "condition", "", "enabled", "", "(Lorg/jetbrains/debugger/BreakpointTarget;IILjava/lang/String;Z)V", "actualLocations", "", "getActualLocations", "()Ljava/util/List;", "getColumn", "()I", "value", "getCondition", "()Ljava/lang/String;", "setCondition", "(Ljava/lang/String;)V", "dirty", "getDirty", "()Z", "setDirty", "(Z)V", "getEnabled", "setEnabled", "isResolved", "getLine", "setLine", "(I)V", "getTarget", "()Lorg/jetbrains/debugger/BreakpointTarget;", "flush", "Lorg/jetbrains/concurrency/Promise;", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "hashCode", "isVmRegistered", "setActualLocation", "", "(Ljava/lang/Object;)V", "setActualLocations", ""}, moduleName="script-debugger-backend")
public abstract class BreakpointBase<L>
implements Breakpoint {
    @NotNull
    private final List<L> actualLocations;
    private volatile boolean dirty;
    @Nullable
    private String condition;
    private boolean enabled;
    @NotNull
    private final BreakpointTarget target;
    private int line;
    private final int column;

    @NotNull
    public final List<L> getActualLocations() {
        return this.actualLocations;
    }

    protected final boolean getDirty() {
        return this.dirty;
    }

    protected final void setDirty(boolean bl) {
        this.dirty = bl;
    }

    @Override
    public boolean isResolved() {
        return !this.actualLocations.isEmpty();
    }

    @Override
    @Nullable
    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(@Nullable String value) {
        if (Intrinsics.areEqual((Object)this.condition, (Object)value) ^ true) {
            this.condition = value;
            this.dirty = true;
        }
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean value) {
        if (value != this.enabled) {
            this.enabled = value;
            this.dirty = true;
        }
    }

    public final void setActualLocations(@Nullable List<? extends L> value) {
        this.actualLocations.clear();
        if (!ContainerUtil.isEmpty((Collection)value)) {
            List<? extends L> list = value;
            if (list == null) {
                Intrinsics.throwNpe();
            }
            this.actualLocations.addAll((Collection)list);
        }
    }

    public final void setActualLocation(@Nullable L value) {
        this.actualLocations.clear();
        if (value != null) {
            this.actualLocations.add(value);
        }
    }

    public abstract boolean isVmRegistered();

    public int hashCode() {
        int result2 = this.getLine();
        result2 *= 31 + this.getColumn();
        result2 *= 31 + (this.getEnabled() ? 1 : 0);
        if (this.getCondition() != null) {
            String string = this.getCondition();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            result2 *= 31 + string.hashCode();
        }
        return result2 *= 31 + this.getTarget().hashCode();
    }

    @NotNull
    public abstract Promise<?> flush(@NotNull BreakpointManager var1);

    @Override
    @NotNull
    public BreakpointTarget getTarget() {
        return this.target;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setLine(int n) {
        this.line = n;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public BreakpointBase(@NotNull BreakpointTarget target, int line, int column, @Nullable String condition, boolean enabled) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        this.target = target;
        this.line = line;
        this.column = column;
        List list = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ContainerUtil.createLockFreeCopyOnWriteList<L>()");
        this.actualLocations = list;
        this.condition = condition;
        this.enabled = enabled;
    }

    @Override
    public boolean isActualLineCorrect() {
        return Breakpoint.DefaultImpls.isActualLineCorrect(this);
    }
}

