/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Ref;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.SetsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.BreakpointListener;
import org.jetbrains.debugger.BreakpointManager;
import org.jetbrains.debugger.BreakpointTarget;
import org.jetbrains.debugger.DebugProcessImpl;
import org.jetbrains.debugger.Location;
import org.jetbrains.debugger.Vm;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"{\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003!\u0005R!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0011\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0005!Q\u0001B\n\r\u0001e\t\u0001\u0014AQ\t\u0013\u0015A\u0011!D\u0002\n\u0003\u0011\r\u00014A)\u0004\u0003!\u0011QE\u0004\u0003\u000b\u0011/i\u0011\u0001\u0007\u0007\u001a\u000b!eQbA\u0005\u0002\t\u0007Aj!G\u0002\t\u001b5\t\u00014D\u0013\u0012\t)Aa\"\u0004\u0002\r\u0002a=\u0011d\u0001E\u000f\u001b\u0005Ar\"G\u0002\t 5\t\u0001\u0004E\r\u0004\u0011\u000bi\u0011\u0001G\u0002&\u0007!\u0005R\"\u0001\r\rK]!!\u0003C\t\u000e\u0003ay\u0011D\u0002E\r\u001b\u0011I\u0011\u0001b\u0001\r\u0002a5\u0011d\u0001E\u0003\u001b\u0005A2!G\u0002\t 5\t\u0001\u0004E\r\u0004\u0011Gi\u0011\u0001g\u0007&!!\u0011RbA\u0005\u0002\t\u0007A*#G\u0003\t\u001a5\u0019\u0011\"\u0001C\u00021\u001bIB\u0001B\u0001\t\u001b5\t\u00014D\u0013\f\tIA1#\u0004\u0003\n\u0005%\t\u0001t\u0002M\u00143\rAA#D\u0001\u0019*\u0015\nCA\u0001\u0005\u0016\u001b\ta\t\u0001g\u0004\u001a\r!eQ\u0002B\u0005\u0002\t\u0007a\t\u0001'\u0004\u001a\u0007!}Q\"\u0001\r\u00113\rA\u0019#D\u0001\u0019\u001ceaA!\u0001E\u0016\u001b%Ia!C\u0003\n\u0007\u0011\u0005\u0011\"\u0001M\b1Ka\t\u0001\u0007\f&\u0011\u0011Y\u0001RF\u0007\u000217I2\u0001#\u0007\u000e\u0003a=QE\u0003\u0005\u0018\u001b\u0005AZ\"\u0007\u0004\t05!\u0011BA\u0005\u00021\u001fA:#J\u0003\t15\u0019\u0011\"\u0001C\u00021K)s\u0002#\r\u000e\u0007%\tA1\u0001M\u00133\u0015AI\"D\u0002\n\u0003\u0011\r\u0001TB\r\u0004\u0011ei\u0011\u0001g\u0007&\u000f!MR\"\u0001\r\r3\rAA#D\u0001\u0019*\u0015J\u0001BG\u0007\u000211IR\u0001#\u0007\u000e\u0007%\tA1\u0001M\u0007KuA!$D\u0001\u0019\u0019e)\u0001\u0012D\u0007\u0004\u0013\u0005!\u0019\u0001'\u0004\u001a\r!UR\u0002B\u0005\u0003\u0013\u0005A\u0002\u0003g\n\u001a\u0019\u0011\t\u00012F\u0007\n\u0013\u0019IQ!C\u0002\u0005\u0002%\t\u0001t\u0002M\u0013\u0019\u0003Ab#J\u0002\t75\t\u0001\u0004D\u0015\u000b\t\u0005C\u0001RA\u0007\u00021\ra\u0012%U\u0002\u0004\u001b\t!9\u0001\u0003\u0003*\u000f\u0011\t\u0005\u0002#\u0003\u000e\u0003a)\u0011kA\u0001\u0006\u0001%JA!\u0011\u0005\t\u00035\u0019\u0011\"\u0001C\u00021\u0007\t6!A\u0003\u0001SI!\u0011\t\u0003E\u0006\u001b1IA!C\u0002\n\u0003\u0011\r\u0001TB\u0005\u0006\u0013\u0011I!!C\u0001\u0019\u0010a9\u0001DB)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!AQ\"\u0001M\t#\u000e\tQ\u0001A\u0015\u000b\t\u0005C\u0001\"C\u0007\u0005\u0013\tI\u0011\u0001g\u0004\u0019\u0014E\u001b\u0011!\u0002\u0001*+\u0011\u0011\u0005\u0002\u0003\u0006\u000e\u0019%\u0011\u0011\"\u0001M\b\u0013\u001dIa!\u0003\u0003\n\u0007%\tA1\u0001M\u00071\u001dAb!U\u0002\u0005\u000b\u0001i!\u0001\"\u0006\t\u0017\u0001"}, strings={"Lorg/jetbrains/debugger/LineBreakpointManager;", "", "debugProcess", "Lorg/jetbrains/debugger/DebugProcessImpl;", "(Lorg/jetbrains/debugger/DebugProcessImpl;)V", "breakpointManager", "Lorg/jetbrains/debugger/BreakpointManager;", "getBreakpointManager", "()Lorg/jetbrains/debugger/BreakpointManager;", "breakpointResolvedListenerAdded", "Ljava/util/concurrent/atomic/AtomicBoolean;", "ideToVmBreakpoints", "Lgnu/trove/THashMap;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "", "Lorg/jetbrains/debugger/Breakpoint;", "lock", "Ljava/lang/Object;", "runToLocationBreakpoints", "Lgnu/trove/THashSet;", "vmToIdeBreakpoints", "getVmToIdeBreakpoints", "()Lgnu/trove/THashMap;", "beforeBreakpointRemoved", "", "breakpoint", "disable", "", "checkDuplicates", "newTarget", "Lorg/jetbrains/debugger/BreakpointTarget;", "location", "Lorg/jetbrains/debugger/Location;", "clearRunToLocationBreakpoints", "createTarget", "isTemporary", "doRemoveBreakpoint", "Lorg/jetbrains/concurrency/Promise;", "doRunToLocation", "", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "doSetBreakpoint", "promiseRef", "Lcom/intellij/openapi/util/Ref;", "isAnyFirstLineBreakpoint", "isRunToCursorBreakpoints", "breakpoints", "removeAllBreakpoints", "removeBreakpoint", "temporary", "runToLocation", "setBreakpoint", "locations", "updateAllBreakpoints"}, moduleName="script-debugger-ui")
public abstract class LineBreakpointManager {
    private final THashMap<XLineBreakpoint<?>, List<Breakpoint>> ideToVmBreakpoints;
    @NotNull
    private final THashMap<Breakpoint, List<XLineBreakpoint<?>>> vmToIdeBreakpoints;
    private final THashSet<Breakpoint> runToLocationBreakpoints;
    private final Object lock;
    private final AtomicBoolean breakpointResolvedListenerAdded;
    private final DebugProcessImpl<?> debugProcess;

    @NotNull
    protected final THashMap<Breakpoint, List<XLineBreakpoint<?>>> getVmToIdeBreakpoints() {
        return this.vmToIdeBreakpoints;
    }

    private final BreakpointManager getBreakpointManager() {
        Vm vm = this.debugProcess.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        return vm.getBreakpointManager();
    }

    public boolean isAnyFirstLineBreakpoint(@NotNull Breakpoint breakpoint) {
        Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setBreakpoint(@NotNull XLineBreakpoint<?> breakpoint) {
        List list;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Object lock = this.lock;
        synchronized (lock) {
            list = (List)this.ideToVmBreakpoints.get(breakpoint);
        }
        List target = list;
        if (target == null) {
            LineBreakpointManager.setBreakpoint$default(this, breakpoint, this.debugProcess.getLocationsForBreakpoint(breakpoint), null, 4);
        } else {
            BreakpointManager breakpointManager = this.getBreakpointManager();
            for (Breakpoint vmBreakpoint : target) {
                if (vmBreakpoint.getEnabled()) continue;
                vmBreakpoint.setEnabled(true);
                breakpointManager.flush(vmBreakpoint).rejected((Consumer)new Consumer<Throwable>(this, breakpoint){
                    final /* synthetic */ LineBreakpointManager this$0;
                    final /* synthetic */ XLineBreakpoint $breakpoint;

                    public final void consume(Throwable it) {
                        LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().updateBreakpointPresentation(this.$breakpoint, AllIcons.Debugger.Db_invalid_breakpoint, it.getMessage());
                    }
                    {
                        this.this$0 = lineBreakpointManager;
                        this.$breakpoint = xLineBreakpoint;
                    }
                });
            }
        }
    }

    @NotNull
    public final Promise<?> removeBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean temporary) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        boolean disable = temporary && this.getBreakpointManager().getMuteMode() != BreakpointManager.MUTE_MODE.NONE;
        this.beforeBreakpointRemoved(breakpoint, disable);
        return this.doRemoveBreakpoint(breakpoint, disable);
    }

    protected void beforeBreakpointRemoved(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final Promise<?> doRemoveBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, boolean disable) {
        void vmBreakpoints;
        void lock;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = SetsKt.emptySet();
        Object object = this.lock;
        synchronized (lock) {
            block13: {
                block12: {
                    if (disable) break block12;
                    List list = (List)this.ideToVmBreakpoints.remove(breakpoint);
                    if (list == null) {
                        return PromiseKt.resolvedPromise();
                    }
                    vmBreakpoints.element = list;
                    if (!((Collection)vmBreakpoints.element).isEmpty()) {
                        for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                            UtilKt.remove((Map)this.getVmToIdeBreakpoints(), vmBreakpoint, breakpoint);
                            if (!this.getVmToIdeBreakpoints().containsKey((Object)vmBreakpoint)) continue;
                            return PromiseKt.resolvedPromise();
                        }
                    }
                    break block13;
                }
                List list = (List)this.ideToVmBreakpoints.get(breakpoint);
                if (list == null) {
                    return PromiseKt.resolvedPromise();
                }
                List list2 = list;
                Iterator iterator = list2.iterator();
                List list3 = list2;
                Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"list");
                vmBreakpoints.element = list3;
                while (iterator.hasNext()) {
                    Breakpoint vmBreakpoint = (Breakpoint)iterator.next();
                    List list4 = (List)this.getVmToIdeBreakpoints().get((Object)vmBreakpoint);
                    if ((list4 != null ? list4.size() : -1) <= 1) continue;
                    iterator.remove();
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        if (((Collection)vmBreakpoints.element).isEmpty()) {
            return PromiseKt.resolvedPromise();
        }
        BreakpointManager breakpointManager = this.getBreakpointManager();
        SmartList promises = new SmartList();
        if (disable) {
            for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                vmBreakpoint.setEnabled(false);
                promises.add(breakpointManager.flush(vmBreakpoint));
            }
        } else {
            for (Breakpoint vmBreakpoint : (Collection)vmBreakpoints.element) {
                promises.add(breakpointManager.remove(vmBreakpoint));
            }
        }
        Promise promise2 = Promise.all((Collection)((Collection)promises));
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.all(promises)");
        return promise2;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Promise doRemoveBreakpoint$default(LineBreakpointManager lineBreakpointManager, XLineBreakpoint xLineBreakpoint, boolean bl, int n) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return lineBreakpointManager.doRemoveBreakpoint(xLineBreakpoint, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void setBreakpoint(@NotNull XLineBreakpoint<?> breakpoint, @NotNull List<? extends Location> locations, @Nullable Ref<Promise<? extends Breakpoint>> promiseRef) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull(locations, (String)"locations");
        if (locations.isEmpty()) {
            return;
        }
        SmartList vmBreakpoints = new SmartList();
        for (Location location : locations) {
            Boolean bl;
            if (this.doSetBreakpoint(breakpoint, location, false, promiseRef) != null) {
                void $receiver;
                Breakpoint it = (Breakpoint)$receiver;
                bl = vmBreakpoints.add((Object)it);
                continue;
            }
            bl = null;
        }
        Object object = this.lock;
        synchronized (object) {
            this.ideToVmBreakpoints.put(breakpoint, (Object)vmBreakpoints);
            for (Breakpoint vmBreakpoint : vmBreakpoints) {
                UtilKt.putValue((Map)this.getVmToIdeBreakpoints(), vmBreakpoint, breakpoint);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public static /* bridge */ /* synthetic */ void setBreakpoint$default(LineBreakpointManager lineBreakpointManager, XLineBreakpoint xLineBreakpoint, List list, Ref ref, int n) {
        if ((n & 4) != 0) {
            ref = null;
        }
        lineBreakpointManager.setBreakpoint(xLineBreakpoint, list, (Ref<Promise<? extends Breakpoint>>)ref);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected final Breakpoint doSetBreakpoint(@Nullable XLineBreakpoint<?> breakpoint, @NotNull Location location, boolean isTemporary, @Nullable Ref<Promise<? extends Breakpoint>> promiseRef) {
        XExpression xExpression;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        if (this.breakpointResolvedListenerAdded.compareAndSet(false, true)) {
            this.getBreakpointManager().addBreakpointListener(new BreakpointListener(this){
                final /* synthetic */ LineBreakpointManager this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void resolved(@NotNull Breakpoint breakpoint) {
                    Unit unit;
                    List list;
                    Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                    Object lock = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        list = (List)this.this$0.getVmToIdeBreakpoints().get((Object)breakpoint);
                    }
                    List list2 = list;
                    if (list2 != null) {
                        List $receiver = list2;
                        List it = $receiver;
                        for (XLineBreakpoint ideBreakpoint : it) {
                            LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_verified_breakpoint, (String)null);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void errorOccurred(@NotNull Breakpoint breakpoint, @Nullable String errorMessage) {
                    Unit unit;
                    List list;
                    boolean bl;
                    Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                    if (this.this$0.isAnyFirstLineBreakpoint(breakpoint)) {
                        return;
                    }
                    Object lock = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        bl = LineBreakpointManager.access$getRunToLocationBreakpoints$p(this.this$0).remove((Object)breakpoint);
                    }
                    if (bl) {
                        LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().reportError("Cannot run to cursor: " + errorMessage);
                        return;
                    }
                    lock = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        list = (List)this.this$0.getVmToIdeBreakpoints().get((Object)breakpoint);
                    }
                    List list2 = list;
                    if (list2 != null) {
                        List $receiver = list2;
                        List it = $receiver;
                        for (XLineBreakpoint ideBreakpoint : it) {
                            LineBreakpointManager.access$getDebugProcess$p(this.this$0).getSession().updateBreakpointPresentation(ideBreakpoint, AllIcons.Debugger.Db_invalid_breakpoint, errorMessage);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nonProvisionalBreakpointRemoved(@NotNull Breakpoint breakpoint) {
                    Unit unit;
                    List list;
                    Intrinsics.checkParameterIsNotNull((Object)breakpoint, (String)"breakpoint");
                    Object lock = LineBreakpointManager.access$getLock$p(this.this$0);
                    synchronized (lock) {
                        List list2;
                        List list3 = (List)this.this$0.getVmToIdeBreakpoints().remove((Object)breakpoint);
                        if (list3 != null) {
                            List $receiver = list3;
                            List it = $receiver;
                            for (XLineBreakpoint ideBreakpoint : it) {
                                UtilKt.remove((Map)LineBreakpointManager.access$getIdeToVmBreakpoints$p(this.this$0), ideBreakpoint, breakpoint);
                            }
                            list2 = it;
                        } else {
                            list2 = null;
                        }
                        list = list2;
                    }
                    List list4 = list;
                    if (list4 != null) {
                        List $receiver = list4;
                        List it = $receiver;
                        for (XLineBreakpoint ideBreakpoint : it) {
                            LineBreakpointManager.setBreakpoint$default(this.this$0, ideBreakpoint, LineBreakpointManager.access$getDebugProcess$p(this.this$0).getLocationsForBreakpoint(ideBreakpoint), null, 4);
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                }
                {
                    this.this$0 = $outer;
                }
            });
        }
        if ((object = this.debugProcess.getVm()) == null || (object = object.getBreakpointManager()) == null) {
            return null;
        }
        Object breakpointManager = object;
        BreakpointTarget target = this.createTarget((XLineBreakpoint<?>)breakpoint, (BreakpointManager)breakpointManager, location, isTemporary);
        Breakpoint breakpoint2 = this.checkDuplicates(target, location, (BreakpointManager)breakpointManager);
        if (breakpoint2 != null) {
            Unit unit;
            void $receiver;
            Breakpoint breakpoint3 = breakpoint2;
            Breakpoint it = (Breakpoint)$receiver;
            Ref<Promise<? extends Breakpoint>> ref = promiseRef;
            if (ref != null) {
                ref.set(PromiseKt.resolvedPromise(it));
                unit = Unit.INSTANCE;
            } else {
                unit = null;
            }
            return it;
        }
        return BreakpointManager.DefaultImpls.setBreakpoint$default((BreakpointManager)breakpointManager, target, location.getLine(), location.getColumn(), (xExpression = breakpoint) != null && (xExpression = xExpression.getConditionExpression()) != null ? xExpression.getExpression() : null, 0, false, promiseRef, 48);
    }

    @Nullable
    protected static /* bridge */ /* synthetic */ Breakpoint doSetBreakpoint$default(LineBreakpointManager lineBreakpointManager, XLineBreakpoint xLineBreakpoint, Location location, boolean bl, Ref ref, int n) {
        if ((n & 8) != 0) {
            ref = null;
        }
        return lineBreakpointManager.doSetBreakpoint(xLineBreakpoint, location, bl, (Ref<Promise<? extends Breakpoint>>)ref);
    }

    @NotNull
    protected abstract BreakpointTarget createTarget(@Nullable XLineBreakpoint<?> var1, @NotNull BreakpointManager var2, @NotNull Location var3, boolean var4);

    @Nullable
    protected Breakpoint checkDuplicates(@NotNull BreakpointTarget newTarget, @NotNull Location location, @NotNull BreakpointManager breakpointManager) {
        Intrinsics.checkParameterIsNotNull((Object)newTarget, (String)"newTarget");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)breakpointManager, (String)"breakpointManager");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runToLocation(@NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        List<Breakpoint> addedBreakpoints = this.doRunToLocation(position);
        if (addedBreakpoints.isEmpty()) {
            return;
        }
        Object lock = this.lock;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.addAll((Collection)addedBreakpoints);
        }
        this.debugProcess.resume();
    }

    @NotNull
    protected abstract List<Breakpoint> doRunToLocation(@NotNull XSourcePosition var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isRunToCursorBreakpoints(@NotNull List<? extends Breakpoint> breakpoints) {
        Intrinsics.checkParameterIsNotNull(breakpoints, (String)"breakpoints");
        THashSet<Breakpoint> lock = this.runToLocationBreakpoints;
        synchronized (lock) {
            boolean bl = this.runToLocationBreakpoints.containsAll((Collection)breakpoints);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateAllBreakpoints() {
        XLineBreakpoint[] xLineBreakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            Collection $receiver = this.ideToVmBreakpoints.keySet();
            Collection collection = $receiver;
            if (collection == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection = collection;
            XLineBreakpoint[] xLineBreakpointArray2 = thisCollection.toArray(new XLineBreakpoint[thisCollection.size()]);
            if (xLineBreakpointArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            xLineBreakpointArray = (XLineBreakpoint[])((Object[])xLineBreakpointArray2);
        }
        XLineBreakpoint[] array = xLineBreakpointArray;
        for (int i = 0; i < array.length; ++i) {
            XLineBreakpoint breakpoint;
            XLineBreakpoint xLineBreakpoint = breakpoint = array[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint, (String)"breakpoint");
            this.removeBreakpoint(xLineBreakpoint, false);
            XLineBreakpoint xLineBreakpoint2 = breakpoint;
            Intrinsics.checkExpressionValueIsNotNull((Object)xLineBreakpoint2, (String)"breakpoint");
            this.setBreakpoint(xLineBreakpoint2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Promise<?> removeAllBreakpoints() {
        Object lock = this.lock;
        synchronized (lock) {
            this.ideToVmBreakpoints.clear();
            this.getVmToIdeBreakpoints().clear();
            this.runToLocationBreakpoints.clear();
            Unit unit = Unit.INSTANCE;
        }
        return this.getBreakpointManager().removeAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearRunToLocationBreakpoints() {
        Breakpoint[] breakpointArray;
        Object lock = this.lock;
        synchronized (lock) {
            if (this.runToLocationBreakpoints.isEmpty()) {
                return;
            }
            Breakpoint[] breakpoints = (Breakpoint[])this.runToLocationBreakpoints.toArray((Object[])new Breakpoint[this.runToLocationBreakpoints.size()]);
            this.runToLocationBreakpoints.clear();
            breakpointArray = breakpoints;
        }
        Breakpoint[] breakpoints = breakpointArray;
        BreakpointManager breakpointManager = this.getBreakpointManager();
        for (int i = 0; i < breakpoints.length; ++i) {
            Breakpoint breakpoint;
            Breakpoint breakpoint2 = breakpoint = breakpoints[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)breakpoint2, (String)"breakpoint");
            breakpointManager.remove(breakpoint2);
        }
    }

    public LineBreakpointManager(@NotNull DebugProcessImpl<?> debugProcess) {
        Intrinsics.checkParameterIsNotNull(debugProcess, (String)"debugProcess");
        this.debugProcess = debugProcess;
        this.ideToVmBreakpoints = new THashMap();
        this.vmToIdeBreakpoints = new THashMap();
        this.runToLocationBreakpoints = new THashSet();
        this.lock = new Object();
        this.breakpointResolvedListenerAdded = new AtomicBoolean();
    }

    @NotNull
    public static final /* synthetic */ Object access$getLock$p(LineBreakpointManager $this) {
        return $this.lock;
    }

    @NotNull
    public static final /* synthetic */ DebugProcessImpl access$getDebugProcess$p(LineBreakpointManager $this) {
        return $this.debugProcess;
    }
}

