/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.Collection;
import java.util.Map;
import kotlin.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.MemberFilter;
import org.jetbrains.debugger.Variable;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t%\u0015\t\u0001bB\u0003\u0002\t\t)\u0011\u0001c\u0003\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001!1\u0002\u0004\u0001\u001a\u0003a\u0005\u00115D\u0005\u000b\u0011\u0005i\u0001\"\u0003\u0002\n\u0003a\u0011\u0011BA\u0005\u00021\ta\t\u0001g\u0001R\u0007\u0005A)!\n\u0003\u0005\u0017!!Q\"\u0001M\u0005K!!!\u0002C\u0003\u000e\u0003a\u0011\u0011d\u0001E\u0006\u001b\u0005A\"!\n\u0005\u0005\u0017!\tQ\"\u0001\r\u00033\rAa!D\u0001\u0019\u000e\u0015JAa\u0003\u0005\b\u001b\ta\t\u0001\u0007\u0002\u001a\u0007!-Q\"\u0001\r\u0003SA!!\t\u0003\u0005\u0002\u001b\u001dI!!C\u0001\u0019\u0005%\u0011\u0011\"\u0001\r\u00031\u0007\t6\u0001B\u0003\u0001\u001b\t!1\u0001c\u0002"}, strings={"Lorg/jetbrains/debugger/MemberFilterWithNameMappings;", "Lorg/jetbrains/debugger/MemberFilter;", "rawNameToSource", "", "", "(Ljava/util/Map;)V", "getRawNameToSource", "()Ljava/util/Map;", "hasNameMappings", "", "normalizeMemberName", "name", "variable", "Lorg/jetbrains/debugger/Variable;", "sourceNameToRaw"}, moduleName="script-debugger-ui")
public class MemberFilterWithNameMappings
implements MemberFilter {
    @NotNull
    private final Map<String, ? extends String> rawNameToSource;

    @NotNull
    protected final Map<String, String> getRawNameToSource() {
        return this.rawNameToSource;
    }

    @Override
    public boolean hasNameMappings() {
        return !this.rawNameToSource.isEmpty();
    }

    @Override
    @NotNull
    public String rawNameToSource(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        String name = variable.getName();
        String sourceName = this.rawNameToSource.get(name);
        String string = sourceName;
        if (string == null) {
            String string2 = name;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
            string = this.normalizeMemberName(string2);
        }
        return string;
    }

    @NotNull
    protected String normalizeMemberName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return name;
    }

    @Override
    @Nullable
    public String sourceNameToRaw(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (!this.hasNameMappings()) {
            return null;
        }
        for (Map.Entry<String, ? extends String> entry : this.rawNameToSource.entrySet()) {
            if (!Intrinsics.areEqual((Object)entry.getValue(), (Object)name)) continue;
            return entry.getKey();
        }
        return null;
    }

    public MemberFilterWithNameMappings(@Nullable Map<String, ? extends String> rawNameToSource) {
        Map map = rawNameToSource;
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        this.rawNameToSource = map;
    }

    @Override
    public boolean isMemberVisible(@NotNull Variable variable) {
        Intrinsics.checkParameterIsNotNull((Object)variable, (String)"variable");
        return MemberFilter.DefaultImpls.isMemberVisible(this, variable);
    }

    @Override
    @NotNull
    public Collection<Variable> getAdditionalVariables() {
        return MemberFilter.DefaultImpls.getAdditionalVariables(this);
    }
}

