/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.connection;

import com.intellij.ide.browsers.WebBrowser;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.socketConnection.ConnectionState;
import com.intellij.util.io.socketConnection.ConnectionStatus;
import com.intellij.util.io.socketConnection.SocketConnectionListener;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkListener;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseKt;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Vm;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"\u000b\u0004)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\u0005R!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005A\u0001#\u0002\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0005\u0001\u000b\u0005!!!B\u0001\r\u0003\u0015\tA!B\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA1A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\tMa\u0001!\u0006\u0003\u0005\u0001!\u0005Q#\u0001\r\u00023\u0005A\u001a!)\u0002R\u0007\u0005A!!J\u0004\t)5\t\u0001tB\r\u0004\u0011Si\u0011\u0001\u0007\u0006&\u000f!)R\"\u0001M\b3\rAI#D\u0001\u0019,\u0015b\u0001BF\u0007\u00021\u001fIB\u0001#\f\u000e\u00051\u0005\u0001dF\r\u0004\u0011_i\u0011\u0001\u0007\r&\r\u0011Y\u0001\u0012G\u0007\u0004\u0013\u0005!\u0019\u0001G\r&\t\u0011Y\u00012G\u0007\u00021\u001f)s\u0001\u0003\u000e\u000e\u0003a=\u0011d\u0001E\u001b\u001b\u0005A2$\n\u0004\u0005\b!eQbA\u0005\u0002\t\u0007A\u0012$\n\u000b\u0005\u0005!]R\"\u0001M\b3\rAy#D\u0001\u00191e)A!\u0001E\u0017\u001b\ta\t\u0001G\f\u001a\u000b\u0011\t\u0001\u0002H\u0007\u0003\u0019\u0003AJ$\n\u0003\u0005\u0015!iR\"\u0001M\bK5AY$D\u0001\u0019\u0010eI\u0001\u0012F\u0007\b\u0013\tI\u0011\u0001G\u0004\n\u0005%\t\u0001t\u0002M\u0007S-!1\n\u0003E\u0003\u001b\ta\t\u0001G\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\b!!\u0011f\u0002\u0003B\u0011!%Q\"\u0001\r\u0006#\u000e\tQ\u0001A\u00156\t\u0005C\u00012B\u00070\u0013II\u0011#\u0003\u0002\n\u0003a9\u0011BA\u0005\u00021\u001f\u0001\u0002\"\u0006\u0005\n\u0005%\t\u0001dB\u0005\u0003\u0013\u0005Az\u0001$\u0001\u0019\u000ea5\u0001\u0003CK\u0017\u0013II\u0011#\u0003\u0002\n\u0003a9\u0011BA\u0005\u00021\u001f\u0001\u0002\"\u0006\u0005\n\u0005%\t\u0001dB\u0005\u0003\u0013\u0005Az\u0001$\u0001\u0019\u000ea5\u0001$C)\u0004\u0003\u0011E\u0001DB)\u0004\u0003\u0011E\u0011kA\u0001\u0006\u0001%RAA\u0011\u0005\t\u00145\t\u0001D\u0003\u000f##\u000e\u0019QB\u0001C\u000b\u0011-I\u0013\u0004B!\t\u0011/i1#\u0003\u0004\n\u000bAAQC\u0001G\u00011)A\"\u0002\u0005\u0005\u0016\u0013%1\u0011\"\u0002\t\t+\ta\t\u0001\u0007\u0006\u0019\u00151\u0005\u0001\u0004\u0004\r\r#\u000e\tQ\u0001A\u0015\f\t\u0005C\u0001\u0012D\u0007\u0006\u0013\rI!\u0001$\u0001\u0019\u001cai\u0011kA\u0001\u0006\u0001%RAa\u0011\u0005\t\u001d5\t\u0001d\u0002\u000f$#\u000e\u0019QB\u0001C\u000f\u0011=Ic\u0002B!\t\u0011?i\u0001\"\u0003\u0004\n\u000bAAQC\u0001G\u00011\u001dAr\u0001\u0007\tR\u0007\u0005)\u0001!\u000b\f\u0005\brA\u0011#\u0004\u0002\r\u0002q\u0001\u0011\u0004\u0002E\u0011\u001b\ta\t\u0001\b\u0001\u001d\u0007\u0001\u0012\u0013k\u0001\u0005\u0006\u0003!\u001dRB\u0001C\u0012\u0011I\t\"\u0001\"\n\t'\u0001"}, strings={"Lorg/jetbrains/debugger/connection/VmConnection;", "T", "Lorg/jetbrains/debugger/Vm;", "Lcom/intellij/openapi/Disposable;", "()V", "browser", "Lcom/intellij/ide/browsers/WebBrowser;", "getBrowser", "()Lcom/intellij/ide/browsers/WebBrowser;", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "connectionDispatcher", "", "Lkotlin/Function1;", "Lcom/intellij/util/io/socketConnection/ConnectionState;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "debugEventListener", "Lorg/jetbrains/debugger/DebugEventListener;", "getDebugEventListener", "()Lorg/jetbrains/debugger/DebugEventListener;", "dispatcher", "Lcom/intellij/util/EventDispatcher;", "opened", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "state", "getState", "()Lcom/intellij/util/io/socketConnection/ConnectionState;", "stateRef", "Ljava/util/concurrent/atomic/AtomicReference;", "<set-?>", "vm", "getVm", "()Lorg/jetbrains/debugger/Vm;", "setVm", "(Lorg/jetbrains/debugger/Vm;)V", "Lorg/jetbrains/debugger/Vm;", "addDebugListener", "listener", "addListener", "Lcom/intellij/util/io/socketConnection/SocketConnectionListener;", "close", "message", "", "status", "Lcom/intellij/util/io/socketConnection/ConnectionStatus;", "detachAndClose", "Lorg/jetbrains/concurrency/Promise;", "dispose", "executeOnStart", "runnable", "Ljava/lang/Runnable;", "setState", "messageLinkListener", "Ljavax/swing/event/HyperlinkListener;", "startProcessing", "stateChanged"}, moduleName="script-debugger-ui")
public abstract class VmConnection<T extends Vm>
implements Disposable {
    @Nullable
    private final WebBrowser browser;
    private final AtomicReference<ConnectionState> stateRef = new AtomicReference<ConnectionState>(new ConnectionState(ConnectionStatus.NOT_CONNECTED));
    private final EventDispatcher<DebugEventListener> dispatcher = EventDispatcher.create(DebugEventListener.class);
    private final List<Function1<? super ConnectionState, ? extends Unit>> connectionDispatcher = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private volatile T vm;
    private final AsyncPromise<Object> opened = new AsyncPromise();
    private final AtomicBoolean closed = new AtomicBoolean();

    @Nullable
    public WebBrowser getBrowser() {
        return this.browser;
    }

    @Nullable
    public final T getVm() {
        return this.vm;
    }

    protected final void setVm(@Nullable T t) {
        this.vm = t;
    }

    @NotNull
    public final ConnectionState getState() {
        ConnectionState connectionState = this.stateRef.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)connectionState, (String)"stateRef.get()");
        return connectionState;
    }

    public final void addDebugListener(@NotNull DebugEventListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.dispatcher.addListener((EventListener)listener);
    }

    @NotNull
    public final Promise<?> opened() {
        return (Promise)this.opened;
    }

    public final void executeOnStart(@NotNull Runnable runnable2) {
        Intrinsics.checkParameterIsNotNull((Object)runnable2, (String)"runnable");
        this.opened.done(new Consumer<T>(runnable2){
            final /* synthetic */ Runnable $runnable;

            public final void consume(@Nullable Object it) {
                this.$runnable.run();
            }
            {
                this.$runnable = runnable2;
            }
        });
    }

    protected final void setState(@NotNull ConnectionStatus status, @Nullable String message, @Nullable HyperlinkListener messageLinkListener) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        ConnectionState newState = new ConnectionState(status, message, messageLinkListener);
        ConnectionState oldState = this.stateRef.getAndSet(newState);
        if (oldState == null || Intrinsics.areEqual((Object)((Object)oldState.getStatus()), (Object)((Object)status)) ^ true) {
            if (Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ConnectionStatus.CONNECTION_FAILED))) {
                this.opened.setError(newState.getMessage());
            }
            for (Function1<? super ConnectionState, ? extends Unit> listener : this.connectionDispatcher) {
                listener.invoke((Object)newState);
            }
        }
    }

    protected static /* bridge */ /* synthetic */ void setState$default(VmConnection vmConnection, ConnectionStatus connectionStatus, String string, HyperlinkListener hyperlinkListener, int n) {
        if ((n & 2) != 0) {
            string = null;
        }
        if ((n & 4) != 0) {
            hyperlinkListener = null;
        }
        vmConnection.setState(connectionStatus, string, hyperlinkListener);
    }

    public final void stateChanged(@NotNull Function1<? super ConnectionState, ? extends Unit> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        this.connectionDispatcher.add(listener);
    }

    public final void addListener(@NotNull SocketConnectionListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.stateChanged((Function1<ConnectionState, Unit>)((Function1)new Function1<ConnectionState, Unit>(listener){
            final /* synthetic */ SocketConnectionListener $listener;

            public final void invoke(@NotNull ConnectionState it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$listener.statusChanged(it.getStatus());
            }
            {
                this.$listener = socketConnectionListener;
                super(1);
            }
        }));
    }

    @NotNull
    protected final DebugEventListener getDebugEventListener() {
        DebugEventListener debugEventListener = (DebugEventListener)this.dispatcher.getMulticaster();
        Intrinsics.checkExpressionValueIsNotNull((Object)debugEventListener, (String)"dispatcher.multicaster");
        return debugEventListener;
    }

    protected void startProcessing() {
        this.opened.setResult(null);
    }

    public final void close(@Nullable String message, @NotNull ConnectionStatus status) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
        if (!this.closed.compareAndSet(false, true)) {
            return;
        }
        if (PromiseKt.isPending((Promise)this.opened)) {
            this.opened.setError("closed");
        }
        VmConnection.setState$default(this, status, message, null, 4);
        Disposer.dispose((Disposable)this, (boolean)false);
    }

    public void dispose() {
        this.vm = null;
    }

    @NotNull
    public Promise<?> detachAndClose() {
        Promise<?> callback;
        T currentVm;
        if (PromiseKt.isPending((Promise)this.opened)) {
            this.opened.setError((Throwable)PromiseKt.createError("detached and closed", false));
        }
        if ((currentVm = this.vm) == null) {
            callback = PromiseKt.resolvedPromise();
        } else {
            this.vm = null;
            callback = currentVm.getAttachStateManager().detach();
        }
        this.close(null, ConnectionStatus.DISCONNECTED);
        return callback;
    }
}

