/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.Urls;
import java.io.File;
import java.util.List;
import kotlin.StringsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.SourceResolver;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={")\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\t\u0006\u0003!9Q\u0001A\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001\"\u0002\u000eD!\u0001Q\"\u0001M\u00013\u0019A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u00023\rA)!D\u0001\u0019\u0007e!\u0001rA\u0007\u0003\u0019\u0003AB!G\u0004\t\n5)\u0011BA\u0005\u00021\ta\t\u0001g\u0001\u001a\t\u0011\t\u0001\"B\u0007\u00021\r!61B\u0007 \t\r\u0003\u0002\u0002A\u0007\u00021\u0003Ib\u0001C\u0001\u000e\t%\u0011\u0011\"\u0001\r\u00031\u0007Ir\u0001#\u0003\u000e\u000b%\u0011\u0011\"\u0001\r\u0003\u0019\u0003A\u001a!G\u0005\t\r59\u0011BA\u0005\u00021\tI!!C\u0001\u0019\ta5Aka\u0003\u000e\"!9Q\"\u0001\r\u00033\rAy!D\u0001\u0019\u0005e\u0019\u0001rA\u0007\u00021\u0011I2\u0001C\u0003\u000e\u0003a\u0019Aka\u0003\u000e.!AQ\"\u0001\r\u00053\rAy!D\u0001\u0019\u0005e!\u0001rA\u0007\u0003\u0019\u0003AB!G\u0002\t\u00065\t\u0001dA\r\u0005\t\u0005AQ!D\u0001\u0019\u0007Q\u001bY!$\u000b\t\u00125\t\u0001\u0004B\r\u0004\u0011\u001fi\u0011\u0001\u0007\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rAQ!D\u0001\u0019\u0007e\u0019\u0001\"C\u0007\u00021\r!61\u0002"}, strings={"SourceResolver", "Lorg/jetbrains/debugger/sourcemap/SourceResolver;", "rawSources", "", "", "trimFileScheme", "", "baseUrl", "Lcom/intellij/util/Url;", "sourceContents", "baseUrlIsFile", "SourceResolverKt", "urlCanonicalizer", "Lkotlin/Function1;", "canonicalizePath", "url", "canonicalizeUrl", "doCanonicalize", "asLocalFileIfAbsoluteAndExists"}, moduleName="script-debugger-backend")
public final class SourceResolverKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SourceResolver SourceResolver(@NotNull List<? extends String> rawSources, @Nullable List<? extends String> sourceContents, @NotNull Function1<? super String, ? extends Url> urlCanonicalizer) {
        Object[] objectArray;
        void size;
        SourceResolver sourceResolver;
        Intrinsics.checkParameterIsNotNull(rawSources, (String)"rawSources");
        Intrinsics.checkParameterIsNotNull(urlCanonicalizer, (String)"urlCanonicalizer");
        int n = rawSources.size();
        List<? extends String> list = rawSources;
        SourceResolver sourceResolver2 = sourceResolver;
        SourceResolver sourceResolver3 = sourceResolver;
        Url[] result2 = new Url[size];
        boolean bl = false;
        void var7_9 = size - true;
        if (bl <= var7_9) {
            void i;
            do {
                void it;
                void var8_10 = ++i;
                void var15_12 = i;
                objectArray = result2;
                Url url = (Url)urlCanonicalizer.invoke((Object)rawSources.get((int)it));
                objectArray[var15_12] = url;
            } while (i != var7_9);
        }
        objectArray = result2;
        sourceResolver2(list, (Url[])objectArray, sourceContents);
        return sourceResolver3;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SourceResolver SourceResolver(@NotNull List<? extends String> rawSources, boolean trimFileScheme, @Nullable Url baseUrl, @Nullable List<? extends String> sourceContents, boolean baseUrlIsFile) {
        Object[] objectArray;
        void size;
        SourceResolver sourceResolver;
        Intrinsics.checkParameterIsNotNull(rawSources, (String)"rawSources");
        int n = rawSources.size();
        List<? extends String> list = rawSources;
        SourceResolver sourceResolver2 = sourceResolver;
        SourceResolver sourceResolver3 = sourceResolver;
        Url[] result2 = new Url[size];
        boolean bl = false;
        void var11_11 = size - true;
        if (bl <= var11_11) {
            void i;
            do {
                void it;
                void var12_12 = ++i;
                void var13_13 = i;
                objectArray = result2;
                String it2 = rawSources.get((int)it);
                Url url = SourceResolverKt.canonicalizeUrl(it2, baseUrl, trimFileScheme, baseUrlIsFile);
                objectArray[var13_13] = url;
            } while (i != var11_11);
        }
        objectArray = result2;
        sourceResolver2(list, (Url[])objectArray, sourceContents);
        return sourceResolver3;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ SourceResolver SourceResolver$default(List list, boolean bl, Url url, List list2, boolean bl2, int n) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return SourceResolverKt.SourceResolver(list, bl, url, list2, bl2);
    }

    @NotNull
    public static final String canonicalizePath(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        String path = url;
        if (url.charAt(0) != '/') {
            String basePath = baseUrl.getPath();
            if (baseUrlIsFile) {
                int lastSlashIndex = StringsKt.lastIndexOf$default((CharSequence)basePath, (char)'/', (int)0, (boolean)false, (int)6);
                StringBuilder pathBuilder = new StringBuilder();
                if (lastSlashIndex == -1) {
                    pathBuilder.append('/');
                } else {
                    pathBuilder.append(basePath, 0, lastSlashIndex + 1);
                }
                String string = pathBuilder.append(url).toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathBuilder.append(url).toString()");
                path = string;
            } else {
                path = basePath + "/" + url;
            }
        }
        String string = FileUtil.toCanonicalPath((String)path, (char)'/');
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"FileUtil.toCanonicalPath(path, '/')");
        return string;
    }

    @NotNull
    public static final Url canonicalizeUrl(@NotNull String url, @Nullable Url baseUrl, boolean trimFileScheme, boolean baseUrlIsFile) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (trimFileScheme && StringsKt.startsWith$default((String)url, (String)"file://", (boolean)false, (int)2)) {
            Url url2 = Urls.newLocalFileUrl(FileUtil.toCanonicalPath((String)StringsKt.substring((String)VfsUtilCore.toIdeaUrl((String)url, (boolean)true), (int)"file://".length()), (char)'/'));
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"Urls.newLocalFileUrl(Fil\u2026COL_PREFIX.length), '/'))");
            return url2;
        }
        if (baseUrl == null || StringsKt.contains$default((CharSequence)url, (CharSequence)"://", (boolean)false, (int)2) || StringsKt.startsWith$default((String)url, (String)"data:", (boolean)false, (int)2) || StringsKt.startsWith$default((String)url, (String)"blob:", (boolean)false, (int)2) || StringsKt.startsWith$default((String)url, (String)"javascript:", (boolean)false, (int)2)) {
            Url url3 = Urls.parseEncoded(url);
            if (url3 == null) {
                url3 = new UrlImpl(url);
            }
            return url3;
        }
        return SourceResolverKt.doCanonicalize(url, baseUrl, baseUrlIsFile, true);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ Url canonicalizeUrl$default(String string, Url url, boolean bl, boolean bl2, int n) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return SourceResolverKt.canonicalizeUrl(string, url, bl, bl2);
    }

    @NotNull
    public static final Url doCanonicalize(@NotNull String url, @NotNull Url baseUrl, boolean baseUrlIsFile, boolean asLocalFileIfAbsoluteAndExists) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        Intrinsics.checkParameterIsNotNull((Object)baseUrl, (String)"baseUrl");
        String path = SourceResolverKt.canonicalizePath(url, baseUrl, baseUrlIsFile);
        if (baseUrl.getScheme() == null && baseUrl.isInLocalFileSystem() || asLocalFileIfAbsoluteAndExists && SourceResolver.Companion.isAbsolute(path) && new File(path).exists()) {
            Url url2 = Urls.newLocalFileUrl(path);
            Intrinsics.checkExpressionValueIsNotNull((Object)url2, (String)"Urls.newLocalFileUrl(path)");
            return url2;
        }
        return new UrlImpl(baseUrl.getScheme(), baseUrl.getAuthority(), path, null);
    }
}

