/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.graph;

import org.gradle.api.Action;
import org.gradle.logging.StyledTextOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphRenderer {
    private final StyledTextOutput output;
    private StringBuilder prefix = new StringBuilder();
    private boolean seenRootChildren;
    private boolean lastChild = true;

    public GraphRenderer(StyledTextOutput output) {
        this.output = output;
    }

    public void visit(Action<? super StyledTextOutput> node, boolean lastChild) {
        if (this.seenRootChildren) {
            this.output.withStyle(StyledTextOutput.Style.Info).text(this.prefix + (lastChild ? "\\--- " : "+--- "));
        }
        this.lastChild = lastChild;
        node.execute((Object)this.output);
        this.output.println();
    }

    public void startChildren() {
        if (this.seenRootChildren) {
            this.prefix.append(this.lastChild ? "     " : "|    ");
        }
        this.seenRootChildren = true;
    }

    public void completeChildren() {
        if (this.prefix.length() == 0) {
            this.seenRootChildren = false;
        } else {
            this.prefix.setLength(this.prefix.length() - 5);
        }
    }

    public StyledTextOutput getOutput() {
        return this.output;
    }
}

