/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.build;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import kotlin.CollectionsKt;
import kotlin.PreconditionsKt;
import kotlin.Sequence;
import kotlin.SequencesKt;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionReference;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.JavaSourceRootDescriptor;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.java.dependencyView.Mappings;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.builders.storage.StorageProvider;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.BuilderCategory;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.ModuleBuildTarget;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.incremental.storage.BuildDataManager;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.JpsSimpleElement;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.compilerRunner.CompilerEnvironment;
import org.jetbrains.kotlin.compilerRunner.KotlinCompilerRunner;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollector;
import org.jetbrains.kotlin.compilerRunner.OutputItemsCollectorImpl;
import org.jetbrains.kotlin.compilerRunner.SimpleOutputItem;
import org.jetbrains.kotlin.config.CompilerSettings;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.jps.JpsKotlinCompilerSettings;
import org.jetbrains.kotlin.jps.build.GeneratedFile;
import org.jetbrains.kotlin.jps.build.GeneratedJvmClass;
import org.jetbrains.kotlin.jps.build.JpsJsModuleUtils;
import org.jetbrains.kotlin.jps.build.JpsUtils;
import org.jetbrains.kotlin.jps.build.KotlinBuilder;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt;
import org.jetbrains.kotlin.jps.build.KotlinBuilderKt$sam$FileFilter$23290363;
import org.jetbrains.kotlin.jps.build.KotlinBuilderModuleScriptGenerator;
import org.jetbrains.kotlin.jps.build.KotlinJpsCompilerArgumentsProvider;
import org.jetbrains.kotlin.jps.build.KotlinSourceFileCollector;
import org.jetbrains.kotlin.jps.build.TeamcityStatisticsLogger;
import org.jetbrains.kotlin.jps.incremental.ChangeInfo;
import org.jetbrains.kotlin.jps.incremental.CompilationResult;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImpl;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.IncrementalCompilationComponentsImpl;
import org.jetbrains.kotlin.jps.incremental.KotlinDataContainerTarget;
import org.jetbrains.kotlin.jps.incremental.LookupStorage;
import org.jetbrains.kotlin.jps.incremental.LookupStorageProvider;
import org.jetbrains.kotlin.jps.incremental.LookupSymbol;
import org.jetbrains.kotlin.jps.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.load.kotlin.ModuleMapping;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.progress.CompilationCanceledException;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.utils.LibraryUtils;
import org.jetbrains.kotlin.utils.PathUtil;
import org.jetbrains.org.objectweb.asm.ClassReader;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"O\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005A)#B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005A\u0019#B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t%\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u0003!\u0001R!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\t\u001f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0011\u0017)\u0001!B\u0001\r\u0003\u0015\tAQ\u0001\u0007\u0001!\u0015J\u0012\u0001'\u0001\u001e\u0003\u0015.\u0013UA)\u0004\u0003!\tQE\u0007\u0003\f\u0011\u000bi\u0011\u0001G\u0002\u001a\u0007!\u001dQ\"\u0001\r\u00053\rAI!D\u0001\u0019\u000beI\u00012B\u0007\b\u0013\tI\u0011\u0001'\u0004\n\u0005%\t\u0001d\u0002\r\u00073\rAy!D\u0001\u0019\u0011\u0015JAa\u0003E\t\u001b\u0005A\u0012\"\u0007\u0003\t\b5\u0011A\u0012\u0001\r\u0005K!!1\u0002c\u0005\u000e\u0003aI\u0011d\u0001E\u0004\u001b\u0005AB!\n\u0013\u0005\u0003!QQB\u0001G\u00011+I2\u0001#\u0003\u000e\u0003a)\u0011d\u0001\u0005\f\u001b\u0005A:\"G\u0002\t\u00195\t\u0001\u0014D\r\u000b\u00115i\u0001\"\u0003\u0002\n\u0003aq\u0011BA\u0005\u00021;a\t\u0001g\u0007\u001a\u0007!yQ\"\u0001M\u00103\rA\u0001#D\u0001\u0019\"\u0015\"D!\u0001\u0005\u0012\u001b\ta\t\u0001'\u0006\u001a\r!\rR\u0002B\u0005\u0003\u0013\u0005A*\u0003\u0007\n\u001a\u0007!%Q\"\u0001\r\u00063\rA1\"D\u0001\u0019\u0018e\u0019\u0001rA\u0007\u00021\u0011I\u0012\u0002c\u0003\u000e\u000f%\u0011\u0011\"\u0001M\u0007\u0013\tI\u0011\u0001G\u0004\u0019\re\u0019\u0001\u0002D\u0007\u000213I\u0012\u0002C\n\u000e\u000f%\u0011\u0011\"\u0001\r\b\u0013\tI\u0011\u0001'\n\u0019(e\u0019\u0001bD\u0007\u00021?)C\u0002B\u0001\t)5\t\u0001$C\r\u0004\u0011\u0013i\u0011\u0001G\u0003\u001a\u0007!\u0001R\"\u0001M\u0011KY!\u0011\u0001#\u000b\u000e\u0003ae\u0011$\u0003\u0005\u000e\u001b\u001dI!!C\u0001\u0019\u000f%\u0011\u0011\"\u0001M\u000f1UI2\u0001c\u000b\u000e\u0003a1\u0012d\u0001E\u0004\u001b\u0005AB!\n\u0010\u0005\u0003!5R\"\u0001\r\u00043\rAI!D\u0001\u0019\u000be\u0019\u0001rA\u0007\u00021\u0011I\u0012\u0002c\u0003\u000e\u000f%\u0011\u0011\"\u0001M\u0007\u0013\tI\u0011\u0001G\u0004\u0019\re\u0019\u0001bD\u0007\u00021?I2\u0001c\u0004\u000e\u0003aAQE1\u0001\u0005\u0003!9RB\u0001G\u00011+Ib\u0001c\t\u000e\t%\u0011\u0011\"\u0001M\u00131II2\u0001#\u0003\u000e\u0003a)\u0011d\u0001\u0005\f\u001b\u0005A:\"G\u0002\t\b5\t\u0001\u0004B\r\n\u0011\u0017iq!\u0003\u0002\n\u0003a5\u0011BA\u0005\u00021\u001dAb!G\u0002\t\u00195\t\u0001\u0014D\r\n\u0011Miq!\u0003\u0002\n\u0003a9\u0011BA\u0005\u00021KA:#G\u0005\t\u001b59\u0011BA\u0005\u00021\u001dI!!C\u0001\u00190a)\u0012d\u0001\u0005\u0010\u001b\u0005Az\"G\u0002\t!5\t\u0001\u0014E\u0013\b\t-A\u0001$\u0004\u0003\n\u0005%\t\u0001$\u0007M\u0019K=!\u0011\u0001c\r\u000e\t%\u0011\u0011\"\u0001M\u001b1iI2\u0001#\u0003\u000e\u0003a)\u0011d\u0001\u0005\u001c\u001b\u0005A*\"\n\u0003\u0005\u0017!]R\"\u0001\r\u001aK%\"\u0011\u0001\u0003\u000f\u000e\u0003aI\u0011d\u0001E\u0004\u001b\u0005AB!G\u0002\t\n5\t\u0001$B\r\u0007\u0011siA!\u0003\u0002\n\u0003a\u0015\u0002$H\r\u0007\u0011GiA!\u0003\u0002\n\u0003a\u0015\u0002DE\r\u0004\u0011wi\u0011\u0001\u0007\u0010\u001a\r!uR\u0002B\u0005\u0003\u0013\u0005Az\u0003\u0007\u000e\u001a\u0007!yR\"\u0001M K=!\u0011\u0001\u0003\u0011\u000e\u0003aI\u0011d\u0001E\b\u001b\u0005A\u0002\"\u0007\u0004\tB5!\u0011BA\u0005\u00021kA\"$J\u0016\u0005\u0003!\tS\"\u0001\r\n3\rAI!D\u0001\u0019\u000be\u0019\u00012I\u0007\u00021\tJ2\u0001c\u0002\u000e\u0003a!\u0011$\u0003E\u0006\u001b\u001dI!!C\u0001\u0019\u000e%\u0011\u0011\"\u0001\r\b1\u0019I\u0012\u0002C\n\u000e\u000f%\u0011\u0011\"\u0001\r\b\u0013\tI\u0011\u0001'\n\u0019(e1\u0001RI\u0007\u0005\u0013\tI\u0011\u0001G\u0012\u00195\u0015jB!\u0001E$\u001b\u0005Az$G\u0002\tD5\t\u0001DI\r\n\u00115iq!\u0003\u0002\n\u0003a9\u0011BA\u0005\u00021_AR#\u0007\u0004\tB5!\u0011BA\u0005\u00021kA\"$G\u0002\t\n5\t\u0001$B\u0013%\t\u0005AA%D\u0001\u0019\u0013e\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u000b\u000e\u0003a1\u0012d\u0001E\u001e\u001b\u0005Ab$G\u0005\t\f59\u0011BA\u0005\u00021\u001bI!!C\u0001\u0019\u000fa1\u0011$\u0003\u0005\u0014\u001b\u001dI!!C\u0001\u0019\u000f%\u0011\u0011\"\u0001M\u00131O)c\u0001B\u0001\tJ5\t\u0001DI\u000b\u00021KIs\u0001B!\t\u0011\u0007i\u0011\u0001\u0007\u0002R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder;", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder;", "()V", "statisticsLogger", "Lorg/jetbrains/kotlin/jps/build/TeamcityStatisticsLogger;", "build", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$ExitCode;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "chunk", "Lorg/jetbrains/jps/ModuleChunk;", "dirtyFilesHolder", "Lorg/jetbrains/jps/builders/DirtyFilesHolder;", "Lorg/jetbrains/jps/builders/java/JavaSourceRootDescriptor;", "Lorg/jetbrains/jps/incremental/ModuleBuildTarget;", "outputConsumer", "Lorg/jetbrains/jps/incremental/ModuleLevelBuilder$OutputConsumer;", "buildFinished", "", "buildStarted", "compileToJs", "Lorg/jetbrains/kotlin/compilerRunner/OutputItemsCollectorImpl;", "commonArguments", "Lorg/jetbrains/kotlin/cli/common/arguments/CommonCompilerArguments;", "environment", "Lorg/jetbrains/kotlin/compilerRunner/CompilerEnvironment;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/modules/TargetId;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "messageCollector", "Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$MessageCollectorAdapter;", "project", "Lorg/jetbrains/jps/model/JpsProject;", "compileToJvm", "allCompiledFiles", "", "Ljava/io/File;", "filesToCompile", "Lcom/intellij/util/containers/MultiMap;", "copyJsLibraryFilesIfNeeded", "createCompileEnvironment", "", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "doBuild", "doCompileModuleChunk", "Lorg/jetbrains/kotlin/jps/incremental/IncrementalCacheImpl;", "getCompilableFileExtensions", "Ljava/util/ArrayList;", "", "getGeneratedFiles", "", "Lorg/jetbrains/kotlin/jps/build/GeneratedFile;", "outputItemCollector", "getPresentableName", "processChanges", "compiledFiles", "", "dataManager", "Lorg/jetbrains/jps/incremental/storage/BuildDataManager;", "caches", "compilationResult", "Lorg/jetbrains/kotlin/jps/incremental/CompilationResult;", "registerOutputItems", "generatedFiles", "updateJavaMappings", "compilationErrors", "", "generatedClasses", "Lorg/jetbrains/kotlin/jps/build/GeneratedJvmClass;", "updateKotlinIncrementalCache", "updateLookupStorage", "isModuleMappingFile", "Companion", "MessageCollectorAdapter"}, moduleName="jps-plugin")
public final class KotlinBuilder
extends ModuleLevelBuilder {
    @NotNull
    public static final String KOTLIN_BUILDER_NAME = "Kotlin Builder";
    @NotNull
    public static final JpsElementChildRoleBase<JpsSimpleElement<? extends LookupTracker>> LOOKUP_TRACKER;
    public static final Logger LOG;
    private final TeamcityStatisticsLogger statisticsLogger = new TeamcityStatisticsLogger();
    public static final Companion Companion;

    static {
        Companion = org.jetbrains.kotlin.jps.build.KotlinBuilder$Companion.INSTANCE;
        KOTLIN_BUILDER_NAME = KOTLIN_BUILDER_NAME;
        JpsElementChildRoleBase jpsElementChildRoleBase = JpsElementChildRoleBase.create((String)"lookup tracker");
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsElementChildRoleBase, (String)"JpsElementChildRoleBase.create(\"lookup tracker\")");
        LOOKUP_TRACKER = jpsElementChildRoleBase;
        LOG = Logger.getInstance((String)"#org.jetbrains.kotlin.jps.build.KotlinBuilder");
    }

    @NotNull
    public String getPresentableName() {
        return Companion.getKOTLIN_BUILDER_NAME();
    }

    @NotNull
    public ArrayList<String> getCompilableFileExtensions() {
        return CollectionsKt.arrayListOf((Object[])new String[]{"kt"});
    }

    public void buildStarted(@NotNull CompileContext context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Companion.getLOG().debug("==========================================");
        Companion.getLOG().info("is Kotlin incremental compilation enabled: " + IncrementalCompilation.isEnabled());
        Companion.getLOG().info("is Kotlin experimental incremental compilation enabled: " + IncrementalCompilation.isExperimental());
        Companion.getLOG().info("is Kotlin compiler daemon enabled: " + DaemonParamsKt.isDaemonEnabled());
        String historyLabel = context.getBuilderParameter("history label");
        if (historyLabel != null) {
            Companion.getLOG().info("Label in local history: " + historyLabel);
        }
    }

    @NotNull
    public ModuleLevelBuilder.ExitCode build(@NotNull CompileContext context, @NotNull ModuleChunk chunk, @NotNull DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, @NotNull ModuleLevelBuilder.OutputConsumer outputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)chunk, (String)"chunk");
        Intrinsics.checkParameterIsNotNull(dirtyFilesHolder, (String)"dirtyFilesHolder");
        Intrinsics.checkParameterIsNotNull((Object)outputConsumer, (String)"outputConsumer");
        Companion.getLOG().debug("------------------------------------------");
        MessageCollectorAdapter messageCollector = new MessageCollectorAdapter(context);
        try {
            ModuleLevelBuilder.ExitCode result = this.doBuild(chunk, context, dirtyFilesHolder, messageCollector, outputConsumer);
            Companion.getLOG().debug("Build result: " + result);
            return result;
        }
        catch (StopBuildException e) {
            Companion.getLOG().debug("Caught exception: " + (Object)((Object)e));
            throw (Throwable)e;
        }
        catch (Throwable e) {
            Companion.getLOG().debug("Caught exception: " + e);
            String string = OutputMessageUtil.renderException(e);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"OutputMessageUtil.renderException(e)");
            messageCollector.report(CompilerMessageSeverity.EXCEPTION, string, CompilerMessageLocation.NO_LOCATION);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ModuleLevelBuilder.ExitCode doBuild(ModuleChunk chunk, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MessageCollectorAdapter messageCollector, ModuleLevelBuilder.OutputConsumer outputConsumer) {
        void destination;
        void $receiver;
        void $receiver2;
        Iterable destination2;
        Object element3;
        void $receiver3;
        void $receiver4;
        JpsProject project;
        boolean bl;
        ModuleBuildTarget it;
        Iterable $receiver5;
        BuildDataManager dataManager;
        ProjectDescriptor projectDescriptor;
        block14: {
            if (!((Boolean)JavaBuilder.IS_ENABLED.get((UserDataHolder)context, (Object)true)).booleanValue() && !JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
                messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin JPS plugin is disabled", CompilerMessageLocation.NO_LOCATION);
                return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
            }
            projectDescriptor = context.getProjectDescriptor();
            dataManager = projectDescriptor.dataManager;
            Iterable iterable = chunk.getTargets();
            for (Object element2 : $receiver5) {
                it = (ModuleBuildTarget)element2;
                BuildDataPaths buildDataPaths = dataManager.getDataPaths();
                BuildTarget buildTarget = (BuildTarget)it;
                Intrinsics.checkExpressionValueIsNotNull((Object)buildTarget, (String)"it");
                if (!IncrementalCacheImplKt.getKotlinCacheVersion(buildDataPaths, buildTarget).isIncompatible()) continue;
                bl = true;
                break block14;
            }
            bl = false;
        }
        if (bl) {
            Companion.getLOG().info("Clearing caches for " + CollectionsKt.joinToString$default((Iterable)chunk.getTargets(), null, null, null, (int)0, null, (Function1)doBuild.2.INSTANCE, (int)31));
            $receiver5 = chunk.getTargets();
            for (Object element2 : $receiver5) {
                ModuleBuildTarget moduleBuildTarget = it = (ModuleBuildTarget)element2;
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"it");
                IncrementalCacheImplKt.getKotlinCache(dataManager, moduleBuildTarget).clean();
            }
            return ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
        }
        if (!dirtyFilesHolder.hasDirtyFiles() && !dirtyFilesHolder.hasRemovedFiles() || !KotlinBuilderKt.access$hasKotlinDirtyOrRemovedFiles(dirtyFilesHolder, chunk)) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        messageCollector.report(CompilerMessageSeverity.INFO, "Kotlin JPS plugin version " + "1.0.0-beta-3595-IJ143-32", CompilerMessageLocation.NO_LOCATION);
        JpsProject jpsProject = project = projectDescriptor.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject, (String)"project");
        LookupTracker lookupTracker = KotlinBuilderKt.access$getLookupTracker(jpsProject);
        Map incrementalCaches = KotlinBuilderKt.access$getIncrementalCaches(chunk, context);
        CompilerEnvironment environment = this.createCompileEnvironment(incrementalCaches, lookupTracker, context);
        if (!environment.success()) {
            environment.reportErrorsTo(messageCollector);
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        CommonCompilerArguments commonArguments = JpsKotlinCompilerSettings.getCommonCompilerArguments(project);
        commonArguments.verbose = true;
        Set allCompiledFiles = KotlinBuilderKt.access$getAllCompiledFilesContainer(context);
        MultiMap<ModuleBuildTarget, File> filesToCompile = KotlinSourceFileCollector.getDirtySourceFiles(dirtyFilesHolder);
        Companion.getLOG().debug("Compiling files: " + filesToCompile.values());
        long start = System.nanoTime();
        CommonCompilerArguments commonCompilerArguments = commonArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)commonCompilerArguments, (String)"commonArguments");
        MultiMap<ModuleBuildTarget, File> multiMap = filesToCompile;
        Intrinsics.checkExpressionValueIsNotNull(multiMap, (String)"filesToCompile");
        JpsProject jpsProject2 = project;
        Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject2, (String)"project");
        OutputItemsCollectorImpl outputItemCollector = this.doCompileModuleChunk(allCompiledFiles, chunk, commonCompilerArguments, context, dirtyFilesHolder, environment, multiMap, incrementalCaches, messageCollector, jpsProject2);
        this.statisticsLogger.registerStatistic(chunk, System.nanoTime() - start);
        if (outputItemCollector == null) {
            return ModuleLevelBuilder.ExitCode.NOTHING_DONE;
        }
        Boolean compilationErrors = (Boolean)Utils.ERRORS_DETECTED_KEY.get((UserDataHolder)context, (Object)false);
        if (compilationErrors.booleanValue()) {
            Companion.getLOG().info("Compiled with errors");
            return ModuleLevelBuilder.ExitCode.ABORT;
        }
        Companion.getLOG().info("Compiled successfully");
        List<GeneratedFile> generatedFiles = this.getGeneratedFiles(chunk, outputItemCollector);
        this.registerOutputItems(outputConsumer, generatedFiles);
        if (JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            JpsProject jpsProject3 = project;
            Intrinsics.checkExpressionValueIsNotNull((Object)jpsProject3, (String)"project");
            this.copyJsLibraryFilesIfNeeded(chunk, jpsProject3);
            return ModuleLevelBuilder.ExitCode.OK;
        }
        if (!IncrementalCompilation.isEnabled()) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        context.checkCanceled();
        Iterable iterable = generatedFiles;
        void var22_20 = $receiver4;
        Collection collection = new ArrayList();
        for (Object element3 : $receiver3) {
            if (!(element3 instanceof GeneratedJvmClass)) continue;
            destination2.add(element3);
        }
        List generatedClasses = (List)destination2;
        CompilationResult changesInfo = this.updateKotlinIncrementalCache(compilationErrors, incrementalCaches, generatedFiles, chunk);
        boolean bl2 = compilationErrors;
        MultiMap<ModuleBuildTarget, File> multiMap2 = filesToCompile;
        Intrinsics.checkExpressionValueIsNotNull(multiMap2, (String)"filesToCompile");
        this.updateJavaMappings(chunk, bl2, context, dirtyFilesHolder, multiMap2, generatedClasses);
        BuildDataManager buildDataManager = dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager, (String)"dataManager");
        MultiMap<ModuleBuildTarget, File> multiMap3 = filesToCompile;
        Intrinsics.checkExpressionValueIsNotNull(multiMap3, (String)"filesToCompile");
        this.updateLookupStorage(chunk, lookupTracker, buildDataManager, dirtyFilesHolder, multiMap3);
        if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context)) {
            return ModuleLevelBuilder.ExitCode.OK;
        }
        destination2 = filesToCompile.keySet();
        Iterator iterator2 = $receiver2;
        element3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
        for (Object item : $receiver) {
            void it2;
            ModuleBuildTarget moduleBuildTarget = (ModuleBuildTarget)item;
            void var32_28 = destination;
            Object v = incrementalCaches.get(it2);
            if (v == null) {
                Intrinsics.throwNpe();
            }
            IncrementalCacheImpl incrementalCacheImpl = (IncrementalCacheImpl)v;
            var32_28.add(incrementalCacheImpl);
        }
        List caches2 = (List)destination;
        Collection collection2 = filesToCompile.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection2, (String)"filesToCompile.values()");
        BuildDataManager buildDataManager2 = dataManager;
        Intrinsics.checkExpressionValueIsNotNull((Object)buildDataManager2, (String)"dataManager");
        this.processChanges(context, chunk, collection2, allCompiledFiles, buildDataManager2, caches2, changesInfo);
        return ModuleLevelBuilder.ExitCode.ADDITIONAL_PASS_REQUIRED;
    }

    private final void processChanges(CompileContext context, ModuleChunk chunk, Collection<? extends File> compiledFiles, Set<File> allCompiledFiles, BuildDataManager dataManager, List<? extends IncrementalCacheImpl> caches2, CompilationResult compilationResult) {
        Function0<Unit> recompileInlined$ = new Function0<Unit>(caches2, context){
            final /* synthetic */ List $caches;
            final /* synthetic */ CompileContext $context;

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                for (IncrementalCacheImpl cache : this.$caches) {
                    void $receiver;
                    Collection<File> filesToReinline = cache.getFilesToReinline();
                    Iterable iterable = filesToReinline;
                    for (T element : $receiver) {
                        File it = (File)element;
                        FSOperations.markDirty((CompileContext)this.$context, (CompilationRound)CompilationRound.NEXT, (File)it);
                    }
                }
            }
            {
                this.$caches = list;
                this.$context = compileContext;
                super(0);
            }
        };
        Function1<CompilationResult, Unit> doProcessChanges$ = new Function1<CompilationResult, Unit>(allCompiledFiles, context, chunk, recompileInlined$){
            final /* synthetic */ Set $allCompiledFiles;
            final /* synthetic */ CompileContext $context;
            final /* synthetic */ ModuleChunk $chunk;
            final /* synthetic */ processChanges.1 $recompileInlined;

            public final void invoke(CompilationResult $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                processChanges.1 isKotlin$ = processChanges.1.INSTANCE;
                Function1<File, Boolean> isNotCompiled$ = new Function1<File, Boolean>(this){
                    final /* synthetic */ processChanges.2 this$0;

                    public final boolean invoke(@NotNull File file) {
                        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
                        return this.this$0.$allCompiledFiles.contains(file) ^ true;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                };
                KotlinBuilder.Companion.getLOG().debug("compilationResult = " + $receiver);
                if ($receiver.getInlineAdded()) {
                    this.$allCompiledFiles.clear();
                    Function1 function1 = (Function1)Reflection.function((FunctionReference)processChanges.3.INSTANCE);
                    FSOperations.markDirtyRecursively((CompileContext)this.$context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.$chunk, (FileFilter)((FileFilter)(function1 == null ? null : new KotlinBuilderKt$sam$FileFilter$23290363(function1))));
                    return;
                }
                if ($receiver.getConstantsChanged()) {
                    Function1 function1 = (Function1)Reflection.function((FunctionReference)new Function1<File, Boolean>(isNotCompiled$){
                        final /* synthetic */ processChanges.2 $isNotCompiled;

                        public final boolean invoke(@NotNull File p1) {
                            Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                            return this.$isNotCompiled.invoke(p1);
                        }

                        public final KDeclarationContainer getOwner() {
                            return null;
                        }

                        public final String getName() {
                            return "isNotCompiled";
                        }

                        public final String getSignature() {
                            return "invoke(Ljava/io/File;)Z";
                        }
                        {
                            this.$isNotCompiled = var1_1;
                            super(1);
                        }
                    });
                    FSOperations.markDirtyRecursively((CompileContext)this.$context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.$chunk, (FileFilter)((FileFilter)(function1 == null ? null : new KotlinBuilderKt$sam$FileFilter$23290363(function1))));
                    return;
                }
                if ($receiver.getProtoChanged()) {
                    FSOperations.markDirty((CompileContext)this.$context, (CompilationRound)CompilationRound.NEXT, (ModuleChunk)this.$chunk, (FileFilter)new FileFilter(isNotCompiled$){
                        final /* synthetic */ processChanges.2 $isNotCompiled;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean accept(File it) {
                            File file = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                            if (!processChanges.1.INSTANCE.invoke(file)) return false;
                            File file2 = it;
                            Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                            if (!this.$isNotCompiled.invoke(file2)) return false;
                            return true;
                        }
                        {
                            this.$isNotCompiled = var1_1;
                        }
                    });
                }
                if ($receiver.getInlineChanged()) {
                    this.$recompileInlined.invoke();
                }
            }
            {
                this.$allCompiledFiles = set;
                this.$context = compileContext;
                this.$chunk = moduleChunk;
                this.$recompileInlined = var4_4;
                super(1);
            }
        };
        Function1<CompilationResult, Unit> doProcessChangesUsingLookups$ = new Function1<CompilationResult, Unit>(dataManager, compiledFiles, context, caches2){
            final /* synthetic */ BuildDataManager $dataManager;
            final /* synthetic */ Collection $compiledFiles;
            final /* synthetic */ CompileContext $context;
            final /* synthetic */ List $caches;

            /*
             * WARNING - void declaration
             */
            public final void invoke(CompilationResult $receiver) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                LookupStorage lookupStorage = (LookupStorage)this.$dataManager.getStorage((BuildTarget)KotlinDataContainerTarget.INSTANCE, (StorageProvider)LookupStorageProvider.INSTANCE);
                KotlinBuilder.Companion.getLOG().debug("Start processing changes");
                for (ChangeInfo change : $receiver.getChanges()) {
                    void destination;
                    Iterator<T> $receiver2;
                    Iterable $receiver3;
                    KotlinBuilder.Companion.getLOG().debug("Process " + change);
                    if (!(change instanceof ChangeInfo.MembersChanged)) continue;
                    Iterable iterable = ((ChangeInfo.MembersChanged)change).getNames();
                    void var7_7 = $receiver3;
                    Collection collection = new ArrayList<E>();
                    Iterator<T> iterator2 = $receiver2.iterator();
                    while (iterator2.hasNext()) {
                        T element = iterator2.next();
                        String it = (String)element;
                        String string = ((ChangeInfo.MembersChanged)change).getFqName().asString();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"change.fqName.asString()");
                        Iterable list = lookupStorage.get(new LookupSymbol(it, string));
                        CollectionsKt.addAll((Collection)destination, (Iterable)list);
                    }
                    List files2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)((List)destination)), (Function1)processChanges.files.2.INSTANCE), (Function1)((Function1)new Function1<File, Boolean>(this){
                        final /* synthetic */ processChanges.3 this$0;

                        public final boolean invoke(@NotNull File it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return this.this$0.$compiledFiles.contains(it) ^ true && it.exists();
                        }
                        {
                            this.this$0 = var1_1;
                            super(1);
                        }
                    })));
                    KotlinBuilder.Companion.getLOG().debug("Mark dirty files: " + files2);
                    $receiver3 = files2;
                    $receiver2 = $receiver3.iterator();
                    while ($receiver2.hasNext()) {
                        T element = $receiver2.next();
                        File it = (File)element;
                        FSOperations.markDirty((CompileContext)this.$context, (CompilationRound)CompilationRound.NEXT, (File)it);
                    }
                }
                KotlinBuilder.Companion.getLOG().debug("End of processing changes");
                Iterable $receiver4 = this.$caches;
                for (T element : $receiver4) {
                    IncrementalCacheImpl it = (IncrementalCacheImpl)element;
                    it.cleanDirtyInlineFunctions();
                }
            }
            {
                this.$dataManager = buildDataManager;
                this.$compiledFiles = collection;
                this.$context = compileContext;
                this.$caches = list;
                super(1);
            }
        };
        if (IncrementalCompilation.isExperimental()) {
            doProcessChangesUsingLookups$.invoke(compilationResult);
        } else {
            doProcessChanges$.invoke(compilationResult);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl doCompileModuleChunk(Set<File> allCompiledFiles, ModuleChunk chunk, CommonCompilerArguments commonArguments, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, CompilerEnvironment environment, MultiMap<ModuleBuildTarget, File> filesToCompile, Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> incrementalCaches, MessageCollectorAdapter messageCollector, JpsProject project) {
        if (JpsUtils.isJsKotlinModule(chunk.representativeTarget())) {
            void $receiver;
            Collection collection = filesToCompile.values();
            StringBuilder stringBuilder = new StringBuilder().append("Compiling to JS ");
            Logger logger = Companion.getLOG();
            int n = $receiver.size();
            logger.debug(stringBuilder.append(n).append(" files in ").append(CollectionsKt.joinToString$default((Iterable)filesToCompile.keySet(), null, null, null, (int)0, null, (Function1)doCompileModuleChunk.1.INSTANCE, (int)31)).toString());
            return this.compileToJs(chunk, commonArguments, environment, null, messageCollector, project);
        }
        if (IncrementalCompilation.isEnabled()) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                IncrementalCacheImpl cache;
                List list;
                void destination;
                void $receiver;
                void $receiver2;
                if (incrementalCaches.get(target) == null) {
                    Intrinsics.throwNpe();
                }
                Iterable iterable = dirtyFilesHolder.getRemovedFiles((BuildTarget)target);
                Collection collection = filesToCompile.get((Object)target);
                void var16_23 = $receiver2;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
                for (Object item : $receiver) {
                    void it;
                    String string = (String)item;
                    list = destination;
                    File file = new File((String)it);
                    list.add(file);
                }
                list = (List)destination;
                List removedAndDirtyFiles = CollectionsKt.plus((Collection)collection, (Iterable)list);
                cache.markOutputClassesDirty(removedAndDirtyFiles);
            }
        }
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        doCompileModuleChunk.2 concatenate$ = doCompileModuleChunk.2.INSTANCE;
        for (KotlinJpsCompilerArgumentsProvider argumentProvider : ServiceLoader.load(KotlinJpsCompilerArgumentsProvider.class)) {
            String[] stringArray = commonArguments.pluginOptions;
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            commonArguments.pluginOptions = concatenate$.invoke(stringArray, argumentProvider.getExtraArguments(moduleBuildTarget, context));
            String[] stringArray2 = commonArguments.pluginClasspaths;
            ModuleBuildTarget moduleBuildTarget2 = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget2, (String)"representativeTarget");
            commonArguments.pluginClasspaths = concatenate$.invoke(stringArray2, argumentProvider.getClasspath(moduleBuildTarget2, context));
            messageCollector.report(CompilerMessageSeverity.INFO, "Plugin loaded: " + argumentProvider.getClass().getSimpleName(), CompilerMessageLocation.NO_LOCATION);
        }
        return this.compileToJvm(allCompiledFiles, chunk, commonArguments, context, dirtyFilesHolder, environment, filesToCompile, messageCollector);
    }

    private final CompilerEnvironment createCompileEnvironment(Map<ModuleBuildTarget, ? extends IncrementalCache> incrementalCaches, LookupTracker lookupTracker, CompileContext context) {
        Services compilerServices2 = new Services.Builder().register(IncrementalCompilationComponents.class, new IncrementalCompilationComponentsImpl(incrementalCaches, lookupTracker)).register(CompilationCanceledStatus.class, new CompilationCanceledStatus(context){
            final /* synthetic */ CompileContext $context;

            public void checkCanceled() {
                if (this.$context.getCancelStatus().isCanceled()) {
                    throw (Throwable)((Object)new CompilationCanceledException());
                }
            }
            {
                this.$context = $captured_local_variable$0;
            }
        }).build();
        CompilerEnvironment compilerEnvironment = CompilerEnvironment.getEnvironmentFor(PathUtil.getKotlinPathsForJpsPluginOrJpsTests(), createCompileEnvironment.1.INSTANCE, compilerServices2);
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerEnvironment, (String)"CompilerEnvironment.getE\u2026ompilerServices\n        )");
        return compilerEnvironment;
    }

    /*
     * WARNING - void declaration
     */
    private final List<GeneratedFile> getGeneratedFiles(ModuleChunk chunk, OutputItemsCollectorImpl outputItemCollector) {
        void $receiver;
        HashMap<File, ModuleBuildTarget> sourceToTarget = new HashMap<File, ModuleBuildTarget>();
        Collection collection = chunk.getTargets();
        if ($receiver.size() > 1) {
            for (ModuleBuildTarget target : chunk.getTargets()) {
                for (File file : KotlinSourceFileCollector.getAllKotlinSourceFiles(target)) {
                    sourceToTarget.put(file, target);
                }
            }
        }
        ArrayList<GeneratedFile> result = new ArrayList<GeneratedFile>();
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        for (SimpleOutputItem outputItem : outputItemCollector.getOutputs()) {
            File target;
            File file;
            File file2;
            File outputFile;
            Collection<File> sourceFiles;
            block13: {
                void destination;
                void $receiver2;
                Object it;
                Iterable $receiver3;
                block12: {
                    sourceFiles = outputItem.getSourceFiles();
                    outputFile = outputItem.getOutputFile();
                    file2 = (File)CollectionsKt.firstOrNull((Iterable)sourceFiles);
                    if (file2 == null) break block12;
                    File file3 = file2;
                    it = (File)((Object)$receiver3);
                    file2 = (ModuleBuildTarget)sourceToTarget.get(it);
                    if (file2 != null) break block13;
                }
                $receiver3 = chunk.getTargets();
                it = $receiver3;
                Collection $i$a$1 = new ArrayList();
                for (Object element : $receiver2) {
                    boolean bl;
                    ModuleBuildTarget it2 = (ModuleBuildTarget)element;
                    if (it2.getOutputDir() != null) {
                        void $receiver4;
                        File it3;
                        File file4 = it3 = (File)$receiver4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it");
                        bl = FilesKt.startsWith((File)outputFile, (File)file4);
                    } else {
                        bl = false;
                    }
                    if (!bl) continue;
                    destination.add(element);
                }
                file2 = file = (ModuleBuildTarget)CollectionsKt.singleOrNull((List)((List)destination));
            }
            if (file2 == null) {
                file = target = representativeTarget;
            }
            if (StringsKt.endsWith$default((String)outputFile.getName(), (String)".class", (boolean)false, (int)2)) {
                File file5 = target;
                Intrinsics.checkExpressionValueIsNotNull((Object)file5, (String)"target");
                Collection<File> collection2 = sourceFiles;
                Intrinsics.checkExpressionValueIsNotNull(collection2, (String)"sourceFiles");
                File file6 = outputFile;
                Intrinsics.checkExpressionValueIsNotNull((Object)file6, (String)"outputFile");
                result.add(new GeneratedJvmClass((ModuleBuildTarget)file5, collection2, file6));
                continue;
            }
            File file7 = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)file7, (String)"target");
            Collection<File> collection3 = sourceFiles;
            Intrinsics.checkExpressionValueIsNotNull(collection3, (String)"sourceFiles");
            File file8 = outputFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)file8, (String)"outputFile");
            result.add(new GeneratedFile((ModuleBuildTarget)file7, collection3, file8));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateJavaMappings(ModuleChunk chunk, boolean compilationErrors, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MultiMap<ModuleBuildTarget, File> filesToCompile, List<? extends GeneratedJvmClass> generatedClasses) {
        Collection collection;
        Unit unit;
        boolean bl = IncrementalCompilation.isEnabled();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value;
            if (value == false) {
                String message = "updateJavaMappings should not be called when incremental compilation disabled";
                throw (Throwable)((Object)new AssertionError((Object)message));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Mappings previousMappings = context.getProjectDescriptor().dataManager.getMappings();
        Mappings delta = previousMappings.createDelta();
        Callbacks.Backend callback = delta.getCallback();
        for (GeneratedJvmClass generatedJvmClass : generatedClasses) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = generatedJvmClass.getSourceFiles();
            String string = FileUtil.toSystemIndependentName((String)generatedJvmClass.getOutputFile().getAbsolutePath());
            Callbacks.Backend backend = callback;
            void var13_16 = $receiver2;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                File file = (File)item;
                list = destination;
                String string2 = FileUtil.toSystemIndependentName((String)it.getAbsolutePath());
                list.add(string2);
            }
            list = (List)destination;
            backend.associate(string, (Collection)list, new ClassReader(generatedJvmClass.getOutputClass().getFileContents()));
        }
        Collection collection3 = filesToCompile.values();
        if (compilationErrors) {
            collection = CollectionsKt.listOf();
        } else {
            Collection collection4 = collection3;
            collection = collection4;
            Intrinsics.checkExpressionValueIsNotNull((Object)collection4, (String)"allCompiled");
        }
        Collection compiledInThisRound = collection;
        JavaBuilderUtil.updateMappings((CompileContext)context, (Mappings)delta, dirtyFilesHolder, (ModuleChunk)chunk, (Collection)collection3, (Collection)compiledInThisRound);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerOutputItems(ModuleLevelBuilder.OutputConsumer outputConsumer, List<? extends GeneratedFile> generatedFiles) {
        for (GeneratedFile generatedFile : generatedFiles) {
            List list;
            void destination;
            void $receiver;
            void $receiver2;
            Iterable iterable = generatedFile.getSourceFiles();
            File file = generatedFile.getOutputFile();
            BuildTarget buildTarget = (BuildTarget)generatedFile.getTarget();
            ModuleLevelBuilder.OutputConsumer outputConsumer2 = outputConsumer;
            void var6_6 = $receiver2;
            Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver) {
                void it;
                File file2 = (File)item;
                list = destination;
                String string = it.getPath();
                list.add(string);
            }
            list = (List)destination;
            outputConsumer2.registerOutputFile(buildTarget, file, (Collection)list);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final CompilationResult updateKotlinIncrementalCache(boolean compilationErrors, Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> incrementalCaches, List<? extends GeneratedFile> generatedFiles, ModuleChunk chunk) {
        void changesInfo;
        Ref.ObjectRef $receiver;
        Unit unit;
        boolean bl = IncrementalCompilation.isEnabled();
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            void value;
            if (value == false) {
                String string = "updateKotlinIncrementalCache should not be called when incremental compilation disabled";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        Iterable value = chunk.getTargets();
        for (Object element : $receiver) {
            ModuleBuildTarget it = (ModuleBuildTarget)element;
            IncrementalCacheImpl incrementalCacheImpl = incrementalCaches.get(it);
            if (incrementalCacheImpl == null) {
                Intrinsics.throwNpe();
            }
            incrementalCacheImpl.saveCacheFormatVersion();
        }
        $receiver = new Ref.ObjectRef();
        $receiver.element = CompilationResult.Companion.getNO_CHANGES();
        for (GeneratedFile generatedFile : generatedFiles) {
            CompilationResult compilationResult;
            IncrementalCacheImpl ic;
            if (incrementalCaches.get(generatedFile.getTarget()) == null) {
                Intrinsics.throwNpe();
            }
            if (generatedFile instanceof GeneratedJvmClass) {
                compilationResult = ic.saveFileToCache((GeneratedJvmClass)generatedFile);
            } else {
                if (!this.isModuleMappingFile(generatedFile.getOutputFile())) continue;
                compilationResult = ic.saveModuleMappingToCache(generatedFile.getSourceFiles(), generatedFile.getOutputFile());
            }
            CompilationResult newChangesInfo = compilationResult;
            changesInfo.element = ((CompilationResult)changesInfo.element).plus(newChangesInfo);
        }
        if (!compilationErrors) {
            Map<ModuleBuildTarget, ? extends IncrementalCacheImpl> map = incrementalCaches;
            Iterable iterable = map.values();
            for (Object element : iterable) {
                IncrementalCacheImpl it = (IncrementalCacheImpl)element;
                CompilationResult newChangesInfo = it.clearCacheForRemovedClasses();
                changesInfo.element = ((CompilationResult)changesInfo.element).plus(newChangesInfo);
            }
        }
        return (CompilationResult)changesInfo.element;
    }

    /*
     * WARNING - void declaration
     */
    private final void updateLookupStorage(ModuleChunk chunk, LookupTracker lookupTracker, BuildDataManager dataManager, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, MultiMap<ModuleBuildTarget, File> filesToCompile) {
        Object it;
        void destination;
        void $receiver;
        Iterable $receiver2;
        Object it2;
        Object element2;
        void $receiver3;
        if (!IncrementalCompilation.isExperimental()) {
            return;
        }
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw (Throwable)((Object)new AssertionError((Object)("Lookup tracker is expected to be LookupTrackerImpl, got " + lookupTracker.getClass())));
        }
        LookupStorage lookupStorage = (LookupStorage)dataManager.getStorage((BuildTarget)KotlinDataContainerTarget.INSTANCE, (StorageProvider)LookupStorageProvider.INSTANCE);
        Iterable iterable = filesToCompile.values();
        for (Object element2 : $receiver3) {
            it2 = (File)element2;
            File file = it2;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            lookupStorage.removeLookupsFrom(file);
        }
        Iterable iterable2 = chunk.getTargets();
        element2 = $receiver2;
        it2 = new ArrayList();
        for (Object element3 : $receiver) {
            ModuleBuildTarget it3 = (ModuleBuildTarget)element3;
            Iterable list = KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, it3);
            CollectionsKt.addAll((Collection)destination, (Iterable)list);
        }
        List removedFiles = (List)destination;
        $receiver2 = removedFiles;
        for (Object element4 : $receiver2) {
            it = (File)element4;
            File file = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
            lookupStorage.removeLookupsFrom(file);
        }
        $receiver2 = ((LookupTrackerImpl)lookupTracker).getLookups().entrySet();
        for (Object element4 : $receiver2) {
            it = (Map.Entry)element4;
            LookupSymbol lookupSymbol = (LookupSymbol)it.getKey();
            Intrinsics.checkExpressionValueIsNotNull((Object)lookupSymbol, (String)"it.key");
            Collection collection = (Collection)it.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"it.value");
            lookupStorage.add(lookupSymbol, collection);
        }
    }

    private final boolean isModuleMappingFile(File $receiver) {
        return Intrinsics.areEqual((Object)FilesKt.getExtension((File)$receiver), (Object)ModuleMapping.Companion.getMAPPING_FILE_EXT()) && Intrinsics.areEqual((Object)$receiver.getParentFile().getName(), (Object)"META-INF");
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl compileToJs(ModuleChunk chunk, CommonCompilerArguments commonArguments, CompilerEnvironment environment, Map<TargetId, IncrementalCache> incrementalCaches, MessageCollectorAdapter messageCollector, JpsProject project) {
        K2JSCompilerArguments k2JsArguments;
        Iterable $receiver;
        OutputItemsCollectorImpl outputItemCollector = new OutputItemsCollectorImpl();
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        Collection collection = chunk.getModules();
        if ($receiver.size() > 1) {
            List list;
            void destination;
            void $receiver2;
            $receiver = chunk.getModules();
            StringBuilder stringBuilder = new StringBuilder().append("Circular dependencies are not supported. The following JS modules depend on each other: ");
            CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.WARNING;
            MessageCollectorAdapter messageCollectorAdapter = messageCollector;
            Iterable $i$f$size = $receiver;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver, (int)10));
            for (Object item : $receiver2) {
                void it;
                JpsModule jpsModule = (JpsModule)item;
                list = destination;
                String string = it.getName();
                list.add(string);
            }
            list = (List)destination;
            messageCollectorAdapter.report(compilerMessageSeverity, stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62)).append(". ").append("Kotlin is not compiled for these modules").toString(), CompilerMessageLocation.NO_LOCATION);
            return null;
        }
        List<File> sourceFiles = KotlinSourceFileCollector.getAllKotlinSourceFiles(representativeTarget);
        if (sourceFiles.isEmpty()) {
            return null;
        }
        File outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(representativeTarget);
        String moduleName = representativeTarget.getModule().getName();
        File file = outputDir;
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDir");
        String string = moduleName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"moduleName");
        File outputFile = JpsJsModuleUtils.getOutputFile(file, string);
        ModuleBuildTarget moduleBuildTarget = representativeTarget;
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
        List<String> libraryFiles = JpsJsModuleUtils.INSTANCE.getLibraryFilesAndDependencies(moduleBuildTarget);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        K2JSCompilerArguments k2JSCompilerArguments = k2JsArguments = JpsKotlinCompilerSettings.getK2JsCompilerArguments(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)k2JSCompilerArguments, (String)"k2JsArguments");
        CompilerSettings compilerSettings2 = compilerSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerSettings2, (String)"compilerSettings");
        MessageCollector messageCollector2 = messageCollector;
        OutputItemsCollector outputItemsCollector = outputItemCollector;
        Collection collection3 = sourceFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"sourceFiles");
        KotlinCompilerRunner.INSTANCE.runK2JsCompiler(commonArguments, k2JSCompilerArguments, compilerSettings2, messageCollector2, environment, outputItemsCollector, collection3, libraryFiles, outputFile);
        return outputItemCollector;
    }

    private final void copyJsLibraryFilesIfNeeded(ModuleChunk chunk, JpsProject project) {
        ModuleBuildTarget representativeTarget = chunk.representativeTarget();
        File outputDir = KotlinBuilderModuleScriptGenerator.getOutputDirSafe(representativeTarget);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        if (compilerSettings.getCopyJsLibraryFiles()) {
            String outputLibraryRuntimeDirectory = new File(outputDir, compilerSettings.getOutputDirectoryForJsLibraryFiles()).getAbsolutePath();
            ArrayList libraryFilesToCopy = CollectionsKt.arrayListOf((Object[])new String[0]);
            ModuleBuildTarget moduleBuildTarget = representativeTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"representativeTarget");
            JpsJsModuleUtils.INSTANCE.getLibraryFiles(moduleBuildTarget, libraryFilesToCopy);
            List list = libraryFilesToCopy;
            String string = outputLibraryRuntimeDirectory;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"outputLibraryRuntimeDirectory");
            LibraryUtils.copyJsFilesFromLibraries(list, string);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final OutputItemsCollectorImpl compileToJvm(Set<File> allCompiledFiles, ModuleChunk chunk, CommonCompilerArguments commonArguments, CompileContext context, DirtyFilesHolder<JavaSourceRootDescriptor, ModuleBuildTarget> dirtyFilesHolder, CompilerEnvironment environment, MultiMap<ModuleBuildTarget, File> filesToCompile, MessageCollectorAdapter messageCollector) {
        void $receiver;
        Collection it;
        MessageCollectorAdapter messageCollectorAdapter;
        Object object;
        StringBuilder stringBuilder;
        Iterable $receiver2;
        OutputItemsCollectorImpl outputItemCollector = new OutputItemsCollectorImpl();
        Collection collection = chunk.getModules();
        if ($receiver2.size() > 1) {
            List list;
            void destination;
            void $receiver3;
            $receiver2 = chunk.getModules();
            stringBuilder = new StringBuilder().append("Circular dependencies are only partially supported. The following modules depend on each other: ");
            object = CompilerMessageSeverity.WARNING;
            messageCollectorAdapter = messageCollector;
            Iterable $i$f$size = $receiver2;
            Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver2, (int)10));
            for (Object item : $receiver3) {
                JpsModule jpsModule = (JpsModule)item;
                list = destination;
                String string = it.getName();
                list.add(string);
            }
            list = (List)destination;
            messageCollectorAdapter.report((CompilerMessageSeverity)((Object)object), stringBuilder.append(CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, null, (int)62)).append(". ").append("Kotlin will compile them, but some strange effect may happen").toString(), CompilerMessageLocation.NO_LOCATION);
        }
        Collection collection3 = filesToCompile.values();
        Intrinsics.checkExpressionValueIsNotNull((Object)collection3, (String)"filesToCompile.values()");
        allCompiledFiles.addAll(collection3);
        Set processedTargetsWithRemoved = KotlinBuilderKt.access$getProcessedTargetsWithRemovedFilesContainer(context);
        int totalRemovedFiles = 0;
        for (ModuleBuildTarget target : chunk.getTargets()) {
            void $receiver4;
            List<File> removedFilesInTarget = KotlinSourceFileCollector.getRemovedKotlinFiles(dirtyFilesHolder, target);
            if (removedFilesInTarget.isEmpty()) continue;
            ModuleBuildTarget moduleBuildTarget = target;
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleBuildTarget, (String)"target");
            if (!processedTargetsWithRemoved.add(moduleBuildTarget)) continue;
            it = removedFilesInTarget;
            int n = totalRemovedFiles;
            int n2 = $receiver4.size();
            totalRemovedFiles = n + n2;
        }
        File moduleFile = KotlinBuilderModuleScriptGenerator.generateModuleDescription(context, chunk, filesToCompile, totalRemovedFiles != 0);
        if (moduleFile == null) {
            Companion.getLOG().debug("Not compiling, because no files affected: " + CollectionsKt.joinToString$default((Iterable)filesToCompile.keySet(), null, null, null, (int)0, null, (Function1)compileToJvm.2.INSTANCE, (int)31));
            return null;
        }
        JpsProject project = context.getProjectDescriptor().getProject();
        K2JVMCompilerArguments k2JvmArguments = JpsKotlinCompilerSettings.getK2JvmCompilerArguments(project);
        CompilerSettings compilerSettings = JpsKotlinCompilerSettings.getCompilerSettings(project);
        Collection $i$f$size = filesToCompile.values();
        stringBuilder = new StringBuilder().append("Compiling to JVM ");
        object = new StringBuilder();
        messageCollectorAdapter = Companion.getLOG();
        int n = $receiver.size();
        messageCollectorAdapter.debug(((StringBuilder)object).append(stringBuilder.append(n).append(" files").toString()).append(totalRemovedFiles == 0 ? "" : " (" + totalRemovedFiles + " removed files)").append(" in ").append(CollectionsKt.joinToString$default((Iterable)filesToCompile.keySet(), null, null, null, (int)0, null, (Function1)compileToJvm.3.INSTANCE, (int)31)).toString());
        K2JVMCompilerArguments k2JVMCompilerArguments = k2JvmArguments;
        Intrinsics.checkExpressionValueIsNotNull((Object)k2JVMCompilerArguments, (String)"k2JvmArguments");
        CompilerSettings compilerSettings2 = compilerSettings;
        Intrinsics.checkExpressionValueIsNotNull((Object)compilerSettings2, (String)"compilerSettings");
        KotlinCompilerRunner.INSTANCE.runK2JvmCompiler(commonArguments, k2JVMCompilerArguments, compilerSettings2, messageCollector, environment, moduleFile, outputItemCollector);
        moduleFile.delete();
        return outputItemCollector;
    }

    public void buildFinished(@Nullable CompileContext context) {
        this.statisticsLogger.reportTotal();
    }

    public KotlinBuilder() {
        super(BuilderCategory.SOURCE_PROCESSOR);
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!9Q!\u0001C\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tAaq\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002S/!1\tS\u0001\t\u00045\t\u0001DA)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t\u000bA1!K\b\u0005\u0007\"A9!D\u0003\u0011\nU\u0011A\u0012\u0001\r\u00051\u0011\t6!B\u0003\u0002\u0019\u0003i!\u0001B\u0003\t\f%\u0012Ba\u0011\u0005\t\r5A\u0011BB\u0005\u0006\u0013\r!\t!C\u0001\u0019\u0010a9\u0001TB)\u0004\u000b\u0015\tA\u0012A\u0007\u0003\t!A\t\u0002"}, strings={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$Companion;", "", "()V", "KOTLIN_BUILDER_NAME", "", "getKOTLIN_BUILDER_NAME", "()Ljava/lang/String;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "kotlin.jvm.PlatformType", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "LOOKUP_TRACKER", "Lorg/jetbrains/jps/model/ex/JpsElementChildRoleBase;", "Lorg/jetbrains/jps/model/JpsSimpleElement;", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "getLOOKUP_TRACKER", "()Lorg/jetbrains/jps/model/ex/JpsElementChildRoleBase;"}, moduleName="jps-plugin")
    public static final class Companion {
        public static final Companion INSTANCE;

        @NotNull
        public final String getKOTLIN_BUILDER_NAME() {
            return KOTLIN_BUILDER_NAME;
        }

        @NotNull
        public final JpsElementChildRoleBase<JpsSimpleElement<? extends LookupTracker>> getLOOKUP_TRACKER() {
            return LOOKUP_TRACKER;
        }

        public final Logger getLOG() {
            return LOG;
        }

        static {
            new Companion();
        }

        private Companion() {
            INSTANCE = this;
        }
    }

    @KotlinClass(version={1, 0, 0}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\"A\u0003\u0001\u0019\u0001I\u0012\u0001'\u0001\"\u000e%\u0019\u0001\"A\u0007\u00021\u0007\t6!\u0001\u0005\u0003K!!\u0011\u0001#\u0002\u000e\u0003a\u0019\u0011d\u0001E\u0004\u001b\u0005AB!\n\u0005\u0005\u0003!%Q\"\u0001\r\u00063\rAY!D\u0001\u0019\r\u0015\u0002Ba\u0003E\u0007\u001b\u0005Ar!G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011\u001fi\u0011\u0001G\u0003\u001a\u0007!-Q\"\u0001\r\u0007S\u001d!\u0011\t\u0003\u0005\u0002\u001b\u0005A\u001a!U\u0002\u0002\u000b\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/build/KotlinBuilder$MessageCollectorAdapter;", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "context", "Lorg/jetbrains/jps/incremental/CompileContext;", "(Lorg/jetbrains/jps/incremental/CompileContext;)V", "kind", "Lorg/jetbrains/jps/incremental/messages/BuildMessage$Kind;", "severity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "renderLocationIfNeeded", "", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "report", "", "message"}, moduleName="jps-plugin")
    public static final class MessageCollectorAdapter
    implements MessageCollector {
        private final CompileContext context;

        @Override
        public void report(@NotNull CompilerMessageSeverity severity, @NotNull String message, @NotNull CompilerMessageLocation location) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
            String prefix = "";
            if (Intrinsics.areEqual((Object)((Object)severity), (Object)((Object)CompilerMessageSeverity.EXCEPTION))) {
                prefix = "[Internal Error] ";
            }
            this.context.processMessage((BuildMessage)new CompilerMessage("Kotlin", this.kind(severity), prefix + message + this.renderLocationIfNeeded(location), location.getPath(), (long)(-1), (long)(-1), (long)(-1), (long)location.getLine(), (long)location.getColumn()));
        }

        private final String renderLocationIfNeeded(CompilerMessageLocation location) {
            if (Intrinsics.areEqual((Object)location, (Object)CompilerMessageLocation.NO_LOCATION)) {
                return "";
            }
            String pathname = "" + location.getPath();
            return new File(pathname).exists() ? "" : " (" + location + ")";
        }

        private final BuildMessage.Kind kind(CompilerMessageSeverity severity) {
            BuildMessage.Kind kind;
            CompilerMessageSeverity compilerMessageSeverity = severity;
            if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.INFO))) {
                kind = BuildMessage.Kind.INFO;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.ERROR)) || Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.EXCEPTION))) {
                kind = BuildMessage.Kind.ERROR;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.WARNING))) {
                kind = BuildMessage.Kind.WARNING;
            } else if (Intrinsics.areEqual((Object)((Object)compilerMessageSeverity), (Object)((Object)CompilerMessageSeverity.LOGGING))) {
                kind = BuildMessage.Kind.PROGRESS;
            } else {
                throw (Throwable)new IllegalArgumentException("Unsupported severity: " + (Object)((Object)severity));
            }
            return kind;
        }

        public MessageCollectorAdapter(@NotNull CompileContext context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            this.context = context;
        }
    }
}

