/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal.inet;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.List;
import org.gradle.messaging.remote.Address;
import org.gradle.messaging.remote.internal.ConnectCompletion;
import org.gradle.messaging.remote.internal.ConnectException;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.messaging.remote.internal.inet.InetEndpoint;
import org.gradle.messaging.remote.internal.inet.SocketConnectCompletion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpOutgoingConnector
implements OutgoingConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(TcpOutgoingConnector.class);

    public ConnectCompletion connect(Address destinationAddress) throws ConnectException {
        if (!(destinationAddress instanceof InetEndpoint)) {
            throw new IllegalArgumentException(String.format("Cannot create a connection to address of unknown type: %s.", destinationAddress));
        }
        InetEndpoint address = (InetEndpoint)destinationAddress;
        LOGGER.debug("Attempting to connect to {}.", (Object)address);
        List<InetAddress> candidateAddresses = address.getCandidates();
        try {
            SocketException lastFailure = null;
            for (InetAddress candidate : candidateAddresses) {
                SocketChannel socketChannel;
                LOGGER.debug("Trying to connect to address {}.", (Object)candidate);
                try {
                    socketChannel = SocketChannel.open(new InetSocketAddress(candidate, address.getPort()));
                }
                catch (SocketException e) {
                    LOGGER.debug("Cannot connect to address {}, skipping.", (Object)candidate);
                    lastFailure = e;
                    continue;
                }
                LOGGER.debug("Connected to address {}.", (Object)socketChannel.socket().getRemoteSocketAddress());
                return new SocketConnectCompletion(socketChannel);
            }
            throw new ConnectException(String.format("Could not connect to server %s. Tried addresses: %s.", destinationAddress, candidateAddresses), lastFailure);
        }
        catch (ConnectException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Could not connect to server %s. Tried addresses: %s.", destinationAddress, candidateAddresses), e);
        }
    }
}

