/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.ui.experts;

import com.intellij.cvsSupport2.config.CvsApplicationLevelConfiguration;
import com.intellij.cvsSupport2.ui.experts.CvsWizard;
import com.intellij.cvsSupport2.ui.experts.WizardStep;
import com.intellij.cvsSupport2.util.CvsVfsUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.TypeSafeDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileSystemTree;
import com.intellij.openapi.fileChooser.FileSystemTreeFactory;
import com.intellij.openapi.fileChooser.ex.FileDrop;
import com.intellij.openapi.fileChooser.ex.FileLookup;
import com.intellij.openapi.fileChooser.ex.FileTextFieldImpl;
import com.intellij.openapi.fileChooser.ex.LocalFsFinder;
import com.intellij.openapi.fileChooser.impl.FileChooserFactoryImpl;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.intellij.util.ui.update.Update;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseListener;
import java.io.File;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.Nullable;

public abstract class SelectLocationStep
extends WizardStep {
    protected final FileSystemTree myFileSystemTree;
    private final FileTextFieldImpl myPathTextField;
    private final JPanel myNorthPanel = new JPanel(new BorderLayout());
    private final JComponent myPathTextFieldWrapper;
    private final TextFieldAction myTextFieldAction;
    private ActionToolbar myFileSystemToolBar;
    private VirtualFile mySelectedFile;
    private boolean myShowPath;
    private MergingUpdateQueue myUiUpdater;
    private final TreeSelectionListener myTreeSelectionListener;
    private final FileChooserDescriptor myChooserDescriptor;
    private boolean myTreeIsUpdating;

    public SelectLocationStep(String description, CvsWizard wizard, @Nullable Project project, boolean showFiles) {
        super(description, wizard);
        this.myShowPath = CvsApplicationLevelConfiguration.getInstance().SHOW_PATH;
        this.myTreeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SelectLocationStep.this.updatePathFromTree(SelectLocationStep.this.myFileSystemTree.getSelectedFile(), false);
                SelectLocationStep.this.getWizard().updateStep();
            }
        };
        this.myTreeIsUpdating = false;
        this.myChooserDescriptor = new FileChooserDescriptor(showFiles, true, false, false, false, true);
        this.myFileSystemTree = FileSystemTreeFactory.SERVICE.getInstance().createFileSystemTree(project, this.myChooserDescriptor);
        this.myFileSystemTree.updateTree();
        this.myPathTextField = new FileTextFieldImpl.Vfs(FileChooserFactoryImpl.getMacroMap(), (Disposable)this.myFileSystemTree, (FileLookup.LookupFilter)new LocalFsFinder.FileChooserFilter(this.myChooserDescriptor, this.myFileSystemTree)){

            protected void onTextChanged(String newValue) {
                SelectLocationStep.this.updateTreeFromPath(newValue);
            }
        };
        this.myPathTextFieldWrapper = new JPanel(new BorderLayout());
        this.myPathTextFieldWrapper.setBorder(new EmptyBorder(0, 0, 2, 0));
        this.myPathTextFieldWrapper.add((Component)this.myPathTextField.getField(), "Center");
        this.myTextFieldAction = new TextFieldAction();
    }

    @Override
    protected void init() {
        final DefaultActionGroup fileSystemActionGroup = this.createFileSystemActionGroup();
        this.myFileSystemToolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)fileSystemActionGroup, true);
        JTree tree = this.myFileSystemTree.getTree();
        tree.getSelectionModel().addTreeSelectionListener(this.myTreeSelectionListener);
        tree.setCellRenderer((TreeCellRenderer)new NodeRenderer());
        tree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("UpdatePopup", (ActionGroup)fileSystemActionGroup);
                popupMenu.getComponent().show(comp, x, y);
            }
        });
        tree.addSelectionPath(tree.getPathForRow(0));
        new FileDrop((JComponent)tree, new FileDrop.Target(){

            public FileChooserDescriptor getDescriptor() {
                return SelectLocationStep.this.myChooserDescriptor;
            }

            public boolean isHiddenShown() {
                return SelectLocationStep.this.myFileSystemTree.areHiddensShown();
            }

            public void dropFiles(List<VirtualFile> files) {
                if (files.size() > 0) {
                    SelectLocationStep.this.selectInTree(files.toArray(new VirtualFile[files.size()]));
                }
            }
        });
        super.init();
    }

    @Override
    protected JComponent createComponent() {
        MyPanel panel = new MyPanel();
        JPanel toolbarPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        toolbarPanel.add((Component)this.myFileSystemToolBar.getComponent(), constraints);
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        constraints.anchor = 13;
        toolbarPanel.add((Component)((Object)this.myTextFieldAction), constraints);
        this.myNorthPanel.add((Component)toolbarPanel, "North");
        panel.add((Component)this.myNorthPanel, "North");
        panel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myFileSystemTree.getTree()), "Center");
        panel.add((Component)new JLabel("<html><center><small><font color=gray>Drag and drop a file into the space above to quickly locate it in the tree</font></small></center></html>", 0), "South");
        this.myUiUpdater = new MergingUpdateQueue("FileChooserUpdater", 200, false, (JComponent)panel);
        Disposer.register((Disposable)this.myFileSystemTree, (Disposable)this.myUiUpdater);
        new UiNotifyConnector((Component)panel, (Activatable)this.myUiUpdater);
        this.updateTextFieldShowing();
        return panel;
    }

    @Override
    protected void dispose() {
        this.mySelectedFile = this.myFileSystemTree.getSelectedFile();
        this.myFileSystemTree.getTree().getSelectionModel().removeTreeSelectionListener(this.myTreeSelectionListener);
        Disposer.dispose((Disposable)this.myFileSystemTree);
    }

    @Override
    public boolean nextIsEnabled() {
        VirtualFile[] selectedFiles = this.myFileSystemTree.getSelectedFiles();
        return selectedFiles.length == 1 && selectedFiles[0].isDirectory();
    }

    private DefaultActionGroup createFileSystemActionGroup() {
        DefaultActionGroup group = FileSystemTreeFactory.SERVICE.getInstance().createDefaultFileSystemActions(this.myFileSystemTree);
        AnAction[] actions = this.getActions();
        if (actions.length > 0) {
            group.addSeparator();
        }
        for (AnAction action : actions) {
            group.add(action);
        }
        return group;
    }

    protected AnAction[] getActions() {
        return AnAction.EMPTY_ARRAY;
    }

    public File getSelectedFile() {
        if (this.mySelectedFile != null) {
            return CvsVfsUtil.getFileFor(this.mySelectedFile);
        }
        return CvsVfsUtil.getFileFor(this.myFileSystemTree.getSelectedFile());
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myFileSystemTree.getTree();
    }

    private void updateTreeFromPath(final String text) {
        if (!this.myShowPath) {
            return;
        }
        if (this.myPathTextField.isPathUpdating()) {
            return;
        }
        if (text == null) {
            return;
        }
        this.myUiUpdater.queue(new Update("treeFromPath.1"){

            public void run() {
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        final LocalFsFinder.VfsFile toFind = (LocalFsFinder.VfsFile)SelectLocationStep.this.myPathTextField.getFile();
                        if (toFind == null || !toFind.exists()) {
                            return;
                        }
                        SelectLocationStep.this.myUiUpdater.queue(new Update("treeFromPath.2"){

                            public void run() {
                                SelectLocationStep.this.selectInTree(toFind.getFile(), text);
                            }
                        });
                    }
                });
            }
        });
    }

    private void selectInTree(VirtualFile vFile, String fromText) {
        this.myTreeIsUpdating = true;
        if (vFile == null || !vFile.isValid()) {
            return;
        }
        if (fromText == null || fromText.equalsIgnoreCase(this.myPathTextField.getTextFieldText())) {
            this.selectInTree(new VirtualFile[]{vFile});
        }
        this.myTreeIsUpdating = false;
    }

    private void selectInTree(VirtualFile[] vFiles) {
        if (vFiles.length == 0) {
            return;
        }
        this.myFileSystemTree.select(vFiles, null);
    }

    public void toggleShowTextField() {
        CvsApplicationLevelConfiguration.getInstance().SHOW_PATH = this.myShowPath = !this.myShowPath;
        this.updateTextFieldShowing();
    }

    private void updateTextFieldShowing() {
        this.myTextFieldAction.update();
        this.myNorthPanel.remove(this.myPathTextFieldWrapper);
        if (this.myShowPath) {
            this.updatePathFromTree(this.myFileSystemTree.getSelectedFile(), true);
            this.myNorthPanel.add((Component)this.myPathTextFieldWrapper, "South");
        }
        this.myPathTextField.getField().requestFocus();
        this.myNorthPanel.revalidate();
        this.myNorthPanel.repaint();
    }

    private void updatePathFromTree(VirtualFile selection, boolean now) {
        if (!this.myShowPath || this.myTreeIsUpdating) {
            return;
        }
        String text = "";
        if (selection != null) {
            text = selection.isInLocalFileSystem() ? selection.getPresentableUrl() : selection.getUrl();
        } else {
            List roots = this.myChooserDescriptor.getRoots();
            if (!this.myFileSystemTree.getTree().isRootVisible() && roots.size() == 1) {
                text = VfsUtil.getReadableUrl((VirtualFile)((VirtualFile)roots.get(0)));
            }
        }
        this.myPathTextField.setText(text, now, new Runnable(){

            @Override
            public void run() {
                SelectLocationStep.this.myPathTextField.getField().selectAll();
            }
        });
    }

    private class TextFieldAction
    extends LinkLabel
    implements LinkListener {
        public TextFieldAction() {
            super("", null);
            this.setListener(this, null);
            this.update();
        }

        protected void onSetActive(boolean active) {
            String tooltip = KeymapUtil.createTooltipText((String)ActionsBundle.message((String)"action.FileChooser.TogglePathShowing.text", (Object[])new Object[0]), (AnAction)ActionManager.getInstance().getAction("FileChooser.TogglePathShowing"));
            this.setToolTipText(tooltip);
        }

        protected String getStatusBarText() {
            return ActionsBundle.message((String)"action.FileChooser.TogglePathShowing.text", (Object[])new Object[0]);
        }

        public void update() {
            this.setVisible(true);
            this.setText(SelectLocationStep.this.myShowPath ? IdeBundle.message((String)"file.chooser.hide.path", (Object[])new Object[0]) : IdeBundle.message((String)"file.chooser.show.path", (Object[])new Object[0]));
        }

        public void linkSelected(LinkLabel aSource, Object aLinkData) {
            SelectLocationStep.this.toggleShowTextField();
        }
    }

    private class MyPanel
    extends JPanel
    implements TypeSafeDataProvider {
        private MyPanel() {
            super(new BorderLayout());
        }

        public void calcData(DataKey key, DataSink sink) {
            if (key == CommonDataKeys.VIRTUAL_FILE_ARRAY) {
                sink.put(CommonDataKeys.VIRTUAL_FILE_ARRAY, (Object)SelectLocationStep.this.myFileSystemTree.getSelectedFiles());
            } else if (key == FileSystemTree.DATA_KEY) {
                sink.put(FileSystemTree.DATA_KEY, (Object)SelectLocationStep.this.myFileSystemTree);
            }
        }
    }
}

