/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.ide.DataManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Consumer;
import com.intellij.util.net.HttpProxyConfigurable;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JToolTip;
import javax.swing.SpinnerNumberModel;
import javax.swing.plaf.ComponentUI;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.IdeaSubversionConfigurationDirectory;
import org.jetbrains.idea.svn.SvnApplicationSettings;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.auth.SvnAuthenticationNotifier;
import org.jetbrains.idea.svn.config.SvnConfigureProxiesDialog;
import org.jetbrains.idea.svn.dialogs.SshSettingsPanel;
import org.jetbrains.idea.svn.svnkit.SvnKitManager;

public class SvnConfigurable
implements Configurable {
    public static final String DISPLAY_NAME = "Subversion";
    private final Project myProject;
    private JCheckBox myUseDefaultCheckBox;
    private TextFieldWithBrowseButton myConfigurationDirectoryText;
    private JButton myClearAuthButton;
    private JCheckBox myUseCommonProxy;
    private JButton myEditProxiesButton;
    private JPanel myComponent;
    private JLabel myConfigurationDirectoryLabel;
    private JCheckBox myLockOnDemand;
    private JCheckBox myCheckNestedInQuickMerge;
    private JCheckBox myDetectNestedWorkingCopiesCheckBox;
    private JCheckBox myIgnoreWhitespaceDifferenciesInCheckBox;
    private JCheckBox myShowMergeSourceInAnnotate;
    private JBCheckBox myWithCommandLineClient;
    private JBCheckBox myRunUnderTerminal;
    private JSpinner myNumRevsInAnnotations;
    private JCheckBox myMaximumNumberOfRevisionsCheckBox;
    private JSpinner mySSHConnectionTimeout;
    private JSpinner mySSHReadTimeout;
    private TextFieldWithBrowseButton myCommandLineClient;
    private JPanel myCommandLineClientOptions;
    private JSpinner myHttpTimeout;
    private JBRadioButton mySSLv3RadioButton;
    private JBRadioButton myTLSv1RadioButton;
    private JBRadioButton myAllRadioButton;
    private JLabel mySSLExplicitly;
    private SshSettingsPanel mySshSettingsPanel;
    private LinkLabel<Object> myNavigateToCommonProxyLink;
    @NonNls
    private static final String HELP_ID = "project.propSubversion";

    public SvnConfigurable(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myWithCommandLineClient.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SvnConfigurable.this.enableCommandLineClientOptions();
            }
        });
        this.enableCommandLineClientOptions();
        this.myUseDefaultCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean enabled = !SvnConfigurable.this.myUseDefaultCheckBox.isSelected();
                SvnConfigurable.this.myConfigurationDirectoryText.setEnabled(enabled);
                SvnConfigurable.this.myConfigurationDirectoryText.setEditable(enabled);
                SvnConfigurable.this.myConfigurationDirectoryLabel.setEnabled(enabled);
                SvnConfiguration configuration = SvnConfiguration.getInstance(SvnConfigurable.this.myProject);
                String path = configuration.getConfigurationDirectory();
                if (!enabled || path == null) {
                    SvnConfigurable.this.myConfigurationDirectoryText.setText(IdeaSubversionConfigurationDirectory.getPath());
                } else {
                    SvnConfigurable.this.myConfigurationDirectoryText.setText(path);
                }
            }
        });
        this.myCommandLineClient.addBrowseFolderListener(DISPLAY_NAME, "Select path to Subversion executable (1.7+)", project, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        this.myClearAuthButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnAuthenticationNotifier.clearAuthenticationCache(SvnConfigurable.this.myProject, SvnConfigurable.this.myComponent, SvnConfigurable.this.myConfigurationDirectoryText.getText());
            }
        });
        this.myConfigurationDirectoryText.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = SvnConfigurable.this.myConfigurationDirectoryText.getText().trim();
                SvnConfigurable.selectConfigurationDirectory(path, new Consumer<String>(){

                    public void consume(String s) {
                        SvnConfigurable.this.myConfigurationDirectoryText.setText(s);
                    }
                }, SvnConfigurable.this.myProject, SvnConfigurable.this.myComponent);
            }
        });
        this.myConfigurationDirectoryLabel.setLabelFor((Component)this.myConfigurationDirectoryText);
        this.myUseCommonProxy.setText(SvnBundle.message("use.idea.proxy.as.default", ApplicationNamesInfo.getInstance().getProductName()));
        this.myNavigateToCommonProxyLink.setListener((LinkListener)new LinkListener<Object>(){

            public void linkSelected(LinkLabel aSource, Object aLinkData) {
                Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)SvnConfigurable.this.myComponent));
                if (settings != null) {
                    settings.select(settings.find(HttpProxyConfigurable.class));
                }
            }
        }, null);
        this.myEditProxiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnConfigureProxiesDialog dialog = new SvnConfigureProxiesDialog(SvnConfigurable.this.myProject);
                dialog.show();
                SvnConfigurable.this.myHttpTimeout.setValue(SvnConfiguration.getInstance(SvnConfigurable.this.myProject).getHttpTimeout() / 1000L);
            }
        });
        this.myMaximumNumberOfRevisionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SvnConfigurable.this.myNumRevsInAnnotations.setEnabled(SvnConfigurable.this.myMaximumNumberOfRevisionsCheckBox.isSelected());
            }
        });
        this.myNumRevsInAnnotations.setEnabled(this.myMaximumNumberOfRevisionsCheckBox.isSelected());
        ButtonGroup bg = new ButtonGroup();
        bg.add((AbstractButton)this.mySSLv3RadioButton);
        bg.add((AbstractButton)this.myTLSv1RadioButton);
        bg.add((AbstractButton)this.myAllRadioButton);
        if (SvnKitManager.isSSLProtocolExplicitlySet()) {
            this.mySSLv3RadioButton.setEnabled(false);
            this.myTLSv1RadioButton.setEnabled(false);
            this.myAllRadioButton.setEnabled(false);
            this.mySSLExplicitly.setVisible(true);
            this.mySSLExplicitly.setText("Set explicitly to: " + SvnKitManager.getExplicitlySetSslProtocols());
        } else {
            boolean jdkBugFixed;
            this.mySSLv3RadioButton.setEnabled(true);
            this.myTLSv1RadioButton.setEnabled(true);
            this.myAllRadioButton.setEnabled(true);
            this.mySSLExplicitly.setVisible(false);
            String version = SystemInfo.JAVA_RUNTIME_VERSION;
            boolean bl = jdkBugFixed = version.startsWith("1.7") || version.startsWith("1.8");
            if (!jdkBugFixed) {
                this.mySSLExplicitly.setVisible(true);
                this.mySSLExplicitly.setText("Setting 'All' value in this JDK version (" + version + ") is not recommended.");
            }
        }
        this.mySshSettingsPanel.load(SvnConfiguration.getInstance(this.myProject));
    }

    public void enableCommandLineClientOptions() {
        UIUtil.setEnabled((Component)this.myCommandLineClientOptions, (boolean)this.myWithCommandLineClient.isSelected(), (boolean)true);
    }

    public static void selectConfigurationDirectory(@NotNull String path, @NotNull Consumer<String> dirConsumer, Project project, @Nullable Component component) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/idea/svn/SvnConfigurable", "selectConfigurationDirectory"));
        }
        if (dirConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirConsumer", "org/jetbrains/idea/svn/SvnConfigurable", "selectConfigurationDirectory"));
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(SvnBundle.message("dialog.title.select.configuration.directory", new Object[0])).withDescription(SvnBundle.message("dialog.description.select.configuration.directory", new Object[0])).withShowFileSystemRoots(true).withHideIgnored(false).withShowHiddenFiles(true);
        path = "file://" + path.replace(File.separatorChar, '/');
        VirtualFile root = VirtualFileManager.getInstance().findFileByUrl(path);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Component)component, (Project)project, (VirtualFile)root);
        if (file == null) {
            return;
        }
        String resultPath = file.getPath().replace('/', File.separatorChar);
        dirConsumer.consume((Object)resultPath);
    }

    public JComponent createComponent() {
        return this.myComponent;
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    public String getHelpTopic() {
        return HELP_ID;
    }

    private SvnConfiguration.SSLProtocols getSelectedSSL() {
        if (this.myAllRadioButton.isSelected()) {
            return SvnConfiguration.SSLProtocols.all;
        }
        if (this.mySSLv3RadioButton.isSelected()) {
            return SvnConfiguration.SSLProtocols.sslv3;
        }
        if (this.myTLSv1RadioButton.isSelected()) {
            return SvnConfiguration.SSLProtocols.tlsv1;
        }
        throw new IllegalStateException();
    }

    public boolean isModified() {
        boolean useMaxInAnnot;
        if (this.myComponent == null) {
            return false;
        }
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        if (configuration.isUseDefaultConfiguation() != this.myUseDefaultCheckBox.isSelected()) {
            return true;
        }
        if (configuration.isIsUseDefaultProxy() != this.myUseCommonProxy.isSelected()) {
            return true;
        }
        if (configuration.isUpdateLockOnDemand() != this.myLockOnDemand.isSelected()) {
            return true;
        }
        if (configuration.isCheckNestedForQuickMerge() != this.myCheckNestedInQuickMerge.isSelected()) {
            return true;
        }
        if (configuration.isIgnoreSpacesInAnnotate() != this.myIgnoreWhitespaceDifferenciesInCheckBox.isSelected()) {
            return true;
        }
        if (configuration.isShowMergeSourcesInAnnotate() != this.myShowMergeSourceInAnnotate.isSelected()) {
            return true;
        }
        if (!configuration.getUseAcceleration().equals((Object)this.acceleration())) {
            return true;
        }
        if (configuration.isRunUnderTerminal() != this.myRunUnderTerminal.isSelected()) {
            return true;
        }
        int annotateRevisions = configuration.getMaxAnnotateRevisions();
        boolean bl = useMaxInAnnot = annotateRevisions != -1;
        if (useMaxInAnnot != this.myMaximumNumberOfRevisionsCheckBox.isSelected()) {
            return true;
        }
        if (this.myMaximumNumberOfRevisionsCheckBox.isSelected() && annotateRevisions != ((SpinnerNumberModel)this.myNumRevsInAnnotations.getModel()).getNumber().intValue()) {
            return true;
        }
        if (configuration.getSshConnectionTimeout() / 1000L != ((SpinnerNumberModel)this.mySSHConnectionTimeout.getModel()).getNumber().longValue()) {
            return true;
        }
        if (configuration.getSshReadTimeout() / 1000L != ((SpinnerNumberModel)this.mySSHReadTimeout.getModel()).getNumber().longValue()) {
            return true;
        }
        if (configuration.getHttpTimeout() / 1000L != ((SpinnerNumberModel)this.myHttpTimeout.getModel()).getNumber().longValue()) {
            return true;
        }
        if (!this.getSelectedSSL().equals((Object)configuration.getSslProtocols())) {
            return true;
        }
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        if (!Comparing.equal((String)applicationSettings17.getCommandLinePath(), (String)this.myCommandLineClient.getText().trim())) {
            return true;
        }
        if (!configuration.getConfigurationDirectory().equals(this.myConfigurationDirectoryText.getText().trim())) {
            return true;
        }
        return this.mySshSettingsPanel.isModified(configuration);
    }

    private SvnConfiguration.UseAcceleration acceleration() {
        if (this.myWithCommandLineClient.isSelected()) {
            return SvnConfiguration.UseAcceleration.commandLine;
        }
        return SvnConfiguration.UseAcceleration.nothing;
    }

    public void apply() throws ConfigurationException {
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        configuration.setConfigurationDirParameters(this.myUseDefaultCheckBox.isSelected(), this.myConfigurationDirectoryText.getText());
        configuration.setIsUseDefaultProxy(this.myUseCommonProxy.isSelected());
        SvnVcs vcs17 = SvnVcs.getInstance(this.myProject);
        configuration.setCheckNestedForQuickMerge(this.myCheckNestedInQuickMerge.isSelected());
        configuration.setUpdateLockOnDemand(this.myLockOnDemand.isSelected());
        configuration.setIgnoreSpacesInAnnotate(this.myIgnoreWhitespaceDifferenciesInCheckBox.isSelected());
        configuration.setShowMergeSourcesInAnnotate(this.myShowMergeSourceInAnnotate.isSelected());
        if (!this.myMaximumNumberOfRevisionsCheckBox.isSelected()) {
            configuration.setMaxAnnotateRevisions(-1);
        } else {
            configuration.setMaxAnnotateRevisions(((SpinnerNumberModel)this.myNumRevsInAnnotations.getModel()).getNumber().intValue());
        }
        configuration.setSshConnectionTimeout(((SpinnerNumberModel)this.mySSHConnectionTimeout.getModel()).getNumber().longValue() * 1000L);
        configuration.setSshReadTimeout(((SpinnerNumberModel)this.mySSHReadTimeout.getModel()).getNumber().longValue() * 1000L);
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        boolean reloadWorkingCopies = !this.acceleration().equals((Object)configuration.getUseAcceleration()) || !StringUtil.equals((CharSequence)applicationSettings17.getCommandLinePath(), (CharSequence)this.myCommandLineClient.getText().trim());
        configuration.setUseAcceleration(this.acceleration());
        configuration.setRunUnderTerminal(this.myRunUnderTerminal.isSelected());
        configuration.setSslProtocols(this.getSelectedSSL());
        SvnVcs.getInstance(this.myProject).getSvnKitManager().refreshSSLProperty();
        applicationSettings17.setCommandLinePath(this.myCommandLineClient.getText().trim());
        boolean isClientValid = vcs17.checkCommandLineVersion();
        if (isClientValid && reloadWorkingCopies) {
            vcs17.invokeRefreshSvnRoots();
            VcsDirtyScopeManager.getInstance((Project)this.myProject).markEverythingDirty();
        }
        configuration.setHttpTimeout(((SpinnerNumberModel)this.myHttpTimeout.getModel()).getNumber().longValue() * 1000L);
        this.mySshSettingsPanel.apply(configuration);
    }

    public void reset() {
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        String path = configuration.getConfigurationDirectory();
        if (configuration.isUseDefaultConfiguation() || path == null) {
            path = IdeaSubversionConfigurationDirectory.getPath();
        }
        this.myConfigurationDirectoryText.setText(path);
        this.myUseDefaultCheckBox.setSelected(configuration.isUseDefaultConfiguation());
        this.myUseCommonProxy.setSelected(configuration.isIsUseDefaultProxy());
        this.myCheckNestedInQuickMerge.setSelected(configuration.isCheckNestedForQuickMerge());
        boolean enabled = !this.myUseDefaultCheckBox.isSelected();
        this.myConfigurationDirectoryText.setEnabled(enabled);
        this.myConfigurationDirectoryText.setEditable(enabled);
        this.myConfigurationDirectoryLabel.setEnabled(enabled);
        this.myLockOnDemand.setSelected(configuration.isUpdateLockOnDemand());
        this.myIgnoreWhitespaceDifferenciesInCheckBox.setSelected(configuration.isIgnoreSpacesInAnnotate());
        this.myShowMergeSourceInAnnotate.setSelected(configuration.isShowMergeSourcesInAnnotate());
        int annotateRevisions = configuration.getMaxAnnotateRevisions();
        if (annotateRevisions == -1) {
            this.myMaximumNumberOfRevisionsCheckBox.setSelected(false);
            this.myNumRevsInAnnotations.setValue(500);
        } else {
            this.myMaximumNumberOfRevisionsCheckBox.setSelected(true);
            this.myNumRevsInAnnotations.setValue(annotateRevisions);
        }
        this.myNumRevsInAnnotations.setEnabled(this.myMaximumNumberOfRevisionsCheckBox.isSelected());
        this.mySSHConnectionTimeout.setValue(configuration.getSshConnectionTimeout() / 1000L);
        this.mySSHReadTimeout.setValue(configuration.getSshReadTimeout() / 1000L);
        this.myHttpTimeout.setValue(configuration.getHttpTimeout() / 1000L);
        this.myWithCommandLineClient.setSelected(configuration.isCommandLine());
        this.myRunUnderTerminal.setSelected(configuration.isRunUnderTerminal());
        SvnApplicationSettings applicationSettings17 = SvnApplicationSettings.getInstance();
        this.myCommandLineClient.setText(applicationSettings17.getCommandLinePath());
        if (SvnConfiguration.SSLProtocols.sslv3.equals((Object)configuration.getSslProtocols())) {
            this.mySSLv3RadioButton.setSelected(true);
        } else if (SvnConfiguration.SSLProtocols.tlsv1.equals((Object)configuration.getSslProtocols())) {
            this.myTLSv1RadioButton.setSelected(true);
        } else {
            this.myAllRadioButton.setSelected(true);
        }
        this.mySshSettingsPanel.reset(configuration);
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.myLockOnDemand = new JCheckBox(){

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI((ComponentUI)new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
        SvnConfiguration configuration = SvnConfiguration.getInstance(this.myProject);
        int value = configuration.getMaxAnnotateRevisions();
        value = value == -1 ? 500 : value;
        this.myNumRevsInAnnotations = new JSpinner(new SpinnerNumberModel(value, 10, 100000, 100));
        this.myNavigateToCommonProxyLink = new LinkLabel(SvnBundle.message("navigate.to.idea.proxy.settings", new Object[0]), null);
        Long maximum = 1800000L;
        long connection = configuration.getSshConnectionTimeout() <= maximum ? configuration.getSshConnectionTimeout() : maximum.longValue();
        long read = configuration.getSshReadTimeout() <= maximum ? configuration.getSshReadTimeout() : maximum.longValue();
        this.mySSHConnectionTimeout = new JSpinner(new SpinnerNumberModel((Number)(connection / 1000L), Long.valueOf(0L), maximum, (Number)10L));
        this.mySSHReadTimeout = new JSpinner(new SpinnerNumberModel((Number)(read / 1000L), Long.valueOf(0L), maximum, (Number)10L));
        this.myHttpTimeout = new JSpinner(new SpinnerNumberModel((Number)(read / 1000L), Long.valueOf(0L), maximum, (Number)10L));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SshSettingsPanel sshSettingsPanel;
        JCheckBox jCheckBox;
        JBRadioButton jBRadioButton;
        JBRadioButton jBRadioButton2;
        JBRadioButton jBRadioButton3;
        JButton jButton;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBCheckBox jBCheckBox2;
        JButton jButton2;
        JCheckBox jCheckBox6;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JLabel jLabel;
        JPanel jPanel2;
        this.createUIComponents();
        this.myComponent = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(7, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "");
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        jPanel2.add((Component)jBTabbedPane, new GridConstraints(0, 0, 1, 1, 0, 3, 6, 6, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(7, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("General", null, jPanel3, null);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(4, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        JCheckBox jCheckBox7 = this.myLockOnDemand;
        this.$$$loadButtonText$$$(jCheckBox7, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.text.configurable"));
        jCheckBox7.setToolTipText(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("action.Subversion.update.use.locks.on.demand.description"));
        jPanel4.add((Component)jCheckBox7, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myConfigurationDirectoryLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.configuration.configuration.directory"));
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null, 3));
        this.myConfigurationDirectoryText = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setEditable(false);
        jPanel5.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseDefaultCheckBox = jCheckBox6 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox6, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("checkbox.configure.use.system.default.configuration.directory"));
        jPanel3.add((Component)jCheckBox6, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(6, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myClearAuthButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("button.text.clear.authentication.cache"));
        jPanel7.add((Component)jButton2, new GridConstraints(0, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("label.text.delete.stored.credentials"));
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel7.add((Component)jBLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(6, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel3.add((Component)spacer3, new GridConstraints(5, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 4, 0, 3, 3, 3, null, null, null));
        this.myWithCommandLineClient = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Use command line client:");
        jBCheckBox2.setMargin(new Insets(2, 3, 2, 3));
        jPanel8.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myCommandLineClient = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel8.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myCommandLineClientOptions = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 3));
        this.myRunUnderTerminal = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("command.line.interactive.mode.title"));
        jBCheckBox.setMargin(new Insets(2, -2, 2, 3));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("command.line.interactive.mode.description"));
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(5, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Presentation", null, jPanel9, null);
        this.myCheckNestedInQuickMerge = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Check svn:mergeinfo in target subtree when preparing for merge");
        jPanel9.add((Component)jCheckBox5, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(0, 2, 1, 2, 0, 1, 6, 1, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel9.add((Component)spacer5, new GridConstraints(4, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        this.myMaximumNumberOfRevisionsCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Maximum number of revisions to look back in annotations:");
        jPanel9.add((Component)jCheckBox4, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel9.add((Component)spacer6, new GridConstraints(1, 2, 1, 2, 0, 1, 6, 1, null, null, null));
        JSpinner jSpinner = this.myNumRevsInAnnotations;
        jPanel9.add((Component)jSpinner, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(70, -1), null));
        this.myShowMergeSourceInAnnotate = jCheckBox3 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox3, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("annotation.show.merge.sources.default.text"));
        jPanel9.add((Component)jCheckBox3, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myIgnoreWhitespaceDifferenciesInCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("svn.option.ignore.whitespace.in.annotate"));
        jPanel9.add((Component)jCheckBox2, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(10, 31, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Network", null, jPanel10, null);
        Spacer spacer7 = new Spacer();
        jPanel10.add((Component)spacer7, new GridConstraints(8, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel11, new GridConstraints(9, 0, 1, 31, 0, 3, 3, 3, null, null, null));
        this.myEditProxiesButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("button.text.edit.proxies"));
        jPanel11.add((Component)jButton, new GridConstraints(0, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel3.setText("Edit 'servers' Subversion runtime configuration file");
        jBLabel3.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel11.add((Component)jBLabel3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel11.add((Component)spacer8, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        JBLabel jBLabel4 = new JBLabel();
        jBLabel4.setFontColor(UIUtil.FontColor.BRIGHTER);
        this.$$$loadLabelText$$$((JLabel)jBLabel4, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("use.idea.proxy.as.default.label.text"));
        jBLabel4.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel10.add((Component)jBLabel4, new GridConstraints(1, 0, 1, 30, 8, 0, 0, 0, null, null, null, 3));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel12, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel5 = new JBLabel();
        jBLabel5.setText("HTTP timeout:");
        jPanel12.add((Component)jBLabel5, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSpinner jSpinner2 = this.myHttpTimeout;
        jPanel12.add((Component)jSpinner2, new GridConstraints(0, 1, 1, 1, 8, 0, 6, 0, null, new Dimension(70, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("seconds");
        jPanel12.add((Component)jLabel2, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel13, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel6 = new JBLabel();
        jBLabel6.setText("SSH connection timeout:");
        jPanel13.add((Component)jBLabel6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSpinner jSpinner3 = this.mySSHConnectionTimeout;
        jPanel13.add((Component)jSpinner3, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(70, -1), null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("seconds");
        jPanel13.add((Component)jLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel14, new GridConstraints(5, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("SSH read timeout:");
        jPanel14.add((Component)jBLabel7, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSpinner jSpinner4 = this.mySSHReadTimeout;
        jPanel14.add((Component)jSpinner4, new GridConstraints(0, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(70, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("seconds");
        jPanel14.add((Component)jLabel4, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel15 = new JPanel();
        jPanel15.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel10.add((Component)jPanel15, new GridConstraints(7, 0, 1, 1, 8, 0, 3, 3, null, null, null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setVerticalAlignment(0);
        jBLabel8.setText("SSL protocols:");
        jPanel15.add((Component)jBLabel8, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel16 = new JPanel();
        jPanel16.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel15.add((Component)jPanel16, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 3, null, null, null));
        this.mySSLv3RadioButton = jBRadioButton3 = new JBRadioButton();
        jBRadioButton3.setText("SSLv3");
        jPanel16.add((Component)jBRadioButton3, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myTLSv1RadioButton = jBRadioButton2 = new JBRadioButton();
        jBRadioButton2.setText("TLSv1");
        jPanel16.add((Component)jBRadioButton2, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAllRadioButton = jBRadioButton = new JBRadioButton();
        jBRadioButton.setText("All");
        jPanel16.add((Component)jBRadioButton, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        this.mySSLExplicitly = jBLabel9;
        jBLabel9.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel9.setText("");
        jBLabel9.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel15.add((Component)jBLabel9, new GridConstraints(1, 1, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        Spacer spacer9 = new Spacer();
        jPanel10.add((Component)spacer9, new GridConstraints(6, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        Spacer spacer10 = new Spacer();
        jPanel10.add((Component)spacer10, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, new Dimension(-1, 15), new Dimension(-1, 15), new Dimension(-1, 15)));
        JPanel jPanel17 = new JPanel();
        jPanel17.setLayout(new BorderLayout(0, 0));
        jPanel10.add((Component)jPanel17, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseCommonProxy = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use IDEA general proxy settings as default for Subversion");
        jPanel17.add((Component)jCheckBox, "West");
        LinkLabel<Object> linkLabel = this.myNavigateToCommonProxyLink;
        this.$$$loadLabelText$$$((JLabel)linkLabel, ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("navigate.to.idea.proxy.settings"));
        linkLabel.setHorizontalAlignment(10);
        jPanel17.add((Component)linkLabel, "East");
        JPanel jPanel18 = new JPanel();
        jPanel18.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab(ResourceBundle.getBundle("org/jetbrains/idea/svn/SvnBundle").getString("ssh.settings.title"), null, jPanel18, null);
        this.mySshSettingsPanel = sshSettingsPanel = new SshSettingsPanel();
        JComponent jComponent = sshSettingsPanel.$$$getRootComponent$$$();
        jPanel18.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jBLabel5.setAnchor((JComponent)jBLabel6);
        jBLabel7.setAnchor((JComponent)jBLabel6);
        jBLabel8.setAnchor((JComponent)jBLabel6);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

