/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.settingsRepository.git;

import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.ui.UIUtil;
import kotlin.StringsKt;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.keychain.Credentials;
import org.jetbrains.keychain.CredentialsStore;
import org.jetbrains.keychain.OSXKeychainLibraryKt;
import org.jetbrains.settingsRepository.CredentialsStoreKt;
import org.jetbrains.settingsRepository.IcsManagerKt;
import org.jetbrains.settingsRepository.UtilKt;
import org.jetbrains.settingsRepository.git.GitCredentialKt;
import org.jetbrains.settingsRepository.git.JGitCredentialsProviderKt;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"S\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\b\u000b\u0005!\u0011!B\u0001\t\u0012\u0015\tA1A\u0003\u0002\u0011\u0005)\u0011\u0001B\u0001\r\u0001e\t\u0001\u0014AQ\u000e\u0013\u0019A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002\u0013\rA)!D\u0001\u0019\u0007E\u001b\u0011\u0001c\u0002&/\u0011\t\u0001\"B\u0007\u00021\u0017I2\u0001\u0003\u0004\u000e\u0003a5\u0011\u0004\u0002\u0005\b\u001b\ta\t\u0001g\u0004\u001a\t!AQB\u0001G\u00011#IB\u0001C\u0005\u000e\u00051\u0005\u00014C\u0013\u0016\t-#\u0001BC\u0007\u00021\u0017I2\u0001\u0003\u0004\u000e\u0003a5\u0011$\u0003E\u000b\u001b\u0015I1\u0001\"\u0001\n\u0003aE\u0001dC\t\u00021#\t6!\u0001E\fK\u0011!1\u0002\u0003\u0007\u000e\u0003a-Q\u0005\u0003\u0003\f\u00113i\u0011\u0001G\u0007\u001a\u0007!1Q\"\u0001M\u0007KC!1\u0002c\u0007\u000e\u0003a-\u0011$\u0003E\u000b\u001b\u0015I1\u0001\"\u0001\n\u0003aE\u0001dC\t\u00021#\t6!\u0001\u0005\u000fS!!\u0011\t\b\u0005\u0005\u001b\ta\t\u0001'\u0003R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0003\"A\u0011!\u0004\u0003\n\u0005%\t\u0001D\u0001M\u0002#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001RA\u0007\u00021\r\t6!A\u0003\u0001"}, strings={"Lorg/jetbrains/settingsRepository/git/JGitCredentialsProvider;", "Lorg/eclipse/jgit/transport/CredentialsProvider;", "credentialsStore", "Lcom/intellij/openapi/util/NotNullLazyValue;", "Lorg/jetbrains/keychain/CredentialsStore;", "repository", "Lorg/eclipse/jgit/lib/Repository;", "(Lcom/intellij/openapi/util/NotNullLazyValue;Lorg/eclipse/jgit/lib/Repository;)V", "credentialsFromGit", "Lorg/jetbrains/keychain/Credentials;", "doGet", "", "uri", "Lorg/eclipse/jgit/transport/URIish;", "userNameItem", "Lorg/eclipse/jgit/transport/CredentialItem$Username;", "passwordItem", "Lorg/eclipse/jgit/transport/CredentialItem;", "sshKeyFile", "", "get", "items", "", "(Lorg/eclipse/jgit/transport/URIish;[Lorg/eclipse/jgit/transport/CredentialItem;)Z", "isInteractive", "reset", "", "supports", "([Lorg/eclipse/jgit/transport/CredentialItem;)Z"}, moduleName="settings-repository")
public final class JGitCredentialsProvider
extends CredentialsProvider {
    private Credentials credentialsFromGit;
    private final NotNullLazyValue<CredentialsStore> credentialsStore;
    private final Repository repository;

    public boolean isInteractive() {
        return true;
    }

    public boolean supports(CredentialItem ... items) {
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        for (int i = 0; i < items.length; ++i) {
            CredentialItem item = items[i];
            if (item instanceof CredentialItem.Password || item instanceof CredentialItem.Username || item instanceof CredentialItem.StringType || item instanceof CredentialItem.YesNoType) continue;
            return false;
        }
        return true;
    }

    public boolean get(@NotNull URIish uri, CredentialItem ... items) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        Intrinsics.checkParameterIsNotNull((Object)items, (String)"items");
        CredentialItem.Username userNameItem = null;
        CredentialItem passwordItem = null;
        String sshKeyFile = null;
        for (int i = 0; i < items.length; ++i) {
            CredentialItem item = items[i];
            if (item instanceof CredentialItem.Username) {
                userNameItem = (CredentialItem.Username)item;
                continue;
            }
            if (item instanceof CredentialItem.Password) {
                passwordItem = item;
                continue;
            }
            if (item instanceof CredentialItem.StringType) {
                String marker;
                String promptText = ((CredentialItem.StringType)item).getPromptText();
                if (promptText == null || !StringsKt.startsWith$default((String)promptText, (String)(marker = "Passphrase for "), (boolean)false, (int)2)) continue;
                sshKeyFile = StringsKt.substring((String)promptText, (int)marker.length());
                passwordItem = item;
                continue;
            }
            if (!(item instanceof CredentialItem.YesNoType)) continue;
            UIUtil.invokeAndWaitIfNeeded((Runnable)new Runnable(item){
                final /* synthetic */ CredentialItem $item;

                public final void run() {
                    CredentialItem.YesNoType yesNoType = (CredentialItem.YesNoType)this.$item;
                    String string = ((CredentialItem.YesNoType)this.$item).getPromptText();
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    yesNoType.setValue(MessageDialogBuilder.yesNo((String)"", (String)string).show() == 0);
                }
                {
                    this.$item = credentialItem;
                }
            });
            return true;
        }
        if (userNameItem == null && passwordItem == null) {
            return false;
        }
        return this.doGet(uri, userNameItem, passwordItem, sshKeyFile);
    }

    private final boolean doGet(URIish uri, CredentialItem.Username userNameItem, CredentialItem passwordItem, String sshKeyFile) {
        Credentials credentials;
        String userFromUri = sshKeyFile == null ? UtilKt.nullize(uri.getUser()) : (String)null;
        String passwordFromUri = UtilKt.nullize(uri.getPass());
        boolean saveCredentialsToStore = false;
        if (userFromUri != null && passwordFromUri != null) {
            credentials = new Credentials(userFromUri, passwordFromUri);
        } else {
            if (sshKeyFile == null || !OSXKeychainLibraryKt.isOSXCredentialsStoreSupported()) {
                if (this.credentialsFromGit == null) {
                    this.credentialsFromGit = GitCredentialKt.getCredentialsUsingGit(uri, this.repository);
                }
                credentials = this.credentialsFromGit;
            } else {
                credentials = null;
            }
            if (credentials == null) {
                try {
                    credentials = ((CredentialsStore)this.credentialsStore.getValue()).get(uri.getHost(), sshKeyFile);
                }
                catch (Throwable e) {
                    IcsManagerKt.getLOG().error(e);
                }
                saveCredentialsToStore = true;
                if (userFromUri != null) {
                    Credentials credentials2 = credentials;
                    if (Intrinsics.areEqual((Object)userFromUri, (Object)(credentials2 != null ? credentials2.getId() : null)) ^ true) {
                        credentials = new Credentials(userFromUri, passwordFromUri);
                    } else if (passwordFromUri != null) {
                        Credentials credentials3 = credentials;
                        if (Intrinsics.areEqual((Object)passwordFromUri, (Object)(credentials3 != null ? credentials3.getToken() : null)) ^ true) {
                            credentials = new Credentials(userFromUri, passwordFromUri);
                        }
                    }
                }
            }
        }
        if (!org.jetbrains.keychain.CredentialsStoreKt.isFulfilled(credentials)) {
            credentials = CredentialsStoreKt.showAuthenticationForm(credentials, JGitCredentialsProviderKt.toStringWithoutCredentials(uri), uri.getHost(), uri.getPath(), sshKeyFile);
        }
        if (saveCredentialsToStore && org.jetbrains.keychain.CredentialsStoreKt.isFulfilled(credentials)) {
            CredentialsStore credentialsStore2 = (CredentialsStore)this.credentialsStore.getValue();
            String string = uri.getHost();
            Credentials credentials4 = credentials;
            if (credentials4 == null) {
                Intrinsics.throwNpe();
            }
            credentialsStore2.save(string, credentials4, sshKeyFile);
        }
        CredentialItem.Username username = userNameItem;
        if (username != null) {
            Credentials credentials5 = credentials;
            username.setValue(credentials5 != null ? credentials5.getId() : null);
        }
        if (passwordItem != null) {
            if (passwordItem instanceof CredentialItem.Password) {
                Object object = credentials;
                ((CredentialItem.Password)passwordItem).setValue(object != null && (object = ((Credentials)object).getToken()) != null ? StringsKt.toCharArray((String)object) : null);
            } else {
                CredentialItem credentialItem = passwordItem;
                if (credentialItem == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.eclipse.jgit.transport.CredentialItem.StringType");
                }
                Credentials credentials6 = credentials;
                ((CredentialItem.StringType)credentialItem).setValue(credentials6 != null ? credentials6.getToken() : null);
            }
        }
        return credentials != null;
    }

    public void reset(@NotNull URIish uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.credentialsFromGit = null;
        CredentialsStore credentialsStore2 = (CredentialsStore)this.credentialsStore.getValue();
        String string = uri.getHost();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        credentialsStore2.reset(string);
    }

    public JGitCredentialsProvider(@NotNull NotNullLazyValue<CredentialsStore> credentialsStore2, @NotNull Repository repository2) {
        Intrinsics.checkParameterIsNotNull(credentialsStore2, (String)"credentialsStore");
        Intrinsics.checkParameterIsNotNull((Object)repository2, (String)"repository");
        this.credentialsStore = credentialsStore2;
        this.repository = repository2;
    }
}

