/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.Buffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;

public final class Native {
    static final boolean DEBUG_LOAD;
    static final boolean DEBUG_JNA_LOAD;
    static String jnidispatchPath;
    private static Map options;
    private static Map libraries;
    private static final Callback.UncaughtExceptionHandler DEFAULT_HANDLER;
    private static Callback.UncaughtExceptionHandler callbackExceptionHandler;
    public static final int POINTER_SIZE;
    public static final int LONG_SIZE;
    public static final int WCHAR_SIZE;
    public static final int SIZE_T_SIZE;
    static final int MAX_ALIGNMENT;
    static final int MAX_PADDING;
    private static final Object finalizer;
    private static Map registeredClasses;
    private static Map registeredLibraries;
    private static Object unloader;
    private static Map nativeThreads;
    private static ThreadLocal nativeThreadTerminationFlag;

    private static void dispose() {
        NativeLibrary.disposeAll();
        jnidispatchPath = null;
    }

    static boolean deleteLibrary(File lib) {
        if (lib.delete()) {
            return true;
        }
        Native.markTemporaryFile(lib);
        return false;
    }

    private Native() {
    }

    private static native void initIDs();

    public static synchronized native void setProtected(boolean var0);

    public static Pointer getDirectBufferPointer(Buffer b) {
        long peer = Native._getDirectBufferPointer(b);
        return peer == 0L ? null : new Pointer(peer);
    }

    private static native long _getDirectBufferPointer(Buffer var0);

    public static Object loadLibrary(String name, Class interfaceClass) {
        return Native.loadLibrary(name, interfaceClass, Collections.EMPTY_MAP);
    }

    public static Object loadLibrary(String name, Class interfaceClass, Map options) {
        Library.Handler handler2 = new Library.Handler(name, interfaceClass, options);
        ClassLoader loader = interfaceClass.getClassLoader();
        Library proxy = (Library)Proxy.newProxyInstance(loader, new Class[]{interfaceClass}, (InvocationHandler)handler2);
        Native.cacheOptions(interfaceClass, options, proxy);
        return proxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadLibraryInstance(Class cls) {
        Map map2 = libraries;
        synchronized (map2) {
            if (cls != null && !libraries.containsKey(cls)) {
                try {
                    Field[] fields2 = cls.getFields();
                    for (int i = 0; i < fields2.length; ++i) {
                        Field field = fields2[i];
                        if (field.getType() != cls || !Modifier.isStatic(field.getModifiers())) continue;
                        libraries.put(cls, new WeakReference<Object>(field.get(null)));
                        break;
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Could not access instance of " + cls + " (" + e + ")");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class findEnclosingLibraryClass(Class cls) {
        Class<?> declaring;
        Class fromDeclaring;
        if (cls == null) {
            return null;
        }
        Map map2 = libraries;
        synchronized (map2) {
            if (options.containsKey(cls)) {
                return cls;
            }
        }
        if (Library.class.isAssignableFrom(cls)) {
            return cls;
        }
        if (Callback.class.isAssignableFrom(cls)) {
            cls = CallbackReference.findCallbackClass(cls);
        }
        if ((fromDeclaring = Native.findEnclosingLibraryClass(declaring = cls.getDeclaringClass())) != null) {
            return fromDeclaring;
        }
        return Native.findEnclosingLibraryClass(cls.getSuperclass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map getLibraryOptions(Class type2) {
        Map map2 = libraries;
        synchronized (map2) {
            if (options.containsKey(type2)) {
                return (Map)options.get(type2);
            }
        }
        Class mappingClass = Native.findEnclosingLibraryClass(type2);
        if (mappingClass != null) {
            Native.loadLibraryInstance(mappingClass);
        } else {
            mappingClass = type2;
        }
        Map map3 = libraries;
        synchronized (map3) {
            if (options.containsKey(mappingClass)) {
                Map libraryOptions = (Map)options.get(mappingClass);
                options.put(type2, libraryOptions);
                return libraryOptions;
            }
            Map<String, Object> libraryOptions = null;
            try {
                Field field = mappingClass.getField("OPTIONS");
                field.setAccessible(true);
                libraryOptions = (Map)field.get(null);
            }
            catch (NoSuchFieldException e) {
                libraryOptions = Collections.EMPTY_MAP;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("OPTIONS must be a public field of type java.util.Map (" + e + "): " + mappingClass);
            }
            libraryOptions = new HashMap(libraryOptions);
            if (!libraryOptions.containsKey("type-mapper")) {
                libraryOptions.put("type-mapper", Native.lookupField(mappingClass, "TYPE_MAPPER", TypeMapper.class));
            }
            if (!libraryOptions.containsKey("structure-alignment")) {
                libraryOptions.put("structure-alignment", Native.lookupField(mappingClass, "STRUCTURE_ALIGNMENT", Integer.class));
            }
            if (!libraryOptions.containsKey("string-encoding")) {
                libraryOptions.put("string-encoding", Native.lookupField(mappingClass, "STRING_ENCODING", String.class));
            }
            options.put(mappingClass, libraryOptions);
            if (type2 != mappingClass) {
                options.put(type2, libraryOptions);
            }
            return libraryOptions;
        }
    }

    private static Object lookupField(Class mappingClass, String fieldName, Class resultClass) {
        try {
            Field field = mappingClass.getField(fieldName);
            field.setAccessible(true);
            return field.get(null);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(fieldName + " must be a public field of type " + resultClass.getName() + " (" + e + "): " + mappingClass);
        }
    }

    public static TypeMapper getTypeMapper(Class cls) {
        return (TypeMapper)Native.getLibraryOptions(cls).get("type-mapper");
    }

    public static String getStringEncoding(Class cls) {
        String encoding = (String)Native.getLibraryOptions(cls).get("string-encoding");
        return encoding != null ? encoding : Native.getDefaultStringEncoding();
    }

    public static String getDefaultStringEncoding() {
        return System.getProperty("jna.encoding", "utf8");
    }

    public static int getStructureAlignment(Class cls) {
        Integer alignment = (Integer)Native.getLibraryOptions(cls).get("structure-alignment");
        return alignment == null ? 0 : alignment;
    }

    static byte[] getBytes(String s, String encoding) {
        if (encoding != null) {
            try {
                return s.getBytes(encoding);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("JNA Warning: Encoding '" + encoding + "' is unsupported");
            }
        }
        System.err.println("JNA Warning: Encoding with fallback " + System.getProperty("file.encoding"));
        return s.getBytes();
    }

    private static void loadNativeDispatchLibrary() {
        if (!Boolean.getBoolean("jna.nounpack")) {
            try {
                Native.removeTemporaryFiles();
            }
            catch (IOException e) {
                System.err.println("JNA Warning: IOException removing temporary files: " + e.getMessage());
            }
        }
        String libName = System.getProperty("jna.boot.library.name", "jnidispatch");
        String bootPath = System.getProperty("jna.boot.library.path");
        if (bootPath != null) {
            StringTokenizer dirs = new StringTokenizer(bootPath, File.pathSeparator);
            while (dirs.hasMoreTokens()) {
                String ext;
                String orig;
                String dir = dirs.nextToken();
                File file = new File(new File(dir), System.mapLibraryName(libName).replace(".dylib", ".jnilib"));
                String path = file.getAbsolutePath();
                if (DEBUG_JNA_LOAD) {
                    System.out.println("Looking in " + path);
                }
                if (file.exists()) {
                    try {
                        if (DEBUG_JNA_LOAD) {
                            System.out.println("Trying " + path);
                        }
                        System.setProperty("jnidispatch.path", path);
                        System.load(path);
                        jnidispatchPath = path;
                        if (DEBUG_JNA_LOAD) {
                            System.out.println("Found jnidispatch at " + path);
                        }
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        // empty catch block
                    }
                }
                if (!Platform.isMac()) continue;
                if (path.endsWith("dylib")) {
                    orig = "dylib";
                    ext = "jnilib";
                } else {
                    orig = "jnilib";
                    ext = "dylib";
                }
                path = path.substring(0, path.lastIndexOf(orig)) + ext;
                if (DEBUG_JNA_LOAD) {
                    System.out.println("Looking in " + path);
                }
                if (!new File(path).exists()) continue;
                try {
                    if (DEBUG_JNA_LOAD) {
                        System.out.println("Trying " + path);
                    }
                    System.setProperty("jnidispatch.path", path);
                    System.load(path);
                    jnidispatchPath = path;
                    if (DEBUG_JNA_LOAD) {
                        System.out.println("Found jnidispatch at " + path);
                    }
                    return;
                }
                catch (UnsatisfiedLinkError ex) {
                    System.err.println("File found at " + path + " but not loadable: " + ex.getMessage());
                }
            }
        }
        if (!Boolean.getBoolean("jna.nosys")) {
            try {
                if (DEBUG_JNA_LOAD) {
                    System.out.println("Trying (via loadLibrary) " + libName);
                }
                System.loadLibrary(libName);
                if (DEBUG_JNA_LOAD) {
                    System.out.println("Found jnidispatch on system path");
                }
                return;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        if (Boolean.getBoolean("jna.noclasspath")) {
            throw new UnsatisfiedLinkError("Unable to locate JNA native support library");
        }
        Native.loadNativeDispatchLibraryFromClasspath();
    }

    private static void loadNativeDispatchLibraryFromClasspath() {
        try {
            String libName = "/com/sun/jna/" + Platform.RESOURCE_PREFIX + "/" + System.mapLibraryName("jnidispatch").replace(".dylib", ".jnilib");
            File lib = Native.extractFromResourcePath(libName, Native.class.getClassLoader());
            if (lib == null && lib == null) {
                throw new UnsatisfiedLinkError("Could not find JNA native support");
            }
            if (DEBUG_JNA_LOAD) {
                System.out.println("Trying " + lib.getAbsolutePath());
            }
            System.setProperty("jnidispatch.path", lib.getAbsolutePath());
            System.load(lib.getAbsolutePath());
            jnidispatchPath = lib.getAbsolutePath();
            if (DEBUG_JNA_LOAD) {
                System.out.println("Found jnidispatch at " + jnidispatchPath);
            }
            if (Native.isUnpacked(lib) && !Boolean.getBoolean("jnidispatch.preserve")) {
                Native.deleteLibrary(lib);
            }
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
    }

    static boolean isUnpacked(File file) {
        return file.getName().startsWith("jna");
    }

    public static File extractFromResourcePath(String name, ClassLoader loader) throws IOException {
        URL url;
        String resourcePath;
        boolean DEBUG;
        boolean bl = DEBUG = DEBUG_LOAD || DEBUG_JNA_LOAD && name.indexOf("jnidispatch") != -1;
        if (loader == null && (loader = Thread.currentThread().getContextClassLoader()) == null) {
            loader = Native.class.getClassLoader();
        }
        if (DEBUG) {
            System.out.println("Looking in classpath from " + loader + " for " + name);
        }
        String libname = name.startsWith("/") ? name : NativeLibrary.mapSharedLibraryName(name);
        String string = resourcePath = name.startsWith("/") ? name : Platform.RESOURCE_PREFIX + "/" + libname;
        if (resourcePath.startsWith("/")) {
            resourcePath = resourcePath.substring(1);
        }
        if ((url = loader.getResource(resourcePath)) == null && resourcePath.startsWith(Platform.RESOURCE_PREFIX)) {
            url = loader.getResource(libname);
        }
        if (url == null) {
            String path = System.getProperty("java.class.path");
            if (loader instanceof URLClassLoader) {
                path = Arrays.asList(((URLClassLoader)loader).getURLs()).toString();
            }
            throw new IOException("Native library (" + resourcePath + ") not found in resource path (" + path + ")");
        }
        if (DEBUG) {
            System.out.println("Found library resource at " + url);
        }
        File lib = null;
        if (url.getProtocol().toLowerCase().equals("file")) {
            try {
                lib = new File(new URI(url.toString()));
            }
            catch (URISyntaxException e) {
                lib = new File(url.getPath());
            }
            if (DEBUG) {
                System.out.println("Looking in " + lib.getAbsolutePath());
            }
            if (!lib.exists()) {
                throw new IOException("File URL " + url + " could not be properly decoded");
            }
        } else if (!Boolean.getBoolean("jna.nounpack")) {
            InputStream is = loader.getResourceAsStream(resourcePath);
            if (is == null) {
                throw new IOException("Can't obtain InputStream for " + resourcePath);
            }
            FileOutputStream fos = null;
            try {
                int count;
                File dir = Native.getTempDir();
                lib = File.createTempFile("jna", Platform.isWindows() ? ".dll" : null, dir);
                if (!Boolean.getBoolean("jnidispatch.preserve")) {
                    lib.deleteOnExit();
                }
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to create temporary file for " + name + " library: " + e.getMessage());
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return lib;
    }

    private static native int sizeof(int var0);

    private static native String getNativeVersion();

    public static native int getLastError();

    public static String getWebStartLibraryPath(String libName) {
        if (System.getProperty("javawebstart.version") == null) {
            return null;
        }
        try {
            ClassLoader cl = Native.class.getClassLoader();
            Method m = (Method)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        Method m = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                        m.setAccessible(true);
                        return m;
                    }
                    catch (Exception e) {
                        return null;
                    }
                }
            });
            String libpath = (String)m.invoke((Object)cl, libName);
            if (libpath != null) {
                return new File(libpath).getParent();
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static void markTemporaryFile(File file) {
        try {
            File marker = new File(file.getParentFile(), file.getName() + ".x");
            marker.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static File getTempDir() throws IOException {
        File jnatmp;
        String prop = System.getProperty("jna.tmpdir");
        if (prop != null) {
            jnatmp = new File(prop);
            jnatmp.mkdirs();
        } else {
            File tmp = new File(System.getProperty("java.io.tmpdir"));
            jnatmp = new File(tmp, "jna-" + System.getProperty("user.name").hashCode());
            jnatmp.mkdirs();
            if (!jnatmp.exists() || !jnatmp.canWrite()) {
                jnatmp = tmp;
            }
        }
        if (!jnatmp.exists()) {
            throw new IOException("JNA temporary directory '" + jnatmp + "' does not exist");
        }
        if (!jnatmp.canWrite()) {
            throw new IOException("JNA temporary directory '" + jnatmp + "' is not writable");
        }
        return jnatmp;
    }

    static void removeTemporaryFiles() throws IOException {
        File dir = Native.getTempDir();
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".x") && name.startsWith("jna");
            }
        };
        File[] files = dir.listFiles(filter);
        for (int i = 0; files != null && i < files.length; ++i) {
            File marker = files[i];
            String name = marker.getName();
            name = name.substring(0, name.length() - 2);
            File target = new File(marker.getParentFile(), name);
            if (target.exists() && !target.delete()) continue;
            marker.delete();
        }
    }

    public static int getNativeSize(Class type2, Object value) {
        if (type2.isArray()) {
            int len = Array.getLength(value);
            if (len > 0) {
                Object o = Array.get(value, 0);
                return len * Native.getNativeSize(type2.getComponentType(), o);
            }
            throw new IllegalArgumentException("Arrays of length zero not allowed: " + type2);
        }
        if (Structure.class.isAssignableFrom(type2) && !Structure.ByReference.class.isAssignableFrom(type2)) {
            return Structure.size(type2, (Structure)value);
        }
        try {
            return Native.getNativeSize(type2);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("The type \"" + type2.getName() + "\" is not supported: " + e.getMessage());
        }
    }

    public static int getNativeSize(Class cls) {
        if (NativeMapped.class.isAssignableFrom(cls)) {
            cls = NativeMappedConverter.getInstance(cls).nativeType();
        }
        if (cls == Boolean.TYPE || cls == Boolean.class) {
            return 4;
        }
        if (cls == Byte.TYPE || cls == Byte.class) {
            return 1;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return 2;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return 4;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return 8;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return 4;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return 8;
        }
        if (Structure.class.isAssignableFrom(cls)) {
            if (Structure.ByValue.class.isAssignableFrom(cls)) {
                return Structure.size(cls);
            }
            return POINTER_SIZE;
        }
        if (Pointer.class.isAssignableFrom(cls) || Platform.HAS_BUFFERS && Buffers.isBuffer(cls) || Callback.class.isAssignableFrom(cls) || String.class == cls || WString.class == cls) {
            return POINTER_SIZE;
        }
        throw new IllegalArgumentException("Native size for type \"" + cls.getName() + "\" is unknown");
    }

    public static boolean isSupportedNativeType(Class cls) {
        if (Structure.class.isAssignableFrom(cls)) {
            return true;
        }
        try {
            return Native.getNativeSize(cls) != 0;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static Callback.UncaughtExceptionHandler getCallbackExceptionHandler() {
        return callbackExceptionHandler;
    }

    private static native void unregister(Class var0, long[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cacheOptions(Class cls, Map libOptions, Object proxy) {
        libOptions = new HashMap(libOptions);
        Map map2 = libraries;
        synchronized (map2) {
            options.put(cls, libOptions);
            if (proxy != null) {
                libraries.put(cls, new WeakReference<Object>(proxy));
            }
            if (!cls.isInterface() && Library.class.isAssignableFrom(cls)) {
                Class<?>[] ifaces = cls.getInterfaces();
                for (int i = 0; i < ifaces.length; ++i) {
                    if (!Library.class.isAssignableFrom(ifaces[i])) continue;
                    Native.cacheOptions(ifaces[i], libOptions, proxy);
                    break;
                }
            }
        }
    }

    static synchronized native void freeNativeCallback(long var0);

    static synchronized native long createNativeCallback(Callback var0, Method var1, Class[] var2, Class var3, int var4, int var5, String var6);

    static native int invokeInt(long var0, int var2, Object[] var3);

    static native long invokeLong(long var0, int var2, Object[] var3);

    static native void invokeVoid(long var0, int var2, Object[] var3);

    static native float invokeFloat(long var0, int var2, Object[] var3);

    static native double invokeDouble(long var0, int var2, Object[] var3);

    static native long invokePointer(long var0, int var2, Object[] var3);

    private static native void invokeStructure(long var0, int var2, Object[] var3, long var4, long var6);

    static Structure invokeStructure(long fp, int callFlags, Object[] args, Structure s) {
        Native.invokeStructure(fp, callFlags, args, s.getPointer().peer, s.getTypeInfo().peer);
        return s;
    }

    static native Object invokeObject(long var0, int var2, Object[] var3);

    static long open(String name) {
        return Native.open(name, -1);
    }

    static native long open(String var0, int var1);

    static native void close(long var0);

    static native long findSymbol(long var0, String var2);

    static native void read(long var0, byte[] var2, int var3, int var4);

    static native void read(long var0, short[] var2, int var3, int var4);

    static native void read(long var0, char[] var2, int var3, int var4);

    static native void read(long var0, int[] var2, int var3, int var4);

    static native void read(long var0, long[] var2, int var3, int var4);

    static native void read(long var0, float[] var2, int var3, int var4);

    static native void read(long var0, double[] var2, int var3, int var4);

    static native void write(long var0, byte[] var2, int var3, int var4);

    static native void write(long var0, short[] var2, int var3, int var4);

    static native void write(long var0, char[] var2, int var3, int var4);

    static native void write(long var0, int[] var2, int var3, int var4);

    static native void write(long var0, long[] var2, int var3, int var4);

    static native void write(long var0, float[] var2, int var3, int var4);

    static native void write(long var0, double[] var2, int var3, int var4);

    static native byte getByte(long var0);

    static native char getChar(long var0);

    static native short getShort(long var0);

    static native int getInt(long var0);

    static native long getLong(long var0);

    static native float getFloat(long var0);

    static native double getDouble(long var0);

    static Pointer getPointer(long addr) {
        long peer = Native._getPointer(addr);
        return peer == 0L ? null : new Pointer(peer);
    }

    private static native long _getPointer(long var0);

    static native String getWideString(long var0);

    static String getString(long addr, String encoding) {
        byte[] data = Native.getStringBytes(addr);
        if (encoding != null) {
            try {
                return new String(data, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(data);
    }

    static native byte[] getStringBytes(long var0);

    static native void setMemory(long var0, long var2, byte var4);

    static native void setByte(long var0, byte var2);

    static native void setShort(long var0, short var2);

    static native void setChar(long var0, char var2);

    static native void setInt(long var0, int var2);

    static native void setLong(long var0, long var2);

    static native void setFloat(long var0, float var2);

    static native void setDouble(long var0, double var2);

    static native void setPointer(long var0, long var2);

    static native void setWideString(long var0, String var2);

    public static native long malloc(long var0);

    public static native void free(long var0);

    static {
        String version;
        DEBUG_LOAD = Boolean.getBoolean("jna.debug_load");
        DEBUG_JNA_LOAD = Boolean.getBoolean("jna.debug_load.jna");
        jnidispatchPath = null;
        options = new WeakHashMap();
        libraries = new WeakHashMap();
        callbackExceptionHandler = DEFAULT_HANDLER = new Callback.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Callback c, Throwable e) {
                System.err.println("JNA: Callback " + c + " threw the following exception:");
                e.printStackTrace();
            }
        };
        Native.loadNativeDispatchLibrary();
        POINTER_SIZE = Native.sizeof(0);
        LONG_SIZE = Native.sizeof(1);
        WCHAR_SIZE = Native.sizeof(2);
        SIZE_T_SIZE = Native.sizeof(3);
        Native.initIDs();
        if (Boolean.getBoolean("jna.protected")) {
            Native.setProtected(true);
        }
        if (!"4.0.0".equals(version = Native.getNativeVersion())) {
            String LS = System.getProperty("line.separator");
            throw new Error(LS + LS + "There is an incompatible JNA native library installed on this system" + LS + (jnidispatchPath != null ? "(at " + jnidispatchPath + ")" : System.getProperty("java.library.path")) + "." + LS + "To resolve this issue you may do one of the following:" + LS + " - remove or uninstall the offending library" + LS + " - set the system property jna.nosys=true" + LS + " - set jna.boot.library.path to include the path to the version of the " + LS + "   jnidispatch library included with the JNA jar file you are using" + LS);
        }
        MAX_ALIGNMENT = Platform.isSPARC() || Platform.isWindows() || Platform.isLinux() && (Platform.isARM() || Platform.isPPC()) || Platform.isAIX() || Platform.isAndroid() ? 8 : LONG_SIZE;
        MAX_PADDING = Platform.isMac() && Platform.isPPC() ? 8 : MAX_ALIGNMENT;
        finalizer = new Object(){

            protected void finalize() {
                Native.dispose();
            }
        };
        registeredClasses = new HashMap();
        registeredLibraries = new HashMap();
        unloader = new Object(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void finalize() {
                Map map2 = registeredClasses;
                synchronized (map2) {
                    Iterator i = registeredClasses.entrySet().iterator();
                    while (i.hasNext()) {
                        Map.Entry e = i.next();
                        Native.unregister((Class)e.getKey(), (long[])e.getValue());
                        i.remove();
                    }
                }
            }
        };
        nativeThreads = Collections.synchronizedMap(new WeakHashMap());
        nativeThreadTerminationFlag = new ThreadLocal(){

            protected Object initialValue() {
                Memory m = new Memory(4L);
                m.clear();
                return m;
            }
        };
    }

    private static class Buffers {
        static boolean isBuffer(Class cls) {
            return Buffer.class.isAssignableFrom(cls);
        }
    }
}

