/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.inline;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.inline.CoveringTryCatchNodeProcessorKt;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtil;
import org.jetbrains.kotlin.codegen.inline.IntervalMetaInfo;
import org.jetbrains.kotlin.codegen.inline.LocalVarNodeWrapper;
import org.jetbrains.kotlin.codegen.inline.TryCatchBlockNodeInfo;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.IincInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.VarInsnNode;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"Q\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\t\t\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011!Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t!\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005!\u0011!B\u0001\t\f\u0015\tAAA\u0003\u0002\u0019\u0005)\u0001\u0001B\n\r\u0001e\t\u0001\u0014AQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&\u0015!IQ\u0002B\u0005\u0003\u0013\u0005A\u0002\u0002g\u0005\u001a\u0007!QQ\"\u0001M\u000bK)A1\"\u0004\u0003\n\u0005%\t\u0001\u0004\u0003M\n3\rA!\"D\u0001\u0019\u0016\u0015BAa\u0005E\f\u001b\u0005A\u001a!G\u0002\t\u00195\t\u0001\u0014D\u0013\r\t-AQ\"D\u0001\u0019\u001ce\u0019\u0001BD\u0007\u000213I2\u0001#\b\u000e\u0003ayQ%\u0004E\u0010\u001b\u0011I!!C\u0001\u0019\u0011aM\u0011D\u0002\u0005\u0011\u001b\u0011I!!C\u0001\u0019\u0011aMQe\u0002E\u0011\u001b\u0005AZ\"G\u0002\t#5\t\u00014E\u0013\t\t\tA!#D\u0001\u0019\u001ce\u0019\u0001\"E\u0007\u00021GIS\u0002B\"\t\u0011\u000biA!\u0003\u0002\n\u0003a\u001d\u0001dA)\u0004\t\u0015\u0001QB\u0001\u0003\u0005\u0011\u0013I#\u0003B\"\u001d\u0011\u0017i\u0011\u0001g\u0001\u001a\u0007!)Q\"\u0001M\u0002A\u0005\n6aB\u0003\u0001\u001b\t!a\u0001#\u0004\u0012\u0005\u00119\u0001BA\u0015\u000e\t\rC\u0001rB\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0005\u0019\u0007E\u001bA!\u0002\u0001\u000e\u0005\u0011E\u0001\u0012\u0002"}, strings={"Lorg/jetbrains/kotlin/codegen/inline/CoveringTryCatchNodeProcessor;", "", "parameterSize", "", "(I)V", "localVarsMetaInfo", "Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "Lorg/jetbrains/kotlin/codegen/inline/LocalVarNodeWrapper;", "getLocalVarsMetaInfo", "()Lorg/jetbrains/kotlin/codegen/inline/IntervalMetaInfo;", "<set-?>", "nextFreeLocalIndex", "getNextFreeLocalIndex", "()I", "setNextFreeLocalIndex", "tryBlocksMetaInfo", "Lorg/jetbrains/kotlin/codegen/inline/TryCatchBlockNodeInfo;", "getTryBlocksMetaInfo", "getEndNodes", "", "label", "Lorg/jetbrains/org/objectweb/asm/tree/LabelNode;", "getStartNodes", "instructionIndex", "inst", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "processInstruction", "", "curInstr", "directOrder", "", "sortTryCatchBlocks", "intervals", "substituteLocalVarTable", "node", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "substituteTryBlockNodes"}, moduleName="kotlin-compiler")
public abstract class CoveringTryCatchNodeProcessor {
    @NotNull
    private final IntervalMetaInfo<TryCatchBlockNodeInfo> tryBlocksMetaInfo = new IntervalMetaInfo();
    @NotNull
    private final IntervalMetaInfo<LocalVarNodeWrapper> localVarsMetaInfo = new IntervalMetaInfo();
    private int nextFreeLocalIndex;

    @NotNull
    public final IntervalMetaInfo<TryCatchBlockNodeInfo> getTryBlocksMetaInfo() {
        return this.tryBlocksMetaInfo;
    }

    @NotNull
    public final IntervalMetaInfo<LocalVarNodeWrapper> getLocalVarsMetaInfo() {
        return this.localVarsMetaInfo;
    }

    public final int getNextFreeLocalIndex() {
        return this.nextFreeLocalIndex;
    }

    @NotNull
    public final List<TryCatchBlockNodeInfo> getStartNodes(@NotNull LabelNode label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        Collection collection = this.tryBlocksMetaInfo.getIntervalStarts().get((Object)label);
        Intrinsics.checkExpressionValueIsNotNull(collection, "tryBlocksMetaInfo.intervalStarts.get(label)");
        return collection;
    }

    @NotNull
    public final List<TryCatchBlockNodeInfo> getEndNodes(@NotNull LabelNode label) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        Collection collection = this.tryBlocksMetaInfo.getIntervalEnds().get((Object)label);
        Intrinsics.checkExpressionValueIsNotNull(collection, "tryBlocksMetaInfo.intervalEnds.get(label)");
        return collection;
    }

    public void processInstruction(@NotNull AbstractInsnNode curInstr, boolean directOrder) {
        Intrinsics.checkParameterIsNotNull(curInstr, "curInstr");
        if (curInstr instanceof VarInsnNode || curInstr instanceof IincInsnNode) {
            int n;
            int argSize = InlineCodegenUtil.getLoadStoreArgSize(curInstr.getOpcode());
            if (curInstr instanceof VarInsnNode) {
                n = ((VarInsnNode)curInstr).var;
            } else {
                AbstractInsnNode abstractInsnNode = curInstr;
                if (abstractInsnNode == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.IincInsnNode");
                }
                n = ((IincInsnNode)abstractInsnNode).var;
            }
            int varIndex = n;
            this.nextFreeLocalIndex = Math.max(this.nextFreeLocalIndex, varIndex + argSize);
        }
        if (curInstr instanceof LabelNode) {
            this.tryBlocksMetaInfo.processCurrent((LabelNode)curInstr, directOrder);
            this.localVarsMetaInfo.processCurrent((LabelNode)curInstr, directOrder);
        }
    }

    public abstract int instructionIndex(@NotNull AbstractInsnNode var1);

    @NotNull
    public final List<TryCatchBlockNodeInfo> sortTryCatchBlocks(@NotNull List<? extends TryCatchBlockNodeInfo> intervals) {
        Intrinsics.checkParameterIsNotNull(intervals, "intervals");
        Comparator comp2 = new Comparator<TryCatchBlockNodeInfo>(this){
            final /* synthetic */ CoveringTryCatchNodeProcessor this$0;

            /*
             * WARNING - void declaration
             */
            public final int compare(@NotNull TryCatchBlockNodeInfo t1, @NotNull TryCatchBlockNodeInfo t2) {
                void var3_3;
                Intrinsics.checkParameterIsNotNull(t1, "t1");
                Intrinsics.checkParameterIsNotNull(t2, "t2");
                int result2 = this.this$0.instructionIndex(t1.getHandler()) - this.this$0.instructionIndex(t2.getHandler());
                if (result2 == 0 && (result2 = this.this$0.instructionIndex(t1.getStartLabel()) - this.this$0.instructionIndex(t2.getStartLabel())) == 0) {
                    Unit unit;
                    boolean bl = false;
                    if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                        void value;
                        if (value == false) {
                            String message = "Error: support multicatch finallies: " + t1.getHandler() + ", " + t2.getHandler();
                            throw (Throwable)((Object)new AssertionError((Object)message));
                        }
                        unit = Unit.INSTANCE;
                    } else {
                        unit = Unit.INSTANCE;
                    }
                    result2 = this.this$0.instructionIndex(t1.getEndLabel()) - this.this$0.instructionIndex(t2.getEndLabel());
                }
                return (int)var3_3;
            }
            {
                this.this$0 = coveringTryCatchNodeProcessor;
            }
        };
        Collections.sort(intervals, comp2);
        return intervals;
    }

    protected final void substituteTryBlockNodes(@NotNull MethodNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        node.tryCatchBlocks.clear();
        this.sortTryCatchBlocks((List<? extends TryCatchBlockNodeInfo>)this.tryBlocksMetaInfo.getAllIntervals());
        for (TryCatchBlockNodeInfo info : CoveringTryCatchNodeProcessorKt.getMeaningfulIntervals(this.tryBlocksMetaInfo)) {
            node.tryCatchBlocks.add(info.getNode());
        }
    }

    public final void substituteLocalVarTable(@NotNull MethodNode node) {
        Intrinsics.checkParameterIsNotNull(node, "node");
        node.localVariables.clear();
        for (LocalVarNodeWrapper info : CoveringTryCatchNodeProcessorKt.getMeaningfulIntervals(this.localVarsMetaInfo)) {
            node.localVariables.add(info.getNode());
        }
    }

    public CoveringTryCatchNodeProcessor(int parameterSize) {
        this.nextFreeLocalIndex = parameterSize;
    }
}

