/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.rmi.registry.Registry;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import kotlin.ArraysKt;
import kotlin.CollectionsKt;
import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.StringsKt;
import kotlin.Unit;
import kotlin.concurrent.TimersKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.ConsoleKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.js.K2JSCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.daemon.CompileServiceImpl;
import org.jetbrains.kotlin.daemon.CompilerSelector;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon$WhenMappings;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon$log$1;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon$main$compilerSelector$1$js$1;
import org.jetbrains.kotlin.daemon.KotlinCompileDaemon$main$compilerSelector$1$jvm$1;
import org.jetbrains.kotlin.daemon.LogStream;
import org.jetbrains.kotlin.daemon.common.CompileService;
import org.jetbrains.kotlin.daemon.common.CompilerId;
import org.jetbrains.kotlin.daemon.common.DaemonJVMOptions;
import org.jetbrains.kotlin.daemon.common.DaemonOptions;
import org.jetbrains.kotlin.daemon.common.DaemonParamsKt;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.OptionsGroup;

@KotlinClass(version={1, 0, 0}, abiVersion=32, data={"'\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0003\u0004\u000b\u0005Aq!\u0002\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0011#)\u0001\u0001B2\u0002\u0019\u0001I\u0012\u0001'\u0001\"\b\u0011\t\u0011kA\u0001\t\u0003\u0015*A!\u0001\u0005\u0006\u001b\ta\t\u0001g\u0003&\u001c\u0011\u001d\u0001BB\u0007\u00021\u001bIb\u0001C\u0004\u000e\t%\u0011\u0011\"\u0001M\u00061\u001f\t6!\u0001\u0005\tSE!1\t\u0003E\u0002\u001b\u0015\u0001*!\u0006\u0002\r\u0002a\u0011\u0001D\u0001\u000f$#\u000e1QA\u0001\u0003\u0005\u0011\u0013i!\u0001B\u0002\t\b\u0001"}, strings={"Lorg/jetbrains/kotlin/daemon/KotlinCompileDaemon;", "", "()V", "log", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Ljava/util/logging/Logger;", "log$delegate", "Lkotlin/Lazy;", "loadVersionFromResource", "", "main", "", "args", "", "([Ljava/lang/String;)V"}, moduleName="kotlin-compiler")
public final class KotlinCompileDaemon {
    private static final Lazy<? extends Logger> log$delegate;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;
    public static final KotlinCompileDaemon INSTANCE;
    public static final KotlinCompileDaemon INSTANCE$;

    public final Logger getLog() {
        return LazyKt.getValue(log$delegate, this, $$delegatedProperties[0]);
    }

    private final String loadVersionFromResource() {
        Unit unit;
        Object object;
        ClassLoader classLoader = KotlinCompileDaemon.class.getClassLoader();
        if (!(classLoader instanceof URLClassLoader)) {
            classLoader = null;
        }
        if ((object = (URLClassLoader)classLoader) != null && (object = ((URLClassLoader)object).findResource("META-INF/MANIFEST.MF")) != null) {
            Object $receiver = object;
            URL it = (URL)$receiver;
            try {
                String string = new Manifest(it.openStream()).getMainAttributes().getValue("Implementation-Version");
                if (string == null) {
                    string = null;
                }
                return string;
            }
            catch (IOException iOException) {
                unit = Unit.INSTANCE;
            }
        } else {
            unit = null;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Logger logger = INSTANCE.getLog();
        StringBuilder stringBuilder = new StringBuilder().append("Kotlin compiler daemon version ");
        String string = INSTANCE.loadVersionFromResource();
        if (string == null) {
            string = "<unknown>";
        }
        logger.info(stringBuilder.append((Object)string).toString());
        INSTANCE.getLog().info("daemon JVM args: " + CollectionsKt.joinToString$default((Iterable)ManagementFactory.getRuntimeMXBean().getInputArguments(), (CharSequence)" ", null, null, 0, null, null, 62));
        INSTANCE.getLog().info("daemon args: " + ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, 0, null, null, 62));
        CompilerId compilerId = new CompilerId(null, null, 3, null);
        DaemonOptions daemonOptions = new DaemonOptions(null, 0L, 0, 0, 0L, 0L, false, false, 255, null);
        try {
            void port;
            void registry;
            Object helpLine;
            String[] stringArray = new String[]{};
            boolean bl = true;
            boolean bl2 = true;
            DaemonJVMOptions daemonJVMOptions = DaemonParamsKt.configureDaemonJVMOptions(stringArray, bl2, bl);
            OptionsGroup[] optionsGroupArray = new OptionsGroup[]{compilerId, daemonOptions};
            String string2 = DaemonParamsKt.getCOMPILE_DAEMON_CMDLINE_OPTIONS_PREFIX();
            Iterable<String> filteredArgs = DaemonParamsKt.filterExtractProps(ArraysKt.asIterable((Object[])args), optionsGroupArray, string2);
            if (CollectionsKt.any(filteredArgs)) {
                helpLine = "usage: <daemon> <compilerId options> <daemon options>";
                INSTANCE.getLog().info((String)helpLine);
                ConsoleKt.println(helpLine);
                throw (Throwable)new IllegalArgumentException("Unknown arguments: " + CollectionsKt.joinToString$default(filteredArgs, (CharSequence)" ", null, null, 0, null, null, 62));
            }
            INSTANCE.getLog().info("starting daemon");
            Pair<Registry, Integer> pair = NetworkUtilsKt.findPortAndCreateRegistry(DaemonParamsKt.getCOMPILE_DAEMON_FIND_PORT_ATTEMPTS(), DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_START(), DaemonParamsKt.getCOMPILE_DAEMON_PORTS_RANGE_END());
            helpLine = pair.component1();
            int n = ((Number)pair.component2()).intValue();
            pair = null;
            CompilerSelector compilerSelector2 = new CompilerSelector(){
                private final Lazy<? extends K2JVMCompiler> jvm$delegate;
                private final Lazy<? extends K2JSCompiler> js$delegate;
                private static final /* synthetic */ KProperty[] $$delegatedProperties;

                private final K2JVMCompiler getJvm() {
                    return LazyKt.getValue(this.jvm$delegate, this, $$delegatedProperties[0]);
                }

                private final K2JSCompiler getJs() {
                    return LazyKt.getValue(this.js$delegate, this, $$delegatedProperties[1]);
                }

                @NotNull
                public CLICompiler<?> get(@NotNull CompileService.TargetPlatform targetPlatform) {
                    CLICompiler cLICompiler;
                    Intrinsics.checkParameterIsNotNull(targetPlatform, "targetPlatform");
                    switch (KotlinCompileDaemon$WhenMappings.$EnumSwitchMapping$0[targetPlatform.ordinal()]) {
                        case 1: {
                            cLICompiler = this.getJvm();
                            break;
                        }
                        case 2: {
                            cLICompiler = this.getJs();
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    return cLICompiler;
                }

                static {
                    $$delegatedProperties = new KProperty[]{KotlinCompileDaemon$main$compilerSelector$1$jvm$1.INSTANCE, KotlinCompileDaemon$main$compilerSelector$1$js$1.INSTANCE};
                }
                {
                    this.jvm$delegate = LazyKt.lazy(main.compilerSelector.jvm.2.INSTANCE);
                    this.js$delegate = LazyKt.lazy(main.compilerSelector.js.2.INSTANCE);
                }

                @NotNull
                public static final /* synthetic */ K2JVMCompiler access$getJvm$p(main.compilerSelector.1 $this) {
                    return $this.getJvm();
                }

                @NotNull
                public static final /* synthetic */ K2JSCompiler access$getJs$p(main.compilerSelector.1 $this) {
                    return $this.getJs();
                }
            };
            Timer timer = new Timer(true);
            CompileServiceImpl compilerService2 = new CompileServiceImpl((Registry)registry, compilerSelector2, compilerId, daemonOptions, daemonJVMOptions, (int)port, timer, (Function0<? extends Unit>)new Function0<Unit>(daemonOptions, timer){
                final /* synthetic */ DaemonOptions $daemonOptions;
                final /* synthetic */ Timer $timer;

                public final void invoke() {
                    if (this.$daemonOptions.getForceShutdownTimeoutMilliseconds() != DaemonParamsKt.getCOMPILE_DAEMON_TIMEOUT_INFINITE_MS()) {
                        TimersKt.schedule(this.$timer, this.$daemonOptions.getForceShutdownTimeoutMilliseconds(), (Function1<? super TimerTask, ? extends Unit>)main.compilerService.1.INSTANCE);
                    } else {
                        this.$timer.cancel();
                    }
                }
                {
                    this.$daemonOptions = daemonOptions;
                    this.$timer = timer;
                    super(0);
                }
            });
            if (StringsKt.isNotEmpty((CharSequence)daemonOptions.getRunFilesPath())) {
                ConsoleKt.println(daemonOptions.getRunFilesPath());
            }
            System.out.close();
            System.err.close();
            System.setErr(new PrintStream(new LogStream("stderr")));
            System.setOut(new PrintStream(new LogStream("stdout")));
        }
        catch (Exception e) {
            System.err.println("Exception: " + e.getMessage());
            Throwable throwable = e;
            PrintStream printStream = System.err;
            Intrinsics.checkExpressionValueIsNotNull(printStream, "System.err");
            ExceptionsKt.printStackTrace(throwable, printStream);
            INSTANCE.getLog().log(Level.INFO, "Exception: ", e);
            throw (Throwable)e;
        }
    }

    static {
        $$delegatedProperties = new KProperty[]{KotlinCompileDaemon$log$1.INSTANCE};
        new KotlinCompileDaemon();
    }

    /*
     * WARNING - void declaration
     */
    private KotlinCompileDaemon() {
        void logPath;
        void fileIsGiven;
        Pair<String, Boolean> pair;
        INSTANCE = this;
        INSTANCE$ = this;
        String string = new SimpleDateFormat("yyyy-MM-dd.HH-mm-ss-SSS").format(new Date());
        Intrinsics.checkExpressionValueIsNotNull(string, "SimpleDateFormat(\"yyyy-M\u2026m-ss-SSS\").format(Date())");
        String logTime = string;
        String string2 = System.getProperty(DaemonParamsKt.getCOMPILE_DAEMON_LOG_PATH_PROPERTY());
        if (string2 != null && (string2 = DaemonParamsKt.trimQuotes(string2)) != null) {
            void $receiver;
            String string3 = string2;
            String it = (String)$receiver;
            pair = new Pair<String, Boolean>(it, new File(it).isFile());
        } else {
            pair = new Pair<String, Boolean>("%t", false);
        }
        Pair<String, Boolean> pair2 = pair;
        String string4 = pair2.component1();
        boolean bl = pair2.component2();
        pair2 = null;
        String cfg = "handlers = java.util.logging.FileHandler\n" + "java.util.logging.FileHandler.level     = ALL\n" + "java.util.logging.FileHandler.formatter = java.util.logging.SimpleFormatter\n" + "java.util.logging.FileHandler.encoding  = UTF-8\n" + ("java.util.logging.FileHandler.limit     = " + (fileIsGiven != false ? 0 : 1 << 20) + "\n") + ("java.util.logging.FileHandler.count     = " + (fileIsGiven != false ? 1 : 3) + "\n") + ("java.util.logging.FileHandler.append    = " + (boolean)fileIsGiven + "\n") + ("java.util.logging.FileHandler.pattern   = " + (String)(fileIsGiven != false ? logPath : (String)logPath + File.separator + (DaemonParamsKt.getCOMPILE_DAEMON_DEFAULT_FILES_PREFIX() + "." + logTime + ".%u%g.log")) + "\n") + "java.util.logging.SimpleFormatter.format = %1$tF %1$tT.%1$tL [%3$s] %4$s: %5$s\\n\n";
        LogManager.getLogManager().readConfiguration(ByteStreamsKt.byteInputStream$default(cfg, null, 1));
        log$delegate = LazyKt.lazy(log.2.INSTANCE);
    }
}

