/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.CollectionsKt;
import kotlin.IntRange;
import kotlin.MapsKt;
import kotlin.NoWhenBranchMatchedException;
import kotlin.SetsKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.resolve.calls.inference.CapturedType;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintContext;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemUtilsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBounds;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsImpl;
import org.jetbrains.kotlin.resolve.calls.inference.TypeBoundsKt;
import org.jetbrains.kotlin.resolve.calls.inference.TypeVariable;
import org.jetbrains.kotlin.resolve.calls.inference.constraintPosition.CompoundConstraintPosition;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeProjectionImpl;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typesApproximation.ApproximationBounds;
import org.jetbrains.kotlin.types.typesApproximation.CapturedTypeApproximationKt;

@KotlinFileFacade(version={1, 0, 0}, abiVersion=32, data={"\u0015\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001C\u0004\u001bK!\u0011\u0001\u0003\u0001\u000e\u0003a\u0005Q#\u0001\r\u00023\u0013A\u0019!D\u0001\u0019\u0005A\u001b\t!'\u0003\t\u00065\t\u0001D\u0001)\u0004\u0003Q\u001b1!$\n\u0005\u0003!\u001dQ\"\u0001M\u0001+\u0005A\u0012!'\u0003\t\t5\t\u0001D\u0001)\u0004\u0002e%\u0001\u0012B\u0007\u00021\t\u00016!\u0001+\u0004\u00075a\u0001\"B\u0007\u00021\u0003)\u0012\u0001G\u0001\u001a\n!-Q\"\u0001\r\u0003!\u000e\u0005AkA\u0002"}, strings={"addConstraintFromBounds", "", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilderImpl;", "old", "Lorg/jetbrains/kotlin/resolve/calls/inference/TypeBounds$Bound;", "new", "ConstraintIncorporationKt", "generateNewBound", "bound", "substitution", "incorporateBound", "newBound"}, moduleName="kotlin-compiler")
public final class ConstraintIncorporationKt {
    /*
     * WARNING - void declaration
     */
    public static final void incorporateBound(ConstraintSystemBuilderImpl $receiver, @NotNull TypeBounds.Bound newBound) {
        void $receiver2;
        KotlinType constrainingType;
        List<TypeBounds.Bound> list;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(newBound, "newBound");
        TypeVariable typeVariable = newBound.getTypeVariable();
        TypeBoundsImpl typeBounds = $receiver.getTypeBounds$kotlin_compiler(typeVariable);
        IntRange intRange = CollectionsKt.getIndices(typeBounds.getBounds());
        int n = intRange.getFirst();
        int n2 = intRange.getLast();
        if (n <= n2) {
            while (true) {
                void oldBoundIndex;
                TypeBounds.Bound bound = (TypeBounds.Bound)((ArrayList)typeBounds.getBounds()).get((int)oldBoundIndex);
                Intrinsics.checkExpressionValueIsNotNull(bound, "typeBounds.bounds[oldBoundIndex]");
                ConstraintIncorporationKt.addConstraintFromBounds($receiver, bound, newBound);
                if (oldBoundIndex == n2) break;
                ++oldBoundIndex;
            }
        }
        if ((list = $receiver.getUsedInBounds$kotlin_compiler().get(typeVariable)) == null) {
            list = CollectionsKt.emptyList();
        }
        List<TypeBounds.Bound> boundsUsedIn = list;
        IntRange intRange2 = CollectionsKt.getIndices((Collection)boundsUsedIn);
        n2 = intRange2.getFirst();
        int n3 = intRange2.getLast();
        if (n2 <= n3) {
            while (true) {
                void index2;
                TypeBounds.Bound boundUsedIn = boundsUsedIn.get((int)index2);
                ConstraintIncorporationKt.generateNewBound($receiver, boundUsedIn, newBound);
                if (index2 == n3) break;
                ++index2;
            }
        }
        if ($receiver.isMyTypeVariable$kotlin_compiler(constrainingType = newBound.getConstrainingType())) {
            ConstraintContext context = new ConstraintContext(newBound.getPosition(), newBound.getDerivedFrom(), false, 4, null);
            TypeVariable typeVariable2 = $receiver.getMyTypeVariable$kotlin_compiler(constrainingType);
            if (typeVariable2 == null) {
                Intrinsics.throwNpe();
            }
            $receiver.addBound$kotlin_compiler(typeVariable2, typeVariable.getType(), TypeBoundsKt.reverse(newBound.getKind()), context);
            return;
        }
        Iterable context = $receiver.getNestedTypeVariables$kotlin_compiler(constrainingType);
        for (Object element : $receiver2) {
            int n4;
            TypeVariable it2 = (TypeVariable)element;
            Collection boundsForNestedVariable = $receiver.getTypeBounds$kotlin_compiler(it2).getBounds();
            IntRange intRange3 = CollectionsKt.getIndices(boundsForNestedVariable);
            int n5 = intRange3.getFirst();
            if (n5 > (n4 = intRange3.getLast())) continue;
            while (true) {
                void index3;
                TypeBounds.Bound bound = (TypeBounds.Bound)((ArrayList)boundsForNestedVariable).get((int)index3);
                Intrinsics.checkExpressionValueIsNotNull(bound, "boundsForNestedVariable[index]");
                ConstraintIncorporationKt.generateNewBound($receiver, newBound, bound);
                if (index3 == n4) break;
                ++index3;
            }
        }
    }

    private static final void addConstraintFromBounds(ConstraintSystemBuilderImpl $receiver, TypeBounds.Bound old, TypeBounds.Bound bound) {
        if (Intrinsics.areEqual(old, bound)) {
            return;
        }
        KotlinType oldType = old.getConstrainingType();
        KotlinType newType = bound.getConstrainingType();
        ConstraintContext context = new ConstraintContext(new CompoundConstraintPosition(old.getPosition(), bound.getPosition()), SetsKt.plus(old.getDerivedFrom(), (Iterable)bound.getDerivedFrom()), false, 4, null);
        if (old.getKind().ordinal() < bound.getKind().ordinal()) {
            $receiver.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, oldType, newType, context);
        } else if (old.getKind().ordinal() > bound.getKind().ordinal()) {
            $receiver.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.SUB_TYPE, newType, oldType, context);
        } else if (Intrinsics.areEqual((Object)old.getKind(), (Object)bound.getKind()) && Intrinsics.areEqual((Object)old.getKind(), (Object)TypeBounds.BoundKind.EXACT_BOUND)) {
            $receiver.addConstraint(ConstraintSystemBuilderImpl.ConstraintKind.EQUAL, oldType, newType, context);
        }
    }

    private static final void generateNewBound(ConstraintSystemBuilderImpl $receiver, TypeBounds.Bound bound, TypeBounds.Bound substitution) {
        KotlinType kotlinType;
        TypeBounds.BoundKind boundKind = substitution.getKind();
        if (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.EXACT_BOUND)) {
            kotlinType = substitution.getConstrainingType();
        } else if (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.UPPER_BOUND)) {
            kotlinType = new CapturedType(new TypeProjectionImpl(Variance.OUT_VARIANCE, substitution.getConstrainingType()));
        } else if (Intrinsics.areEqual((Object)boundKind, (Object)TypeBounds.BoundKind.LOWER_BOUND)) {
            kotlinType = new CapturedType(new TypeProjectionImpl(Variance.IN_VARIANCE, substitution.getConstrainingType()));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        KotlinType substitutedType = kotlinType;
        TypeProjectionImpl newTypeProjection = new TypeProjectionImpl(substitutedType);
        TypeSubstitutor substitutor2 = TypeSubstitutor.create(MapsKt.mapOf(TuplesKt.to(substitution.getTypeVariable().getType().getConstructor(), newTypeProjection)));
        KotlinType kotlinType2 = substitutor2.substitute(bound.getConstrainingType(), Variance.INVARIANT);
        if (kotlinType2 == null) {
            return;
        }
        KotlinType type2 = kotlinType2;
        CompoundConstraintPosition position = new CompoundConstraintPosition(bound.getPosition(), substitution.getPosition());
        Function2<KotlinType, TypeBounds.BoundKind, Unit> addNewBound$ = new Function2<KotlinType, TypeBounds.BoundKind, Unit>($receiver, bound, substitution, position){
            final /* synthetic */ ConstraintSystemBuilderImpl receiver$0;
            final /* synthetic */ TypeBounds.Bound $bound;
            final /* synthetic */ TypeBounds.Bound $substitution;
            final /* synthetic */ CompoundConstraintPosition $position;

            public final void invoke(@NotNull KotlinType newConstrainingType, @NotNull TypeBounds.BoundKind newBoundKind) {
                Intrinsics.checkParameterIsNotNull(newConstrainingType, "newConstrainingType");
                Intrinsics.checkParameterIsNotNull((Object)((Object)newBoundKind), "newBoundKind");
                if (this.receiver$0.getNestedTypeVariables$kotlin_compiler(newConstrainingType).contains(this.$bound.getTypeVariable())) {
                    return;
                }
                HashSet<TypeVariable> derivedFrom = new HashSet<TypeVariable>((Collection)SetsKt.plus(this.$bound.getDerivedFrom(), (Iterable)this.$substitution.getDerivedFrom()));
                if (derivedFrom.contains(this.$substitution.getTypeVariable())) {
                    return;
                }
                derivedFrom.add(this.$substitution.getTypeVariable());
                this.receiver$0.addBound$kotlin_compiler(this.$bound.getTypeVariable(), newConstrainingType, newBoundKind, new ConstraintContext(this.$position, derivedFrom, false, 4, null));
            }
            {
                this.receiver$0 = constraintSystemBuilderImpl;
                this.$bound = bound;
                this.$substitution = bound2;
                this.$position = compoundConstraintPosition;
                super(2);
            }
        };
        if (Intrinsics.areEqual((Object)substitution.getKind(), (Object)TypeBounds.BoundKind.EXACT_BOUND)) {
            KotlinType kotlinType3 = type2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "type");
            addNewBound$.invoke(kotlinType3, bound.getKind());
            return;
        }
        KotlinType kotlinType4 = type2;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "type");
        ApproximationBounds<KotlinType> approximationBounds = CapturedTypeApproximationKt.approximateCapturedTypes(kotlinType4);
        Function1<KotlinType, Boolean> containsConstrainingTypeWithoutProjection$ = new Function1<KotlinType, Boolean>(substitution){
            final /* synthetic */ TypeBounds.Bound $substitution;

            public final boolean invoke(KotlinType $receiver) {
                boolean bl;
                block1: {
                    Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
                    Iterable $receiver2 = ConstraintSystemUtilsKt.getNestedArguments($receiver);
                    for (T element : $receiver2) {
                        TypeProjection it2 = (TypeProjection)element;
                        if (!(Intrinsics.areEqual(it2.getType().getConstructor(), this.$substitution.getConstrainingType().getConstructor()) && Intrinsics.areEqual((Object)((Object)it2.getProjectionKind()), (Object)((Object)Variance.INVARIANT)))) continue;
                        bl = true;
                        break block1;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                this.$substitution = bound;
                super(1);
            }
        };
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getUpper()) && Intrinsics.areEqual((Object)bound.getKind(), (Object)TypeBounds.BoundKind.LOWER_BOUND) ^ true) {
            addNewBound$.invoke(approximationBounds.getUpper(), TypeBounds.BoundKind.UPPER_BOUND);
        }
        if (containsConstrainingTypeWithoutProjection$.invoke(approximationBounds.getLower()) && Intrinsics.areEqual((Object)bound.getKind(), (Object)TypeBounds.BoundKind.UPPER_BOUND) ^ true) {
            addNewBound$.invoke(approximationBounds.getLower(), TypeBounds.BoundKind.LOWER_BOUND);
        }
    }
}

