/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.renderers;

import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.AtomTreeNode;
import com.android.tools.idea.editors.gfxtrace.controllers.modeldata.EnumInfoCache;
import com.android.tools.idea.editors.gfxtrace.schema.AtomReader;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class AtomTreeRenderer
extends ColoredTreeCellRenderer {
    private EnumInfoCache myEnumInfoCache;
    private AtomReader myAtomReader;

    public void init(@NotNull EnumInfoCache enumInfoCache, @NotNull AtomReader atomReader) {
        if (enumInfoCache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "enumInfoCache", "com/android/tools/idea/editors/gfxtrace/renderers/AtomTreeRenderer", "init"));
        }
        if (atomReader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atomReader", "com/android/tools/idea/editors/gfxtrace/renderers/AtomTreeRenderer", "init"));
        }
        this.myEnumInfoCache = enumInfoCache;
        this.myAtomReader = atomReader;
    }

    public void clearState() {
        this.myEnumInfoCache = null;
        this.myAtomReader = null;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/editors/gfxtrace/renderers/AtomTreeRenderer", "customizeCellRenderer"));
        }
        assert (value != null && value instanceof DefaultMutableTreeNode);
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)value;
        Object userObject = treeNode.getUserObject();
        assert (userObject instanceof AtomTreeNode);
        List<AtomTreeNode.TextPiece> textPieceList = ((AtomTreeNode)userObject).getTextPieces(tree, treeNode, this.myEnumInfoCache, this.myAtomReader);
        for (AtomTreeNode.TextPiece textPiece : textPieceList) {
            this.append(textPiece.myString, textPiece.myTextAttributes);
        }
    }
}

