/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.structure;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.ide.structureView.StructureViewModel;
import com.intellij.ide.structureView.TreeBasedStructureViewBuilder;
import com.intellij.ide.structureView.impl.java.JavaFileTreeModel;
import com.intellij.ide.structureView.impl.java.JavaInheritedMembersNodeProvider;
import com.intellij.ide.util.treeView.smartTree.NodeProvider;
import com.intellij.lang.PsiStructureViewFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiFile;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;

public class GroovyStructureViewFactory
implements PsiStructureViewFactory {
    public StructureViewBuilder getStructureViewBuilder(final PsiFile psiFile) {
        return new TreeBasedStructureViewBuilder(){

            @NotNull
            public StructureViewModel createStructureViewModel(@Nullable Editor editor) {
                JavaFileTreeModel javaFileTreeModel = new JavaFileTreeModel((GroovyFileBase)psiFile, editor){

                    @NotNull
                    public Collection<NodeProvider> getNodeProviders() {
                        List<NodeProvider> list = Arrays.asList(new JavaInheritedMembersNodeProvider());
                        if (list == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/structure/GroovyStructureViewFactory$1$1", "getNodeProviders"));
                        }
                        return list;
                    }
                };
                if (javaFileTreeModel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/structure/GroovyStructureViewFactory$1", "createStructureViewModel"));
                }
                return javaFileTreeModel;
            }
        };
    }
}

