/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storage;

import java.io.DataOutput;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.jps.incremental.IncrementalCacheImplKt;
import org.jetbrains.kotlin.jps.incremental.storage.BasicStringMap;
import org.jetbrains.kotlin.jps.incremental.storage.LazyStorage;
import org.jetbrains.kotlin.jps.incremental.storage.StringCollectionExternalizer;
import org.jetbrains.kotlin.name.FqName;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001C\b\u0006\u0003!9Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0002\u0006\u0003!\tR!\u0001\u0003\u0002\t!a\u0001!G\u0004\n\u000b%!\u0011BA\u0005\u00021\u0007A\u0012\u0001'\u0001\"\u000e%\u0019\u0001BA\u0007\u00021\u000b\t6!\u0001\u0005\u0004K-A9!D\u0001\u0019\te\u0019\u0001\u0012B\u0007\u00021\u0015I2\u0001c\u0003\u000e\u0003a)Qe\u0003\u0003\u000b\u0011\u0019i\u0011\u0001g\u0001\u001a\r!-Q\u0002B\u0005\u0003\u0013\u0005A\u001a\u0001G\u0001&\u0018\u0011\u0019E\u0001#\u0004\u000e\t%\u0011\u0011\"\u0001\r\u00061\u0005I2\u0001#\u0003\u000e\u0003a)Qe\u0002\u0005\b\u001b\u0005AB!G\u0002\t\n5\t\u0001$B\u0013\u000f\u0011\u001fi\u0011\u0001\u0007\u0003\u001a\u0007!%Q\"\u0001\r\u00063\u0019A\u0001\"\u0004\u0003\n\u0005%\t\u0001$\u0002M\tK?!1\t\u0002\u0005\n\u001b\u0005AB!G\u0002\t\n5\t\u0001$B\r\u0007\u0011'iA!\u0003\u0002\n\u0003a)\u0001$\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/storage/ClassOneToManyMap;", "Lorg/jetbrains/kotlin/jps/incremental/storage/BasicStringMap;", "", "", "storageFile", "Ljava/io/File;", "(Ljava/io/File;)V", "add", "", "key", "Lorg/jetbrains/kotlin/name/FqName;", "value", "dumpValue", "get", "remove", "removeValues", "removed", "", "set", "values"}, moduleName="jps-plugin")
public class ClassOneToManyMap
extends BasicStringMap<Collection<? extends String>> {
    @Override
    @NotNull
    protected String dumpValue(@NotNull Collection<String> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return IncrementalCacheImplKt.dumpCollection(value);
    }

    public final void add(@NotNull FqName key, @NotNull FqName value) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        LazyStorage lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key.asString()");
        lazyStorage.append(string, (Function1<DataOutput, Unit>)((Function1)new Function1<DataOutput, Unit>(value){
            final /* synthetic */ FqName $value;

            public final void invoke(@NotNull DataOutput out) {
                Intrinsics.checkParameterIsNotNull((Object)out, (String)"out");
                out.writeUTF(this.$value.asString());
            }
            {
                this.$value = fqName;
                super(1);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<FqName> get(@NotNull FqName key) {
        Collection collection;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        LazyStorage lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key.asString()");
        Collection collection2 = (Collection)lazyStorage.get(string);
        if (collection2 != null) {
            void destination$iv$iv;
            void $receiver$iv$iv;
            Iterable $receiver$iv = collection2;
            Iterable iterable = $receiver$iv;
            Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void p1;
                String string2 = (String)item$iv$iv;
                void var11_8 = destination$iv$iv;
                FqName fqName = new FqName((String)p1);
                var11_8.add(fqName);
            }
            collection = (List)destination$iv$iv;
        } else {
            collection = SetsKt.setOf();
        }
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    public final void set(@NotNull FqName key, @NotNull Collection<FqName> values) {
        List list;
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(values, (String)"values");
        if (values.isEmpty()) {
            this.remove(key);
            return;
        }
        LazyStorage<String, List> lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key.asString()");
        Iterable iterable = values;
        String string2 = string;
        LazyStorage<String, List> lazyStorage2 = lazyStorage;
        void var4_6 = $receiver$iv;
        Collection collection = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            FqName fqName = (FqName)item$iv$iv;
            list = destination$iv$iv;
            String string3 = p1.asString();
            list.add(string3);
        }
        list = (List)destination$iv$iv;
        lazyStorage2.set(string2, list);
    }

    public final void remove(@NotNull FqName key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        LazyStorage lazyStorage = this.getStorage();
        String string = key.asString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key.asString()");
        lazyStorage.remove(string);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeValues(@NotNull FqName key, @NotNull Set<FqName> removed) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull(removed, (String)"removed");
        Iterable iterable = this.get(key);
        void var5_4 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            FqName it = (FqName)element$iv$iv;
            if (!(removed.contains(it) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notRemoved = (List)destination$iv$iv;
        this.set(key, notRemoved);
    }

    public ClassOneToManyMap(@NotNull File storageFile) {
        Intrinsics.checkParameterIsNotNull((Object)storageFile, (String)"storageFile");
        super(storageFile, StringCollectionExternalizer.INSTANCE);
    }
}

