/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Iterator;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u001f\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001c\b\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\t-a\u0001!\u0006\u0002\u0005\u0001!\u0005\u0011dB\u0005\u0006\u0013\u0011I!!C\u0001%\u0002a\r\u0001$AQ\u0014\u0013\u0019A!!\u0004\u0003\n\u0005%\tA\u0004\u0001\r\u0002\u0013%A)!D\u0004\n\u000b%!\u0011BA\u0005\u00029\u0001A:\u0001G\u0002R\u0007\u0005AA!J\u0006\u0005\u0017!%Q\u0002B\u0005\u0003\u0013\u0005a\u0002\u0001g\u0001\u001a\u0007!)Q\"\u0001M\u0006K=!1\u0002\u0003\u0004\u000e\u0003a5\u0011d\u0001\u0005\b\u001b\u0005Az!\u0007\u0004\t\u00115!\u0011BA\u0005\u00029\u0001A\u001a!\u000b\u0006\u0005\u0003\"A!!\u0004\u0003\n\u0005%\tA\u0004\u0001\r\u0002#\u000e\tQ\u0001A\u0015\u000e\t\u0005C\u0001RA\u0007\b\u0013\u0015IA!\u0003\u0002\n\u0003q\u0001\u0001t\u0001\r\u0004#\u000e\tQ\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/storage/CollectionExternalizer;", "T", "Lcom/intellij/util/io/DataExternalizer;", "", "elementExternalizer", "newCollection", "Lkotlin/Function0;", "", "(Lcom/intellij/util/io/DataExternalizer;Lkotlin/jvm/functions/Function0;)V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "value"}, moduleName="jps-plugin")
public class CollectionExternalizer<T>
implements DataExternalizer<Collection<? extends T>> {
    private final DataExternalizer<T> elementExternalizer;
    private final Function0<Collection<T>> newCollection;

    @NotNull
    public Collection<T> read(@NotNull DataInput input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        Collection result = (Collection)this.newCollection.invoke();
        DataInput dataInput = input;
        if (dataInput == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.io.DataInputStream");
        }
        DataInputStream stream = (DataInputStream)dataInput;
        while (stream.available() > 0) {
            result.add(this.elementExternalizer.read((DataInput)stream));
        }
        return result;
    }

    public void save(@NotNull DataOutput output, @NotNull Collection<? extends T> value) {
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        Iterable $receiver$iv = value;
        Iterator iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator2.next();
            this.elementExternalizer.save(output, it);
        }
    }

    public CollectionExternalizer(@NotNull DataExternalizer<T> elementExternalizer, @NotNull Function0<? extends Collection<T>> newCollection) {
        Intrinsics.checkParameterIsNotNull(elementExternalizer, (String)"elementExternalizer");
        Intrinsics.checkParameterIsNotNull(newCollection, (String)"newCollection");
        this.elementExternalizer = elementExternalizer;
        this.newCollection = newCollection;
    }
}

