/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.HashMap;
import java.util.Map;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.jps.incremental.storage.ConstantsMapExternalizer$WhenMappings;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"-\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001\u0003\n\u0006\u0003!9Q!\u0001\u0005\u0001\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tAaY\u0001\r\u0001eQ\u0011\u0002C\u0005\b\u0013\tI\u0011\u0001g\u0001\n\u0005%\t\u0001D\u0001\r\u00021\u0003i\naBQ\u0004\t\u0005\t6!\u0001E\u0003K=!1\u0002C\u0002\u000e\u0011%\u0011\u0011\"\u0001M\u0002\u0013\tI\u0011\u0001\u0007\u0002\r\u0002a\t\u0011d\u0001E\u0004\u001b\u0005AB!J\n\u0005\u0017!%Q\"\u0001\r\u00063\rAY!D\u0001\u0019\reQ\u0001RB\u0007\t\u0013\tI\u0011\u0001g\u0001\n\u0005%\t\u0001D\u0001G\u00011\u0005\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/storage/ConstantsMapExternalizer;", "Lcom/intellij/util/io/DataExternalizer;", "", "", "", "()V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "map", "Kind"}, moduleName="jps-plugin")
public final class ConstantsMapExternalizer
implements DataExternalizer<Map<String, ? extends Object>> {
    public static final ConstantsMapExternalizer INSTANCE;
    public static final ConstantsMapExternalizer INSTANCE$;

    /*
     * WARNING - void declaration
     */
    public void save(@NotNull DataOutput output, @Nullable Map<String, ? extends Object> map) {
        void $receiver$iv;
        void $receiver$iv2;
        Intrinsics.checkParameterIsNotNull((Object)output, (String)"output");
        Map<String, ? extends Object> map2 = map;
        if (map2 == null) {
            Intrinsics.throwNpe();
        }
        Map<String, ? extends Object> map3 = map2;
        DataOutput dataOutput = output;
        int n = $receiver$iv2.size();
        dataOutput.writeInt(n);
        Map<String, ? extends Object> map4 = map;
        for (String name : CollectionsKt.sorted((Iterable)$receiver$iv.keySet())) {
            Enum $receiver$iv3;
            Object value;
            Object object;
            IOUtil.writeString((String)name, (DataOutput)output);
            if (map.get(name) == null) {
                Intrinsics.throwNpe();
            }
            if ((object = value) instanceof Integer) {
                Enum enum_ = Kind.INT;
                dataOutput = output;
                n = $receiver$iv3.ordinal();
                dataOutput.writeByte(n);
                output.writeInt(((Number)value).intValue());
                continue;
            }
            if (object instanceof Float) {
                $receiver$iv3 = Kind.FLOAT;
                dataOutput = output;
                n = $receiver$iv3.ordinal();
                dataOutput.writeByte(n);
                output.writeFloat(((Number)value).floatValue());
                continue;
            }
            if (object instanceof Long) {
                $receiver$iv3 = Kind.LONG;
                dataOutput = output;
                n = $receiver$iv3.ordinal();
                dataOutput.writeByte(n);
                output.writeLong(((Number)value).longValue());
                continue;
            }
            if (object instanceof Double) {
                $receiver$iv3 = Kind.DOUBLE;
                dataOutput = output;
                n = $receiver$iv3.ordinal();
                dataOutput.writeByte(n);
                output.writeDouble(((Number)value).doubleValue());
                continue;
            }
            if (object instanceof String) {
                $receiver$iv3 = Kind.STRING;
                dataOutput = output;
                n = $receiver$iv3.ordinal();
                dataOutput.writeByte(n);
                IOUtil.writeString((String)((String)value), (DataOutput)output);
                continue;
            }
            throw (Throwable)new IllegalStateException("Unexpected constant class: " + value.getClass());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Map<String, Object> read(@NotNull DataInput input) {
        Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
        int size = input.readInt();
        HashMap map = new HashMap(size);
        int n = 0;
        int n2 = size - 1;
        if (n <= n2) {
            void index$iv;
            do {
                String name;
                Object object;
                void it = ++index$iv;
                if (IOUtil.readString((DataInput)input) == null) {
                    Intrinsics.throwNpe();
                }
                Kind kind = Kind.values()[input.readByte()];
                switch (ConstantsMapExternalizer$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                    case 1: {
                        object = input.readInt();
                        break;
                    }
                    case 2: {
                        object = Float.valueOf(input.readFloat());
                        break;
                    }
                    case 3: {
                        object = input.readLong();
                        break;
                    }
                    case 4: {
                        object = input.readDouble();
                        break;
                    }
                    case 5: {
                        object = IOUtil.readString((DataInput)input);
                        if (object != null) break;
                        Intrinsics.throwNpe();
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                Object value = object;
                MapsKt.set((Map)map, (Object)name, (Object)value);
            } while (index$iv != n2);
        }
        return map;
    }

    private ConstantsMapExternalizer() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new ConstantsMapExternalizer();
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\r\u0015\tA\"A\u0003\u0002\u0011!)\u0011\u0001B\u0002\u0005\u0003\u0004a\u0001!\u0007\u0003\n\u0005%\t\u0001\u0004\u0001M\u0001C\u000f!\u0011!U\u0002\u0002\u0011\u0005\t,1\u0001B\u0003\u0007\u000f)\u0014\u0001b\u00016\u0003\u0011\u0011Q'\u0001C\u0003k\u0005!1!N\u0001\u0005\b\u0001"}, strings={"Lorg/jetbrains/kotlin/jps/incremental/storage/ConstantsMapExternalizer$Kind;", "", "(Ljava/lang/String;I)V", "INT", "FLOAT", "LONG", "DOUBLE", "STRING"}, moduleName="jps-plugin")
    private static final class Kind
    extends Enum<Kind> {
        public static final /* enum */ Kind INT;
        public static final /* enum */ Kind FLOAT;
        public static final /* enum */ Kind LONG;
        public static final /* enum */ Kind DOUBLE;
        public static final /* enum */ Kind STRING;
        private static final /* synthetic */ Kind[] $VALUES;

        static {
            Kind[] kindArray = new Kind[5];
            Kind[] kindArray2 = kindArray;
            kindArray[0] = INT = new Kind();
            kindArray[1] = FLOAT = new Kind();
            kindArray[2] = LONG = new Kind();
            kindArray[3] = DOUBLE = new Kind();
            kindArray[4] = STRING = new Kind();
            $VALUES = kindArray;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String string) {
            return Enum.valueOf(Kind.class, string);
        }
    }
}

