/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.plugincomponents;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.editorconfig.Utils;
import org.editorconfig.core.EditorConfig;
import org.editorconfig.core.EditorConfigException;
import org.jetbrains.annotations.Nullable;

public class SettingsProviderComponent {
    private EditorConfig editorConfig = new EditorConfig();

    public static SettingsProviderComponent getInstance() {
        return (SettingsProviderComponent)ServiceManager.getService(SettingsProviderComponent.class);
    }

    public List<EditorConfig.OutPair> getOutPairs(Project project, String filePath) {
        if (filePath == null) {
            return Collections.emptyList();
        }
        try {
            Set<String> rootDirs = this.getRootDirs(project);
            List outPairs = this.editorConfig.getProperties(filePath, rootDirs);
            return outPairs;
        }
        catch (EditorConfigException error) {
            Utils.invalidConfigMessage(project, error.getMessage(), "", filePath);
            return new ArrayList<EditorConfig.OutPair>();
        }
    }

    public Set<String> getRootDirs(final Project project) {
        if (!Registry.is((String)"editor.config.stop.at.project.root")) {
            return Collections.emptySet();
        }
        return (Set)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, (CachedValueProvider)new CachedValueProvider<Set<String>>(){

            @Nullable
            public CachedValueProvider.Result<Set<String>> compute() {
                HashSet<String> dirs = new HashSet<String>();
                VirtualFile projectBase = project.getBaseDir();
                if (projectBase != null) {
                    dirs.add(project.getBasePath());
                    for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                            if (VfsUtilCore.isAncestor((VirtualFile)projectBase, (VirtualFile)root, (boolean)false)) continue;
                            dirs.add(root.getPath());
                        }
                    }
                }
                dirs.add(PathManager.getConfigPath());
                return new CachedValueProvider.Result(dirs, new Object[]{ProjectRootModificationTracker.getInstance((Project)project)});
            }
        });
    }
}

