/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import kotlin.ByteIterator;
import kotlin.Charsets;
import kotlin.Deprecated;
import kotlin.ReplaceWith;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"[\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!!Q\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\t\u000f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\n\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0005\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u001b5A\u0001!D\u0001\u0019\u0002U\t\u0001$AM\u0006\t\u0005A\u0019!D\u0001\u0019\u0005A\u001b\t\u0001VB\u0003\u001b5A\u0001!D\u0001\u0019\u0007U\t\u0001tAM\u0006\t\u0005A\u0019!D\u0001\u0019\u0005A\u001b\t\u0001VB\u0003\u001b5AA!D\u0001\u0019\nU\t\u0001$AM\u0006\t\u0005AQ!D\u0001\u0019\fA\u001b\t\u0001VB\u0003\u001b1AA!D\u0001\u0019\nU\t\u0001$AM\u0005\u0011\u0015i\u0011\u0001\u0007\u0004Q\u0007\u0003!6QA\u0007\u000e\u0011\u001bi\u0011\u0001G\u0004\u0016\u0003a\u001d\u00114\u0002\u0003\u0002\u0011\u0015i\u0011\u0001g\u0003Q\u0007\u0003!6QA\u0007\r\u0011\u001bi\u0011\u0001G\u0004\u0016\u0003a\u001d\u0011\u0014\u0002\u0005\u0006\u001b\u0005Ab\u0001UB\u0001)\u000e\u0015Q\"\u0004E\b\u001b\u0005A\u0012!F\u0001\u0019\re-A!\u0001\u0005\u0006\u001b\u0005AZ\u0001UB\u0001)\u000e\u0015QR\u0005\u0005\t\u001b\u0005A\n\"F\u0001\u0019\u0003e%\u0001\"C\u0007\u00021\u000f\u00016\u0011AM\u0006\t\u0005A\u0019!D\u0001\u0019\u0005A\u001b\u0011\u0001VB\u0003\u001b\u001bA\u0019\"D\u0001\u0019\u0015U\t\u0001T\u0003+\u0004\u00065\r\u00022C\u0007\u00021))\u0012\u0001'\u0006\u001a\n!YQ\"\u0001\r\u0003!\u000e\u0005\u0011\u0014\u0002E\f\u001b\u0005A\"\u0001U\u0002\u0002)\u000e\u0015Q\u0002\u0003\u0003D\t!aQ\"\u0001M\r+\u0005A\n\u0001VB\u0003\u001b!!9\t\u0002\u0005\r\u001b\u0005AJ\"F\u0001\u0019\u0003Q\u001b)!D\u0007\t\u001b5\t\u0001TC\u000b\u00021\u0005IZ\u0001B\u0001\t\u001c5\t\u0001D\u0001)\u0004\u0002Q\u001b)!D\u0007\t\u001d5\t\u0001TD\u000b\u00021\u0005IZ\u0001B\u0001\t\u000b5\t\u00014\u0002)\u0004\u0002Q\u001b)!\u0004\u0007\t\u001d5\t\u0001TD\u000b\u00021\u0005IJ\u0001C\u0003\u000e\u0003a1\u0001k!\u0001U\u0007\u000biQ\u0002C\b\u000e\u0003a}Q#\u0001M\u00043\u0017!\u0011\u0001C\u0003\u000e\u0003a-\u0001k!\u0001U\u0007\u000biA\u0002C\b\u000e\u0003a}Q#\u0001M\u00043\u0013AQ!D\u0001\u0019\rA\u001b\t\u0001VB\u0003"}, strings={"buffered", "Ljava/io/BufferedInputStream;", "Ljava/io/InputStream;", "bufferSize", "", "ByteStreamsKt", "Ljava/io/BufferedOutputStream;", "Ljava/io/OutputStream;", "bufferedReader", "Ljava/io/BufferedReader;", "charset", "Ljava/nio/charset/Charset;", "", "bufferedWriter", "Ljava/io/BufferedWriter;", "byteInputStream", "copyTo", "", "out", "inputStream", "Ljava/io/ByteArrayInputStream;", "", "offset", "length", "iterator", "Lkotlin/ByteIterator;", "readBytes", "estimatedSize", "reader", "Ljava/io/InputStreamReader;", "writer", "Ljava/io/OutputStreamWriter;"}, moduleName="kotlin-stdlib")
@JvmName(name="ByteStreamsKt")
public final class ByteStreamsKt {
    @Deprecated(message="It's not recommended to iterate through input stream of bytes unless it's buffered. Use buffered() extension on stream to make it buffered.", replaceWith=@ReplaceWith(expression="this.buffered().iterator()", imports={}))
    @NotNull
    public static final ByteIterator iterator(InputStream $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return ByteStreamsKt.iterator(ByteStreamsKt.buffered$default($receiver, 0, 1));
    }

    @NotNull
    public static final ByteIterator iterator(BufferedInputStream $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteIterator($receiver){
            private int nextByte;
            private boolean nextPrepared;
            private boolean finished;
            final /* synthetic */ BufferedInputStream receiver$0;

            public final int getNextByte() {
                return this.nextByte;
            }

            public final void setNextByte(int n) {
                this.nextByte = n;
            }

            public final boolean getNextPrepared() {
                return this.nextPrepared;
            }

            public final void setNextPrepared(boolean bl) {
                this.nextPrepared = bl;
            }

            public final boolean getFinished() {
                return this.finished;
            }

            public final void setFinished(boolean bl) {
                this.finished = bl;
            }

            private final void prepareNext() {
                if (!this.nextPrepared && !this.finished) {
                    this.nextByte = this.receiver$0.read();
                    this.nextPrepared = true;
                    this.finished = this.nextByte == -1;
                }
            }

            public boolean hasNext() {
                this.prepareNext();
                return !this.finished;
            }

            public byte nextByte() {
                this.prepareNext();
                if (this.finished) {
                    throw (Throwable)new NoSuchElementException("Input stream is over");
                }
                byte res = (byte)this.nextByte;
                this.nextPrepared = false;
                return res;
            }
            {
                this.receiver$0 = $receiver;
                this.nextByte = -1;
            }

            public void remove() {
                throw new UnsupportedOperationException("Mutating immutable collection");
            }
        };
    }

    @NotNull
    public static final InputStream byteInputStream(String $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new ByteArrayInputStream(StringsKt.toByteArray($receiver, charset));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ InputStream byteInputStream$default(String string, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.byteInputStream(string, charset);
    }

    @NotNull
    public static final ByteArrayInputStream inputStream(byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteArrayInputStream($receiver);
    }

    @NotNull
    public static final ByteArrayInputStream inputStream(byte[] $receiver, int offset, int length) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteArrayInputStream($receiver, offset, length);
    }

    @NotNull
    public static final BufferedInputStream buffered(InputStream $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedInputStream ? (BufferedInputStream)$receiver : new BufferedInputStream($receiver, bufferSize);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedInputStream buffered$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return ByteStreamsKt.buffered(inputStream, n);
    }

    @NotNull
    public static final InputStreamReader reader(InputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ InputStreamReader reader$default(InputStream inputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.reader(inputStream, charset);
    }

    @NotNull
    public static final BufferedReader bufferedReader(InputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.reader($receiver, charset), 0, 1);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedReader bufferedReader$default(InputStream inputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.bufferedReader(inputStream, charset);
    }

    @NotNull
    public static final InputStreamReader reader(InputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    @NotNull
    public static final BufferedReader bufferedReader(InputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.reader($receiver, charset), 0, 1);
    }

    @NotNull
    public static final BufferedOutputStream buffered(OutputStream $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedOutputStream ? (BufferedOutputStream)$receiver : new BufferedOutputStream($receiver, bufferSize);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedOutputStream buffered$default(OutputStream outputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return ByteStreamsKt.buffered(outputStream, n);
    }

    @NotNull
    public static final OutputStreamWriter writer(OutputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ OutputStreamWriter writer$default(OutputStream outputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.writer(outputStream, charset);
    }

    @NotNull
    public static final BufferedWriter bufferedWriter(OutputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.writer($receiver, charset), 0, 1);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedWriter bufferedWriter$default(OutputStream outputStream, Charset charset, int n) {
        if ((n & 1) != 0) {
            charset = Charsets.getUTF_8();
        }
        return ByteStreamsKt.bufferedWriter(outputStream, charset);
    }

    @NotNull
    public static final OutputStreamWriter writer(OutputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    @NotNull
    public static final BufferedWriter bufferedWriter(OutputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.writer($receiver, charset), 0, 1);
    }

    public static final long copyTo(InputStream $receiver, @NotNull OutputStream out, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(out, "out");
        long bytesCopied = 0L;
        byte[] buffer = new byte[bufferSize];
        int bytes = $receiver.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = $receiver.read(buffer);
        }
        return bytesCopied;
    }

    public static /* bridge */ /* synthetic */ long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, int n2) {
        if ((n2 & 2) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return ByteStreamsKt.copyTo(inputStream, outputStream, n);
    }

    @NotNull
    public static final byte[] readBytes(InputStream $receiver, int estimatedSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(estimatedSize);
        ByteStreamsKt.copyTo$default($receiver, buffer, 0, 2);
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "buffer.toByteArray()");
        return byArray;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ byte[] readBytes$default(InputStream inputStream, int n, int n2) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return ByteStreamsKt.readBytes(inputStream, n);
    }
}

