/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.sam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.PreconditionsKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.java.components.SamConversionResolver;
import org.jetbrains.kotlin.load.java.descriptors.JavaClassDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaConstructorDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.JavaMethodDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamAdapterDescriptor;
import org.jetbrains.kotlin.load.java.descriptors.SamConstructorDescriptor;
import org.jetbrains.kotlin.load.java.lazy.descriptors.LazyJavaClassDescriptor;
import org.jetbrains.kotlin.load.java.sam.SingleAbstractMethodUtils;
import org.jetbrains.kotlin.load.java.sources.JavaSourceElement;
import org.jetbrains.kotlin.load.java.structure.JavaClass;
import org.jetbrains.kotlin.load.java.structure.JavaElement;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.checker.KotlinTypeChecker;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"I\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011E)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005!)!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00031\tAaY\u0001\r\u0001e\t\u0001\u0014AQ\u0004\t\u0005\t6!\u0001\u0005\u0002K-!\u0011\u0001c\u0001\u000e\u0003a\u0011\u0011D\u0002E\u0003\u001b\u0011I!!C\u0001\u0019\ba\u0019Qe\u0005\u0003\f\u0011\u0011i!\u0001$\u0001\u0019\be\u0019\u0001\u0012B\u0007\u00021\u0015I\u0012\u0002c\u0003\u000e\u000f%\u0011\u0011\"\u0001M\u0007\u0013\tI\u0011\u0001G\u0004\u0019\r\u0015\u0006Bq\u0003E\b\u001b\ta\t\u0001\n\u0005\u0012\t\u0011\u0001\u0001\u0002C\u000b\u00021\u001dI2\u0001#\u0005\u000e\u0003\u0011B\u0011kA\u0001\t\u0013\u0015\nBa\u0003E\n\u001b\ta\t\u0001\u0007\u0006\u001a\u0007!UQ\"\u0001\r\f3\u001dA9\"D\u0003\n\u0007%\u0011A\u0012\u0001M\r11\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/sam/SamConversionResolverImpl;", "Lorg/jetbrains/kotlin/load/java/components/SamConversionResolver;", "()V", "findFunctionWithMostSpecificReturnType", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "supertypes", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolveFunctionTypeIfSamInterface", "classDescriptor", "Lorg/jetbrains/kotlin/load/java/descriptors/JavaClassDescriptor;", "resolveMethod", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/load/java/structure/JavaMethod;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolveSamAdapter", "D", "original", "(Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;)Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "resolveSamConstructor", "Lorg/jetbrains/kotlin/load/java/descriptors/SamConstructorDescriptor;", "constructorOwner", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "classifier", "Lkotlin/Function0;", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;"}, moduleName="kotlin-compiler")
public final class SamConversionResolverImpl
implements SamConversionResolver {
    public static final SamConversionResolverImpl INSTANCE;
    public static final SamConversionResolverImpl INSTANCE$;

    @Override
    @Nullable
    public SamConstructorDescriptor resolveSamConstructor(@NotNull DeclarationDescriptor constructorOwner, @NotNull Function0<? extends ClassifierDescriptor> classifier2) {
        Intrinsics.checkParameterIsNotNull(constructorOwner, "constructorOwner");
        Intrinsics.checkParameterIsNotNull(classifier2, "classifier");
        ClassifierDescriptor classifierDescriptor = classifier2.invoke();
        if (!(classifierDescriptor instanceof LazyJavaClassDescriptor) || ((LazyJavaClassDescriptor)classifierDescriptor).getFunctionTypeForSamInterface() == null) {
            return null;
        }
        return SingleAbstractMethodUtils.createSamConstructorFunction(constructorOwner, (JavaClassDescriptor)classifierDescriptor);
    }

    @Override
    @Nullable
    public <D extends FunctionDescriptor> D resolveSamAdapter(@NotNull D original) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(original, "original");
        if (!SingleAbstractMethodUtils.isSamAdapterNecessary(original)) {
            functionDescriptor = null;
        } else if (original instanceof JavaConstructorDescriptor) {
            SamAdapterDescriptor<JavaConstructorDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterConstructor((JavaConstructorDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor = samAdapterDescriptor;
        } else if (original instanceof JavaMethodDescriptor) {
            SamAdapterDescriptor<JavaMethodDescriptor> samAdapterDescriptor = SingleAbstractMethodUtils.createSamAdapterFunction((JavaMethodDescriptor)original);
            if (samAdapterDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type D");
            }
            functionDescriptor = samAdapterDescriptor;
        } else {
            functionDescriptor = null;
        }
        return (D)functionDescriptor;
    }

    @Override
    @Nullable
    public KotlinType resolveFunctionTypeIfSamInterface(@NotNull JavaClassDescriptor classDescriptor, @NotNull Function1<? super JavaMethod, ? extends FunctionDescriptor> resolveMethod) {
        FunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
        Intrinsics.checkParameterIsNotNull(resolveMethod, "resolveMethod");
        SourceElement sourceElement = classDescriptor.getSource();
        if (!(sourceElement instanceof JavaSourceElement)) {
            sourceElement = null;
        }
        JavaSourceElement javaSourceElement = (JavaSourceElement)sourceElement;
        JavaElement javaElement = javaSourceElement != null ? javaSourceElement.getJavaElement() : null;
        if (!(javaElement instanceof JavaClass)) {
            javaElement = null;
        }
        JavaClass javaClass = (JavaClass)javaElement;
        if (javaClass == null) {
            return null;
        }
        JavaClass jClass = javaClass;
        JavaMethod javaMethod = SingleAbstractMethodUtils.getSamInterfaceMethod(jClass);
        if (javaMethod == null) {
            return null;
        }
        JavaMethod samInterfaceMethod = javaMethod;
        if (Intrinsics.areEqual(jClass.getFqName(), samInterfaceMethod.getContainingClass().getFqName())) {
            JavaMethod javaMethod2 = samInterfaceMethod;
            Intrinsics.checkExpressionValueIsNotNull(javaMethod2, "samInterfaceMethod");
            functionDescriptor = resolveMethod.invoke(javaMethod2);
        } else {
            Set<KotlinType> set = TypeUtils.getAllSupertypes(classDescriptor.getDefaultType());
            Intrinsics.checkExpressionValueIsNotNull(set, "TypeUtils.getAllSupertyp\u2026criptor.getDefaultType())");
            functionDescriptor = this.findFunctionWithMostSpecificReturnType(set);
        }
        FunctionDescriptor abstractMethod = functionDescriptor;
        return SingleAbstractMethodUtils.getFunctionTypeForAbstractMethod(abstractMethod);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleFunctionDescriptor findFunctionWithMostSpecificReturnType(Set<? extends KotlinType> supertypes2) {
        void var3_6;
        ArrayList<SimpleFunctionDescriptor> arrayList;
        Collection collection = supertypes2;
        ArrayList<SimpleFunctionDescriptor> arrayList2 = arrayList;
        ArrayList<SimpleFunctionDescriptor> arrayList3 = arrayList;
        int n = collection.size();
        arrayList2(n);
        ArrayList<SimpleFunctionDescriptor> candidates = arrayList3;
        for (KotlinType kotlinType : supertypes2) {
            List<CallableMemberDescriptor> abstractMembers = SingleAbstractMethodUtils.getAbstractMembers(kotlinType);
            if (abstractMembers.isEmpty()) continue;
            CallableMemberDescriptor callableMemberDescriptor = abstractMembers.get(0);
            if (callableMemberDescriptor == null) {
                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor");
            }
            candidates.add((SimpleFunctionDescriptor)callableMemberDescriptor);
        }
        if (candidates.isEmpty()) {
            throw (Throwable)new IllegalStateException("Couldn't find abstract method in supertypes " + supertypes2);
        }
        SimpleFunctionDescriptor simpleFunctionDescriptor = (SimpleFunctionDescriptor)candidates.get(0);
        for (SimpleFunctionDescriptor candidate : candidates) {
            Unit unit;
            KotlinType candidateReturnType = candidate.getReturnType();
            KotlinType currentMostSpecificReturnType = var3_6.getReturnType();
            boolean bl = candidateReturnType != null && currentMostSpecificReturnType != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = candidate + ", " + currentMostSpecificReturnType;
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            KotlinType kotlinType = candidateReturnType;
            if (kotlinType == null) {
                Intrinsics.throwNpe();
            }
            KotlinType kotlinType2 = currentMostSpecificReturnType;
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            if (!KotlinTypeChecker.DEFAULT.isSubtypeOf(kotlinType, kotlinType2)) continue;
            SimpleFunctionDescriptor simpleFunctionDescriptor2 = candidate;
        }
        void v5 = var3_6;
        Intrinsics.checkExpressionValueIsNotNull(v5, "currentMostSpecificType");
        return v5;
    }

    private SamConversionResolverImpl() {
        INSTANCE = this;
        INSTANCE$ = this;
    }

    static {
        new SamConversionResolverImpl();
    }
}

