/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.descriptors.impl.FunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeImpl;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.RedeclarationHandler;
import org.jetbrains.kotlin.types.IndexedParametersSubstitution;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitution;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

public class FunctionDescriptorUtil {
    private static final TypeSubstitutor MAKE_TYPE_PARAMETERS_FRESH = TypeSubstitutor.create(new TypeSubstitution(){

        @Override
        public TypeProjection get(@NotNull KotlinType key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil$1", "get"));
            }
            return null;
        }

        public String toString() {
            return "FunctionDescriptorUtil.MAKE_TYPE_PARAMETERS_FRESH";
        }
    });

    private FunctionDescriptorUtil() {
    }

    public static TypeSubstitution createSubstitution(@NotNull FunctionDescriptor functionDescriptor, @NotNull List<KotlinType> typeArguments) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "createSubstitution"));
        }
        if (typeArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeArguments", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "createSubstitution"));
        }
        if (functionDescriptor.getTypeParameters().isEmpty()) {
            return TypeSubstitution.getEMPTY();
        }
        return new IndexedParametersSubstitution(functionDescriptor.getTypeParameters(), TypeUtilsKt.defaultProjections(typeArguments));
    }

    @NotNull
    public static LexicalScope getFunctionInnerScope(@NotNull LexicalScope outerScope, @NotNull FunctionDescriptor descriptor2, @NotNull BindingTrace trace) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        TraceBasedRedeclarationHandler redeclarationHandler = new TraceBasedRedeclarationHandler(trace);
        LexicalScope lexicalScope = FunctionDescriptorUtil.getFunctionInnerScope(outerScope, descriptor2, redeclarationHandler);
        if (lexicalScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        return lexicalScope;
    }

    @NotNull
    public static LexicalScope getFunctionInnerScope(@NotNull LexicalScope outerScope, final @NotNull FunctionDescriptor descriptor2, @NotNull RedeclarationHandler redeclarationHandler) {
        if (outerScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outerScope", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        if (redeclarationHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "redeclarationHandler", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        ReceiverParameterDescriptor receiver = descriptor2.getExtensionReceiverParameter();
        LexicalScopeImpl lexicalScopeImpl = new LexicalScopeImpl(outerScope, descriptor2, true, receiver, LexicalScopeKind.FUNCTION_INNER_SCOPE, redeclarationHandler, (Function1<? super LexicalScopeImpl.InitializeHandler, Unit>)new Function1<LexicalScopeImpl.InitializeHandler, Unit>(){

            @Override
            public Unit invoke(LexicalScopeImpl.InitializeHandler handler2) {
                for (TypeParameterDescriptor typeParameter : descriptor2.getTypeParameters()) {
                    handler2.addClassifierDescriptor(typeParameter);
                }
                for (ValueParameterDescriptor valueParameterDescriptor : descriptor2.getValueParameters()) {
                    handler2.addVariableDescriptor(valueParameterDescriptor);
                }
                return Unit.INSTANCE$;
            }
        });
        if (lexicalScopeImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "getFunctionInnerScope"));
        }
        return lexicalScopeImpl;
    }

    public static void initializeFromFunctionType(@NotNull FunctionDescriptorImpl functionDescriptor, @NotNull KotlinType functionType, @Nullable ReceiverParameterDescriptor dispatchReceiverParameter, @NotNull Modality modality, @NotNull Visibility visibility) {
        if (functionDescriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionDescriptor", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "initializeFromFunctionType"));
        }
        if (functionType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionType", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "initializeFromFunctionType"));
        }
        if (modality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modality", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "initializeFromFunctionType"));
        }
        if (visibility == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibility", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "initializeFromFunctionType"));
        }
        assert (KotlinBuiltIns.isFunctionOrExtensionFunctionType(functionType));
        functionDescriptor.initialize(KotlinBuiltIns.getReceiverType(functionType), dispatchReceiverParameter, Collections.emptyList(), KotlinBuiltIns.getValueParameters(functionDescriptor, functionType), KotlinBuiltIns.getReturnTypeFromFunctionType(functionType), modality, visibility);
    }

    public static <D extends CallableDescriptor> D alphaConvertTypeParameters(D candidate) {
        return (D)candidate.substitute(MAKE_TYPE_PARAMETERS_FRESH);
    }

    @NotNull
    public static FunctionDescriptor replaceFunctionParameters(@NotNull FunctionDescriptor function, @NotNull List<ValueParameterDescriptor> newParameters) {
        if (function == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "function", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "replaceFunctionParameters"));
        }
        if (newParameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newParameters", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "replaceFunctionParameters"));
        }
        SimpleFunctionDescriptorImpl descriptor2 = SimpleFunctionDescriptorImpl.create(function.getContainingDeclaration(), function.getAnnotations(), function.getName(), function.getKind(), SourceElement.NO_SOURCE);
        ArrayList<ValueParameterDescriptor> parameters2 = new ArrayList<ValueParameterDescriptor>(newParameters.size());
        int idx = 0;
        for (ValueParameterDescriptor parameter : newParameters) {
            KotlinType returnType2 = parameter.getReturnType();
            assert (returnType2 != null);
            parameters2.add(new ValueParameterDescriptorImpl(descriptor2, null, idx, parameter.getAnnotations(), parameter.getName(), returnType2, parameter.declaresDefaultValue(), parameter.isCrossinline(), parameter.isNoinline(), parameter.getVarargElementType(), SourceElement.NO_SOURCE));
            ++idx;
        }
        ReceiverParameterDescriptor receiver = function.getExtensionReceiverParameter();
        ((FunctionDescriptorImpl)descriptor2).initialize(receiver == null ? null : receiver.getType(), function.getDispatchReceiverParameter(), function.getTypeParameters(), parameters2, function.getReturnType(), function.getModality(), function.getVisibility());
        descriptor2.setOperator(function.isOperator());
        descriptor2.setInfix(function.isInfix());
        descriptor2.setExternal(function.isExternal());
        descriptor2.setInline(function.isInline());
        descriptor2.setTailrec(function.isTailrec());
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = descriptor2;
        if (simpleFunctionDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/resolve/FunctionDescriptorUtil", "replaceFunctionParameters"));
        }
        return simpleFunctionDescriptorImpl;
    }
}

