/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.load.java.lazy.types.LazyJavaTypeResolverKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPostfixExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.checkers.AdditionalTypeChecker;
import org.jetbrains.kotlin.resolve.calls.context.CallResolutionContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.jvm.checkers.JavaNullabilityWarningsChecker;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.SenselessComparisonChecker;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"g\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA1\u0001\u0007\u00013\u0005A\n!)\u0002R\u0007\u0005A\u0011!\n\f\u0005\u0017!\rQ\"\u0001\r\u00033\rA)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)\u0011$\u0002E\u0006\u001b\rI\u0011\u0001b\u0001\u0019\r\u00152Ba\u0003E\u0007\u001b\u0005A\"!G\u0002\t\u000f5\t\u0001tB\r\u0004\u0011!i\u0011\u0001'\u0005\u001a\u0007!IQ\"\u0001M\t3\u0015AY!D\u0002\n\u0003\u0011\r\u00014C\u0013\"\t\u0005A!\"D\u0001\u0019\u0005e\u0019\u0001\u0002C\u0007\u00021#I2\u0001#\u0006\u000e\u0003aE\u0011d\u0001\u0005\f\u001b\u0005A:\"G\u0002\t\u00195\t\u0001\u0014D\r\r\u00115i!\"\u0003\u0002\n\u0003aq\u0011BA\u0005\u000219I!!C\u0001\u0019\u0005amQ5\b\u0003\u0002\u0011;i!\u0001$\u0001%\u001fE!A\u0001\u0001\u0005\u0010+\u0005Az\"G\u0002\t\u00175\t\u0001tC\r\u0006\u0011\u0017i1!C\u0001\u0005\u0004aM\u0011D\u0002\u0005\u0011\u001b\u0011I!!C\u0001%\u001fa\u0005\u0012kA\u0001\t#\u0015:A!\u0001E\u0012\u001b\ta\t\u0001\u0007\b\u0016\u0003aEQe\u0002\u0003\u0002\u0011Ii!\u0001$\u0001\u0019\u001dU\t\u0001\u0014\u0003"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JavaNullabilityWarningsChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/AdditionalTypeChecker;", "()V", "checkReceiver", "", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "safeAccess", "", "c", "Lorg/jetbrains/kotlin/resolve/calls/context/CallResolutionContext;", "checkType", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expressionTypeWithSmartCast", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "doCheckType", "expectedType", "dataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "dataFlowInfo", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowInfo;", "reportWarning", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/resolve/jvm/diagnostics/ErrorsJvm$NullabilityInformationSource;", "doIfNotNull", "T", "", "body", "Lkotlin/Function0;", "(Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "mayBeNull", "mustNotBeNull"}, moduleName="kotlin-compiler")
public final class JavaNullabilityWarningsChecker
implements AdditionalTypeChecker {
    private final ErrorsJvm.NullabilityInformationSource mayBeNull(KotlinType $receiver) {
        if (!$receiver.isError() && !FlexibleTypesKt.isFlexible($receiver) && TypeUtils.isNullableType($receiver)) {
            return ErrorsJvm.NullabilityInformationSource.KOTLIN;
        }
        if (FlexibleTypesKt.isFlexible($receiver) && TypeUtils.isNullableType(FlexibleTypesKt.flexibility($receiver).getLowerBound())) {
            return ErrorsJvm.NullabilityInformationSource.KOTLIN;
        }
        if (LazyJavaTypeResolverKt.isMarkedNullable($receiver.getAnnotations())) {
            return ErrorsJvm.NullabilityInformationSource.JAVA;
        }
        return null;
    }

    private final ErrorsJvm.NullabilityInformationSource mustNotBeNull(KotlinType $receiver) {
        if (!($receiver.isError() || FlexibleTypesKt.isFlexible($receiver) || TypeUtils.isNullableType($receiver))) {
            return ErrorsJvm.NullabilityInformationSource.KOTLIN;
        }
        if (FlexibleTypesKt.isFlexible($receiver) && !TypeUtils.isNullableType(FlexibleTypesKt.flexibility($receiver).getUpperBound())) {
            return ErrorsJvm.NullabilityInformationSource.KOTLIN;
        }
        if (!$receiver.isMarkedNullable() && LazyJavaTypeResolverKt.isMarkedNotNull($receiver.getAnnotations())) {
            return ErrorsJvm.NullabilityInformationSource.JAVA;
        }
        return null;
    }

    private final void doCheckType(KotlinType expressionType, KotlinType expectedType, DataFlowValue dataFlowValue, DataFlowInfo dataFlowInfo, Function2<? super ErrorsJvm.NullabilityInformationSource, ? super ErrorsJvm.NullabilityInformationSource, Unit> reportWarning) {
        if (TypeUtils.noExpectedType(expectedType)) {
            return;
        }
        ErrorsJvm.NullabilityInformationSource expectedMustNotBeNull = this.mustNotBeNull(expectedType);
        if (Intrinsics.areEqual((Object)dataFlowInfo.getPredictableNullability(dataFlowValue), (Object)Nullability.NOT_NULL)) {
            return;
        }
        ErrorsJvm.NullabilityInformationSource actualMayBeNull = this.mayBeNull(expressionType);
        if (Intrinsics.areEqual((Object)expectedMustNotBeNull, (Object)ErrorsJvm.NullabilityInformationSource.KOTLIN) && Intrinsics.areEqual((Object)actualMayBeNull, (Object)ErrorsJvm.NullabilityInformationSource.KOTLIN)) {
            return;
        }
        if (expectedMustNotBeNull != null && actualMayBeNull != null) {
            reportWarning.invoke(expectedMustNotBeNull, actualMayBeNull);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void checkType(@NotNull KtExpression expression, @NotNull KotlinType expressionType, @NotNull KotlinType expressionTypeWithSmartCast, @NotNull ResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(expressionType, "expressionType");
        Intrinsics.checkParameterIsNotNull(expressionTypeWithSmartCast, "expressionTypeWithSmartCast");
        Intrinsics.checkParameterIsNotNull(c, "c");
        KotlinType kotlinType = c.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "c.expectedType");
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(expression, expressionType, c);
        Intrinsics.checkExpressionValueIsNotNull(dataFlowValue, "DataFlowValueFactory.cre\u2026ssion, expressionType, c)");
        DataFlowInfo dataFlowInfo = c.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "c.dataFlowInfo");
        this.doCheckType(expressionType, kotlinType, dataFlowValue, dataFlowInfo, (Function2<? super ErrorsJvm.NullabilityInformationSource, ? super ErrorsJvm.NullabilityInformationSource, Unit>)new Function2<ErrorsJvm.NullabilityInformationSource, ErrorsJvm.NullabilityInformationSource, Unit>(c, expression){
            final /* synthetic */ ResolutionContext $c;
            final /* synthetic */ KtExpression $expression;

            public final void invoke(@NotNull ErrorsJvm.NullabilityInformationSource expectedMustNotBeNull, @NotNull ErrorsJvm.NullabilityInformationSource actualMayBeNull) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)expectedMustNotBeNull), "expectedMustNotBeNull");
                Intrinsics.checkParameterIsNotNull((Object)((Object)actualMayBeNull), "actualMayBeNull");
                this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)this.$expression), expectedMustNotBeNull, actualMayBeNull));
            }
            {
                this.$c = resolutionContext;
                this.$expression = ktExpression;
                super(2);
            }
        });
        KtExpression ktExpression = expression;
        if (ktExpression instanceof KtWhenExpression) {
            void $receiver$iv;
            if (((KtWhenExpression)expression).getElseExpression() != null) return;
            Object object = ((KtWhenExpression)expression).getSubjectExpression();
            if (object == null) return;
            KtExpression ktExpression2 = object;
            KtExpression it = (KtExpression)$receiver$iv;
            object = c.trace.getType(it);
            if (object == null) {
                return;
            }
            Object type2 = object;
            if (!FlexibleTypesKt.isFlexible((KotlinType)type2) || !TypeUtils.isNullableType(FlexibleTypesKt.flexibility((KotlinType)type2).getUpperBound()) || LazyJavaTypeResolverKt.isMarkedNotNull(type2.getAnnotations())) return;
            ClassDescriptor classDescriptor = WhenChecker.getClassDescriptorOfTypeIfEnum((KotlinType)type2);
            if (classDescriptor == null) {
                return;
            }
            ClassDescriptor enumClassDescriptor = classDescriptor;
            if (!WhenChecker.isWhenOnEnumExhaustive((KtWhenExpression)expression, c.trace, enumClassDescriptor) || WhenChecker.containsNullCase((KtWhenExpression)expression, c.trace)) return;
            c.trace.report(ErrorsJvm.WHEN_ENUM_CAN_BE_NULL_IN_JAVA.on((KtExpression)((PsiElement)((KtWhenExpression)expression).getSubjectExpression())));
            return;
        } else if (ktExpression instanceof KtPostfixExpression) {
            if (!Intrinsics.areEqual(((KtPostfixExpression)expression).getOperationToken(), KtTokens.EXCLEXCL)) return;
            KtExpression ktExpression3 = ((KtPostfixExpression)expression).getBaseExpression();
            if (ktExpression3 == null) {
                return;
            }
            KtExpression baseExpression = ktExpression3;
            KotlinType kotlinType2 = c.trace.getType(baseExpression);
            if (kotlinType2 == null) {
                return;
            }
            KotlinType baseExpressionType = kotlinType2;
            DataFlowValue dataFlowValue2 = DataFlowValueFactory.createDataFlowValue(baseExpression, baseExpressionType, c);
            Intrinsics.checkExpressionValueIsNotNull(dataFlowValue2, "DataFlowValueFactory.cre\u2026n, baseExpressionType, c)");
            this.doIfNotNull(dataFlowValue2, c, (Function0)new Function0<Unit>(c, expression, baseExpressionType){
                final /* synthetic */ ResolutionContext $c;
                final /* synthetic */ KtExpression $expression;
                final /* synthetic */ KotlinType $baseExpressionType;

                public final void invoke() {
                    this.$c.trace.report(Errors.UNNECESSARY_NOT_NULL_ASSERTION.on(((KtPostfixExpression)this.$expression).getOperationReference(), this.$baseExpressionType));
                }
                {
                    this.$c = resolutionContext;
                    this.$expression = ktExpression;
                    this.$baseExpressionType = kotlinType;
                    super(0);
                }
            });
            return;
        } else {
            if (!(ktExpression instanceof KtBinaryExpression)) return;
            IElementType iElementType = ((KtBinaryExpression)expression).getOperationToken();
            if (Intrinsics.areEqual(iElementType, KtTokens.ELVIS)) {
                void $receiver$iv;
                KtExpression baseExpression = ((KtBinaryExpression)expression).getLeft();
                Object object = baseExpression;
                if (object == null) return;
                KtExpression $i$a$1 = object;
                KtExpression it = (KtExpression)$receiver$iv;
                object = c.trace.getType(it);
                if (object == null) {
                    return;
                }
                Object baseExpressionType = object;
                KtExpression ktExpression4 = baseExpression;
                if (ktExpression4 == null) {
                    Intrinsics.throwNpe();
                }
                DataFlowValue dataFlowValue3 = DataFlowValueFactory.createDataFlowValue(ktExpression4, (KotlinType)baseExpressionType, c);
                Intrinsics.checkExpressionValueIsNotNull(dataFlowValue3, "DataFlowValueFactory.cre\u2026!, baseExpressionType, c)");
                this.doIfNotNull(dataFlowValue3, c, (Function0)new Function0<Unit>(c, expression, (KotlinType)baseExpressionType){
                    final /* synthetic */ ResolutionContext $c;
                    final /* synthetic */ KtExpression $expression;
                    final /* synthetic */ KotlinType $baseExpressionType;

                    public final void invoke() {
                        this.$c.trace.report(Errors.USELESS_ELVIS.on((KtBinaryExpression)this.$expression, this.$baseExpressionType));
                    }
                    {
                        this.$c = resolutionContext;
                        this.$expression = ktExpression;
                        this.$baseExpressionType = kotlinType;
                        super(0);
                    }
                });
                return;
            } else {
                if (!Intrinsics.areEqual(iElementType, KtTokens.EQEQ) && !Intrinsics.areEqual(iElementType, KtTokens.EXCLEQ) && !Intrinsics.areEqual(iElementType, KtTokens.EQEQEQ) && !Intrinsics.areEqual(iElementType, KtTokens.EXCLEQEQEQ) || ((KtBinaryExpression)expression).getLeft() == null || ((KtBinaryExpression)expression).getRight() == null) return;
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)expression;
                KtExpression ktExpression5 = ((KtBinaryExpression)expression).getLeft();
                if (ktExpression5 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(ktExpression5, "expression.getLeft()!!");
                KtExpression ktExpression6 = ((KtBinaryExpression)expression).getRight();
                if (ktExpression6 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull(ktExpression6, "expression.getRight()!!");
                SenselessComparisonChecker.checkSenselessComparisonWithNull(ktBinaryExpression, ktExpression5, ktExpression6, c, (Function1<? super KtExpression, ? extends KotlinType>)new Function1<KtExpression, KotlinType>(c){
                    final /* synthetic */ ResolutionContext $c;

                    @Nullable
                    public final KotlinType invoke(@NotNull KtExpression it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return this.$c.trace.getType(it);
                    }
                    {
                        this.$c = resolutionContext;
                        super(1);
                    }
                }, (Function1<? super DataFlowValue, ? extends Nullability>)new Function1<DataFlowValue, Nullability>(this, c){
                    final /* synthetic */ JavaNullabilityWarningsChecker this$0;
                    final /* synthetic */ ResolutionContext $c;

                    @NotNull
                    public final Nullability invoke(@NotNull DataFlowValue value) {
                        Intrinsics.checkParameterIsNotNull(value, "value");
                        Nullability nullability = (Nullability)((Object)JavaNullabilityWarningsChecker.access$doIfNotNull(this.this$0, value, this.$c, checkType.1.INSTANCE));
                        if (nullability == null) {
                            nullability = Nullability.UNKNOWN;
                        }
                        return nullability;
                    }
                    {
                        this.this$0 = javaNullabilityWarningsChecker;
                        this.$c = resolutionContext;
                        super(1);
                    }
                });
            }
        }
    }

    private final <T> T doIfNotNull(DataFlowValue dataFlowValue, ResolutionContext<?> c, Function0<? extends T> body) {
        if (c.dataFlowInfo.getPredictableNullability(dataFlowValue).canBeNull() && Intrinsics.areEqual((Object)this.mustNotBeNull(dataFlowValue.getType()), (Object)ErrorsJvm.NullabilityInformationSource.JAVA)) {
            return body.invoke();
        }
        return null;
    }

    @Override
    public void checkReceiver(@NotNull ReceiverParameterDescriptor receiverParameter, @NotNull ReceiverValue receiverArgument, boolean safeAccess, @NotNull CallResolutionContext<?> c) {
        Intrinsics.checkParameterIsNotNull(receiverParameter, "receiverParameter");
        Intrinsics.checkParameterIsNotNull(receiverArgument, "receiverArgument");
        Intrinsics.checkParameterIsNotNull(c, "c");
        DataFlowValue dataFlowValue = DataFlowValueFactory.createDataFlowValue(receiverArgument, c);
        if (!safeAccess) {
            KotlinType kotlinType = receiverArgument.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "receiverArgument.getType()");
            KotlinType kotlinType2 = receiverParameter.getType();
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "receiverParameter.getType()");
            DataFlowValue dataFlowValue2 = dataFlowValue;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowValue2, "dataFlowValue");
            DataFlowInfo dataFlowInfo = c.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "c.dataFlowInfo");
            this.doCheckType(kotlinType, kotlinType2, dataFlowValue2, dataFlowInfo, (Function2<? super ErrorsJvm.NullabilityInformationSource, ? super ErrorsJvm.NullabilityInformationSource, Unit>)new Function2<ErrorsJvm.NullabilityInformationSource, ErrorsJvm.NullabilityInformationSource, Unit>(receiverArgument, c){
                final /* synthetic */ ReceiverValue $receiverArgument;
                final /* synthetic */ CallResolutionContext $c;

                public final void invoke(@NotNull ErrorsJvm.NullabilityInformationSource expectedMustNotBeNull, @NotNull ErrorsJvm.NullabilityInformationSource actualMayBeNull) {
                    KtElement ktElement;
                    Intrinsics.checkParameterIsNotNull((Object)((Object)expectedMustNotBeNull), "expectedMustNotBeNull");
                    Intrinsics.checkParameterIsNotNull((Object)((Object)actualMayBeNull), "actualMayBeNull");
                    if (this.$receiverArgument instanceof ExpressionReceiver) {
                        ktElement = ((ExpressionReceiver)this.$receiverArgument).getExpression();
                    } else {
                        KtExpression ktExpression = this.$c.call.getCalleeExpression();
                        ktElement = ktExpression != null ? (KtElement)ktExpression : this.$c.call.getCallElement();
                    }
                    KtElement reportOn = ktElement;
                    this.$c.trace.report(ErrorsJvm.NULLABILITY_MISMATCH_BASED_ON_JAVA_ANNOTATIONS.on((KtElement)((PsiElement)reportOn), expectedMustNotBeNull, actualMayBeNull));
                }
                {
                    this.$receiverArgument = receiverValue;
                    this.$c = callResolutionContext;
                    super(2);
                }
            });
        } else {
            DataFlowValue dataFlowValue3 = dataFlowValue;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowValue3, "dataFlowValue");
            this.doIfNotNull(dataFlowValue3, (ResolutionContext)c, (Function0)new Function0<Unit>(c, receiverArgument){
                final /* synthetic */ CallResolutionContext $c;
                final /* synthetic */ ReceiverValue $receiverArgument;

                public final void invoke() {
                    BindingTrace bindingTrace = this.$c.trace;
                    ASTNode aSTNode = this.$c.call.getCallOperationNode();
                    if (aSTNode == null) {
                        Intrinsics.throwNpe();
                    }
                    bindingTrace.report(Errors.UNNECESSARY_SAFE_CALL.on(aSTNode.getPsi(), this.$receiverArgument.getType()));
                }
                {
                    this.$c = callResolutionContext;
                    this.$receiverArgument = receiverValue;
                    super(0);
                }
            });
        }
    }

    @Nullable
    public static final /* synthetic */ Object access$doIfNotNull(JavaNullabilityWarningsChecker $this, @NotNull DataFlowValue dataFlowValue, @NotNull ResolutionContext c, @NotNull Function0 body) {
        return $this.doIfNotNull(dataFlowValue, c, body);
    }
}

