/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.analysis;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.analysis.AnalysisScopeUtil;
import com.intellij.analysis.AnalysisUIOptions;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.ide.highlighter.ArchiveFileType;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseAnalysisAction
extends AnAction {
    private final String myTitle;
    private final String myAnalysisNoon;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.analysis.BaseAnalysisAction");

    protected BaseAnalysisAction(String title, String analysisNoon) {
        this.myTitle = title;
        this.myAnalysisNoon = analysisNoon;
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = event.getProject();
        boolean dumbMode = project == null || DumbService.getInstance((Project)project).isDumb();
        presentation.setEnabled(!dumbMode && this.getInspectionScope(dataContext) != null);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        Module module = (Module)e.getData(LangDataKeys.MODULE);
        if (project == null) {
            return;
        }
        AnalysisScope scope = this.getInspectionScope(dataContext);
        LOG.assertTrue(scope != null);
        boolean rememberScope = ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace());
        AnalysisUIOptions uiOptions = AnalysisUIOptions.getInstance(project);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        BaseAnalysisActionDialog dlg = new BaseAnalysisActionDialog(AnalysisScopeBundle.message((String)"specify.analysis.scope", (Object[])new Object[]{this.myTitle}), AnalysisScopeBundle.message((String)"analysis.scope.title", (Object[])new Object[]{this.myAnalysisNoon}), project, scope, module != null ? ModuleUtilCore.getModuleNameInReadAction((Module)module) : null, rememberScope, AnalysisUIOptions.getInstance(project), element){

            @Override
            @Nullable
            protected JComponent getAdditionalActionSettings(Project project) {
                return BaseAnalysisAction.this.getAdditionalActionSettings(project, this);
            }

            protected void doHelpAction() {
                HelpManager.getInstance().invokeHelp(BaseAnalysisAction.this.getHelpTopic());
            }

            @NotNull
            protected Action[] createActions() {
                Action[] actionArray = new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
                if (actionArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/analysis/BaseAnalysisAction$1", "createActions"));
                }
                return actionArray;
            }
        };
        if (!dlg.showAndGet()) {
            this.canceled();
            return;
        }
        int oldScopeType = uiOptions.SCOPE_TYPE;
        scope = dlg.getScope(uiOptions, scope, project, module);
        if (!rememberScope) {
            uiOptions.SCOPE_TYPE = oldScopeType;
        }
        uiOptions.ANALYZE_TEST_SOURCES = dlg.isInspectTestSources();
        FileDocumentManager.getInstance().saveAllDocuments();
        this.analyze(project, scope);
    }

    @NonNls
    protected String getHelpTopic() {
        return "reference.dialogs.analyzeDependencies.scope";
    }

    protected void canceled() {
    }

    protected abstract void analyze(@NotNull Project var1, @NotNull AnalysisScope var2);

    @Nullable
    private AnalysisScope getInspectionScope(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/analysis/BaseAnalysisAction", "getInspectionScope"));
        }
        if (CommonDataKeys.PROJECT.getData(dataContext) == null) {
            return null;
        }
        AnalysisScope scope = this.getInspectionScopeImpl(dataContext);
        return scope != null && scope.getScopeType() != 6 ? scope : null;
    }

    @Nullable
    private AnalysisScope getInspectionScopeImpl(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/analysis/BaseAnalysisAction", "getInspectionScopeImpl"));
        }
        Project projectContext = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
        if (projectContext != null) {
            return new AnalysisScope(projectContext);
        }
        AnalysisScope analysisScope = (AnalysisScope)AnalysisScopeUtil.KEY.getData(dataContext);
        if (analysisScope != null) {
            return analysisScope;
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (psiFile != null && psiFile.getManager().isInProject((PsiElement)psiFile)) {
            PsiDirectory psiDirectory;
            VirtualFile jarRoot;
            VirtualFile file2 = psiFile.getVirtualFile();
            if (file2 != null && file2.isValid() && file2.getFileType() instanceof ArchiveFileType && this.acceptNonProjectDirectories() && (jarRoot = JarFileSystem.getInstance().getJarRootForLocalFile(file2)) != null && (psiDirectory = psiFile.getManager().findDirectory(jarRoot)) != null) {
                return new AnalysisScope(psiDirectory);
            }
            return new AnalysisScope(psiFile);
        }
        VirtualFile[] virtualFiles = (VirtualFile[])CommonDataKeys.VIRTUAL_FILE_ARRAY.getData(dataContext);
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (virtualFiles != null && project != null) {
            PsiDirectory psiDirectory;
            ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
            if (virtualFiles.length == 1 && (psiDirectory = PsiManager.getInstance((Project)project).findDirectory(virtualFiles[0])) != null && (this.acceptNonProjectDirectories() || psiDirectory.getManager().isInProject((PsiElement)psiDirectory))) {
                return new AnalysisScope(psiDirectory);
            }
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            for (VirtualFile vFile : virtualFiles) {
                if (!fileIndex.isInContent(vFile)) continue;
                files.add(vFile);
            }
            return new AnalysisScope(project, files);
        }
        Module moduleContext = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (moduleContext != null) {
            return new AnalysisScope(moduleContext);
        }
        Module[] modulesArray = (Module[])LangDataKeys.MODULE_CONTEXT_ARRAY.getData(dataContext);
        if (modulesArray != null) {
            return new AnalysisScope(modulesArray);
        }
        return project == null ? null : new AnalysisScope(project);
    }

    protected boolean acceptNonProjectDirectories() {
        return false;
    }

    @Nullable
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        return null;
    }
}

