/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.ParameterInfoComponent;
import com.intellij.codeInsight.hint.ShowParameterInfoHandler;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Component;
import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterInfoController
implements Disposable {
    private final Project myProject;
    @NotNull
    private final Editor myEditor;
    private final RangeMarker myLbraceMarker;
    private final LightweightHint myHint;
    private final ParameterInfoComponent myComponent;
    private final CaretListener myEditorCaretListener;
    @NotNull
    private final ParameterInfoHandler<Object, Object> myHandler;
    private final ShowParameterInfoHandler.BestLocationPointProvider myProvider;
    private final Alarm myAlarm;
    private static final int DELAY = 200;
    private boolean myDisposed;
    private static final Key<List<ParameterInfoController>> ALL_CONTROLLERS_KEY = Key.create((String)"ParameterInfoController.ALL_CONTROLLERS_KEY");

    public static ParameterInfoController findControllerAtOffset(Editor editor, int offset) {
        List<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(editor);
        for (int i = 0; i < allControllers.size(); ++i) {
            ParameterInfoController controller = allControllers.get(i);
            if (controller.myLbraceMarker.getStartOffset() != offset) continue;
            if (controller.myHint.isVisible()) {
                return controller;
            }
            Disposer.dispose((Disposable)controller);
            --i;
        }
        return null;
    }

    public Object[] getSelectedElements() {
        ParameterInfoContext context = new ParameterInfoContext(){

            public Project getProject() {
                return ParameterInfoController.this.myProject;
            }

            public PsiFile getFile() {
                return ParameterInfoController.this.myComponent.getParameterOwner().getContainingFile();
            }

            public int getOffset() {
                return ParameterInfoController.this.myEditor.getCaretModel().getOffset();
            }

            @NotNull
            public Editor getEditor() {
                Editor editor = ParameterInfoController.this.myEditor;
                if (editor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ParameterInfoController$1", "getEditor"));
                }
                return editor;
            }
        };
        if (!this.myHandler.tracksParameterIndex()) {
            return this.myHandler.getParametersForDocumentation(this.myComponent.getObjects()[0], context);
        }
        Object[] objects = this.myComponent.getObjects();
        int selectedParameterIndex = this.myComponent.getCurrentParameterIndex();
        ArrayList<Object> params = new ArrayList<Object>(objects.length);
        Object highlighted = this.myComponent.getHighlighted();
        for (Object o : objects) {
            if (highlighted != null && !o.equals(highlighted)) continue;
            this.collectParams(context, selectedParameterIndex, params, o);
        }
        if (highlighted != null && params.isEmpty()) {
            for (Object o : objects) {
                this.collectParams(context, selectedParameterIndex, params, o);
            }
        }
        return ArrayUtil.toObjectArray(params);
    }

    private void collectParams(ParameterInfoContext context, int selectedParameterIndex, List<Object> params, Object o) {
        Object[] availableParams = this.myHandler.getParametersForDocumentation(o, context);
        if (availableParams != null && selectedParameterIndex < availableParams.length && selectedParameterIndex >= 0) {
            params.add(availableParams[selectedParameterIndex]);
        }
    }

    private static List<ParameterInfoController> getAllControllers(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ParameterInfoController", "getAllControllers"));
        }
        ArrayList array = (ArrayList)editor.getUserData(ALL_CONTROLLERS_KEY);
        if (array == null) {
            array = new ArrayList();
            editor.putUserData(ALL_CONTROLLERS_KEY, array);
        }
        return array;
    }

    public static boolean isAlreadyShown(Editor editor, int lbraceOffset) {
        return ParameterInfoController.findControllerAtOffset(editor, lbraceOffset) != null;
    }

    public ParameterInfoController(@NotNull Project project, @NotNull Editor editor, int lbraceOffset, @NotNull LightweightHint hint, @NotNull ParameterInfoHandler handler2, @NotNull ShowParameterInfoHandler.BestLocationPointProvider provider) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/hint/ParameterInfoController", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/hint/ParameterInfoController", "<init>"));
        }
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/codeInsight/hint/ParameterInfoController", "<init>"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/codeInsight/hint/ParameterInfoController", "<init>"));
        }
        if (provider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/codeInsight/hint/ParameterInfoController", "<init>"));
        }
        this.myAlarm = new Alarm();
        this.myDisposed = false;
        this.myProject = project;
        this.myEditor = editor;
        this.myHandler = handler2;
        this.myProvider = provider;
        this.myLbraceMarker = editor.getDocument().createRangeMarker(lbraceOffset, lbraceOffset);
        this.myHint = hint;
        this.myComponent = (ParameterInfoComponent)this.myHint.getComponent();
        List<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(this.myEditor);
        allControllers.add(this);
        this.myEditorCaretListener = new CaretAdapter(){

            public void caretPositionChanged(CaretEvent e) {
                ParameterInfoController.this.myAlarm.cancelAllRequests();
                ParameterInfoController.this.addAlarmRequest();
            }
        };
        this.myEditor.getCaretModel().addCaretListener(this.myEditorCaretListener);
        this.myEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                ParameterInfoController.this.myAlarm.cancelAllRequests();
                ParameterInfoController.this.addAlarmRequest();
            }
        }, (Disposable)this);
        PropertyChangeListener lookupListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                LookupImpl lookup;
                if ("activeLookup".equals(evt.getPropertyName()) && (lookup = (LookupImpl)evt.getNewValue()) != null && lookup.isShown()) {
                    ParameterInfoController.this.adjustPositionForLookup(lookup);
                }
            }
        };
        LookupManager.getInstance(project).addPropertyChangeListener(lookupListener, this);
        this.updateComponent();
        if (this.myEditor instanceof EditorImpl) {
            Disposer.register((Disposable)((EditorImpl)this.myEditor).getDisposable(), (Disposable)this);
        }
    }

    public void dispose() {
        if (this.myDisposed) {
            return;
        }
        this.myDisposed = true;
        List<ParameterInfoController> allControllers = ParameterInfoController.getAllControllers(this.myEditor);
        allControllers.remove(this);
        this.myEditor.getCaretModel().removeCaretListener(this.myEditorCaretListener);
    }

    private void adjustPositionForLookup(@NotNull Lookup lookup) {
        if (lookup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lookup", "com/intellij/codeInsight/hint/ParameterInfoController", "adjustPositionForLookup"));
        }
        if (!this.myHint.isVisible() || this.myEditor.isDisposed()) {
            Disposer.dispose((Disposable)this);
            return;
        }
        HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
        short constraint = lookup.isPositionedAboveCaret() ? (short)2 : 1;
        Point p = hintManager.getHintPosition(this.myHint, this.myEditor, constraint);
        this.myHint.pack();
        this.myHint.updateLocation(p.x, p.y);
    }

    private void addAlarmRequest() {
        Runnable request = new Runnable(){

            @Override
            public void run() {
                if (!ParameterInfoController.this.myDisposed && !ParameterInfoController.this.myProject.isDisposed()) {
                    DumbService.getInstance((Project)ParameterInfoController.this.myProject).withAlternativeResolveEnabled(new Runnable(){

                        @Override
                        public void run() {
                            ParameterInfoController.this.updateComponent();
                        }
                    });
                }
            }
        };
        this.myAlarm.addRequest(request, 200, ModalityState.stateForComponent((Component)this.myEditor.getComponent()));
    }

    private void updateComponent() {
        if (!this.myHint.isVisible()) {
            Disposer.dispose((Disposable)this);
            return;
        }
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        CharSequence chars = this.myEditor.getDocument().getCharsSequence();
        int offset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(this.myEditor.getCaretModel().getOffset() - 1), (String)" \t") + 1;
        MyUpdateParameterInfoContext context = new MyUpdateParameterInfoContext(offset, file2);
        Object elementForUpdating = this.myHandler.findElementForUpdatingParameterInfo((UpdateParameterInfoContext)context);
        if (elementForUpdating != null) {
            this.myHandler.updateParameterInfo(elementForUpdating, (UpdateParameterInfoContext)context);
            if (!this.myDisposed && this.myHint.isVisible() && this.myEditor.getComponent().getRootPane() != null) {
                this.myComponent.update();
                Pair<Point, Short> pos = this.myProvider.getBestPointPosition(this.myHint, (PsiElement)elementForUpdating, offset, true, (short)2);
                HintManagerImpl.adjustEditorHintPosition(this.myHint, this.myEditor, (Point)pos.getFirst(), (Short)pos.getSecond());
            }
        } else {
            context.removeHint();
        }
    }

    public static boolean hasPrevOrNextParameter(Editor editor, int lbraceOffset, boolean isNext) {
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        return controller != null && controller.getPrevOrNextParameterOffset(isNext) != -1;
    }

    public static void prevOrNextParameter(Editor editor, int lbraceOffset, boolean isNext) {
        int newOffset;
        ParameterInfoController controller = ParameterInfoController.findControllerAtOffset(editor, lbraceOffset);
        int n = newOffset = controller != null ? controller.getPrevOrNextParameterOffset(isNext) : -1;
        if (newOffset != -1) {
            controller.moveToParameterAtOffset(newOffset);
        }
    }

    private void moveToParameterAtOffset(int offset) {
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        Object argsList = ParameterInfoController.findArgumentList(file2, offset, -1);
        if (argsList == null) {
            return;
        }
        this.myEditor.getCaretModel().moveToOffset(offset);
        this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        this.myEditor.getSelectionModel().removeSelection();
        this.myHandler.updateParameterInfo(argsList, (UpdateParameterInfoContext)new MyUpdateParameterInfoContext(offset, file2));
    }

    private int getPrevOrNextParameterOffset(boolean isNext) {
        PsiElement argList;
        if (!(this.myHandler instanceof ParameterInfoHandlerWithTabActionSupport)) {
            return -1;
        }
        int offset = CharArrayUtil.shiftBackward((CharSequence)this.myEditor.getDocument().getCharsSequence(), (int)(this.myEditor.getCaretModel().getOffset() - 1), (String)" \t") + 1;
        int lbraceOffset = this.myLbraceMarker.getStartOffset();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)this.myProject).getPsiFile(this.myEditor.getDocument());
        PsiElement psiElement = argList = lbraceOffset < offset ? (PsiElement)ParameterInfoController.findArgumentList(file2, offset, lbraceOffset) : null;
        if (argList == null) {
            return -1;
        }
        ParameterInfoHandlerWithTabActionSupport handler2 = (ParameterInfoHandlerWithTabActionSupport)this.myHandler;
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)argList.getNode(), (int)offset, (IElementType)handler2.getActualParameterDelimiterType());
        if (currentParameterIndex == -1) {
            return -1;
        }
        PsiElement[] parameters = handler2.getActualParameters(argList);
        int prevOrNextParameterIndex = isNext && currentParameterIndex < parameters.length - 1 ? currentParameterIndex + 1 : (!isNext && currentParameterIndex > 0 ? currentParameterIndex - 1 : -1);
        return prevOrNextParameterIndex != -1 ? parameters[prevOrNextParameterIndex].getTextRange().getStartOffset() : -1;
    }

    @Nullable
    public static <E extends PsiElement> E findArgumentList(PsiFile file2, int offset, int lbraceOffset) {
        if (file2 == null) {
            return null;
        }
        ParameterInfoHandler[] handlers = ShowParameterInfoHandler.getHandlers(file2.getProject(), PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset), file2.getViewProvider().getBaseLanguage());
        if (handlers != null) {
            for (ParameterInfoHandler handler2 : handlers) {
                ParameterInfoHandlerWithTabActionSupport parameterInfoHandler2;
                PsiElement e;
                if (!(handler2 instanceof ParameterInfoHandlerWithTabActionSupport) || (e = ParameterInfoUtils.findArgumentList((PsiFile)file2, (int)offset, (int)lbraceOffset, (ParameterInfoHandlerWithTabActionSupport)(parameterInfoHandler2 = (ParameterInfoHandlerWithTabActionSupport)handler2))) == null) continue;
                return (E)e;
            }
        }
        return null;
    }

    private class MyUpdateParameterInfoContext
    implements UpdateParameterInfoContext {
        private final int myOffset;
        private final PsiFile myFile;

        public MyUpdateParameterInfoContext(int offset, PsiFile file2) {
            this.myOffset = offset;
            this.myFile = file2;
        }

        public int getParameterListStart() {
            return ParameterInfoController.this.myLbraceMarker.getStartOffset();
        }

        public int getOffset() {
            return this.myOffset;
        }

        public Project getProject() {
            return ParameterInfoController.this.myProject;
        }

        public PsiFile getFile() {
            return this.myFile;
        }

        @NotNull
        public Editor getEditor() {
            Editor editor = ParameterInfoController.this.myEditor;
            if (editor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/ParameterInfoController$MyUpdateParameterInfoContext", "getEditor"));
            }
            return editor;
        }

        public void removeHint() {
            ParameterInfoController.this.myHint.hide();
            Disposer.dispose((Disposable)ParameterInfoController.this);
        }

        public void setParameterOwner(PsiElement o) {
            ParameterInfoController.this.myComponent.setParameterOwner(o);
        }

        public PsiElement getParameterOwner() {
            return ParameterInfoController.this.myComponent.getParameterOwner();
        }

        public void setHighlightedParameter(Object method) {
            ParameterInfoController.this.myComponent.setHighlightedParameter(method);
        }

        public void setCurrentParameter(int index) {
            ParameterInfoController.this.myComponent.setCurrentParameterIndex(index);
        }

        public boolean isUIComponentEnabled(int index) {
            return ParameterInfoController.this.myComponent.isEnabled(index);
        }

        public void setUIComponentEnabled(int index, boolean b) {
            ParameterInfoController.this.myComponent.setEnabled(index, b);
        }

        public Object[] getObjectsToView() {
            return ParameterInfoController.this.myComponent.getObjects();
        }
    }
}

