/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.actions;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;

public abstract class CompileActionBase
extends AnAction
implements DumbAware {
    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return;
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile file2 = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (file2 != null && editor != null && !DumbService.getInstance((Project)project).isDumb()) {
            DaemonCodeAnalyzer.getInstance((Project)project).autoImportReferenceAtCursor(editor, file2);
        }
        this.doAction(dataContext, project);
    }

    protected abstract void doAction(DataContext var1, Project var2);

    public void update(AnActionEvent e) {
        super.update(e);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            e.getPresentation().setEnabled(false);
        } else {
            e.getPresentation().setEnabled(!CompilerManager.getInstance((Project)project).isCompilationActive());
        }
    }
}

