/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.DirectoryBasedStorageKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.SchemeManagerImplKt;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.StateSplitter;
import com.intellij.openapi.components.StateSplitterEx;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DirectoryStorageUtil;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.components.store.ReadOnlyModificationException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.SmartList;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.SmartHashSet;
import gnu.trove.THashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"W\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ!\u0001\u0003\u0002\u000b\u0005Aq!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0005)\u0001!B\u0001\t$\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t\u0001\u0015\u0001Q!\u0001E\u0006\u000b\u0005!9!B\u0001\r\u0003\u0015\u0001Aa\u0003\u0007\u00013\u0011I!!C\u0001\u0019\u0003a\u0005Q\u0014!\t\"\"%\u0019\u00012A\u0007\u00021\tI1\u0001#\u0002\u000e\u0003a\u0019\u0011\"\u0002\u0003\u0002\u0011\u000fi!\u0001$\u0001\u0019\tE\u001b\u0011\u0001#\u0003&\u0017\u0011Y\u0001bB\u0007\u00021\u001fIb\u0001\u0003\u0005\u000e\t%\u0011\u0011\"\u0001M\u00061#)c\u0003B\u0006\t\u00135\u0011A\u0012\u0001M\n3\rA!\"D\u0001\u0019\u0003e!\u0001RC\u0007\u0003\u0019\u0003A2\"G\u0002\t\u000b5\t\u00014B\r\u0004\u0011/i\u0011\u0001\u0007\u0007&\u000b\u0011\t\u0001\u0012D\u0007\u0003\u0019\u0003Aj!\n\u0007\u0005\u0015!iQ\"\u0001\r\r3\rA!\"D\u0001\u0019\u0003e\u0019\u0001\"B\u0007\u00021\u0017)C\u0001\u0002\u0006\t\u001c5\t\u0001$A\u0013\t\t\u0005Aa\"D\u0001\u0019\u0010e\u0019\u0001RD\u0007\u00021\u0005)\u0003\u0002C\b\u000e\u0003a=\u0011\u0004\u0002E\u0002\u001b\ta\t\u0001'\u0004&\u000b\u0011Y\u0001rD\u0007\u0003\u0019\u0003A\u0002#\u000b\u0005\u0005\u0003rAQ!\u0004\u0002\r\u0002a-\u0011kA\u0001\u0006\u0001%:A!\u0011\u0005\t\u00045\t\u0001DA)\u0004\u0003\u0015\u0001\u0011\u0006\u0003\u0003B\u0011!\u001dQB\u0001G\u00011\u0011\t6!A\u0003\u0001S\u001d!\u0011\t\u0003E\u0003\u001b\u0005A2!U\u0002\u0002\u000b\u0001I#\u0002b!\u001d\u0011\u0019i!\u0001$\u0001\u0019\u000eq\t\u0001%A)\u0004\u0003\u0015\u0001\u0001"}, strings={"Lcom/intellij/configurationStore/DirectoryBasedStorage;", "Lcom/intellij/openapi/components/impl/stores/StateStorageBase;", "Lcom/intellij/configurationStore/StateMap;", "dir", "Ljava/io/File;", "splitter", "Lcom/intellij/openapi/components/StateSplitter;", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "(Ljava/io/File;Lcom/intellij/openapi/components/StateSplitter;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;)V", "componentName", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "analyzeExternalChangesAndUpdateIfNeed", "", "componentNames", "", "getSerializedState", "Lorg/jdom/Element;", "storageData", "component", "", "archive", "", "getVirtualFile", "hasState", "loadData", "setStorageData", "newStates", "setVirtualDir", "startExternalization", "Lcom/intellij/openapi/components/StateStorage$ExternalizationSession;", "MySaveSession"}, moduleName="configuration-store-impl")
public class DirectoryBasedStorage
extends StateStorageBase<StateMap> {
    private volatile VirtualFile virtualFile;
    private String componentName;
    private final File dir;
    private final StateSplitter splitter;
    private final TrackingPathMacroSubstitutor pathMacroSubstitutor;

    public final void setVirtualDir(@Nullable VirtualFile dir) {
        this.virtualFile = dir;
    }

    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        StateMap newData = this.loadData();
        this.getStorageDataRef().set(newData);
        if (this.componentName != null) {
            String string = this.componentName;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            componentNames.add(string);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        this.componentName = componentName;
        if (storageData.isEmpty()) {
            return null;
        }
        Element state = new Element("component");
        if (this.splitter instanceof StateSplitterEx) {
            String[] stringArray = storageData.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                Element subState;
                String fileName = stringArray[i];
                if (storageData.getState(fileName, archive) == null) {
                    return null;
                }
                ((StateSplitterEx)this.splitter).mergeStateInto(state, subState);
            }
        } else {
            Object fileName;
            SmartList subElements = new SmartList();
            String[] subState = storageData.keys();
            for (int i = 0; i < subState.length; ++i) {
                Element subState2;
                fileName = subState[i];
                if (storageData.getState((String)fileName, archive) == null) {
                    return null;
                }
                subElements.add((Object)subState2);
            }
            if (!subElements.isEmpty()) {
                void $receiver$iv;
                fileName = (Collection)subElements;
                Element element = state;
                StateSplitter stateSplitter = this.splitter;
                Collection thisCollection$iv = (Collection)$receiver$iv;
                Element[] elementArray = thisCollection$iv.toArray(new Element[thisCollection$iv.size()]);
                if (elementArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Object[] objectArray = elementArray;
                stateSplitter.mergeStatesInto(element, (Element[])objectArray);
            }
        }
        return state;
    }

    @Override
    @NotNull
    protected StateMap loadData() {
        Map<String, Element> map = DirectoryStorageUtil.loadFrom(this.getVirtualFile(), this.pathMacroSubstitutor);
        Intrinsics.checkExpressionValueIsNotNull(map, (String)"DirectoryStorageUtil.loa\u2026(), pathMacroSubstitutor)");
        return StateMap.Companion.fromMap(map);
    }

    private final VirtualFile getVirtualFile() {
        VirtualFile result2 = this.virtualFile;
        if (result2 == null) {
            this.virtualFile = result2 = LocalFileSystem.getInstance().findFileByIoFile(this.dir);
        }
        return result2;
    }

    @Nullable
    public StateStorage.ExternalizationSession startExternalization() {
        return this.checkIsSavingDisabled() ? (MySaveSession)null : new MySaveSession(this, (StateMap)StateStorageBase.getStorageData$default(this, false, 1));
    }

    private final void setStorageData(StateMap newStates) {
        this.getStorageDataRef().set(newStates);
    }

    @Override
    protected boolean hasState(@NotNull StateMap storageData, @NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.hasStates();
    }

    public DirectoryBasedStorage(@NotNull File dir, @NotNull StateSplitter splitter, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)splitter, (String)"splitter");
        this.dir = dir;
        this.splitter = splitter;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
    }

    public /* synthetic */ DirectoryBasedStorage(File file2, StateSplitter stateSplitter, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        this(file2, stateSplitter, trackingPathMacroSubstitutor);
    }

    @Nullable
    public static final /* synthetic */ VirtualFile access$getVirtualFile$p(DirectoryBasedStorage $this) {
        return $this.virtualFile;
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"K\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0011!B\u0001\t&\u0015\t\u0001bB\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\t\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tAa\u0001\u0003\u0002\u0019\u0001I\u0012\u0001'\u0001\"\u0016%\u0019\u0001\"A\u0007\u00021\u0007I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011kA\u0001\t\u0007\u0015*Aa\u0003E\b\u001b\ta\t\u0001\u0007\u0001&\u0011\u0011\t\u0001\u0002C\u0007\u00021#I2\u0001C\u0005\u000e\u0003aMQ\u0005\u0004\u0003\u0002\u0011)i\u0011\u0001'\u0005\u001a\u0007!UQ\"\u0001M\u00053\rA1\"D\u0001\u0019\u0018\u0015\"Aa\u0003\u0005\r\u001b\u0005A\n\"\n\u0007\u0005\u0003!eQ\"\u0001M\t3\rA\u0011\"D\u0001\u0019\u0014e\u0019\u0001\"D\u0007\u00021\u000b)S\u0002\u0002\u0006\t\u001c5\t\u0001\u0014C\r\u0004\u00119i\u0011\u0001'\u0003\u001a\t!uQB\u0001G\u00011/Ic\u0002B!\u001d\u0011\u000fi\u0001\"\u0003\u0002\n\u0003a%\u0011BA\u0005\u00021\u0015a\t\u0001\u0007\u0003R\u0007\u0005)\u0001!\u000b\u0006\u0005\u0003\"AY!\u0004\u0003\n\u0005%\t\u0001\u0014\u0002\r\u0007#\u000e\tQ\u0001A\u0015\b\t\u0005C\u0001BA\u0007\u00021\u000b\t6!A\u0003\u0001S\u001d!\u0011\t\bE\u0007\u001b\u0005Ar!U\u0002\u0002\u000b\u0001Is\u0001B!\t\u0011\u0005i\u0011\u0001g\u0001R\u0007\u0005)\u0001\u0001"}, strings={"Lcom/intellij/configurationStore/DirectoryBasedStorage$MySaveSession;", "Lcom/intellij/configurationStore/SaveSessionBase;", "storage", "Lcom/intellij/configurationStore/DirectoryBasedStorage;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "(Lcom/intellij/configurationStore/DirectoryBasedStorage;Lcom/intellij/configurationStore/StateMap;)V", "copiedStorageData", "", "", "", "dirtyFileNames", "Lcom/intellij/util/containers/SmartHashSet;", "someFileRemoved", "", "createSaveSession", "deleteFiles", "", "dir", "Lcom/intellij/openapi/vfs/VirtualFile;", "doSetState", "fileName", "subState", "Lorg/jdom/Element;", "save", "saveStates", "states", "setSerializedState", "componentName", "element"}, moduleName="configuration-store-impl")
    private static final class MySaveSession
    extends SaveSessionBase {
        private Map<String, Object> copiedStorageData;
        private final SmartHashSet<String> dirtyFileNames;
        private boolean someFileRemoved;
        private final DirectoryBasedStorage storage;
        private final StateMap originalStates;

        @Override
        protected void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            block9: {
                block7: {
                    block8: {
                        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
                        this.storage.componentName = componentName;
                        if (!JDOMUtil.isEmpty((Element)element)) break block7;
                        if (this.copiedStorageData == null) break block8;
                        Map<String, Object> map = this.copiedStorageData;
                        if (map == null) {
                            Intrinsics.throwNpe();
                        }
                        map.clear();
                        break block9;
                    }
                    if (this.originalStates.isEmpty()) break block9;
                    this.copiedStorageData = (Map)new THashMap();
                    break block9;
                }
                StateSplitter stateSplitter = this.storage.splitter;
                Element element2 = element;
                if (element2 == null) {
                    Intrinsics.throwNpe();
                }
                List stateAndFileNameList = stateSplitter.splitState(element2);
                for (Pair pair : stateAndFileNameList) {
                    String string = (String)pair.second;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pair.second");
                    Element element3 = (Element)pair.first;
                    Intrinsics.checkExpressionValueIsNotNull((Object)element3, (String)"pair.first");
                    this.doSetState(string, element3);
                }
                String[] stringArray = this.originalStates.keys();
                block1: for (int i = 0; i < stringArray.length; ++i) {
                    String key = stringArray[i];
                    for (Pair pair : stateAndFileNameList) {
                        if (!Intrinsics.areEqual((Object)((String)pair.second), (Object)key)) continue;
                        continue block1;
                    }
                    if (this.copiedStorageData == null) {
                        this.copiedStorageData = this.originalStates.toMutableMap();
                    }
                    this.someFileRemoved = true;
                    Map<String, Object> map = this.copiedStorageData;
                    if (map == null) {
                        Intrinsics.throwNpe();
                    }
                    map.remove(key);
                }
            }
        }

        private final void doSetState(String fileName, Element subState) {
            if (this.copiedStorageData == null) {
                this.copiedStorageData = StateMapKt.setStateAndCloneIfNeed$default(fileName, subState, this.originalStates, null, 8);
                if (this.copiedStorageData != null) {
                    this.dirtyFileNames.add((Object)fileName);
                }
            } else {
                Map<String, Object> map = this.copiedStorageData;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                if (StateMapKt.updateState$default(map, fileName, subState, null, 8)) {
                    this.dirtyFileNames.add((Object)fileName);
                }
            }
        }

        @Nullable
        public MySaveSession createSaveSession() {
            return this.storage.checkIsSavingDisabled() || this.copiedStorageData == null ? (MySaveSession)null : this;
        }

        public void save() {
            Map<String, Object> map = this.copiedStorageData;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            StateMap stateMap = StateMap.Companion.fromMap(map);
            VirtualFile dir = this.storage.getVirtualFile();
            Map<String, Object> map2 = this.copiedStorageData;
            if (map2 == null) {
                Intrinsics.throwNpe();
            }
            if (map2.isEmpty()) {
                if (dir != null && dir.exists()) {
                    FileBasedStorageKt.deleteFile(this, dir);
                }
                this.storage.setStorageData(stateMap);
                return;
            }
            if (dir == null || !dir.isValid()) {
                dir = SchemeManagerImplKt.createDir(this.storage.dir, this);
                this.storage.virtualFile = dir;
            }
            if (!this.dirtyFileNames.isEmpty()) {
                this.saveStates(dir, stateMap);
            }
            if (this.someFileRemoved && dir.exists()) {
                this.deleteFiles(dir);
            }
            this.storage.setStorageData(stateMap);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void saveStates(VirtualFile dir, StateMap states) {
            Element storeElement = new Element("component");
            String[] stringArray = states.keys();
            for (int i = 0; i < stringArray.length; ++i) {
                String fileName = stringArray[i];
                if (!this.dirtyFileNames.contains((Object)fileName)) continue;
                Element element = null;
                try {
                    Unit unit;
                    element = states.getElement(fileName, null);
                    TrackingPathMacroSubstitutor trackingPathMacroSubstitutor = this.storage.pathMacroSubstitutor;
                    if (trackingPathMacroSubstitutor != null) {
                        trackingPathMacroSubstitutor.collapsePaths(element);
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    String string = this.storage.componentName;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    storeElement.setAttribute("name", string);
                    storeElement.addContent(element);
                    VirtualFile file2 = SchemeManagerImplKt.getFile(fileName, dir, this);
                    File file3 = null;
                    LineSeparator lineSeparator = LineSeparator.fromString((String)(file2.exists() ? (String)DirectoryBasedStorageKt.access$loadFile((VirtualFile)file2).second : SystemProperties.getLineSeparator()));
                    Intrinsics.checkExpressionValueIsNotNull((Object)lineSeparator, (String)"LineSeparator.fromString\u2026rties.getLineSeparator())");
                    FileBasedStorageKt.writeFile(file3, this, file2, storeElement, lineSeparator, false);
                    continue;
                }
                catch (IOException e) {
                    ComponentStoreImplKt.getLOG().error((Throwable)e);
                    continue;
                }
                finally {
                    if (element != null) {
                        element.detach();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void deleteFiles(VirtualFile dir) {
            AccessToken token$iv = WriteAction.start();
            try {
                VirtualFile[] virtualFileArray = dir.getChildren();
                for (int i = 0; i < virtualFileArray.length; ++i) {
                    VirtualFile file2 = virtualFileArray[i];
                    String fileName = file2.getName();
                    if (!StringsKt.endsWith$default((String)fileName, (String)".xml", (boolean)false, (int)2)) continue;
                    Map<String, Object> map = this.copiedStorageData;
                    if (map == null) {
                        Intrinsics.throwNpe();
                    }
                    if (map.containsKey(fileName)) continue;
                    try {
                        file2.delete((Object)this);
                        continue;
                    }
                    catch (FileNotFoundException e) {
                        throw (Throwable)new ReadOnlyModificationException(file2, e, null);
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                token$iv.finish();
            }
        }

        public MySaveSession(@NotNull DirectoryBasedStorage storage2, @NotNull StateMap originalStates) {
            Intrinsics.checkParameterIsNotNull((Object)storage2, (String)"storage");
            Intrinsics.checkParameterIsNotNull((Object)originalStates, (String)"originalStates");
            this.storage = storage2;
            this.originalStates = originalStates;
            this.dirtyFileNames = new SmartHashSet();
        }
    }
}

