/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.configurationStore;

import com.intellij.configurationStore.ComponentStoreImplKt;
import com.intellij.configurationStore.FileBasedStorageKt;
import com.intellij.configurationStore.SaveSessionBase;
import com.intellij.configurationStore.StateMap;
import com.intellij.configurationStore.StateMapKt;
import com.intellij.configurationStore.StorageBaseEx;
import com.intellij.configurationStore.StreamProvider;
import com.intellij.configurationStore.StreamProviderKt;
import com.intellij.configurationStore.XmlElementStorageKt;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.openapi.components.impl.stores.StateStorageBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jdom.Element;
import org.jdom.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"W\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0002\t\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\n\u0015\t\u0001\"A\u0003\u0001\u000b\u0005A\u0019#B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0003\u0011\u0011Q!\u0001\u0005\u0001\u000b\u0001)\u0011\u0001c\u0003\u0006\u0003\u0011=Aa\u0005\u0007\u00013\u0011I!!C\u0001\u0019\u0003a\u0005Q\u0014a\u000e\"<\u0011\u0011\u0011b\u0001E\u0002\u001b\u0005A\"!C\u0002\t\u00065\t\u0001DA\u0005\u0006\t\u0005A1!\u0004\u0002\r\u0002a\u001d\u0011\"\u0002\u0003\u0002\u0011\u0011i!\u0001$\u0001\u0019\n%)A!\u0001\u0005\u0006\u001b\ta\t\u0001g\u0003R\u0007\u0005Aa!J\u0006\u0005\u0017!QQ\"\u0001M\u000b3\u0019A1\"\u0004\u0003\n\u0005%\t\u0001D\u0001M\fKE!1\u0002\u0003\u0007\u000e\u0003aU\u0011d\u0001E\r\u001b\u0005A\u0012!G\u0002\t\u001b5\t\u0001DA\r\u0005\u00117i!\u0001$\u0001\u0019\u001d\u0015BAA\u0003E\u000f\u001b\u0005A*\"G\u0002\t\u001f5\t\u0001DD\u0013\t\t)Ay\"D\u0001\u0019\u0016e\u0019\u0001bD\u0007\u000219)\u0003\u0002\u0002\n\t!5\t\u0001\u0014E\r\u0004\u0011Ei\u0011\u0001G\u0001&\u0013\u0011Q\u00012E\u0007\u00021+IB\u0001C\b\u000e\u00051\u0005\u0001DD\u0013\u0016\u0011Ii!\u0001$\u0001\u0019\u001de\u0019\u0001\u0012D\u0007\u00021\u0005IB\u0001#\n\u000e\u00051\u0005\u0001dE\r\u0004\u00115i\u0011\u0001\u0007\u0002\u001a\u0007!\u001dR\"\u0001\r\u0015K1!!\u0002#\u000b\u000e\u0003a!\u0012d\u0001E\r\u001b\u0005A\u0012!G\u0002\t\u001b5\t\u0001DA\u0013\u0005\t)AQ#D\u0001\u0019\u0003\u0015BA!\u0001E\u0016\u001b\u0015\u0001b#\u0006\u0002\r\u0002aq\u0001DD\u0013\u0006\tIAi#\u0004\u0002\r\u0002aqQ\u0005\u0003\u0003\u0002\u0011]i\u0011\u0001G\u0001\u001a\u0007!yQ\"\u0001\r\u000fK\u001dAy#D\u0001\u0019\u0016e\u0019\u0001bD\u0007\u000219)S\u0002B\u0001\t15\t\u0001TC\r\u0004\u0011ci\u0011\u0001G\u0001\u001a\t!IRB\u0001G\u00011\u0005)S\u0001B\u0006\t45\u0011A\u0012\u0001M\u0011K9A!$D\u0001\u0019\u0016e1\u0001RG\u0007\u0005\u0013\tI\u0011\u0001\u0007\u0002\u0019\u0018e\u0019\u0001bG\u0007\u00021QI#\u0002\u0002\"\t\u0011\u0007i\u0011\u0001\u0007\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000e!9\u0011f\u0003\u0003C\u0011!\u0019QB\u0001G\u00011\u000f\t6\u0001B\u0003\u0001\u001b\t!y\u0001\u0003\u0005*\u0011\u0011\t\u0005\u0002C\u0003\u000e\u00051\u0005\u00014B)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003D\u0011!!Q\"\u0001M\u0005#\u000e!Q\u0001A\u0007\u0003\t#A\u0011\"\u000b\u0006\u0005\u0005\"A)!D\u0001\u0019\u0005E\u001bA!\u0002\u0001\u000e\u0005\u0011M\u0001b\u0002"}, strings={"Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/StorageBaseEx;", "Lcom/intellij/configurationStore/StateMap;", "fileSpec", "", "rootElementName", "pathMacroSubstitutor", "Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "roamingType", "Lcom/intellij/openapi/components/RoamingType;", "provider", "Lcom/intellij/configurationStore/StreamProvider;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;Lcom/intellij/openapi/components/RoamingType;Lcom/intellij/configurationStore/StreamProvider;)V", "getFileSpec", "()Ljava/lang/String;", "getPathMacroSubstitutor", "()Lcom/intellij/openapi/components/TrackingPathMacroSubstitutor;", "getRoamingType", "()Lcom/intellij/openapi/components/RoamingType;", "getRootElementName", "analyzeExternalChangesAndUpdateIfNeed", "", "componentNames", "", "archiveState", "storageData", "componentName", "serializedState", "Lorg/jdom/Element;", "beforeElementLoaded", "element", "beforeElementSaved", "createSaveSession", "Lcom/intellij/openapi/components/StateStorage$ExternalizationSession;", "states", "dataLoadedFromProvider", "getSerializedState", "component", "", "archive", "", "hasState", "loadData", "loadDataFromProvider", "kotlin.jvm.PlatformType", "loadLocalData", "loadState", "setDefaultState", "setStates", "oldStorageData", "newStorageData", "startExternalization", "updatedFromStreamProvider", "changedComponentNames", "deleted", "XmlElementStorageSaveSession"}, moduleName="configuration-store-impl")
public abstract class XmlElementStorage
extends StorageBaseEx<StateMap> {
    @NotNull
    private final RoamingType roamingType;
    private final StreamProvider provider;
    @NotNull
    private final String fileSpec;
    @NotNull
    private final String rootElementName;
    @Nullable
    private final TrackingPathMacroSubstitutor pathMacroSubstitutor;

    @NotNull
    public final RoamingType getRoamingType() {
        return this.roamingType;
    }

    @Nullable
    protected abstract Element loadLocalData();

    @Override
    @Nullable
    public final Element getSerializedState(@NotNull StateMap storageData, @Nullable Object component, @NotNull String componentName, boolean archive) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.getState(componentName, archive);
    }

    @Override
    public void archiveState(@NotNull StateMap storageData, @NotNull String componentName, @Nullable Element serializedState) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        storageData.archive(componentName, serializedState);
    }

    @Override
    protected boolean hasState(@NotNull StateMap storageData, @NotNull String componentName) {
        Intrinsics.checkParameterIsNotNull((Object)storageData, (String)"storageData");
        Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
        return storageData.hasState(componentName);
    }

    @Override
    @NotNull
    protected StateMap loadData() {
        Element element;
        if (this.provider != null && this.provider.getEnabled()) {
            try {
                element = this.loadDataFromProvider();
                this.dataLoadedFromProvider(element);
            }
            catch (Exception e) {
                ComponentStoreImplKt.getLOG().error((Throwable)e);
                element = null;
            }
        } else {
            element = this.loadLocalData();
        }
        return element == null ? StateMap.Companion.getEMPTY() : this.loadState(element);
    }

    protected void dataLoadedFromProvider(@Nullable Element element) {
    }

    private final Element loadDataFromProvider() {
        StreamProvider streamProvider = this.provider;
        if (streamProvider == null) {
            Intrinsics.throwNpe();
        }
        return JDOMUtil.load((InputStream)streamProvider.read(this.fileSpec, this.roamingType));
    }

    private final StateMap loadState(Element element) {
        this.beforeElementLoaded(element);
        Map map = FileStorageCoreUtil.load(element, this.pathMacroSubstitutor, true);
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"FileStorageCoreUtil.load\u2026thMacroSubstitutor, true)");
        return StateMap.Companion.fromMap(map);
    }

    public final void setDefaultState(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        element.setName(this.rootElementName);
        this.getStorageDataRef().set(this.loadState(element));
    }

    @Nullable
    public StateStorage.ExternalizationSession startExternalization() {
        return this.checkIsSavingDisabled() ? (StateStorage.ExternalizationSession)null : this.createSaveSession((StateMap)StateStorageBase.getStorageData$default(this, false, 1));
    }

    @NotNull
    protected abstract StateStorage.ExternalizationSession createSaveSession(@NotNull StateMap var1);

    /*
     * WARNING - void declaration
     */
    public void analyzeExternalChangesAndUpdateIfNeed(@NotNull Set<String> componentNames) {
        Intrinsics.checkParameterIsNotNull(componentNames, (String)"componentNames");
        StateMap oldData = (StateMap)this.getStorageDataRef().get();
        StateMap newData = (StateMap)this.getStorageData(true);
        if (oldData == null) {
            void $receiver$iv;
            Logger logger = ComponentStoreImplKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                void var8_6 = $receiver$iv;
                String string = "analyzeExternalChangesAndUpdateIfNeed: old data null, load new for " + this.toString();
                var8_6.debug(string);
            }
            CollectionsKt.addAll((Collection)componentNames, (Object[])newData.keys());
        } else {
            void $receiver$iv;
            Set changedComponentNames = XmlElementStorageKt.access$getChangedComponentNames(oldData, newData);
            Logger $i$a$1 = ComponentStoreImplKt.getLOG();
            if ($receiver$iv.isDebugEnabled()) {
                void var8_7 = $receiver$iv;
                String string = "analyzeExternalChangesAndUpdateIfNeed: changedComponentNames " + changedComponentNames + " for " + this.toString();
                var8_7.debug(string);
            }
            if (!ContainerUtil.isEmpty((Collection)changedComponentNames)) {
                componentNames.addAll(changedComponentNames);
            }
        }
    }

    private final void setStates(StateMap oldStorageData, StateMap newStorageData) {
        if (oldStorageData != newStorageData && this.getStorageDataRef().getAndSet(newStorageData) != oldStorageData) {
            ComponentStoreImplKt.getLOG().warn("Old storage data is not equal to current, new storage data was set anyway");
        }
    }

    protected void beforeElementLoaded(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeElementSaved(@NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        if (this.pathMacroSubstitutor != null) {
            try {
                this.pathMacroSubstitutor.collapsePaths(element);
            }
            finally {
                this.pathMacroSubstitutor.reset();
            }
        }
    }

    public final void updatedFromStreamProvider(@NotNull Set<String> changedComponentNames, boolean deleted) {
        Intrinsics.checkParameterIsNotNull(changedComponentNames, (String)"changedComponentNames");
        if (Intrinsics.areEqual((Object)this.roamingType, (Object)RoamingType.DISABLED)) {
            return;
        }
        try {
            Element newElement = deleted ? (Element)null : this.loadDataFromProvider();
            StateMap states = (StateMap)this.getStorageDataRef().get();
            if (newElement == null) {
                if (states != null) {
                    CollectionsKt.addAll((Collection)changedComponentNames, (Object[])states.keys());
                    this.setStates(states, null);
                }
            } else if (states != null) {
                StateMap newStates = this.loadState(newElement);
                changedComponentNames.addAll(XmlElementStorageKt.access$getChangedComponentNames(states, newStates));
                this.setStates(states, newStates);
            }
        }
        catch (Throwable e) {
            ComponentStoreImplKt.getLOG().error(e);
        }
    }

    @NotNull
    protected final String getFileSpec() {
        return this.fileSpec;
    }

    @NotNull
    protected final String getRootElementName() {
        return this.rootElementName;
    }

    @Nullable
    protected final TrackingPathMacroSubstitutor getPathMacroSubstitutor() {
        return this.pathMacroSubstitutor;
    }

    protected XmlElementStorage(@NotNull String fileSpec, @NotNull String rootElementName, @Nullable TrackingPathMacroSubstitutor pathMacroSubstitutor, @Nullable RoamingType roamingType, @Nullable StreamProvider provider) {
        Intrinsics.checkParameterIsNotNull((Object)fileSpec, (String)"fileSpec");
        Intrinsics.checkParameterIsNotNull((Object)rootElementName, (String)"rootElementName");
        this.fileSpec = fileSpec;
        this.rootElementName = rootElementName;
        this.pathMacroSubstitutor = pathMacroSubstitutor;
        RoamingType roamingType2 = roamingType;
        if (roamingType2 == null) {
            roamingType2 = RoamingType.DEFAULT;
        }
        this.roamingType = roamingType2;
        this.provider = provider == null || Intrinsics.areEqual((Object)roamingType, (Object)RoamingType.DISABLED) || !provider.isApplicable(this.fileSpec, this.roamingType) ? (StreamProvider)null : provider;
    }

    protected /* synthetic */ XmlElementStorage(String string, String string2, TrackingPathMacroSubstitutor trackingPathMacroSubstitutor, RoamingType roamingType, StreamProvider streamProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            trackingPathMacroSubstitutor = null;
        }
        if ((n & 8) != 0) {
            roamingType = RoamingType.DEFAULT;
        }
        if ((n & 0x10) != 0) {
            streamProvider = null;
        }
        this(string, string2, trackingPathMacroSubstitutor, roamingType, streamProvider);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!\u0019!B\u0001\t&\u0015\t\u0001bB\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u000b)\u0011\u0001C\u0001\u0006\u0003\u0011\u0011Aa\u0005\u0007\u0001+\u0011!\u0001\u0001#\u0001\u0016\u0003a\t\u0011$\u0001M\u0002C+I1\u0001\u0003\u0002\u000e\u0003a\u0015\u0011b\u0001\u0005\u0004\u001b\u0005a\u0002!U\u0002\u0002\u0011\u000f)\u0003\u0002B\u0006\t\u00135)\u0011BA\u0005\u00029\u0001a\t\u0001\u0007\u0001&\t\u0011Y\u00012C\u0007\u00021))\u0013\u0002\u0002\n\t\u00165\t\u0001DC\r\u0005\u0011-i!\u0001$\u0001\u0019\u000f\u0015jAA\u0003E\f\u001b\u0005A\"\"G\u0002\t\u00195\t\u0001$B\r\u0005\u0011-i!\u0001$\u0001\u0019\u000f%rA!\u0011\u000f\t\t5A\u0011BA\u0005\u00021\u0015I!!C\u0001\u0019\f1\u0005\u0001\u0014B)\u0004\u0003\u0015\u0001\u0011&\u0004\u0003B\u0011!1QbB\u0005\u0003\u0013\u0005AR!\u0003\u0002\n\u0003a9\u0001TB)\u0004\u0003\u0015\u0001\u0011f\u0002\u0003B\u0011!\u0011Q\"\u0001M\u0003#\u000e\tQ\u0001A\u0015\f\t\tC\u0001bA\u0007\u00029\u0001\t6!B\u0003\u0002\u0011#i!\u0001b\u0004\t\u0011\u0001"}, strings={"Lcom/intellij/configurationStore/XmlElementStorage$XmlElementStorageSaveSession;", "T", "Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/SaveSessionBase;", "originalStates", "Lcom/intellij/configurationStore/StateMap;", "storage", "(Lcom/intellij/configurationStore/StateMap;Lcom/intellij/configurationStore/XmlElementStorage;)V", "copiedStates", "", "", "", "newLiveStates", "Lgnu/trove/THashMap;", "Lorg/jdom/Element;", "getStorage", "()Lcom/intellij/configurationStore/XmlElementStorage;", "Lcom/intellij/configurationStore/XmlElementStorage;", "createSaveSession", "save", "", "saveLocally", "element", "setSerializedState", "componentName"}, moduleName="configuration-store-impl")
    public static abstract class XmlElementStorageSaveSession<T extends XmlElementStorage>
    extends SaveSessionBase {
        private Map<String, Object> copiedStates;
        private final THashMap<String, Element> newLiveStates;
        private final StateMap originalStates;
        @NotNull
        private final T storage;

        @Nullable
        public XmlElementStorageSaveSession<T> createSaveSession() {
            return ((XmlElementStorage)this.storage).checkIsSavingDisabled() || this.copiedStates == null ? (XmlElementStorageSaveSession)null : this;
        }

        @Override
        protected void setSerializedState(@NotNull String componentName, @Nullable Element element) {
            Intrinsics.checkParameterIsNotNull((Object)componentName, (String)"componentName");
            Element element2 = element;
            Object object = element2 != null ? XmlElementStorageKt.normalizeRootName(element2) : null;
            if (this.copiedStates == null) {
                this.copiedStates = StateMapKt.setStateAndCloneIfNeed(componentName, element, this.originalStates, (Map)this.newLiveStates);
            } else {
                Map<String, Object> map = this.copiedStates;
                if (map == null) {
                    Intrinsics.throwNpe();
                }
                StateMapKt.updateState(map, componentName, element, (Map)this.newLiveStates);
            }
        }

        public void save() {
            StateMap stateMap;
            Element element;
            Map<String, Object> map = this.copiedStates;
            if (map == null) {
                Intrinsics.throwNpe();
            }
            if ((element = XmlElementStorageKt.save(stateMap = StateMap.Companion.fromMap(map), ((XmlElementStorage)this.storage).getRootElementName(), (Map)this.newLiveStates)) == null || JDOMUtil.isEmpty((Element)element)) {
                element = null;
            } else {
                ((XmlElementStorage)this.storage).beforeElementSaved(element);
            }
            StreamProvider provider = ((XmlElementStorage)this.storage).provider;
            if (provider != null && provider.getEnabled()) {
                if (element == null) {
                    provider.delete(((XmlElementStorage)this.storage).getFileSpec(), ((XmlElementStorage)this.storage).getRoamingType());
                } else {
                    StreamProviderKt.write(provider, ((XmlElementStorage)this.storage).getFileSpec(), FileBasedStorageKt.toBufferExposingByteArray$default((Parent)element, null, 1), ((XmlElementStorage)this.storage).getRoamingType());
                }
            } else {
                this.saveLocally(element);
            }
            ((XmlElementStorage)this.storage).setStates(this.originalStates, stateMap);
        }

        protected abstract void saveLocally(@Nullable Element var1);

        @NotNull
        protected final T getStorage() {
            return this.storage;
        }

        public XmlElementStorageSaveSession(@NotNull StateMap originalStates, @NotNull T storage2) {
            Intrinsics.checkParameterIsNotNull((Object)originalStates, (String)"originalStates");
            Intrinsics.checkParameterIsNotNull(storage2, (String)"storage");
            this.originalStates = originalStates;
            this.storage = storage2;
            this.newLiveStates = new THashMap();
        }
    }
}

